#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

textsw_vswin_evt(t, evt)
Textsw *t;
XEvent *evt;
/*
   Event in the vertical scroll window may be
   an expose event or a button press.
*/
{
	void textsw_drawscrolls();
	void textsw_vswin_bp_proc();

	switch(evt->type) {
	case Expose:
		textsw_drawscrolls(t);
		break;
	case ButtonPress:
		textsw_vswin_bp_proc(t, (XButtonPressedEvent *) evt);
		break;
	case EnterNotify:
		if (t->xt_updatescroll == LXT_LONGESTLINEUNKNOWN) {
			textsw_longestline(t);
			textsw_drawscrolls(t);
			t->xt_updatescroll = FALSE;
		}
		else if (t->xt_updatescroll == LXT_LONGESTLINEKNOWN) {
			textsw_drawscrolls(t);
			t->xt_updatescroll = FALSE;
		}
		break;
	}
}

textsw_hswin_evt(t, evt)
Textsw *t;
XEvent *evt;
/*
   Event in the horizontal scroll window may
   be an expose event or a button press.
*/
{
	void textsw_drawscrolls();
	void textsw_hswin_bp_proc();

	switch (evt->type) {
	case Expose:
		textsw_drawscrolls(t);
		break;
	case ButtonPress:
		textsw_hswin_bp_proc(t, (XButtonPressedEvent *) evt);
		break;
	case EnterNotify:
		if (t->xt_updatescroll == LXT_LONGESTLINEUNKNOWN) {
			textsw_longestline(t);
			textsw_drawscrolls(t);
			t->xt_updatescroll = FALSE;
		}
		else if (t->xt_updatescroll == LXT_LONGESTLINEKNOWN) {
			textsw_drawscrolls(t);
			t->xt_updatescroll = FALSE;
		}
		break;
	}
}

void
textsw_vswin_bp_proc(t, evt)
Textsw *t;
XButtonPressedEvent *evt;
{
	float window_percentage;	/* percentage point in window where user clicked button */
	int line_number;		/* place in text to where mouse click maps */
	int line_in_window;		/* Used temporarily to store new top line in window */
	Scrollbar *s;
	void textsw_draw(), textsw_display();

	s  = t->xt_vscroll;

	line_in_window = t->xt_topline;

	/* check for scroll button events */
	/* top button */

	if (evt->y <= t->xt_vscroll->xs_buttonlen) {
		if (evt->button == Button1) 
			++line_in_window;
		if (evt->button == Button2)
			line_in_window = 0;
		if (evt->button == Button3)
			--line_in_window;
	}
	/* bottom scroll button */
	else if(evt->y >= t->xt_vscroll->xs_buttonlen + t->xt_vscrolllen) {
		if (evt->button == Button1)
			++line_in_window;
		if (evt->button == Button2)
			line_in_window = t->xt_nbuflines - (t->xt_wch/2);
		if (evt->button == Button3) 
			--line_in_window;
	}
	else {	/* button press was not on a scroll button */
		/*
			Determine the top line in the window as the percentage of where
			the mouse was clicked to the total number of lines. 
 */
	
		window_percentage = ((float)(evt->y - s->xs_buttonlen)/(float) t->xt_vscrolllen);
		line_number = window_percentage*t->xt_nbuflines;
		line_in_window = line_number - (t->xt_wch/2);
	}

	
	/* make line be at the center of the window */
	if (line_in_window < 0)
		line_in_window = 0;
	if (line_in_window > t->xt_nbuflines)
		line_in_window = t->xt_nbuflines;

	/* don't bother displaying text if nothing has changed */
	if (line_in_window != t->xt_topline) {
		t->xt_topline = line_in_window;
		textsw_draw(t);
		textsw_display(t);
	}

	textsw_drawscrolls(t);
}

void
textsw_hswin_bp_proc(t, evt)
Textsw *t;
XButtonPressedEvent *evt;
{
	float window_percentage;	/* percentage point in window where user clicked button */
	int pix_in_window;		/* Used temporarily to store new left pixel in window */
	Scrollbar *s;
	void textsw_draw(), textsw_display();

	s = t->xt_hscroll;
	pix_in_window = t->xt_leftpix;

	if (evt->x <= t->xt_hscroll->xs_buttonlen) {
		if (evt->button == Button1) 
			pix_in_window = pix_in_window + t->xt_cwidth;
		/* scroll to far left */
		if (evt->button == Button2)
			pix_in_window = 0;
		if (evt->button == Button3) 
			pix_in_window = pix_in_window - t->xt_cwidth;
	}
	else if (evt->x >= t->xt_hscroll->xs_buttonlen + t->xt_hscrolllen) {
		if (evt->button == Button1)
			pix_in_window = pix_in_window + t->xt_cwidth;
		if (evt->button == Button2)
		/* scroll to far right */
			pix_in_window = t->xt_maxlinelen;
		if (evt->button == Button3) 
			pix_in_window = pix_in_window - t->xt_cwidth;
	}
	else {
		window_percentage = ((float)(evt->x - s->xs_buttonlen)/(float) t->xt_hscrolllen);
		pix_in_window = window_percentage * t->xt_maxlinelen;
	}


	/* round off pix_in_window to beginning of nearest
	   character if font width is uniform */
	pix_in_window -= pix_in_window % t->xt_cwidth;

	if (pix_in_window < 0)
		pix_in_window = 0;
	else if (pix_in_window > t->xt_maxlinelen)
		pix_in_window =  t->xt_maxlinelen;

	/* don't bother displaying text if nothing has changed */
	if (pix_in_window != t->xt_leftpix) {
		t->xt_leftpix = pix_in_window;
		textsw_draw(t);
		textsw_display(t);
	}

	textsw_drawscrolls(t);
}


void
textsw_drawscrolloutln(t)
Textsw *t;
{
	Scrollbar *vs, *hs;

	vs= t->xt_vscroll;
	hs= t->xt_hscroll;

	/* vertical scrollbar */
	XDrawLine(t->xt_dpy, t->xt_vswin, t->xt_gc, vs->xs_barwidth, 0, vs->xs_barwidth, t->xt_ath);
	XDrawLine(t->xt_dpy, t->xt_vswin, t->xt_gc, 0, 0, vs->xs_barwidth, 0);
	XDrawLine(t->xt_dpy, t->xt_vswin, t->xt_gc, 0, vs->xs_buttonlen, 
		 vs->xs_barwidth, vs->xs_buttonlen);
	XDrawLine(t->xt_dpy, t->xt_vswin, t->xt_gc, 0, t->xt_ath-vs->xs_buttonlen,
		 vs->xs_barwidth, t->xt_ath-vs->xs_buttonlen);

	/* horizontal scrollbar */
	XDrawLine(t->xt_dpy, t->xt_hswin, t->xt_gc, 0, hs->xs_barwidth, t->xt_atw, hs->xs_barwidth);
	XDrawLine(t->xt_dpy, t->xt_hswin, t->xt_gc, 0, 0, 0, hs->xs_barwidth);
	XDrawLine(t->xt_dpy, t->xt_hswin, t->xt_gc, hs->xs_buttonlen, 0, 
		hs->xs_buttonlen, hs->xs_barwidth);
	XDrawLine(t->xt_dpy, t->xt_hswin, t->xt_gc, t->xt_atw-hs->xs_buttonlen, 0,
		 t->xt_atw-hs->xs_buttonlen, hs->xs_barwidth);
}

void
textsw_drawscrolls(t)
/*
   Internal function.
   Plots the text window's vertical and horizontal scrollbars 
   and the scroll outline.
*/
Textsw *t;
{
	Scrollbar *vs, *hs;
	
	int a, b, c, d, e, f;

	if (t->xt_maxlinelen == 0 || t->xt_nbuflines == 0) {
		textsw_drawscrolloutln(t);
		textsw_fillscrolls(t);
		return;
	}

	hs= t->xt_hscroll;
	vs= t->xt_vscroll;

	a = t->xt_atw;
	b = t->xt_maxlinelen;
	c = t->xt_leftpix;
	d = t->xt_wch * t->xt_cheight;
	e = t->xt_nbuflines * t->xt_cheight;
	f = t->xt_topline * t->xt_cheight;

	/* horizontal scroll bar */
	hs->xs_bubblelen = ((float)a/(float)b) * t->xt_hscrolllen;
	hs->xs_bubblemin = (((float)c/(float)b) * t->xt_hscrolllen) + hs->xs_buttonlen;

	/* would the bubble be out of the window? */
	if (hs->xs_bubblemin <= hs->xs_buttonlen)
		hs->xs_bubblemin  = hs->xs_buttonlen + 1;
	if (hs->xs_bubblemin + hs->xs_bubblelen >= hs->xs_buttonlen + t->xt_hscrolllen)
		hs->xs_bubblelen = hs->xs_buttonlen + t->xt_hscrolllen - hs->xs_bubblemin;
	
	textsw_cleararea(t->xt_dpy, t->xt_hswin,  hs->xs_buttonlen+1, 0, 
		t->xt_hscrolllen - 1, hs->xs_barwidth, False);
	textsw_fillrect(t->xt_dpy, t->xt_hswin, t->xt_sgc,
		hs->xs_bubblemin, hs->xs_bubblemargin, hs->xs_bubblelen, hs->xs_barwidth-(2*hs->xs_bubblemargin));

	/* vertical scroll bar */
	vs->xs_bubblelen = ((float)d/(float)e) * t->xt_vscrolllen;
	vs->xs_bubblemin = (((float)f/(float)e) * t->xt_vscrolllen) + vs->xs_buttonlen;

	/* would the bubble be out of the window? */
	if (vs->xs_bubblemin <= vs->xs_buttonlen)
		vs->xs_bubblemin  = vs->xs_buttonlen + 1;

	if (vs->xs_bubblemin + vs->xs_bubblelen >= vs->xs_buttonlen + t->xt_vscrolllen)
		vs->xs_bubblelen = vs->xs_buttonlen + t->xt_vscrolllen - vs->xs_bubblemin;

	textsw_cleararea(t->xt_dpy, t->xt_vswin, 0, vs->xs_buttonlen+1,
		vs->xs_barwidth, t->xt_vscrolllen - 1, False);
	textsw_fillrect(t->xt_dpy, t->xt_vswin, t->xt_sgc,
		vs->xs_bubblemargin, vs->xs_bubblemin, vs->xs_barwidth-(2*vs->xs_bubblemargin), vs->xs_bubblelen);


	textsw_drawscrolloutln(t);
}

textsw_fillscrolls(t)
/*
   Internal function.
   Fill the scroll bars.
*/
Textsw *t;
{
	Scrollbar *vs, *hs;

	hs= t->xt_hscroll;
	vs= t->xt_vscroll;

	textsw_fillrect(t->xt_dpy, t->xt_hswin, t->xt_sgc, hs->xs_buttonlen + 1, hs->xs_bubblemargin,
		t->xt_hscrolllen, hs->xs_barwidth-(2*hs->xs_bubblemargin));

	textsw_fillrect(t->xt_dpy, t->xt_vswin, t->xt_sgc, vs->xs_bubblemargin, vs->xs_buttonlen + 1,
		vs->xs_barwidth-(2*vs->xs_bubblemargin), t->xt_vscrolllen);
}
