#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

extern Textsw *xt_textsws;
extern char *xvt_pastebuf;
extern int xvt_pastebufsz;

Void *xtret_void;
int xtret_int;
char *xtret_buf= (char *) NULL;
int xtret_bufsz= 0;

Void *
textsw_get(t, attr)
/*
   User-callable.
   Gets an attribute of a previously created textsw.
*/
Textsw *t;
int attr;
{
	int index, length, i, j;
	int col2, found;
	char *s;
	Textsw *current;
	boolean textsw_compute_cursor_pos();

	xtret_void= (Void *) NULL;
	if (t == (Textsw *) NULL) {
		(void) fprintf(stderr, "textsw_get: null text window\n");
		return(xtret_void);
	}
	if (t->xt_magic != LX_TEXTSW) {
		(void) fprintf(stderr, "textsw_get: object is not a textsw\n");
		return(xtret_void);
	}
	found= FALSE;	
	current= xt_textsws;
	while (current != (Textsw *) NULL) {
		if (current == t) {
			found= TRUE;
			break;
		}
		current= current->xt_next;
	}
	if (!found) {
		(void) fprintf(stderr, "textsw_get: no such text window\n");
		return(xtret_void);
	}

	switch (attr) {

	case LXT_INPUTFILE:
		xtret_void= (Void *) t->xt_rdfilenm;
		break;

	case LXT_OUTPUTFILE:
		xtret_void= (Void *) t->xt_wrfilenm;
		break;

	case LXT_FOREGROUND:
		xtret_void= (Void *) &(t->xt_fg);
		break;

	case LXT_BACKGROUND:
		xtret_void= (Void *) &(t->xt_bg);
		break;

	case LXT_FONT:
		xtret_void= (Void *) t->xt_fontnm;
		break;

	case LXT_ALLOWINPUT:
		xtret_void= (Void *) &(t->xt_allowinput);
		break;

	case LXT_PASTEBUFFER:
		if (xvt_pastebuf == NULL)
			xtret_void= (Void *) NULL;
		else {
			length= 0;
			for (j= 0; j < xvt_pastebufsz; j++) {
				if (xvt_pastebuf[j] != LXT_SPHOLDER)
					++length;
			}

			s= calloc((unsigned) (length+1), sizeof(char));
			length= 0;
			for (j= 0; j < xvt_pastebufsz; j++) {
				if (xvt_pastebuf[j] == LXT_SPHOLDER)
					continue;
				else if (xvt_pastebuf[j] == '\0')
					s[length++]= '\n';
				else
					s[length++]= xvt_pastebuf[j];
			}
			s[length]= '\0';
			xtret_void= (Void *) s;
		}
		break;

	case LXT_CHARPROC:
		xtret_void= (Void *) t->xt_charproc;
		break;

	case LXT_EXITPROC:
		xtret_void= (Void *) t->xt_exitproc;
		break;

	case LXT_TCURSOR:
		xtret_void= (Void *) &(t->xt_tcursor);
		break;

	case LXT_VSCURSOR:
		xtret_void= (Void *) &(t->xt_vscursor);
		break;

	case LXT_HSCURSOR:
		xtret_void= (Void *) &(t->xt_hscursor);
		break;

	case LXT_BARWIDTH:
		xtret_void= (Void *) &(t->xt_vscroll->xs_barwidth);
		break;

	case LXT_BUBBLEMARGIN:
		xtret_void= (Void *) &(t->xt_vscroll->xs_bubblemargin);
		break;

	case LXT_BUTTONLEN:
		xtret_void= (Void *) &(t->xt_vscroll->xs_buttonlen);
		break;

	case LXT_DRAWCURSOR:
		xtret_void= (Void *) &(t->xt_drawcursor);
		break;

	case LXT_DRAWHIGHLIGHT:
		xtret_void= (Void *) &(t->xt_drawhlt);
		break;

	case LXT_CURSORLINE:
		if (!t->xt_drawcursor)
			xtret_int= -1;
		else
			xtret_int= (t->xt_cursorpy/t->xt_cheight) + t->xt_topline;
		xtret_void= (Void *) &xtret_int;
		break;

	case LXT_CURSORCOLUMN:
		if (!t->xt_drawcursor)
			xtret_int= -1;
		else if (!textsw_compute_cursor_pos(t, &i, &xtret_int, &col2))
			xtret_int= -1;

		/* decrement column by the number of space holders */
		if (xtret_int != -1) {
			j= xtret_int;
			for (index= t->xt_linestarts[i]; index < t->xt_linestarts[i] + j; index++) {
				if (t->xt_text[index] == LXT_SPHOLDER)
					--xtret_int;
			}
		}
		xtret_void= (Void *) &xtret_int;
		break;

	case LXT_HIGHLIGHTENDLINE:
		if (!t->xt_drawhlt)
			xtret_int= -1;
		else
			textsw_gethltend(t, &xtret_int, &j);

		xtret_void= (Void *) &xtret_int;
		break;

	case LXT_HIGHLIGHTENDCOLUMN:
		if (!t->xt_drawhlt)
			xtret_int= -1;
		else
			textsw_gethltend(t, &i, &xtret_int);
		xtret_void= (Void *) &xtret_int;
		break;

	case LXT_NUMLINES:
		xtret_void= (Void *) &(t->xt_nbuflines);
		break;

	case LXT_MENU:
		xtret_void= (Void *) t->xt_menu;
		break;

	case LXT_TOPLINE:
		xtret_void= (Void *) &(t->xt_topline);
		break;

	case LXT_CLIENTDATA:
		xtret_void= (Void *) t->xt_clientdata;
		break;

	case LXT_INSERTTEXT:
	case LXT_CURSORVIEWABLE:
		(void) fprintf(stderr, "textsw_get: attribute is set-only\n");
		break;

	default:
		(void) fprintf(stderr, "textsw_get: unrecognized attribute\n");
		break;
	}

	return(xtret_void);
}

char *
textsw_text(t, line)
/*
   User-callable.
   Returns the text associated with a given line number.
*/
Textsw *t;
int line;
{
	int length, j;
	boolean found;
	Textsw *u;

	if (t == (Textsw *) NULL) {
		(void) fprintf(stderr, "textsw_text: null text window\n");
		return((char *) NULL);
	}
	if (t->xt_magic != LX_TEXTSW) {
		(void) fprintf(stderr, "textsw_text: object is not a textsw\n");
		return((char *) NULL);
	}

	found= FALSE;	
	u= xt_textsws;
	while (u != (Textsw *) NULL) {
		if (u == t) {
			found= TRUE;
			break;
		}
		u= u->xt_next;
	}
	if (!found) {
		(void) fprintf(stderr, "textsw_text: no such text window\n");
		return((char *) NULL);
	}

	if (line < 0 || line >= t->xt_nbuflines)
		return((char *) NULL);

	length= 0;
	for (j= t->xt_linestarts[line]; j < t->xt_linestarts[line + 1]; j++) {
		if (t->xt_text[j] != LXT_SPHOLDER)
			++length;
	}

	if (xtret_bufsz < length+1) {
		if (xtret_buf != (char *) NULL)
			cfree(xtret_buf);
		xtret_bufsz= 0;
		if ((xtret_buf= calloc((unsigned) (length+1), sizeof(char))) == (char *) NULL) {
			(void) fprintf(stderr, "textsw_text: memory allocation error\n");
			return((char *) NULL);
		}
		xtret_bufsz= length+1;
	}
	length= 0;
	for (j= t->xt_linestarts[line]; j < t->xt_linestarts[line + 1]; j++) {
		if (t->xt_text[j] == LXT_SPHOLDER)
			continue;
		else if (t->xt_text[j] == '\0')
			xtret_buf[length++]= '\n';
		else
			xtret_buf[length++]= t->xt_text[j];
	}
	xtret_buf[length]= '\0';
	return(xtret_buf);
}
