#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "../lxt.h"

#define PFRAME_WIDTH	560
#define PFRAME_HEIGHT	410
#define CFRAME_WIDTH	400
#define CFRAME_HEIGHT	300
#define CANVAS_WIDTH	600
#define CANVAS_HEIGHT	500
#define TFRAME_WIDTH	400
#define TFRAME_HEIGHT	500
#define FONT		"8x13"

#define OK		0
#define NOWAY		1

#include "scream.bitmap"
XImage *scream_im;

#include "peewee.bitmap"
XImage *peewee_im;

#include "cowboy.bitmap"
XImage *cowboy_im;

#include "penny.bitmap"
XImage *penny_im;

#include "magic.bitmap"
XImage *magic_im;

Display *dpy;
XFontStruct *fontstruct;
Window pwin, cwin, canvas_win;
Window qwin;
Window twin;
Pixmap canvas_pm;
GC canvas_gc;

Panel *panel;
Panel_item *title;
Panel_item *name, *word;
Panel_item *slider;
Panel_item *choice;
Panel_item *cycle;
Panel_item *toggle;
Panel_item *scream_button;
Panel_item *quit_button;
Panel_item *reset_button;
Panel_item *font_button;
Panel_item *penpal_button;

Panel *qpanel;
Panel_item *qmsg;
Panel_item *ok_button;
Panel_item *noway_button;

Canvas *canvas;

Menu *base_menu, *friend_menu;

Textsw *letter;

char *progname;
char font[20];
int fun_index, best_friend;
unsigned long black, white;
XImage *tile;
char *string;

char *quips[]= {
	"\"Made you look!\"",
	"\"I know you are but what am I?\"",
	"\"Heh-heh!\"",
	"\"That's my name, don't wear it out!\"",
	"\"There'll be no more napping!\"",
	0
};

static int line, lx, ly;
static int text, tx, ty;

static XWMHints xwmh= {
	(InputHint | StateHint),	/* flags */
	True,				/* input */
	NormalState,			/* initial_state */
	0,				/* icon pixmap */
	0,				/* icon window */
	0, 0,				/* icon location */
	0,				/* icon mask */
	0,				/* Window group */
};

main(argc, argv)
int argc;
char *argv[];
{
	unsigned int bw;
	XEvent event;
	XSizeHints xsh;
	char *display;
	void setup_panel(), setup_qpanel();
	void setup_images(), setup_canvas();

	progname= *argv;
	display= (char *) NULL;
	for (argc--, argv++; argc > 0; argc--, argv++) {
		if (!strncmp(*argv, "-d", 2)) {
			argc--, argv++;
			display= *argv;
		}
	}

	if ((dpy= XOpenDisplay(display)) == NULL) {
		(void) fprintf(stderr, "%s: can't open display %s\n", argv[0], display);
		exit(1);
	}
	if ((fontstruct= XLoadQueryFont(dpy, FONT)) == NULL) {
		(void) fprintf(stderr, "%s: display %s doesn't know font %s\n", argv[0], DisplayString(dpy), FONT);
		exit(1);
	}

	white= WhitePixel(dpy, DefaultScreen(dpy));
	black= BlackPixel(dpy, DefaultScreen(dpy));
	bw= 4;

	xsh.flags= (PPosition | PSize);
	xsh.height= PFRAME_HEIGHT;
	xsh.width= PFRAME_WIDTH;
	xsh.x= (DisplayWidth(dpy, DefaultScreen(dpy)) - xsh.width) / 2;
	xsh.y= (DisplayHeight(dpy, DefaultScreen(dpy)) - xsh.height) / 2;

	pwin= XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), xsh.x, xsh.y, xsh.width, xsh.height, bw, black, white);
	XSetStandardProperties(dpy, pwin, "peewee", "panel", None, argv, argc, &xsh);
	XSetWMHints(dpy, pwin, &xwmh);

	qwin= XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), xsh.x, xsh.y, 300, 100, bw, black, white);
	XSetStandardProperties(dpy, qwin, "peewee", "qpanel", None, argv, argc, &xsh);
	XSetWMHints(dpy, qwin, &xwmh);

	xsh.height= CFRAME_HEIGHT;
	xsh.width= CFRAME_WIDTH;
	xsh.x= (DisplayWidth(dpy, DefaultScreen(dpy)) - xsh.width) / 2;
	xsh.y= (DisplayHeight(dpy, DefaultScreen(dpy)) - xsh.height) / 2;
	cwin= XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), xsh.x, xsh.y, xsh.width, xsh.height, bw, black, white);
	XSetStandardProperties(dpy, cwin, "peewee", "canvas", None, argv, argc, &xsh);
	XSetWMHints(dpy, cwin, &xwmh);

	xsh.height= TFRAME_HEIGHT;
	xsh.width= TFRAME_WIDTH;
	xsh.x= (DisplayWidth(dpy, DefaultScreen(dpy)) - xsh.width) / 2;
	xsh.y= (DisplayHeight(dpy, DefaultScreen(dpy)) - xsh.height) / 2;
	twin= XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), xsh.x, xsh.y, xsh.width, xsh.height, bw, black, white);
	XSetStandardProperties(dpy, twin, "peewee", "textsw", None, argv, argc, &xsh);
	XSetWMHints(dpy, twin, &xwmh);

	(void) strcpy(font, FONT);
	fun_index= 5;

	setup_images();
	setup_panel();
	setup_qpanel();
	setup_canvas();
	XMapWindow(dpy, pwin);
	XMapWindow(dpy, cwin);

	line= text= 0;
	for (;;) {
		XNextEvent(dpy, &event);

		if (lxt_event(&event))
			continue;

		switch (event.type) {
		case MotionNotify:
			pm_select((XPointerMovedEvent *) &event);
			break;
		case ButtonPress:
			bp_select((XButtonPressedEvent *) &event); break;
		default:
			break;
		}
	}
}

void
setup_canvas()
{
	XGCValues gcv;
	void setup_menus();

	if ((canvas= canvas_create(progname, dpy, cwin,
			LXC_WIDTH, CANVAS_WIDTH,
			LXC_HEIGHT, CANVAS_HEIGHT,
			LXC_NULL)) == (Canvas *) NULL)
		exit(-1);
	canvas_win= *((Window *) canvas_get(canvas, LXC_WINDOW));
	canvas_pm= *((Pixmap *) canvas_get(canvas, LXC_PIXMAP));

	gcv.function= GXxor;
	gcv.font= fontstruct->fid;
	gcv.foreground= black ^ white;
	gcv.plane_mask= black ^ white;
	canvas_gc= XCreateGC(dpy, canvas_win, (GCFunction | GCFont | GCForeground | GCBackground | GCPlaneMask), &gcv);

	XSelectInput(dpy, canvas_win, ExposureMask | ButtonPressMask | ButtonMotionMask);
	setup_menus();
}

void
setup_panel()
{
	void fun(), reset_choice(), friend(), scream(), quit();
	void penpal(), font_proc();

	if ((panel= panel_create(progname, dpy, pwin,
			LXP_FONT, font,
			LXP_NULL)) == (Panel *) NULL)
		exit(-1);
	if ((title= panelitem_create(panel, LXPI_LABEL,
			LXPI_X, 10,
			LXPI_Y, 20,
			LXPI_STRING, "\"Welcome to Pee-Wee's Playhouse!\"",
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((name= panelitem_create(panel, LXPI_TEXT,
			LXPI_X, 10,
			LXPI_Y, 50,
			LXPI_STRING, "Name:",
			LXPTEXT_MAXSTORE, 50,
			LXPTEXT_MAXDISPLAY, 40,
			LXPTEXT_VALUE, "Zyzzybalubah",
			LXPTEXT_IPOS, 7,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((word= panelitem_create(panel, LXPI_TEXT,
			LXPI_X, 10,
			LXPI_Y, 70,
			LXPI_STRING, "Secret word:",
			LXPTEXT_MAXSTORE, 20,
			LXPTEXT_MAXDISPLAY, 10,
			LXPTEXT_VALUE, "Oingo-boingo",
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((slider= panelitem_create(panel, LXPI_SLIDER,
			LXPI_X, 10,
			LXPI_Y, 100,
			LXPI_STRING, "How much fun?",
			LXPI_PROC, fun,
			LXPSLIDER_MINVAL, 0,
			LXPSLIDER_MAXVAL, 20,
			LXPSLIDER_BARLENGTH, 80,
			LXPSLIDER_VALUE, fun_index,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((scream_button= panelitem_create(panel, LXPI_BUTTON,
			LXPI_X, 300,
			LXPI_Y, 96,
			LXPI_IMAGE, scream_im,
			LXPI_PROC, scream,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((choice= panelitem_create(panel, LXPI_CHOICE,
			LXPI_X, 10,
			LXPI_Y, 140,
			LXPI_STRING, "Best friend:",
			LXPI_PROC, friend,
			LXPENUM_SELSTRINGS, "Pee-Wee", "Cowboy Curtis", "Penny", "Magic Screen", 0,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((cycle= panelitem_create(panel, LXPI_CYCLE,
			LXPI_X, 10,
			LXPI_Y, 170,
			LXPI_STRING, "Tell 'em, Pee-Wee!",
			LXPENUM_SELSTRINGS, quips[0], quips[1], quips[2], quips[3], quips[4], 0,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((toggle= panelitem_create(panel, LXPI_TOGGLE,
			LXPI_X, 10,
			LXPI_Y, 190,
			LXPI_STRING, "Good buddies:",
			LXPENUM_SELSTRINGS, "The Dinosaur Family", "The Traveling Salesman", "Randy", 0,
			LXPENUM_SELXS, 130, LXPENUM_LOCTERM,
			LXPENUM_SELYS, 0, 20, 40, LXPENUM_LOCTERM,
			LXPENUM_MARKXS, 110, LXPENUM_LOCTERM,
			LXPENUM_MARKYS, 0, 20, 40, LXPENUM_LOCTERM,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((font_button= panelitem_create(panel, LXPI_BUTTON,
			LXPI_X, 10,
			LXPI_Y, 260,
			LXPI_STRING, "Make it smaller, Magic Screen!",
			LXPI_PROC, font_proc,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((reset_button= panelitem_create(panel, LXPI_BUTTON,
			LXPI_X, 10,
			LXPI_Y, 290,
			LXPI_STRING, "Take it from the top!",
			LXPI_PROC, reset_choice,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((penpal_button= panelitem_create(panel, LXPI_BUTTON,
			LXPI_X, 10,
			LXPI_Y, 320,
			LXPI_STRING, "Oh boy, a pen pal letter!",
			LXPI_PROC, penpal,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((quit_button= panelitem_create(panel, LXPI_BUTTON,
			LXPI_X, 10,
			LXPI_Y, 360,
			LXPI_STRING, "So long for now!",
			LXPI_PROC, quit,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
}

void
setup_qpanel()
{
	void ok(), noway();

	if ((qpanel= panel_create(progname, dpy, qwin,
			LXP_FONT, font,
			LXP_NULL)) == (Panel *) NULL)
		exit(-1);
	if ((qmsg= panelitem_create(qpanel, LXPI_LABEL,
			LXPI_X, 10,
			LXPI_Y, 20,
			LXPI_STRING, "\"Aw, do you really have to go?\"",
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((ok_button= panelitem_create(qpanel, LXPI_BUTTON,
			LXPI_X, 10,
			LXPI_Y, 50,
			LXPI_STRING, "Yeah, sorry.",
			LXPI_PROC, ok,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
	if ((noway_button= panelitem_create(qpanel, LXPI_BUTTON,
			LXPI_X, 150,
			LXPI_Y, 50,
			LXPI_STRING, "Just joking!",
			LXPI_PROC, noway,
			LXPI_NULL)) == (Panel_item *) NULL)
		exit(-1);
}

void
fun(p, pi)
Panel *p;
Panel_item *pi;
{
	fun_index= *((int *) panelitem_get(panel, slider, LXPSLIDER_VALUE));
}

void
friend(p, pi)
Panel *p;
Panel_item *pi;
{
	best_friend= *((int *) panelitem_get(panel, choice, LXPENUM_VALUE));
	switch (best_friend) {
	case 0:
		tile= peewee_im;
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, peewee_im), LXMI_STATE, LXMI_INACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, cowboy_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, penny_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, magic_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		break;
	case 1:
		tile= cowboy_im;
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, peewee_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, cowboy_im), LXMI_STATE, LXMI_INACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, penny_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, magic_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		break;
	case 2:
		tile= penny_im;
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, peewee_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, cowboy_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, penny_im), LXMI_STATE, LXMI_INACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, magic_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		break;
	case 3:
		tile= magic_im;
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, peewee_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, cowboy_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, penny_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
		(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, magic_im), LXMI_STATE, LXMI_INACTIVE, LXMI_NULL);
		break;
	default:
		break;
	}
}

void
reset_choice(p, pi)
Panel *p;
Panel_item *pi;
{
	tile= peewee_im;
	(void) panelitem_set(panel, name, LXPTEXT_VALUE, "Zyzzybalubah", LXPI_NULL);
	(void) panelitem_set(panel, slider, LXPSLIDER_VALUE, 5, LXPI_NULL);
	(void) panelitem_set(panel, choice, LXPENUM_VALUE, 0, LXPI_NULL);
	(void) panelitem_set(panel, cycle, LXPENUM_VALUE, 0, LXPI_NULL);
	(void) panelitem_set(panel, toggle, LXPENUM_VALUE, 0x7, LXPI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, peewee_im), LXMI_STATE, LXMI_INACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, cowboy_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, penny_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, magic_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
}

void
font_proc(p, pi)
Panel *p;
Panel_item *pi;
{
	char str[80];

	if (!strcmp(font, "8x13")) {
		(void) strcpy(str, "Now I can't see anything!");
		(void) strcpy(font, "6x10");
	}
	else {
		(void) strcpy(str, "Make it smaller, Magic Screen!");
		(void) strcpy(font, "8x13");
	}
	(void) panel_set(panel, LXP_VISIBLE, FALSE, LXP_NULL);
	(void) panelitem_set(panel, title, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, word, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, name, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, slider, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, choice, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, cycle, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, toggle, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, scream_button, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, reset_button, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, penpal_button, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, quit_button, LXPI_FONT, font, LXPI_NULL);
	(void) panelitem_set(panel, font_button, LXPI_FONT, font, LXPI_STRING, str, LXPI_NULL);
	(void) panel_set(panel, LXP_VISIBLE, TRUE, LXP_NULL);
	menu_set(base_menu, LXM_FONT, font, LXM_NULL);
	menu_set(friend_menu, LXM_FONT, font, LXM_NULL);
}

void
penpal(p, pi)
Panel *p;
Panel_item *pi;
{
	int val;

	if (textsw_active()) {
		alert_prompt("peewee", dpy, &val,
				LXA_LABEL, "You haven't finished reading",
				LXA_LABEL, "your first pen pal letter yet!",
				LXA_BUTTON, "Gee, thanks for reminding me.", 0,
				LXA_NULL);
		return;
	}

	letter= textsw_create("peewee", dpy, twin,
				LXT_INPUTFILE, "penpal.letter",
				LXT_NULL);
	XMapWindow(dpy, twin);
	return;
}

void
quit(p, pi)
Panel *p;
Panel_item *pi;
{
	int val;

	(void) panel_block(qpanel, &val);
	switch (val) {
	case OK:
		exit(0);
		break;
	case NOWAY:
		break;
	default:
		break;
	}
}

void
ok(p, pi)
Panel *p;
Panel_item *pi;
{
	(void) panel_unblock(qpanel, OK);
}

void
noway(p, pi)
Panel *p;
Panel_item *pi;
{
	(void) panel_unblock(qpanel, NOWAY);
}

pm_select(event)
XPointerMovedEvent *event;
{
	int x, y;

	x= *((int *) canvas_get(canvas, LXC_XOFFSET));
	y= *((int *) canvas_get(canvas, LXC_YOFFSET));

	if (event->state & Button1Mask)
		line_select(event->x+x, event->y+y);
	else if (event->state & Button2Mask)
		text_select(event->x+x, event->y+y);
}

bp_select(event)
XButtonPressedEvent *event;
{
	int vx, vy;

	vx= *((int *) canvas_get(canvas, LXC_XOFFSET));
	vy= *((int *) canvas_get(canvas, LXC_YOFFSET));

	switch (event->button) {
	case Button1:
		line_select(event->x+vx, event->y+vy);
		break;
	case Button2:
		text_select(event->x+vx, event->y+vy);
		break;
	case Button3:
		menu_show(base_menu, event);
		break;
	}
}

line_select(x, y)
int x, y;
{
	int vx, vy;

	vx= *((int *) canvas_get(canvas, LXC_XOFFSET));
	vy= *((int *) canvas_get(canvas, LXC_YOFFSET));

	if (line) {
		XDrawLine(dpy, canvas_win, canvas_gc, 0-vx, 0-vy, lx-vx, ly-vy);
		XDrawLine(dpy, canvas_pm, canvas_gc, 0, 0, lx, ly);
	}
	lx= x;
	ly= y;
	XDrawLine(dpy, canvas_win, canvas_gc, 0-vx, 0-vy, lx-vx, ly-vy);
	XDrawLine(dpy, canvas_pm, canvas_gc, 0, 0, lx, ly);
	line= 1;
}

text_select(x, y)
int x, y;
{
	int vx, vy, ord;

	vx= *((int *) canvas_get(canvas, LXC_XOFFSET));
	vy= *((int *) canvas_get(canvas, LXC_YOFFSET));

	if (text) {
		XDrawString(dpy, canvas_win, canvas_gc, tx-vx, ty-vy, string, strlen(string));
		XDrawString(dpy, canvas_pm, canvas_gc, tx, ty, string, strlen(string));
	}
	tx= x;
	ty= y;
	ord= *((int *) panelitem_get(panel, cycle, LXPENUM_VALUE));
	string= quips[ord];
	XDrawString(dpy, canvas_win, canvas_gc, tx-vx, ty-vy, string, strlen(string));
	XDrawString(dpy, canvas_pm, canvas_gc, tx, ty, string, strlen(string));
	text= 1;
}

void
setup_images()
{
	Visual *v;
	int d;

	v= XDefaultVisualOfScreen(XDefaultScreenOfDisplay(dpy));
	d= XDefaultDepthOfScreen(XDefaultScreenOfDisplay(dpy));
	if ((scream_im= image_create(dpy, black, white, scream_bits, scream_width, scream_height, d)) == (XImage *) NULL)
		exit(-1);
	if ((peewee_im= image_create(dpy, black, white, peewee_bits, peewee_width, peewee_height, d)) == (XImage *) NULL)
		exit(-1);
	if ((cowboy_im= image_create(dpy, black, white, cowboy_bits, cowboy_width, cowboy_height, d)) == (XImage *) NULL)
		exit(-1);
	if ((penny_im= image_create(dpy, black, white, penny_bits, penny_width, penny_height, d)) == (XImage *) NULL)
		exit(-1);
	if ((magic_im= image_create(dpy, black, white, magic_bits, magic_width, magic_height, d)) == (XImage *) NULL)
		exit(-1);
	tile= peewee_im;
}

void
setup_menus()
{
	Menu_item *mi;
	void peewee_proc(), cowboy_proc(), penny_proc(), magic_proc();
	void erase_proc();

	if ((friend_menu= menu_create(progname, dpy, canvas_win,
				LXM_TITLE, "Best Friend",
				LXM_FOREGROUND, black,
				LXM_BACKGROUND, white,
				LXM_NULL)) == (Menu *) NULL)
		exit(-1);
	if ((mi= menuitem_create(LXMI_IMAGE, peewee_im,
				LXMI_PROC, peewee_proc,
				LXMI_NULL)) == (Menu_item *) NULL)
		exit(-1);
	(void) menuitem_set(mi, LXMI_STATE, LXMI_INACTIVE, 0);
	(void) menuitem_insert(friend_menu, mi);
	if ((mi= menuitem_create(LXMI_IMAGE, cowboy_im,
				LXMI_PROC, cowboy_proc,
				LXMI_NULL)) == (Menu_item *) NULL)
		exit(-1);
	(void) menuitem_insert(friend_menu, mi);
	if ((mi= menuitem_create(LXMI_IMAGE, penny_im,
				LXMI_PROC, penny_proc,
				LXMI_NULL)) == (Menu_item *) NULL)
		exit(-1);
	(void) menuitem_insert(friend_menu, mi);
	if ((mi= menuitem_create(LXMI_IMAGE, magic_im,
				LXMI_PROC, magic_proc,
				LXMI_NULL)) == (Menu_item *) NULL)
		exit(-1);
	(void) menuitem_insert(friend_menu, mi);

	if ((base_menu= menu_create(progname, dpy, canvas_win,
				LXM_FOREGROUND, black,
				LXM_BACKGROUND, white,
				LXM_NULL)) == (Menu *) NULL)
		exit(-1);
	if ((mi= menuitem_create(LXMI_STRING, "Best Friend",
				LXMI_PULLRIGHT, friend_menu,
				LXMI_NULL)) == (Menu_item *) NULL)
		exit(-1);
	(void) menuitem_insert(base_menu, mi);
	if ((mi= menuitem_create(LXMI_STRING, "Erase",
				LXMI_PROC, erase_proc,
				LXMI_NULL)) == (Menu_item *) NULL)
		exit(-1);
	(void) menuitem_insert(base_menu, mi);
}

void
peewee_proc(menu, menu_item)
Menu *menu;
Menu_item *menu_item;
{
	tile= peewee_im;
	(void) panelitem_set(panel, choice, LXPENUM_VALUE, 0, LXPI_NULL);
	(void) menuitem_set(menu_item, LXMI_STATE, LXMI_INACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, cowboy_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, penny_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, magic_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
}

void
cowboy_proc(menu, menu_item)
Menu *menu;
Menu_item *menu_item;
{
	tile= cowboy_im;
	(void) panelitem_set(panel, choice, LXPENUM_VALUE, 1, LXPI_NULL);
	(void) menuitem_set(menu_item, LXMI_STATE, LXMI_INACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, peewee_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, penny_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, magic_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
}

void
penny_proc(menu, menu_item)
Menu *menu;
Menu_item *menu_item;
{
	tile= penny_im;
	(void) panelitem_set(panel, choice, LXPENUM_VALUE, 2, LXPI_NULL);
	(void) menuitem_set(menu_item, LXMI_STATE, LXMI_INACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, peewee_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, cowboy_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, magic_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
}

void
magic_proc(menu, menu_item)
Menu *menu;
Menu_item *menu_item;
{
	tile= magic_im;
	(void) panelitem_set(panel, choice, LXPENUM_VALUE, 3, LXPI_NULL);
	(void) menuitem_set(menu_item, LXMI_STATE, LXMI_INACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, peewee_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, cowboy_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	(void) menuitem_set(menuitem_find(friend_menu, LXMI_IMAGE, penny_im), LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
}

void
erase_proc(menu, menu_item)
Menu *menu;
Menu_item *menu_item;
{
	line= text= 0;
	canvas_clear(canvas);
}

void
scream(p, pi)
Panel *p;
Panel_item *pi;
{
	int i, j, rows, columns;
	int h, w;
	void erase_proc();

	erase_proc((Menu *) NULL, (Menu_item *) NULL);
	fun_index= *((int *) panelitem_get(panel, slider, LXPSLIDER_VALUE));
	h= peewee_height+(peewee_height/2);
	w= peewee_width+(peewee_width/2);
	rows= CANVAS_HEIGHT/h;
	if (rows > fun_index)
		rows= fun_index;
	columns= CANVAS_WIDTH/w;
	if (columns > fun_index)
		columns= fun_index;
	for (i= 0; i < rows; i++) {
		for (j= 0; j < columns; j++)
			XPutImage(dpy, canvas_pm, canvas_gc, tile, 0, 0, j*w, i*h, w, h);
	}
	canvas_flush(canvas);
}
