.PP
\0
.ps 14
.vs 20p
.ft B
.ce
An Introduction to The Lamont X Toolkit
.sp 4p
.ps 12
.vs 16p
.ft I
.ce 4
Roger Davis, Ken Howard and Bill Menke
.sp 4p
.ps 10
.vs 12p
Lamont-Doherty Geological Observatory
Palisades, NY 10964
rbd@lamont.ldgo.columbia.edu
.ft R
.sp 24p
.ps 10
.vs 12p
.PP
The Lamont X toolkit (LXT) is a programming package intended to supply much of the
functionality of SunView (a proprietary toolkit developed by Sun Microsystems,
Inc., for use on Sun workstations only) to programmers who are developing
software on an X11 platform. LXT provides walking menus, canvases, panels
containing all of the major item types supported by SunView, and text
subwindows. Blocking panels which freeze the display until the user provides
critical feedback are also available. All canvases, panels and text subwindows
are both vertically and horizontally scrollable.
.PP
LXT is designed to allow the programmer to use its facilities on
an as-needed basis rather than to wrest total control of the application from
the caller. While LXT's data objects are relatively opaque, it is possible
for the programmer to create other Xlib data objects and manage them at will.
Event notification is completely under program control and defers to the LXT
event processor only as directed.
.PP
The entire LXT package was written directly on the Xlib library and does not
require the support of any other toolkit. Although the development of LXT was
done entirely on Sun workstations, it should be easily portable to any system which
provides a working X11 server and the MIT-distributed Xlib programming interface.
LXT was originally released in early 1988 under the name 'XView', which was
changed in late 1989 after Sun's release of a similar product with the same name.
.ft B
.sp 24p
(1) Menus
.PP
Walking menus containing items represented in the menu display by either a text
string or an image may be created and displayed with LXT. A procedure can
be associated with a menu item such that when the item is selected by releasing
the mouse button which caused the menu to be displayed, the attached procedure
will be called.
.PP
A menu is created with the function
.sp 4p
\fBMenu *
.br
menu_create(\fIprogname, display, window, [varargs ...,] \fBLXM_NULL)
.br
char \fI*progname;\fB
.br
Display \fI*display;\fB
.br
Window \fIwindow;\fR
.sp 4p
This function, like many other LXT routines, takes a variable length argument
list consisting of a few necessary arguments followed by any number of optional
arguments and terminated by the special argument LXM_NULL. The required arguments
here are the program name, an open display connection and the XID of an existing
window from which the menu will be displayed. The optional arguments are
attribute/value pairs which specify some characteristic of the menu. The following
table lists the possible attributes, the C data type of the supplied values and
their default values. A brief description of the attributes follows.
.sp 4p
\fBLXM_FONT\fR				char *		obtained with XGetDefault()
.br
\fBLXM_FOREGROUND\fR		unsigned long	BlackPixel(\fIdisplay\fR)
.br
\fBLXM_BACKGROUND\fR		unsigned long	WhitePixel(\fIdisplay\fR)
.br
\fBLXM_TITLE\fR				char *		(char *) NULL
.br
\fBLXM_HIGHLIGHT\fR			int			LXM_INVERT
.br
\fBLXM_HMARGIN\fR			int			8
.br
\fBLXM_VMARGIN\fR			int			2
.br
\fBLXM_BWIDTH\fR				int			2
.br
\fBLXM_CLIENTDATA\fR			char *		(char *) NULL
.sp 4p
LXM_FONT is the name of the font used to display any text strings which appear
in the menu. LXM_FOREGROUND and LXM_BACKGROUND are the foreground and background
colors of the menu. LXM_TITLE determines the text string which will be displayed at
the top of the menu as a title. LXM_HIGHLIGHT sets the mode used to highlight the
currently selected menu item. The default mode is LXM_INVERT, which causes the
item to be displayed in reverse video. Setting the mode to LXM_BOX will cause a 
box to be drawn about the item. LXM_HMARGIN and LXM_VMARGIN are the horizontal and
vertical margins in pixels which separate the menu items from one another and from
the menu's borders. LXM_BWIDTH determines the border width of the menu.
LXM_CLIENTDATA is a pointer to an application memory address which is of no
particular interest to LXT itself and may be used by the application programmer
to reference private data through the menu.
.PP
Any of the above attributes may be set or queried at any time after the menu's
creation with the functions
.sp 4p
\fBint
.br
menu_set(\fImenu, [varargs ...,] \fBLXM_NULL)
.br
Menu \fI*menu;\fR
.sp 4p
and
.sp 4p
\fBvoid *
.br
menu_get(\fImenu, attribute)\fB
.br
Menu \fI*menu;\fB
.br
int \fIattribute;\fR
.sp 4p
The menu_set() function returns either \fBLX_SUCCESS\fR or \fBLX_ERROR\fR,
while menu_get() returns a pointer to the value of the attribute which must be
cast to the type appropriate for that attribute. (The pointer returned will
often point directly to an internal data structure and must never be used to
assign a value.)
.PP
A menu may be destroyed at any time with the \fBmenu_destroy(\fImenu\fB)\fR
function. (This routine does not destroy menu items which have been associated
with the menu.)
.PP
A menu item is created with a call to
.sp 4p
\fBMenu_item *
.br
menuitem_create(\fI[varargs ...,] \fBLXMI_NULL)\fR
.sp 4p
The variable length argument list terminated by LXMI_NULL must contain
attribute/value pairs specifying some characteristic of the item.
The following table lists all item attributes, the C data type of the supplied
values and their default values.
.sp 4p
\fBLXMI_STRING\fR				char *		(char *) NULL
.br
\fBLXMI_IMAGE\fR				XImage *		(XImage *) NULL
.br
\fBLXMI_PULLRIGHT\fR			Menu *		(Menu *) NULL
.br
\fBLXMI_PROC\fR				void (*)()		void (*)() NULL
.br
\fBLXMI_STATE\fR				int			LXMI_ACTIVE
.br
\fBLXMI_CLIENTDATA\fR			char *		(char *) NULL
.br
.sp 4p
LXMI_STRING and LXMI_IMAGE are the text string and image to be displayed in the menu
(if both are non-null, the image will be displayed and not the string).
LXMI_PULLRIGHT is a walking menu which is to be displayed when the item is selected.
LXMI_PROC is the procedure to be invoked when a mouse button release occurs while
the item is selected by the user. LXMI_STATE, which may be set to either LXMI_ACTIVE
or LXMI_INACTIVE, determines whether or not the item may be selected by the user
when the menu is displayed. LXMI_CLIENTDATA is a pointer to private data which is
not referenced by LXT.
.PP
The application procedure attached to the item via the LXMI_PROC attribute should be
defined as
.sp 4p
\fBvoid
.br
proc(\fImenu, item\fB)
.br
Menu \fI*menu;\fB
.br
Menu_item \fI*item;\fR
.sp 4p
The procedure arguments will be set to the menu and item from which it was
called at the time that it is invoked upon mouse button release.
.PP
Any of the menu item attributes may be set or queried at any time after the item's
creation with the functions
.sp 4p
\fBint
.br
menuitem_set(\fIitem, [varargs ...,] \fBLXMI_NULL)
.br
Menu_item \fI*item;\fR
.sp 4p
and
.sp 4p
\fBvoid *
.br
menuitem_get(\fIitem, attribute)\fB
.br
Menu_item \fI*item;\fB
.br
int \fIattribute;\fR
.sp 4p
The menuitem_set() function returns either \fBLX_SUCCESS\fR or \fBLX_ERROR\fR,
while menuitem_get() returns a pointer to the value of the attribute which must be
cast to the type appropriate for that attribute. (The pointer returned will
often point directly to an internal data structure and must never be used to
assign a value.) The attribute
.sp 4p
\fBLXMI_TIMESTAMP\fR			Time
.sp 4p
which is set to the current time (as maintained by the X server) whenever the
item's LXMI_PROC routine is called because the user has selected the item, is
query-only.
.PP
A menu item is inserted into an existing menu with the function
.sp 4p
\fBint
.br
menuitem_insert(\fImenu, item\fB)
.br
Menu \fI*menu;\fB
.br
Menu_item \fI*item;\fR
.sp 4p
The function returns either \fBLX_SUCCESS\fR or \fBLX_ERROR\fR. A menu item
may be inserted into any number of menus \(em the only restriction is that menus
and items may not be constructed in such a manner as to permit a menu to
recursively display itself via items to which pullright menus are attached.
An item may be removed from a menu by calling
.sp 4p
\fBint
.br
menuitem_delete(\fImenu, item\fB)
.br
Menu \fI*menu;\fB
.br
Menu_item \fI*item;\fR
.PP
The routine
.sp 4p
\fBMenu_item *
.br
menuitem_find(\fImenu, attribute, value\fB)
.br
Menu \fI*menu;\fB
.br
int \fIattribute;\fB
.br
 ... \fIvalue;\fR
.sp 4p
returns the first item in a menu with an attribute/value pair which matches the
supplied arguments.
.PP
A menu item may be destroyed at any time with the \fBmenuitem_destroy(\fIitem\fB)\fR
function. It is the programmer's responsibility to guarantee that the item has
already been deleted from any menu into which it had been inserted.
.PP
A menu is displayed with the function
.sp 4p
\fBvoid
.br
menu_show(\fImenu, event\fB)
.br
Menu \fI*menu;\fB
.br
XButtonPressedEvent \fI*event;\fR
.sp 4p
The required arguments are the menu to be displayed and the X11 ButtonPress
event generated by the user which triggers the display of the menu.
This function causes LXT to grab the X11 server until a mouse button is released.
The routine operates on the assumption that the application is causing the menu
to be drawn as a consequence of a user depressing a mouse button, and may
not behave properly if it is invoked under any other circumstances. LXT will
track the item selections made by the user, cause any necessary pullright walking
menus to be displayed, and invoke any application-defined procedures attached to
any items that are selected at the time of button release. Note that items with
pullright menus may have attached procedures \(em in such a case, the item
procedures will be invoked beginning with the procedure attached to the selected
item of the rightmost pullright menu and ending with the procedure attached to
the selected item of the menu named in the call to menu_show().
.PP
Every time a menu is displayed with menu_show(), LXT remembers the final
configuration of selected items and displayed pullright menus chosen by the
user at the time the mouse button was released, and if the user so desires, can
immediately regenerate this final configuration the next time the menu is
displayed with menu_show(). This regeneration is automatic if the value of the
\fBMenuHistory\fR attribute has been set to \fBYes\fR in the user's resource
database. (This is usually done by inserting the line
.sp 2p
*MenuHistory:		Yes
.sp 2p
in the user's ~/.Xdefaults file.) If this attribute is not set, the user can
still utilize this feature by depressing the Control key on the keyboard while
depressing the mouse button at the time the menu is displayed. If the attribute
has been set in the user's resource database, the feature can be disabled by
depressing the Control key while displaying the menu.
.PP
The following code fragments illustrate the use of some of the procedures
explained above:
.sp 4p
Display *dpy;
.br
Window win;
.br
unsigned long red, blue;
.br
Menu *menu, *menu_create();
.br
Menu_item *mi, *menuitem_create(), *menuitem_find();
.br
void read_proc(), write_proc();
.br
 ...

/* create a menu and some items */
.br
if ((menu= menu_create(argv[0], dpy, win,
.br
			LXM_FONT, "8x13",
.br
			LXM_TITLE, "Root Menu",
.br
			LXM_FOREGROUND, blue,
.br
			LXM_BACKGROUND, red,
.br
			LXM_NULL)) == (Menu *) NULL)
.br
	exit(-1);
.br
if ((mi= menuitem_create(LXMI_STRING, "Read",
.br
			LXMI_PROC, read_proc,
.br
			LXMI_NULL)) == (Menu_item *) NULL)
.br
	exit(-1);
.br
menuitem_insert(menu, mi);
.br
if ((mi= menuitem_create(LXMI_STRING, "Write",
.br
			LXMI_PROC, write_proc,
.br
			LXMI_NULL)) == (Menu_item *) NULL)
.br
	exit(-1);
.br
menuitem_insert(menu, mi);
.br
 ...

/* deactivate an item */
.br
menuitem_set(menuitem_find(menu, LXMI_STRING, "Read"),
.br
			LXMI_STATE, LXMI_INACTIVE, LXMI_NULL);
.br
 ...

.br
bp_select(event)
.br
/* function called from main event loop whenever a button is pressed */
.br
XButtonPressedEvent *event;
.br
{
.br
	void menu_show();
.br

.br
	switch (event->button) {
.br
	case Button1:
.br
	case Button2:
.br
		break;
.br
	case Button3:
.br
		menu_show(menu, event);
.br
		break;
.br
	}
.br
}
.ft B
.sp 24p
(2) Canvases
.PP
A \fIcanvas\fR is a display object encapsulating a drawing surface whose
drawables, the displayed window and the
pixmap backing store, are directly accessible to the programmer via any of the
common Xlib output operations such as XDrawLine(), XFillRectangle(), etc.
If the window enclosing the canvas is (re)sized by a window management operation
to a size which is smaller than that requested by the programmer, scrollbars
will be dynamically attached to it. Canvases are created by calls to
.sp 4p
\fBCanvas *
.br
canvas_create(\fIprogname, display, window, [varargs ...,] \fBLXC_NULL)
.br
char \fI*progname;\fB
.br
Display \fI*display;\fB
.br
Window \fIwindow;\fR
.sp 4p
The required arguments are the program name, an open display connection, an
existing window which will enclose the canvas, and the special argument LXC_NULL
which is used to terminate the variable length argument list. The following
table lists the possible attributes, the C data type of the supplied values
and their default values. A brief description of the attributes follows.
.sp 4p
\fBLXC_FOREGROUND\fR			unsigned long	BlackPixel(\fIdisplay\fR)
.br
\fBLXC_BACKGROUND\fR			unsigned long	WhitePixel(\fIdisplay\fR)
.br
\fBLXC_WIDTH\fR				int			500
.br
\fBLXC_HEIGHT\fR				int			500
.br
\fBLXC_BARWIDTH\fR			int			10
.br
\fBLXC_BUBBLEMARGIN\fR		int			2
.br
\fBLXC_BUTTONLEN\fR			int			14
.br
\fBLXC_CCURSOR\fR			Cursor		diagonal arrow
.br
\fBLXC_VSCURSOR\fR			Cursor		right arrow
.br
\fBLXC_HSCURSOR\fR			Cursor		down arrow
.br
\fBLXC_VISIBLE\fR				boolean		TRUE
.br
\fBLXC_ACTIVE\fR				boolean		TRUE
.br
\fBLXC_MODE\fR				int			LXC_STATIC
.br
\fBLXC_BATCH\fR				int			LXC_BATCHOFF
.br
\fBLXC_EXPOSEPROC\fR			void (*)()		internal routine
.sp 4p
LXC_FOREGROUND and LXC_BACKGROUND are the colors used to build graphics contexts
for the drawing of scrollbars and for clearing the canvas with the function
\fBcanvas_clear(\fIcanvas\fB).\fR They have no effect upon any drawing operation
upon the canvas by the programmer. The virtual size of the canvas is set with
LXC_WIDTH and LXC_HEIGHT, which may be larger or smaller than the size of the
window enclosing the canvas. LXC_BARWIDTH, LXC_BUBBLEMARGIN and LXC_BUTTONLEN
determine various aspects of both of the canvas' scrollbars. LXC_CCURSOR,
LXC_VSCURSOR and LXC_HSCURSOR set the cursor for the canvas and its vertical and
horizontal scrollbars. LXC_VISIBLE determines whether or not the canvas is visible.
LXC_ACTIVE determines whether or not the canvas is sensitive
to user input. LXC_MODE, which must be either LXC_STATIC, LXC_DYNAMICCLR
or LXC_DYNAMICPRS, determines the relationship between the virtual canvas and the
window which contains it. If the mode is LXC_STATIC, the size of the virtual canvas
remains fixed no matter what happens to the size of the containing window \(em
when the latter is made smaller or larger than the former by a user resize
operation, scrollbars will be attached or removed as necessary. If the mode is
LXC_DYNAMICCLR or LXC_DYNAMICPRS, the size of the virtual canvas will be dynamically
altered to match the size of the containing window whenever a resize of the latter
occurs (this means that scrollbars are never required). If the mode is
LXC_DYNAMICCLR, the canvas will be erased when it is resized. If the mode is
LXC_DYNAMICPRS, its former contents will be preserved subject to size constraints
upon resizing. The LXC_BATCH attribute, which may be set to either LXC_BATCHON
or LXC_BATCHOFF, is discussed below in the context of the canvas drawing
convenience routines. LXC_EXPOSEPROC sets the procedure which is used to
redraw the canvas upon exposure. It is initialized to an internal routine
which restores the damaged portion of the canvas window from its backing store
pixmap.
.PP
The canvas actually consists of a window (which is a subwindow of the window
supplied to the create_canvas() call) and a pixmap used for backing store, since
no backing store is available under many MIT-distributed X11 servers. For doing
extensive drawing, it is recommended that all Xlib draws be done to the pixmap
which may then be copied to the canvas window and displayed with a call to
\fBcanvas_flush(\fIcanvas\fB).\fR
Occasional light draw operations, such as a few vectors and a text string or two,
should be done to both drawables simultaneously. Transient draws such as bounding
boxes or rubberband lines might be made to the canvas window only. \fIThe programmer
should be aware that any output drawn to the window but not the backing store
will be lost if an expose event should cause the window's contents to be
refreshed from the backing store.\fR
.PP
It may sometimes be more convenient to use the toolkit routines
.sp 4p
\fBint
.br
canvas_draw_line(\fIcanvas, x1, y1, x2, y2, gc\fB)
.br
Canvas \fI*canvas;\fB
.br
int \fIx1, y1, x2, y2;\fB
.br
GC \fIgc;\fR
.sp 4p
and
.sp 4p
\fBint
.br
canvas_draw_string(\fIcanvas, x, y, string, gc\fB)
.br
Canvas \fI*canvas;\fB
.br
int \fIx, y;\fB
.br
char \fI*string;\fB
.br
GC \fIgc;\fR
.sp 4p
to draw into a canvas than to use XDrawLine() and XDrawString(). These routines
will draw into both the canvas and its backing store if LXC_BATCH is set to
LXC_BATCHOFF, otherwise they will draw only into the backing store.
.PP
The event mask for the canvas is initialized to accept only expose events.
It is entirely possible to modify this mask to accept other events of interest \(em
some care must be taken, however, not to mask out expose events and thereby
disable default expose event processing.
The event mask for the enclosing window, passed to LXT as an argument to
canvas_create(), should under no circumstances be altered by the main program.
.PP
Many of the attributes of a canvas can be set or queried at any time after
its creation with the functions
.sp 4p
\fBint
.br
canvas_set(\fIcanvas, [varargs ...,] \fBLXC_NULL)
.br
Canvas \fI*canvas;\fR
.sp 4p
and
.sp 4p
\fBvoid *
.br
canvas_get(\fIcanvas, attribute)\fB
.br
Canvas \fI*canvas;\fB
.br
int \fIattribute;\fR
.sp 4p
The canvas_set() function returns either \fBLX_SUCCESS\fR or \fBLX_ERROR\fR,
while canvas_get() returns a pointer to the value of the attribute which must be
cast to the type appropriate for that attribute. (The pointer returned will
often point directly to an internal data structure and must never be used to
assign a value.) All of the attributes described above may be set in this manner.
The following attributes are query-only:
.sp 4p
\fBLXC_WINDOW\fR				Window
.br
\fBLXC_PIXMAP\fR				Pixmap
.br
\fBLXC_XOFFSET\fR				int
.br
\fBLXC_YOFFSET\fR				int
.br
\fBLXC_VSCROLL\fR				boolean
.br
\fBLXC_HSCROLL\fR				boolean
.br
\fBLXC_DWIDTH\fR				int
.br
\fBLXC_DHEIGHT\fR				int
.sp 4p
LXC_WINDOW and LXC_PIXMAP are the display window and backing store pixmap of the
canvas as described above. These are the drawables to which all output should be
written. Note that if LXC_MODE is either LXC_DYNAMICCLR or LXC_DYNAMICPRS, the
value of LXC_PIXMAP will change whenever a user resizes the canvas window and
should therefore be queried before attempting to perform any draw operations.
The same warning applies to resizing the canvas via the LXC_WIDTH and LXC_HEIGHT
attributes as well as to the deactivation and subsequent reactivation of the canvas
via the LXC_VISIBLE attribute.
LXC_XOFFSET and LXC_YOFFSET are the coordinates of the backing store
pixmap pixel which is currently visible at the upper-leftmost corner of the canvas
window. These will be non-zero positive numbers when the user scrolls the
upper-leftmost corner of the virtual canvas out of view.
LXC_VSCROLL and LXC_HSCROLL indicate whether or not the vertical and horizontal
scrollbars are currently visible. LXC_DWIDTH and LXC_DHEIGHT give
the dimensions of the currently displayed portion of the canvas which is visible
to the user.
.PP
A canvas may be destroyed at any time with the \fBcanvas_destroy(\fIcanvas\fB)\fR
function.
.PP
The following code fragments demonstrate the use of the procedures described above.
.sp 4p
Display *dpy;
.br
Window canvas_frame, canvas_window;
.br
Canvas *canvas;
.br
Pixmap canvas_pixmap;
.br
GC gc;
.br
int vx, vy;
  ...

/* create and display canvas */
.br
if ((canvas_create(argv[0], dpy, canvas_frame,
.br
			LXC_WIDTH, 800,
.br
			LXC_HEIGHT, 400,
.br
			LXC_NULL)) == (Canvas *) NULL)
.br
	printf("Cannot create canvas\\n");
.br
XMapWindow(dpy, canvas_frame);
  ...

/* get the canvas drawables */
.br
canvas_window= *((Window *) canvas_get(canvas, LXC_WINDOW));
.br
canvas_pixmap= *((Pixmap *) canvas_get(canvas, LXC_PIXMAP));
  ...

/* set an input mask */
.br
XSelectInput(dpy, canvas_window, ExposureMask | ButtonPressMask | ButtonMotionMask);
  ...

/* draw a line from virtual (0, 0) to virtual (10, 10) */
.br
vx= *((int *) canvas_get(canvas, LXC_XOFFSET));
.br
vy= *((int *) canvas_get(canvas, LXC_YOFFSET));
.br
XDrawLine(dpy, canvas_window, gc, 0-vx, 0-vy, 10-vx, 10-vy);
.br
XDrawLine(dpy, canvas_pixmap, gc, 0, 0, 10, 10);
  ...

/* destroy the canvas */
.br
canvas_destroy(canvas);
.ft B
.sp 24p
(3) Panels
.PP
A \fIpanel\fR is a display object containing a collection of \fIpanel items\fR
with which a user may interact. There are several types of panel items, most
of which have some value which is visually displayed, may be changed at will by
the user and may be set or queried by the application program.
If the window enclosing the panel is (re)sized by a window management operation
to a size which is smaller than that required for the display of all its items,
scrollbars will be dynamically attached to it. Panels are created by calls to
.sp 4p
\fBPanel *
.br
panel_create(\fIprogname, display, window, [varargs ...,] \fBLXP_NULL)
.br
char \fI*progname;\fB
.br
Display \fI*display;\fB
.br
Window \fIwindow;\fR
.sp 4p
The required arguments are the program name, an open display connection, an
existing window which will enclose the panel, and the special argument LXP_NULL
which is used to terminate the variable length argument list. The optional
arguments are attribute/value pairs which specify some characteristic of the panel.
The following table lists the possible attributes, the C data type of the supplied
values and their default values. A brief description of the attributes follows.
.sp 4p
\fBLXP_FONT\fR				char *		"8x13"
.br
\fBLXP_FOREGROUND\fR			unsigned long	BlackPixel(\fIdisplay\fR)
.br
\fBLXP_BACKGROUND\fR			unsigned long	WhitePixel(\fIdisplay\fR)
.br
\fBLXP_WIDTH\fR				int			(none)
.br
\fBLXP_HEIGHT\fR				int			(none)
.br
\fBLXP_BOTTOMMARGIN\fR		int			15
.br
\fBLXP_RIGHTMARGIN\fR		int			15
.br
\fBLXP_BARWIDTH\fR			int			10
.br
\fBLXP_BUBBLEMARGIN\fR		int			2
.br
\fBLXP_BUTTONLEN\fR			int			14
.br
\fBLXP_PCURSOR\fR				Cursor		diagonal arrow
.br
\fBLXP_VSCURSOR\fR			Cursor		right arrow
.br
\fBLXP_HSCURSOR\fR			Cursor		down arrow
.br
\fBLXP_VISIBLE\fR				boolean		TRUE
.br
\fBLXP_ACTIVE\fR				boolean		TRUE
.br
\fBLXP_CLIENTDATA\fR			char *		(char *) NULL
.sp 4p
LXP_FONT is used to set the default font for any panel items which might be added
to the panel. LXP_FOREGROUND and LXP_BACKGROUND are the colors used to display
the scrollbars and any portions of the panel that are not occupied by items.
The virtual size of the panel may be set with LXP_WIDTH and LXP_HEIGHT. (These
values will be ignored if they are smaller than the minimum size required for
the display of all items contained within the panel.) LXP_BOTTOMMARGIN or
LXP_RIGHTMARGIN may be used to request additional spacing between the bottommost
or rightmost item and the bottom or right edge of the panel. LXP_BARWIDTH,
LXP_BUBBLEMARGIN and LXP_BUTTONLEN determine various aspects of both of the
panel's scrollbars. LXP_PCURSOR, LXP_VSCURSOR and LXP_HSCURSOR set the cursor
for the panel and its vertical and horizontal scrollbars. LXP_VISIBLE determines
whether or not the panel is visible. LXP_ACTIVE determines whether or not the
panel is sensitive to user input. LXP_CLIENTDATA is a pointer to private data
not referenced by LXT itself.
.PP
Any of the attributes described above can be set or queried at any time after
the creation of a panel with the functions
.sp 4p
\fBint
.br
panel_set(\fIpanel, [varargs ...,] \fBLXP_NULL)
.br
Panel \fI*panel;\fR
.sp 4p
and
.sp 4p
\fBvoid *
.br
panel_get(\fIpanel, attribute)\fB
.br
Panel \fI*panel;\fB
.br
int \fIattribute;\fR
.sp 4p
The panel_set() function returns either \fBLX_SUCCESS\fR or \fBLX_ERROR\fR,
while panel_get() returns a pointer to the value of the attribute which must be
cast to the type appropriate for that attribute. (The pointer returned will
often point directly to an internal data structure and must never be used to
assign a value.) The following attributes are query-only:
.sp 4p
\fBLXP_VWIDTH\fR				int
.br
\fBLXP_VHEIGHT\fR				int
.br
\fBLXP_VSCROLL\fR				boolean
.br
\fBLXP_HSCROLL\fR				boolean
.br
\fBLXP_DWIDTH\fR				int
.br
\fBLXP_DHEIGHT\fR				int
.sp 4p
The LXP_VWIDTH and LXP_VHEIGHT attributes describe the virtual dimensions of the
panel, i.e., the size required for the full display of the panel without
scrollbars. LXP_VSCROLL and LXP_HSCROLL indicate whether or not the vertical and
horizontal scrollbars are currently visible. LXP_DWIDTH and LXP_DHEIGHT give
the dimensions of the currently displayed portion of the panel which is visible
to the user.
.PP
The event mask of the panel's enclosing frame is altered within the call to
panel_create() to accept only StructureNotify events. If for some reason the
application requires the recognition of other events on this window and needs
to adjust this mask, it must preserve notification of StructureNotify events
or the panel will not be able to configure itself.
.PP
A panel (and all of its items) may be destroyed by calling
\fBpanel_destroy(\fIpanel\fB).\fR
.PP
The following code fragments demonstrate the use of the procedures described above.
.sp 4p
Display *dpy;
.br
Window panel_frame;
.br
Panel *panel;
.br
unsigned long fg, bg;
.br
  ...

/* create and display panel */
.br
if ((panel= panel_create(argv[0], dpy, panel_frame,
.br
			LXP_FONT, "6x10",
.br
			LXP_NULL)) == (Panel *) NULL)
.br
	printf("Cannot create panel\\n");
.br
XMapWindow(dpy, panel_frame);
  ...

/* query the foreground and background colors */
.br
fg= *((unsigned long *) panel_get(panel, LXP_FOREGROUND));
.br
bg= *((unsigned long *) panel_get(panel, LXP_BACKGROUND));
  ...

/* destroy the panel */
.br
panel_destroy(panel);
.PP
There are seven different types of panel items which may be inserted into
an existing panel: \fIlabel\fR items, \fItext\fR items, \fIbutton\fR items,
\fIslider\fR items, \fIchoice\fR items, \fIcycle\fR items and \fItoggle\fR items.
.PP
A label item is an ouput-only item which simply displays a text string or
a pixmap image.
.PP
A text item consists of a label and an editable text string. The label can
be either a text string or an image. The value of the item is the content
of the editable string. The item is activated for text insertion by the user
by clicking the left mouse button over it, at which time a small caret marking
the current insertion point will be placed in the editable string nearest the
location of the cursor at the time of the mouse click. Text may be inserted
after the caret by typing at the keyboard. (Once a text item has been activated
and the insertion caret appears, the location of the cursor is unimportant as
long as it remains within the panel.) Text preceding the insertion point may
be deleted by typing the character-kill, word-kill or line-kill characters,
which are read from the process' controlling terminal at the time the first
panel is created. If the panel contains more than one text item, typing a tab
or carriage return will deactivate the currently activated text item and then
activate the next text item. The programmer specifies the maximum length of the
string and the maximum number of characters of the string which may be
displayed at any time. If the length of the string is greater than the maximum
display length, the beginning of the string will be scrolled out of view to the
left. Text items participate in the X11 selection transfer protocol via the
XA_PRIMARY selection buffer, allowing text to be copied between text items
(including those in different applications) and other programs using that
selection buffer (such as \fBxterm\fR). Text within a text item is selected by
depressing the left mouse button at one end of the desired text, dragging the
mouse over the text, and releasing the button at the other end of the text.
This causes the selected text to be highlighted by video-inversion and has the
side effect of moving the insertion point to the spot where the mouse button
was depressed. Selected text may be pasted into a text item by clicking the
middle mouse button over the item at the exact location where it is to be
inserted.
.PP
A button item is a string or image label which is video-inverted when the user
clicks the mouse over it.
.PP
A slider item consists of a text or image label and a slider bar which allows
the user to select an arbitrary integer value from a domain of consecutive
integers. Clicking or dragging the mouse anywhere within the bar will set the
value of the slider, which is displayed both as an integer text string
and as a filled rectangle occupying some portion of the slider bar.
.PP
Choice, cycle and toggle items are all variants on an \fIenumerated\fR item.
An enumerated item is comprised of a text or image label and a finite number
(a maximum of 32, to be more precise) of selections. Associated with each
selection is a unique ordinal number in the domain of 0 to 31 and a text string
or pixmap image.
.PP
A choice item displays all of the selection strings or images simultaneously,
but allows only one selection to be activated at any one time. Clicking the
mouse over a selection activates that particular selection and deactivates
all other selections. The active selection is identified by a special \fImark\fR
image which appears nearby. Inactive selections are identified by a special
\fInomark\fR image. There will always be one active selection, and the
value of the item is the ordinal number associated with that selection.
.PP
A cycle item differs from a choice item in that the active selection is the
only one displayed. Clicking the mouse over the label or the selection will
cause the item to cycle through the list of selections one at a time, thus
activating the next selection.
.PP
A toggle item displays all of its selections and allows any number of them to be
simultaneously active. The value of the item is an integer mask which has bits
set or unset according to whether particular selections are active or not, i.e.,
the selection whose ordinal is \fIn\fR is active if and only if (\fIvalue\fR &
(0x1 << \fIn\fR)) is true.
.PP
All of the enumerated types also have an associated menu whose items represent
the various selections. A selection may be (de)activated by clicking the right
mouse button, which causes the menu to appear, and selecting the appropriate
menu item.
.PP
A panel item can be created with a call to
.sp 4p
\fBPanel_item *
.br
panelitem_create(\fIpanel, type, [varargs ...,] \fBLXPI_NULL)
.br
Panel \fI*panel;\fB
.br
int \fItype;\fR
.sp 4p
The required arguments are the panel within which the item will be contained, the
type of item to be created and the special argument LXPI_NULL which is used to
terminate the variable length argument list. The type must be one of
\fBLXPI_LABEL\fR, \fBLXPI_TEXT\fR, \fBLXPI_BUTTON\fR, \fBLXPI_SLIDER\fR,
\fBLXPI_CHOICE\fR, \fBLXPI_CYCLE\fR or \fBLXPI_TOGGLE.\fR The optional arguments are
attribute/value pairs which specify some characteristic of the item. Attributes
may be either generic (applicable to all item types) or type-specific.
.PP
The following table lists all possible generic item attributes, the C data type
of the supplied values and their default values.
.sp 4p
\fBLXPI_X\fR					int			0
.br
\fBLXPI_Y\fR					int			0
.br
\fBLXPI_PROC\fR				void (*)()		(void (*)()) NULL
.br
\fBLXPI_FONT\fR				char *		panel font
.br
\fBLXPI_FOREGROUND\fR		unsigned long	panel foreground color
.br
\fBLXPI_BACKGROUND\fR		unsigned long	panel background color
.br
\fBLXPI_STATE\fR				int			LXPI_ACTIVE
.br
\fBLXPI_STRING\fR				char *		(char *) NULL
.br
\fBLXPI_IMAGE\fR				XImage *		(XImage *) NULL
.br
\fBLXPI_DISPLAY\fR				int			LXPI_REPAINT
.br
\fBLXPI_CLIENTDATA\fR			char *		(char *) NULL
.sp 4p
LXPI_X and LXPI_Y are the location of the upper-left corner of the item relative
to the panel origin. LXPI_PROC is the function to be called upon item selection
for button, slider and enumerated items.
LXPI_FONT, LXPI_FOREGROUND and LXPI_BACKGROUND determine the font
and colors of the item. LXPI_STATE (set to either LXPI_ACTIVE or LXPI_INACTIVE)
determines whether or not the item is visible and sensitive to input. The label
of the item is determined by LXPI_STRING and LXPI_IMAGE. (If both attributes are
non-null, the image will be displayed rather than the string.) LXPI_DISPLAY,
when set to LXPI_REPAINT, will cause the entire panel to which the item belongs
to be redrawn if LXT deems it necessary due to some reconfiguration of the
item via panelitem_set() (see below). It may be desirable to disable this
time-consuming behavior by first setting LXPI_DISPLAY to LXPI_NOREPAINT before
updating a large number of items and then either force a panel repaint by calling
\fBpanel_redisplay(\fIpanel\fB)\fR after all updates have been completed or
repaint each item individually with \fBpanelitem_redisplay(\fIpanel, item\fB)\fR.
LXPI_CLIENTDATA is a pointer which may be set by the application to an arbitrary
memory location. It is not otherwise referenced by LXT.
.PP
The application procedure attached to the item via the LXPI_PROC attribute should be
defined as
.sp 4p
\fBvoid
.br
proc(\fIpanel, item\fB)
.br
Panel \fI*panel;\fB
.br
Panel_item \fI*item;\fR
.sp 4p
The procedure arguments will be set to the panel and item from which it was
invoked. Selection of a button item occurs when the mouse is both clicked and
released directly over the item. Selection of a slider item occurs when the mouse
is clicked over the item and released anywhere. Selection of an enumerated item
takes place as soon as the mouse is clicked over the item or after a menu item
is selected.
.PP
Panel item attributes may be set and queried with the functions
.sp 4p
\fBint
.br
panelitem_set(\fIpanel, item, [varargs ...,] \fBLXPI_NULL)
.br
Panel \fI*panel;\fB
.br
Panel_item \fI*item;\fR
.sp 4p
and
.sp 4p
\fBvoid *
.br
panelitem_get(\fIpanel, item, attribute)\fB
.br
Panel \fI*panel;\fB
.br
Panel_item \fI*item;\fR
.br
int \fIattribute;\fR
.sp 4p
The panelitem_set() function returns either \fBLX_SUCCESS\fR or \fBLX_ERROR\fR,
while panelitem_get() returns a pointer to the value of the attribute which must be
cast to the type appropriate for that attribute. (The pointer returned will
often point directly to an internal data structure and must never be used to
assign a value.) The attributes
.sp 4p
\fBLXPI_TIMESTAMP\fR			Time
.br
\fBLXPI_TYPE\fR				int
.sp 4p
are query-only. LXPI_TIMESTAMP is set to the current time (as maintained by the X
server) whenever the item's LXPI_PROC routine is called because the user has selected
the item. LXPI_TYPE is the type of the item as specified at creation time.
.PP
The function \fBpanelitem_delete(\fIpanel, item\fB)\fR deletes an item from a panel,
while \fBpanelitem_destroy(\fIitem\fB)\fR frees all memory and X11
resources used by the item. (Items must be deleted from panels \fIbefore\fR they
are destroyed.) Both of these routines return one of the integer codes LX_SUCCESS
or LX_ERROR.
.PP
The remainder of this section describes the attributes specific to the various
item types and gives examples of their use.
.sp 12p
\fILabel items.\fR
.PP
Label items have no type-specific attributes. The following
call creates a label item:
.sp 4p
label= panelitem_create(panel, LXPI_LABEL,
.br
			LXPI_X, 10, LXPI_Y, 20,
.br
			LXPI_STRING, "\\"Welcome to Pee-Wee's Playhouse!\\"",
.br
			LXPI_NULL);
.sp 12p
\fIText items.\fR
.PP
The following attributes are specific to text items:
.sp 4p
\fBLXPTEXT_VALUE\fR			char *		""
.br
\fBLXPTEXT_MAXSTORE\fR		int			20
.br
\fBLXPTEXT_MAXDISPLAY\fR		int			20
.br
\fBLXPTEXT_IPOS\fR			int			0
.br
\fBLXPTEXT_GAP\fR				int			8
.br
\fBLXPTEXT_RDONLY\fR			boolean		FALSE
.br
\fBLXPTEXT_PROC\fR			int (*)()		NULL
.sp 4p
LXPTEXT_VALUE is the editable string. LXPTEXT_MAXSTORE is the maximum length of
the string. LXPTEXT_MAXDISPLAY is the maximum number of characters of the string
which may be displayed at any one time. LXPTEXT_IPOS is the index of the current
insertion point. LXPTEXT_GAP is the distance in pixels between the label and
the string. LXPTEXT_RDONLY may be used to disable or enable editing of the item.
LXPTEXT_PROC is a user-supplied function to be called whenever a key
press event occurs over the item. If the function returns TRUE, the toolkit will
process the event normally (i.e., update the item's value and visual display
appropriately). If the function returns FALSE the event will be ignored. The
user function should be defined as
.sp 4p
\fBint
.br
proc(\fIpanel, item, string\fB)
.br
Panel \fI*panel;
.br
\fBPanel_item \fI*item;
.br
\fBchar \fI*string;\fR
.sp 4p
where \fIstring\fR is a pointer to the null-terminated character string generated
by calling XLookupString() on the key press. (Although \fIstring\fR will generally
be only one character long, the calling application should be prepared to handle
other possibilities if unusual key mappings are in effect.) The memory pointed
to by \fIstring\fR is private to LXT and should not be written to or freed.
.PP
The following code creates a text item:
.sp 4p
text= panelitem_create(panel, LXPI_TEXT,
.br
			LXPI_X, 10, LXPI_Y, 50,
.br
			LXPI_STRING, "My name:",
.br
			LXPTEXT_MAXSTORE, 40,
.br
			LXPTEXT_MAXDISPLAY, 20,
.br
			LXPTEXT_VALUE, "Zyzzybalubah",
.br
			LXPI_NULL);
.sp 12p
\fIButton items.\fR
.PP
The attributes specific to button items are:
.sp 4p
\fBLXPBUTTON_HMARGIN\fR		int			6
.br
\fBLXPBUTTON_VMARGIN\fR		int			3
.sp 4p
These attributes specify the horizontal and vertical pixel margins between the
label string and the edges of the button.
.PP
The following code creates a button item:
.sp 4p
button= panelitem_create(panel, LXPI_BUTTON,
.br
			LXPI_X, 10, LXPI_Y, 80,
.br
			LXPI_STRING, "Scream real loud!",
.br
			LXPI_PROC, scream,
.br
			LXPI_NULL);
.sp 12p
\fISlider items.\fR
.PP
The following attributes are specific to slider items:
.sp 4p
\fBLXPSLIDER_MINVAL\fR		int			0
.br
\fBLXPSLIDER_MAXVAL\fR		int			100
.br
\fBLXPSLIDER_VALUE\fR			int			0
.br
\fBLXPSLIDER_VALX\fR			int			compact horizontal layout
.br
\fBLXPSLIDER_VALY\fR			int			compact horizontal layout
.br
\fBLXPSLIDER_BARX\fR			int			compact horizontal layout
.br
\fBLXPSLIDER_BARY\fR			int			compact horizontal layout
.br
\fBLXPSLIDER_BARHEIGHT\fR		int			12
.br
\fBLXPSLIDER_BARLENGTH\fR	int			100
.sp 4p
LXPSLIDER_MINVAL and LXPSLIDER_MAXVAL are the minimum and maximum values to
which the slider may be set, and LXPSLIDER_VALUE is the current value.
LXPSLIDER_VALX and LXPSLIDER_VALY determine the position relative to the item's
origin at which the current value, represented as an integer text string
in enclosing brackets, will be displayed. LXPSLIDER_BARX and LXPSLIDER_BARY
determine the position of the bar itself. These four positioning values are
initialized to display the item in a compact horizontal layout \(em if any
one of them is specified at item creation time, all of them should be specified.
LXPSLIDER_BARHEIGHT and LXPSLIDER_BARLENGTH determine the size of the slider bar.
.PP
The following code creates a slider item:
.sp 4p
slider= panelitem_create(panel, LXPI_SLIDER,
.br
			LXPI_X, 10, LXPI_Y, 110,
.br
			LXPI_STRING, "How much fun?",
.br
			LXPI_PROC, set_fun,
.br
			LXPSLIDER_MINVAL, 0,
.br
			LXPSLIDER_MAXVAL, 10,
.br
			LXPSLIDER_VALUE, 10,
.br
			LXPI_NULL);

.PP
\fIChoice, cycle and toggle items.\fR
The enumerated item types of choice, cycle and toggle are the most complicated
in terms of their attribute specifications. The item label and each selection
label of a choice or toggle item may be positioned at any arbitrary location
relative to the item's origin. The mark and nomark image (and position) for
each selection may also be individually specified. Positioning and (no)mark image
attributes have no effect on cycle items, which may be displayed only in their
default horizontal layout.
.PP
Many of the attributes specific to enumerated items
take variable length value lists when used as arguments to panelitem_create().
In the case of a selection label string or image value list, the list is terminated
by a null pointer. In the case of a selection positioning list, the list is
terminated by the special value \fBLXPENUM_LOCTERM\fR, which is a very large
negative number. The values in the list are assigned one for one to the
selections of the item. If there are fewer values in the list than there are
selections in the item, the last value in the list is assigned to all remaining
selections whose values have not been explicitly set.
.PP
The attributes applicable to all enumerated items are
.sp 4p
\fBLXPENUM_SELSTRINGS\fR		char *
.br
\fBLXPENUM_SELIMAGES\fR		XImage *
.br
\fBLXPENUM_VALUE\fR			int
.sp 4p
LXPENUM_SELSTRINGS and LXPENUM_SELIMAGES determine the number of selections and
the strings or images which represent them in the item's display. LXPENUM_VALUE is
the value of the item and is interpreted differently depending on whether the
item is a choice, cycle or toggle item (see above). \fIAfter the item has been
created, the only one of these attributes which may be set or queried is
LXPENUM_VALUE.\fR
.PP
The call
.sp 4p
cycle= panelitem_create(panel, LXPI_CYCLE,
.br
			LXPI_X, 10, LXPI_Y, 140,
.br
			LXPI_STRING, "Tell 'em, Pee-Wee!",
.br
			LXPENUM_SELSTRINGS, "\\"Made you look!\\"", "\\"That's my name, don't wear it out!\\"", "\\"Heh-heh!\\"", (char *) NULL,
.br
			LXPENUM_VALUE, 0,
.br
			LXPI_NULL);
.sp 4p
creates a cycle item with three selections. (Note the null pointer which terminates
the LXPENUM_SELSTRINGS variable length value list.) The ordinal values of the three
selections will be 0, 1 and 2, and the currently active selection will be "Made
you look!".
(If this was a toggle item and its value was 0, there would be no active selections,
since the value is interpreted as a mask rather than an ordinal.) The default
value of LXPENUM_VALUE for choice and cycle items is 0; the default value for
toggle items is a mask marking all selections as active.
.PP
The following attributes apply to choice and toggle items only (where two default
values are given, the first is for choice items and the second is for toggle items):
.sp 4p
\fBLXPENUM_DISPLAY\fR			int			LXPENUM_DISPALL
.br
\fBLXPENUM_MARKIMAGES\fR	XImage *		shaded push button/box with checkmark
.br
\fBLXPENUM_NOMARKIMAGES\fR	XImage *		unshaded push button/empty box
.br
\fBLXPENUM_SELXS\fR			int			compact horizontal layout
.br
\fBLXPENUM_SELYS\fR			int			compact horizontal layout
.br
\fBLXPENUM_MARKXS\fR			int			compact horizontal layout
.br
\fBLXPENUM_MARKYS\fR			int			compact horizontal layout
.br
\fBLXPENUM_INVERT\fR			boolean		FALSE
.br
\fBLXPENUM_LABELX\fR			int			0
.br
\fBLXPENUM_LABELY\fR			int			0
.sp 4p
LXPENUM_DISPLAY, which may be set to either LXPENUM_DISPALL or LXPENUM_DISPCURRSEL,
determines whether all selections are displayed or only those which are currently
active. LXPENUM_MARKIMAGES and LXPENUM_NOMARKIMAGES take variable length value
lists whose elements are images to be displayed whenever their corresponding
selections are active or inactive. LXPENUM_SELXS and LXPENUM_SELYS take variable
length value lists which determine the positions of the selection strings or images
relative to the item's origin. LXPENUM_MARKXS and LXPENUM_MARKYS determine the
positions of the (no)mark images corresponding to the selections. If LXPENUM_INVERT
is true, active selections will be displayed in inverse video and their (no)mark
images will not be shown. LXPENUM_LABELX and LXPENUM_LABELY set the position of
the item's label string or image relative to the item's origin. \fIOnly the
attributes LXPENUM_DISPLAY and LXPENUM_INVERT may be set or queried after the item
has been created.\fR
.PP
The following code creates a choice item with the default horizontal layout:
.sp 4p
choice= panelitem_create(panel, LXPI_CHOICE,
.br
			LXPI_X, 10, LXPI_Y, 160,
.br
			LXPI_STRING, "Best friend",
.br
			LXPENUM_SELSTRINGS, "Pee-Wee", "Penny", "Magic Screen", (char *) NULL,
.br
			LXPENUM_VALUE, 0,
.br
			LXPI_NULL);
.sp 4p
The code below will create a toggle item with a vertical layout:
.sp 4p
toggle= panelitem_create(panel, LXPI_TOGGLE,
.br
			LXPI_X, 10, LXPI_Y, 180,
.br
			LXPI_STRING, "Good buddies",
.br
			LXPENUM_SELSTRINGS, "Dinosaur Family", "Traveling Salesman", "King of Cartoons", (char *) NULL,
.br
			LXPENUM_MARKXS, 110, LXPENUM_LOCTERM,
.br
			LXPENUM_MARKYS, 0, 20, 40, LXPENUM_LOCTERM,
.br
			LXPENUM_SELXS, 130, LXPENUM_LOCTERM,
.br
			LXPENUM_SELYS, 0, 20, 40, LXPENUM_LOCTERM,
.br
			LXPI_NULL);
.PP
There may be occasions when the exact number of selections within a choice,
cycle or toggle item is not known in advance. In such a case, the item can
be created without specifying any selections, and the selections themselves
can be subsequently added one at a time with the function
.sp 4p
\fBint
.br
panelitem_addsel(\fIpanel, item, [varargs ...,] \fBLXPI_NULL)
.br
Panel \fI*panel;\fB
.br
Panel_item \fI*item;\fR
.sp 4p
which will return either \fBLX_SUCCESS\fR or \fBLX_ERROR\fR.
The attributes applicable to all enumerated items which may be specified when
calling this routine are
.sp 4p
\fBLXPENUM_SELSTRING\fR		char *		(char *) NULL
.br
\fBLXPENUM_SELIMAGE\fR		XImage *		(XImage *) NULL
.sp 4p
These attributes determine the string or image which represents the selection
in the item's display. The following attributes may also be specified when
referring to choice or toggle item selections (where two default values are given,
the first is for choice items and the second is for toggle items):
.sp 4p
\fBLXPENUM_MARKIMAGE\fR		XImage *		shaded push button/box with checkmark
.br
\fBLXPENUM_NOMARKIMAGE\fR	XImage *		unshaded push button/empty box
.br
\fBLXPENUM_SELX\fR			int			0
.br
\fBLXPENUM_SELY\fR			int			0
.br
\fBLXPENUM_MARKX\fR			int			0
.br
\fBLXPENUM_MARKY\fR			int			0
.sp 4p
LXPENUM_MARKIMAGE and LXPENUM_NOMARKIMAGE indicate the images to be displayed
whenever the selection is active or inactive. LXPENUM_SELX and LXPENUM_SELY
determine the position of the selection string or image relative to the item's
origin. LXPENUM_MARKX and LXPENUM_MARKY determine the position of the (no)mark
image corresponding to the selection.
.PP
None of the attributes described here may be set or queried with panelitem_set()
or panelitem_get(). Note also that the positioning attributes should be explicitly
set for choice and toggle item selections which are added in this manner as there
is no default layout.
.PP
The following code illustrates the use of this function:
.sp 4p
wish= panelitem_create(panel, LXPI_CHOICE,
.br
			LXPI_X, 10, LXPI_Y, 200,
.br
			LXPI_STRING, "Number of magic wishes:",
.br
			LXPI_NULL);
.br

.br
x= XTextWidth(font, "Number of magic wishes:", strlen("Number of magic wishes:"))+20;
.br
for (i= 0; i < 5; i++) {
.br
	char str[20];
.br

.br
	sprintf(str, "%d", i);
.br
	if (panelitem_addsel(panel, wish,
.br
			LXPENUM_SELSTRING, str,
.br
			LXPENUM_MARKX, x,
.br
			LXPENUM_MARKY, 0,
.br
			LXPENUM_SELX, x+15,
.br
			LXPENUM_SELY, 0,
.br
			LXPI_NULL) != LX_SUCCESS)
.br
		exit(-1);
.br
	x+= XTextWidth(font, str, strlen(str))+30;
.br
}
.br
panelitem_set(panel, wish,
.br
			LXPENUM_VALUE, 2,
.br
			LXPI_NULL);
.ft B
.sp 24p
(4) Blocking Panels and Alerts
.PP
It is possible to display in a special \fIblocking\fR mode any panel created
with the functions described in the preceding section. A panel displayed in
this mode can effectively freeze the display by grabbing all keyboard and
mouse input to the workstation and discarding any events not directed to the
panel itself. This is often useful when an application wants to suspend all
user-display interaction until confirmation is provided regarding some
irreversible action such as overwriting a file or exiting. Only one such panel
may be active at any time.
.PP
A blocking panel is created exactly as described above, but is displayed by
invoking the function
.sp 4p
\fBint
.br
panel_block(\fIpanel, value_ptr\fB)
.br
Panel \fI*panel;\fB
.br
int \fI*value_ptr;\fR
.sp 4p
rather than by calling XMapWindow(). This routine displays the panel and enters
an internal loop to perform all subsequent event processing until the application
makes a call to
.sp 4p
\fBvoid
.br
panel_unblock(\fIpanel, value\fB)
.br
Panel \fI*panel;\fB
.br
int \fIvalue;\fR
.sp 4p
which undisplays the blocking panel, restores the display's input system to its
normal state and causes the panel_block() routine to return. This call will
normally occur in an application procedure bound to one of the blocking panel's
items via the LXPI_PROC attribute and invoked upon item selection by the user.
The \fIvalue\fR argument supplied to panel_unblock() is passed back into the
memory pointed to by the \fIvalue_ptr\fR argument passed to panel_block(). The
latter function itself returns either \fBLX_SUCCESS\fR or \fBLX_ERROR\fR.
.PP
The following panel attributes, shown with their C data types and default values,
have meaning only with regard to a blocking panel:
.sp 4p
\fBLXP_GRAB\fR				boolean		TRUE
.br
\fBLXP_PROC\fR				void (*)()		NULL
.br
\fBLXP_ALARMINTERVAL\fR		int			0
.br
\fBLXP_ALARMPROC\fR			void (*)()		XBell()
.sp 4p
If LXP_GRAB is TRUE, the pointer will be grabbed and confined to the panel when
panel_block() is called, which will effectively block the user from performing
any activity until the panel is undisplayed with panel_unblock(). If LXP_GRAB
is FALSE, the pointer is not grabbed and the user may continue to interact
normally with all other running X11 client processes, but all pointer motion
and mouse button and keyboard activity directed at any windows owned by the
LXT client process will be ignored. LXP_PROC is a procedure to be called
whenever any non-mouse or non-keyboard event which is not of interest to LXT
(such as an expose event over a window which is not a panel or canvas) is
directed at the LXT client. This procedure will be called regardless of the
value of LXP_GRAB. It should be declared as
.sp 4p
\fBvoid
.br
event_proc(\fIevent\fB)
.br
XEvent \fI*event;\fR
.sp 4p
LXT will set the \fIevent\fR argument to point to the XEvent which caused
the procedure to be called. (The enhanced functionality represented by
the LXP_PROC attribute for blocking panels was provided because panel_block()
processes the client event queue in an internal loop, effectively hiding some
events which might be of interest to the calling application.)
If LXP_ALARMINTERVAL is greater than 0, then the procedure defined by the
LXP_ALARMPROC attribute will be called when the panel is activated by
panel_block() and after every interval of \fIn\fR seconds during which it
receives no user input, where \fIn\fR is the value of LXP_ALARMINTERVAL.
The alarm procedure should be declared as
.sp 4p
\fBvoid
.br
alarm_proc(\fIpanel\fB)
.br
Panel \fI*panel;\fR
.PP
The following code fragments illustrate the use of a blocking panel to request
user confirmation before exiting the application.
.br

#define CANCEL			0
.br
#define CONFIRM		1
.br
 ...
.br

Display *dpy;
.br
Window confirm_frame;
.br
Panel *confirm_panel;
.br
Panel_item *label, *cancel, *confirm;
.br
 ...
.br

if ((panel_create(argv[0], dpy, confirm_frame,
.br
		LXP_FONT, "6x10",
.br
		LXP_NULL)) == (Panel *) NULL)
.br
	printf("Cannot create panel\\n");
.br
label= panelitem_create(confirm_panel, LXPI_LABEL,
.br
		LXPI_X, 10, LXPI_Y, 30,
.br
		LXPI_STRING, "Please cancel or confirm quit.",
.br
		LXPI_NULL);
.br
cancel= panelitem_create(confirm_panel, LXPI_BUTTON,
.br
		LXPI_X, 10, LXPI_Y, 60,
.br
		LXPI_STRING, "Cancel",
.br
		LXPI_PROC, cancel_proc,
.br
		LXPI_NULL);
.br
confirm= panelitem_create(confirm_panel, LXPI_BUTTON,
.br
		LXPI_X, 70, LXPI_Y, 60,
.br
		LXPI_STRING, "Confirm",
.br
		LXPI_PROC, confirm_proc,
.br
		LXPI_NULL);
.br
 ...
.br

void
.br
cancel_proc(p, pi)
.br
Panel *p;
.br
Panel_item *pi;
.br
{
.br
	panel_unblock(confirm_panel, CANCEL);
.br
}
.br

void
.br
confirm_proc(p, pi)
.br
Panel *p;
.br
Panel_item *pi;
.br
{
.br
	panel_unblock(confirm_panel, CONFIRM);
.br
}
.br

void
.br
quit_proc(p, pi)
.br
/* this procedure is called when the user selects a "Quit" button in some other panel */
.br
Panel *p;
.br
Panel_item *pi;
.br
{
.br
	int value;
.br

	panel_block(confirm_panel, &value);
.br
	switch (value) {
.br
	case CANCEL:
.br
		break;
.br
	case CONFIRM:
.br
		exit(0);
.br
		break;
.br
	default:
.br
		break;
.br
	}
.br
}
.br
 ...
.br

.PP
An \fIalert\fR is a special kind of blocking panel that is created, displayed
and destroyed by calling the single function
.sp 4p
\fBint
.br
alert_prompt(\fIprogname, display, value_return, [varargs ...,] \fBLXA_NULL)
.br
\fBchar \fI*progname;
.br
\fBDisplay \fI*display;
.br
\fBint \fI*value_return;\fR
.sp 4p
which will return either \fBLX_SUCCESS\fR or \fBLX_ERROR\fR.
The required arguments to the routine are the program name, an open display
connection, a pointer to a caller-allocated integer into which another return
value will be written, and the special argument LXA_NULL which is used to
terminate the variable-length argument list. 
.PP
Alerts are extremely limited in functionality and are provided purely as a
convenience to relieve the programmer of the responsibility of creating
a panel and its items one by one in certain common cases such as displaying
an error message, prompting for text input or requesting confirmation
before proceeding with some activity. An alert may contain only label, text
and button items, the geometrical layout of which is completely determined by
LXT. All but a few of the attributes of the panel itself are also under
internal control. The items themselves and the specifiable panel attributes
are all declared within the variable-length argument list supplied to the
alert_prompt() routine.
.PP
An alert will usually contain at least one button item. If a user activates
any button item in an alert, the alert is undisplayed and destroyed, a special
integer value corresponding to the activated button (specified by the
programmer in the call to alert_prompt()) is written into the memory
pointed to by \fIvalue_return\fR, and alert_prompt() returns. The calling
routine will then typically check the contents of \fIvalue_return\fR and
take some action based upon the knowledge of which button was selected.
If the alert does not contain any button items, it must contain exactly one
text item. In this case alert_prompt() will return and write a 0 into the
memory pointed to by \fIvalue_return\fR when the user types a carriage return.
.PP
Note that since an alert is really a blocking panel and only one blocking
panel may be active at any time, alert_prompt() will fail if it is called
while any other blocking panel is displayed.
.PP
The following table lists the controllable alert panel attributes, the C data
type of the supplied values and their default values.
.sp 4p
\fBLXA_FOREGROUND\fR			unsigned long	BlackPixel(\fIdisplay\fR)
.br
\fBLXA_BACKGROUND\fR			unsigned long	WhitePixel(\fIdisplay\fR)
.br
\fBLXA_FONT\fR				char *		"8x13"
.br
\fBLXA_PROC\fR				void (*)()		void (*)() NULL
.br
\fBLXA_BWIDTH\fR				int			4
.br
\fBLXA_VISUAL\fR				Visual *		DefaultVisual(\fIdisplay\fR)
.br
\fBLXA_COLORMAP\fR			Colormap		DefaultColormap(\fIdisplay\fR)
.sp 4p
The LXA_FOREGROUND, LXA_BACKGROUND, LXA_FONT and LXA_PROC attributes control the
LXP_FOREGROUND, LXP_BACKGROUND, LXP_FONT and LXP_PROC attributes of the underlying
blocking panel. Note that LXA_FOREGROUND, LXA_BACKGROUND and LXA_FONT control the
appearance of all items contained in the alert. LXA_BWIDTH, LXA_VISUAL and
LXA_COLORMAP set the border width, visual and colormap of the alert's panel.
.PP
Item layout within the alert as well as size and placement of the alert are
determined automatically. Label items, if any, are placed one beneath the
next in sequence beginning at the top of the panel. Text items follow next,
again placed one beneath the next in sequence. Button items are placed at
the bottom, on one line if possible, with the first and last items located
flush left and flush right respectively and all other items spaced evenly
in between. The alert's panel is sized to closely fit this layout and is
centered on the display.
.PP
A label item is created by specifying the attribute/value pair
.sp 4p
\fBLXA_LABEL\fR				char *
.sp 4p
and may be displayed only as a text string, not as an XImage.
.PP
A text item is created by specifying the attribute/value quadruple
.sp 4p
\fBLXA_TEXT\fR				char *	char *	char *
.sp 4p
This attribute requires three character pointer arguments. The first
argument sets the LXPI_STRING attribute of the item. (An alert text item may be
labeled only with a string, not an XImage.) The second argument sets
the LXPTEXT_VALUE attribute of the item. The third argument is a pointer to
caller-allocated memory into which the value of the item (i.e., the text
string) will be copied when alert_prompt() returns. Note that the
LXPTEXT_MAXSTORE and LXPTEXT_MAXDISPLAY attributes of the item are fixed at
the special values LXADEF_MAXSTORE and LXADEF_MAXDISPLAY (currently set to 120
and 30 respectively). The calling routine must ensure that the memory
pointed to by the third argument is large enough to contain LXADEF_MAXSTORE
characters.
.PP
A button item is created by specifying the attribute/value triple
.sp 4p
\fBLXA_BUTTON\fR				char *	int
.sp 4p
This attribute requires one character pointer argument and one integer
argument. The first argument sets the LXPI_STRING attribute of the item.
(An alert button may be labeled only with a string, not an XImage.) The
second argument specifies the value to be written to alert_prompt()'s
\fIvalue_return\fR argument when the button is activated by the user.
In most cases the calling routine will want to associate a unique
integer value with each button in the alert so that it can uniquely
determine the button that was activated and take appropriate action.
LXT will by default warp the pointer to the first button defined in the
attribute list passed to alert_prompt(). The pointer can be initially warped
to some other button by declaring that button with the attribute/value triple
.sp 4p
\fBLXA_DEFAULTBUTTON\fR		char *	int
.sp 4p
.PP
In many cases a program making widespread use of alerts will want all alert
panels to be displayed with the same font, colormap, etc. Rather than
explicitly specifying these attributes each time an alert is created, it
is easier to use the function
.sp 4p
\fBvoid
.br
alert_setdefaults(\fI[varargs ...,] \fBLXA_NULL)\fR
.sp 4p
to set these attributes once at the beginning of the program. Alert
attributes that may be set in this manner include LXA_FOREGROUND,
LXA_BACKGROUND, LXA_FONT, LXA_BWIDTH, LXA_VISUAL and LXA_COLORMAP. Note that
the specification of any of these within a subsequent call to alert_prompt()
will change the default.
.PP
The following code will display an alert that prompts the user for the
name of a file to read:
.sp 4p
char *progname;
.br
Display *dpy;
.br
int val;
.br
char filename[LXADEF_MAXSTORE+1];
.br
int read_file();
.br

.br
/* set up some default attributes for all subsequent alerts */
.br
alert_setdefaults(LXA_FOREGROUND, 0, LXA_BACKGROUND, 1, LXA_NULL);
.br

.br
/* build and display the alert */
.br
if (alert_prompt(progname, dpy, &val,
.br
		LXA_LABEL, "Please enter the name of a file to be read.",
.br
		LXA_LABEL, "Select \\"Read\\" to proceed or \\"Cancel\\" to abort.",
.br
		LXA_TEXT, "Filename:", (char *) NULL, filename,
.br
		LXA_BUTTON, "Read", 0,
.br
		LXA_BUTTON, "Cancel", 1,
.br
		LXA_NULL) == LX_ERROR) {
.br
	printf("alert_prompt failure\\n");
.br
	return;
.br
}
.br

.br
/* take appropriate action based on the button selected */
.br
switch (val) {
.br
case 0:
.br
	read_file(filename);
.br
	break;
.br
case 1:
.br
	printf("read operation cancelled\\n");
.br
	break;
.br
default:
.br
	break;
.br
}
.PP
Remember that alerts are simply objects of convenience which are built
by the toolkit from panels and panel items which you can create yourself \(em
if the default layout or behavior of an alert is not satisfactory you
should be calling the panel routines directly. It should also be remembered
that every time you call alert_prompt() you are allocating memory,
initializing a number of internal data structures and then freeing the
memory. Large numbers of identical calls to this routine will therefore be
considerably less efficient than building a single panel and its items once
yourself and then making repeated calls to panel_block() and panel_unblock().
.ft B
.sp 24p
(5) Text Subwindows\fR
.PP
A text subwindow is a display object consisting of a window with horizontal
and vertical scrollbars and a subwindow into which text may be typed. The
scrollbars are present regardless of the size of the window. Text subwindow
editing features accessible through the window's menu (invoked by depressing
the right mouse button) include highlighting, deleting, moving and copying
text as well as the ability to search for a given string. Text subwindows
participate in the X11 selection transfer protocol via the XA_PRIMARY
selection buffer, allowing text to be copied between them (including those
belonging to separate applications) as well as to and from other programs
using that selection buffer (such as \fBxterm\fR).
.PP
Text windows are created by calls to 
.sp 4p
\fBTextsw *
.br
textsw_create(\fIprogname, display, window, [varargs ...,] \fBLXT_NULL)
.br
char \fI*progname;\fB
.br
Display \fI*display;\fB
.br
Window \fIwindow;\fR
.sp 4p
The required arguments are the program name, an open display connection, an
existing window which will enclose the text subwindow, and the special argument
\fBLXT_NULL\fR which is used to terminate the variable length argument list.
The following table lists all of the possible attributes, along with their C
data types and default values, which may be specified at creation time.
.sp 4p
\fBLXT_INPUTFILE\fR			char *		(char *) NULL
.br
\fBLXT_OUTPUTFILE\fR			char *		(char *) NULL
.br
\fBLXT_FOREGROUND\fR			unsigned long	BlackPixel(\fIdisplay\fR)
.br
\fBLXT_BACKGROUND\fR			unsigned long	WhitePixel(\fIdisplay\fR)
.br
\fBLXT_FONT\fR				char *		"8x13"
.br
\fBLXT_ALLOWINPUT\fR			int			TRUE
.br
\fBLXT_PASTEBUFFER\fR			char *		(char *) NULL
.br
\fBLXT_CHARPROC\fR			int (*)()		(int (*)()) NULL
.br
\fBLXT_EXITPROC\fR			int (*)()		internal routine
.br
\fBLXT_TCURSOR\fR				Cursor		diagonal arrow
.br
\fBLXT_VSCURSOR\fR			Cursor		right arrow
.br
\fBLXT_HSCURSOR\fR			Cursor		down arrow
.br
\fBLXT_BARWIDTH\fR			int			10
.br
\fBLXT_BUBBLEMARGIN\fR		int			2
.br
\fBLXT_BUTTONLEN\fR			int			14
.br
\fBLXT_CLIENTDATA\fR			char *		(char *) NULL
.sp 4p
LXT_INPUTFILENAME is the name of the file that will be read into the text
subwindow. LXT_OUTPUTFILENAME will be used as the default name for saving
the current file. LXT_FOREGROUND and LXT_BACKGROUND are the foreground and
background colors of the window, and LXT_FONT is the font in which the text
contents of the window will be displayed. LXT_ALLOWINPUT determines whether
or not the text editor will respond to user input. LXT_PASTEBUFFER is the
contents of the paste buffer. LXT_CHARPROC is a function to be called
whenever a user attempts to type text into the window, and should be defined as
.sp 4p
\fBint
.br
proc(\fItextsw, c\fB)
.br
Textsw *\fItextsw;\fB
.br
char \fIc;\fR
.sp 4p
If the function returns TRUE, the toolkit will process the event normally
(e.g., enter the character as new text). If the function returns FALSE the
event will be ignored. This can be useful for flagging special keystrokes
such as carriage returns or backspaces. The exit procedure LXT_EXITPROC,
which should be defined as
.sp 4p
\fBint
.br
proc(\fItextsw, display, edited_flag\fB)
.br
Textsw \fI*textsw;\fB
.br
Display \fI*display;\fB
.br
int \fIedited_flag;\fR
.sp 4p
will be called when the user attempts to destroy the text subwindow via the
\fIDestroy\fR menu option. LXT sets \fIedited_flag\fR to TRUE if the text
has been edited and FALSE otherwise. The user's request will be granted only
if the procedure returns TRUE. This attribute is initialized
to an internal routine which will display an alert panel if the text has been
edited and ask the user to provide confirmation before proceeding.
LXT_TCURSOR, LXT_VSCURSOR and LXT_HSCURSOR set the cursor for the text
subwindow and its vertical and horizontal scrollbars. LXT_BARWIDTH,
LXT_BUBBLEMARGIN and LXT_BUTTONLEN control various aspects of the window's
scrollbars. LXT_CLIENTDATA is a pointer which may be set by the application
to an arbitrary memory location. It is not otherwise referenced by LXT.
.PP
Any of the above attributes may be set or queried at any time after the text
subwindow's creation with the functions
.sp 4p
\fBint
.br
textsw_set(\fItextsw, [varargs ...,] \fBLXT_NULL)
.br
Textsw \fI*textsw;\fR
.sp 4p
and
.sp 4p
\fBvoid *
.br
textsw_get(\fItextsw, attribute)\fB
.br
Textsw \fI*textsw;\fB
.br
int \fIattribute;\fR
.sp 4p
The textsw_set() function returns either \fBLX_SUCCESS\fR or \fBLX_ERROR\fR,
while textsw_get() returns a pointer to the value of the attribute which must be
cast to the type appropriate for that attribute. (The pointer returned will
often point directly to an internal data structure and must never be used to
assign a value.)
.PP
The following attributes, shown with their C data types and default values,
may only be set after the text subwindow has been created. Those attributes
which reference line numbers must be greater than or equal to zero (which
indexes the first line of the file) and less than the number of lines in
the file minus one.
.sp 4p
\fBLXT_DRAWCURSOR\fR			boolean	FALSE
.br
\fBLXT_CURSORLINE\fR			int		none
.br
\fBLXT_CURSORCOLUMN\fR		int		none
.br
\fBLXT_DRAWHIGHLIGHT\fR		boolean	FALSE
.br
\fBLXT_HIGHLIGHTENDLINE\fR	int		none
.br
\fBLXT_HIGHLIGHTCOLUMN\fR	int		none
.br
\fBLXT_TOPLINE\fR				int		0
.sp 4p
LXT_DRAWCURSOR determines whether or not the cursor is drawn. Note that
the cursor may be scrolled out of sight and thus not visible even when
this attribute is TRUE. LXT_CURSORLINE and LXT_CURSORCOLUMN are the line
and column representing the current cursor position. LXT_CURSORCOLUMN must be
greater than or equal to zero. If it is set to a number greater than the number
of characters on the line then the cursor will be positioned to the right of
the last character on the line. LXT_DRAWHIGHLIGHT determines whether or not
the current text highlight is drawn. LXT_HIGHLIGHTENDLINE and
LXT_HIGHLIGHTENDCOLUMN refer to the end line and column of highlighted text.
The beginning of highlighted text is always the current cursor position.
These two attributes may be set only when LXT_DRAWHIGHLIGHT is FALSE.
LXT_TOPLINE is the line number of the first line of text to be displayed
in the text subwindow.
.PP
The attribute
.sp 4p
\fBLXT_INSERTTEXT\fR			char *	none
.br
.sp 4p
is set-only, and will insert the supplied string at the current cursor
position as if the string had been typed from the keyboard.
.PP
The attribute
.sp 4p
\fBLXT_CURSORVIEWABLE\fR
.sp 4p
is also set-only and has no associated value. LXT_CURSORVIEWABLE ensures that
a drawn cursor can be seen in the text subwindow by scrolling the text as
necessary to move the cursor into view if it cannot already be seen.
.PP
The following attributes are query-only:
.sp 4p
\fBLXT_NUMLINES\fR			int
.br
\fBLXT_MENU\fR				Menu *
.sp 4p
LXT_NUMLINES is the number of lines of text contained in the file that
is currently being edited. LXT_MENU is a pointer to the text subwindow's
menu which an application may reference to insert additional menu items
as desired.
.PP
The function \fBtextsw_clear(\fItextsw\fB)\fR may be used to delete the entire
contents of a text subwindow.
.PP
A text subwindow may be destroyed at any time with the
\fBtextsw_destroy(\fItextsw\fB)\fR function. This routine does not call
any exit procedure which may be bound to the subwindow via the LXT_EXITPROC
attribute. (The exit procedure is called only when the user attempts to destroy
the text subwindow via the subwindow's own \fIDestroy\fR menu option.)
.PP
The function \fBtextsw_active()\fR returns TRUE if there is at least one
active text subwindow (which may or may not be mapped) and FALSE otherwise.
An application may wish to use this function as an exit condition in its
event loop.
.PP
The function
.sp 4p
\fBchar *
.br
textsw_text(\fItextsw, line\fB)
.br
Textsw \fI*textsw;\fB
.br
int \fIline;\fR
.sp 4p
returns a pointer to the text contained in \fIline\fR. The returned pointer
accesses memory which is private to LXT and should not be written to or freed.
.PP 
The following code fragments illustrate the use of some of the procedures
described above:
.sp 4p
Display *dpy;
.br
Window win;
.br
unsigned long blue, white;
.br
Textsw *textsw;
.br
int lines;
.br
Textsw *textsw_create();
.br
void *textsw_get();
.br
  ...
.br

.br
/* create the text subwindow */
.br
if ((textsw= textsw_create(argv[0], dpy, win,
.br
		LXT_INPUTFILENAME, "penpal.letter",
.br
		LXT_FOREGROUND, white,
.br
		LXT_BACKGROUND, blue,
.br
		LXT_NULL)) == (Textsw *) NULL)
.br
	exit(-1);
.br
  ...
.br

.br
/* get the number of lines in the document */
.br
lines = *((int *) textsw_get(textsw, LXT_NUMLINES));
.br

.br
/* bring the last line to the top of the window, highlight from column
.br
   three to column ten and make sure that the cursor can be seen. */
.br
textsw_set(textsw, LXT_TOPLINE, lines-1,
.br
		LXT_CURSORLINE, lines-1,
.br
		LXT_CURSORCOLUMN, 3,
.br
		LXT_DRAWCURSOR, TRUE,
.br
		LXT_DRAWHIGHLIGHT, FALSE,
.br
		LXT_HIGHLIGHTENDLINE, lines-1,
.br
		LXT_HIGHLIGHTENDCOLUMN, 10,
.br
		LXT_DRAWHIGHLIGHT, TRUE,
.br
		LXT_CURSORVIEWABLE,
.br
		LXT_NULL);
.PP
Details on the text subwindow user interface are provided in an attached
appendix at the end of this document.
.ft B
.sp 24p
(6) Event Processing
.PP
Unlike some toolkits which take control of an application upon entering
an internal notification loop, LXT allows the application program to maintain
direction over virtually all event processing. The function
.sp 4p
\fBboolean
.br
lxt_event(\fIevent\fB)
.br
XEvent \fI*event;\fR
.sp 4p
may be called within the application's own event loop to offer LXT the
opportunity to process an event which has been dispatched by the X11 server.
If the event is of interest to LXT, lxt_event() will
process the event and return \fBTRUE\fR. If the event is not of
interest to the toolkit, the function will return \fBFALSE\fR. In neither case
will the XEvent structure itself be altered in any way.
.PP
Events of interest to LXT include StructureNotify events on windows passed
as arguments to the calls canvas_create() and panel_create(), as well as any
ButtonPress, ButtonRelease, PointerMotion, KeyPress or Expose events on any
subwindows thereof which have been created by LXT.
.PP
The only exception to this absolute control of all event processing by the
application occurs when the functions menu_show() or panel_block() are invoked.
The menu_show() routine descends into an internal event loop which returns only
when the user releases a mouse button. The panel_block() routine enters a
similar loop and returns only when one of the blocked panel's application-defined
item procedures calls panel_unblock().
.PP
The following code illustrates a typical event loop which might be
located at the end of main() in an LXT application:
.sp 4p
for (;;) {
.br
	XNextEvent(dpy, &event);
.br
	if (lxt_event(&event))
.br
		continue;
.br
	
.br
	/* here with an event which LXT is not interested in */
.br
	...
.br

.br
}
.ft B
.sp 24p
(7) Miscellaneous
.PP
The function
.sp 4p
\fBXImage *
.br
image_create(\fIdisplay, foreground, background, data, width, height, depth\fB)
.br
Display \fI*display;\fB
.br
unsigned long \fIforeground, background;\fB
.br
char \fI*data;\fB
.br
int \fIwidth, height, depth;\fR
.sp 4p
may be used to create an XImage of arbitrary foreground, background and depth
from a file which has been created with the \fBbitmap\fR(1) program and
included in the source code with the C preprocessor \fB#include\fR directive.
.PP
The following code fragment illustrates the use of this procedure.
.sp 4p
#include "peewee.bitmap"
.br

.br
Display *dpy;
.br
unsigned long fg, bg;
.br
int depth;
.br
XImage *image;
.br
 ...

image= image_create(dpy, fg, bg, peewee_bits, peewee_width, peewee_height, depth);
.PP
Some window managers, such as Sun's OpenWindows 2.0 \fBolwm\fR(1), reparent
top-level application windows without drawing a border around them. This will
adversely affect the intended visual appearance of most toolkit objects,
particularly those with scrollbars. This can be corrected by inserting the line
.sp 2p
*LXTInternalBorderWidth:	\fIn\fR
.sp 2p
into the user's .Xdefaults file, which will cause LXT itself to internally draw
a border of width \fIn\fR around the inside of its top-level windows.
.ft B
.sp 24p
(8) Bugs
.PP
There are no known bugs, but lots of missing features.
.PP
There is no implementation of shell windows.
.PP
The existing Canvas, Panel and Textsw objects should be encapsulated within
Frame objects similarly to SunView.
.bp
.ft B
.sp 24p
Appendix \(em Text Subwindow User Interface
.sp 18p
\fBSetting the Cursor\fR
.PP
There is no cursor when a text subwindow is first created. The user can make a
cursor appear by using the mouse to point to the desired area and clicking
the left mouse button. The cursor is a vertically drawn line which will
appear to the left of whatever character was pointed to by the mouse.
Many operations (typing, searching for text, etc.) cannot be performed unless
there is a cursor. LXT will beep if this is the case. If the mouse points
to the right of the text on a particular line then the cursor is set to the
end of that line. The cursor cannot be set past the last character of the
document.
.sp
\fBUsing the Scroll Bars\fR
.PP
The user may move around the document by using the horizontal and vertical
scroll bars attached to the text subwindow.
.PP
The horizontal scroll bar consists of a left scroll button, a right scroll
button and the actual scroll bar area. Left and right mouse clicks in either
button area will cause the text to be scrolled to the left and right
respectively by one character. Clicking the middle mouse button over the
left scroll button causes the text to be scrolled left to the first column
of text. Clicking the middle mouse button over the right scroll button causes
the text to be scrolled one character to the right of the longest line in the
entire text. 
The scroll bar area represents the length of the longest line in
the text. All horizontal scroll calculations are based on this length. All
three mouse buttons respond in this area. Therefore, a button click in the
middle of the horizontal scroll area will result in the left most visible
column being half the length of the longest line.
.PP
The vertical scroll bar consists of a top scroll button, a bottom scroll
button and the actual scroll bar area. Left and right mouse clicks in either
button area will cause the text to be scrolled up and down respectively by
one line. Clicking the middle mouse button over the top scroll button causes
the text to be scrolled up to the first line of text. Clicking the middle
mouse button over the bottom scroll button causes the text to be scrolled
down such that the last line of text is in the middle of the text subwindow.
The scroll bar area represents the number of lines in the text.
All vertical scroll calculations are based on this length. All three mouse
buttons respond in this area. Therefore, a button click in the middle of the
vertical scroll area will result with line representing the halfway point
being in the middle of the text subwindow.
.sp 4p
\fBInputting Text\fR
.PP
Once the cursor is drawn the user may input text by typing at the
keyboard unless user input has been disallowed by the application running
the text editor. Typed characters and tabs will appear to the right of the
cursor while both the backspace and delete will delete the character to the
left of the cursor. If added characters go to the right of the visible portion
of the screen, the user must use the horizontal scroll bar to see the new text.
If added newlines would cause the current line to be past the bottom of the visible
portion of the window, the text will automatically be scrolled upwards a few
lines so that the current line remains viewable.
.sp 4p
\fBHighlighting Text\fR
.PP
Certain editing features available within the text subwindow, such as the
cut and paste functions, require that the user first \fIhighlight\fR some
contiguous block of text within the window which is then displayed in
inverse video. Text may be highlighted by either depressing the left mouse
button at the desired starting point and dragging the mouse to the desired
ending point, or by clicking the left mouse button at the starting point
and clicking the middle mouse button at the ending point. Note that the
highlight ending point does not necessarily have to come after the highlight
starting point. Once a highlight area has been set, its ending point may be
changed at any time by clicking the middle mouse button over the new
ending point.
.PP
Text subwindows participate in the X11 selection transfer protocol, enabling
text to be copied and pasted between separate applications (assuming that
those applications also participate in this protocol). When text in a text
subwindow is highlighted, that text becomes the X11 primary selection for
the entire workstation display. (This can be thought of as copying the
selected text into some global buffer to which all X11 programs have access.)
If there was an existing visible primary selection at the time this occurs,
perhaps in another text subwindow or in some other application such as an
\fBxterm\fR window, then that previously selected text will be dehighlighted.
.sp 4p
\fBThe Menu\fR
.PP
Holding down the right mouse button in the text subwindow will cause a menu
to appear. The \fIEdit\fR, \fIFind\fR and \fISave\fR options each reference
a secondary menu which can be made to appear by dragging the mouse to the
rightmost edge of the main menu while the desired option is highlighted.
Many of the menu options described below use a temporary text storage area
known as the \fIpaste buffer\fR.
.sp 4p
\fIEdit -> Cut\fR
.br
This option deletes highlighted text and puts it in the paste buffer,
and will beep if no text is highlighted or if user input has been disallowed.
.sp 4p
\fIEdit -> Copy\fR
.br
This option copies the current X11 primary text selection to the paste buffer,
and will beep if there is no primary selection or if user input has been
disallowed. Note that the X11 primary text selection may be highlighted text
located either in the text subwindow from which this menu option is invoked or
elsewhere on the display.
.sp 4p
\fIEdit -> Paste\fR
.br
This option inserts the contents of the paste buffer at the current cursor
position, and beeps if the paste buffer is empty.
.sp 4p
\fIFind -> String\fR
.br
This option will put up a dialog box prompting for a character string
to find. The text is then scanned from the current cursor position to the end
of the document in search of the character string. If the string is found,
it is made visible by scrolling if necessary and is highlighted. The
cursor will be set to the right of the highlighted text. This option will
beep if the string is not found or if there is no cursor.
.sp 4p
\fIFind -> Buffer\fR
.br
This option is identical to the \fIFind -> String\fR option except that
it uses the contents of the paste buffer as the string for which to search rather
than prompting the user for the string.
.sp 4p
\fIFind -> Again\fR
.br
This option searches for whatever string was used in the most recent
\fIFind\fR request.
.sp 4p
\fISave -> [ Filename ]\fR
.br
This option will save the current version of the file as well as the
most recent version. The backup file will have the same name as the new file
with a percent sign (%) appended to it.
.sp 4p
\fISave -> Other\fR
.br
This option will prompt the user for the name of the new file and will
save the file under the new name.
.sp 4p
\fIRead\fR
.br
This option will prompt the user for the name of the file to be read
and will read it into the text subwindow. The display will beep if user input
has been disallowed.
.sp 4p
\fIRedisplay\fR
.br
This option will redraw the entire text subwindow. 
.sp 4p
\fIDestroy\fR
.br
This option will destroy the text subwindow unless disallowed by the
particular application which created it. If the contents of the window have
been edited but not saved, confirmation may be requested before the destroy
is performed.
.sp 4p
\fBCommunication Between Text Subwindows\fR
.PP
If an application creates more than one text subwindow, the subwindows can
communicate with each other via the paste buffer, which is held in common by
all of them. For example, text may be copied from one window to another by
using the \fIEdit -> Copy\fR option to load the paste buffer with text from
one window and then using the \fIEdit -> Paste\fR option to insert the text
into another window.
