/*
	lxt.h --
	Definitions and typedefs for LXT, the Lamont X
	Toolkit package, an X11 SunView imitation.
	Written by Roger Davis, May 1988.
*/

#ifndef __LXT_DEFINES__
#define __LXT_DEFINES__

/* IRIX doesn't fully implement void */
#ifdef IRIX
#define Void			char
#else
#define Void			void
#endif

#define boolean			int
#ifdef TRUE
#undef TRUE
#endif
#ifdef FALSE
#undef FALSE
#endif
#define TRUE			(1)
#define FALSE			(0)

/* return codes */
#define LX_SUCCESS		(0)
#define LX_ERROR		(1)

#define LX_MAXFONTNMLEN		(40)

#define LX_UPWEDGEHT		(8)
#define LX_UPWEDGEWD		(8)

#define LX_SELATOM		"LX_SELTRANSFER"
#define LX_SELTRANSFERSZ	(512L)

/* object types */
#define LX_NULL			(0)
#define LX_MENU			(1)
#define LX_MENUITEM		(2)
#define LX_CANVAS		(3)
#define LX_PANEL		(4)
#define LX_PANELITEM		(5)
#define LX_TEXTSW		(6)

/* menu attributes */
#define LXM_NULL		(0)
#define LXM_FONT		(1)
#define LXM_FOREGROUND		(2)
#define LXM_BACKGROUND		(3)
#define LXM_TITLE		(4)
#define LXM_ITEM		(5)
#define LXM_HIGHLIGHT		(6)
#define LXM_HMARGIN		(7)
#define LXM_VMARGIN		(8)
#define LXM_BWIDTH		(9)
#define LXM_CLIENTDATA		(10)

/* menu highlight modes */
#define LXM_BOX			(1)
#define LXM_INVERT		(2)

/* default menu attributes */
#define LXMDEF_FONT		"8x13"
#define LXMDEF_HMARGIN		(8)
#define LXMDEF_VMARGIN		(2)
#define LXMDEF_BWIDTH		(2)

/* menu item attributes */
#define LXMI_NULL		(0)
#define LXMI_STRING		(1)
#define LXMI_PROC		(2)
#define LXMI_PULLRIGHT		(3)
#define LXMI_IMAGE		(4)
#define LXMI_STATE		(5)
#define LXMI_CLIENTDATA		(6)
#define LXMI_TIMESTAMP		(7)

/* menu item state */
#define LXMI_ACTIVE		(1)
#define LXMI_INACTIVE		(2)

/* menu item pullright arrows */
#define LXMI_PRARROWLEN		(16)
#define LXMI_PRARROWGAP		(10)

/* Menu_items are the objects which make up a Menu. A Menu_item
   may be a member of more than one Menu at the same time. */
typedef struct Xmi_struct {
	int xmi_magic;			/* must be LX_MENUITEM */
	char *xmi_string;		/* label to appear in menu */
	XImage *xmi_image;		/* image to appear in menu (overrides label, if any) */
	void (*xmi_proc)();		/* function invoked after selection */
	char *xmi_pullright;		/* pullright menu displayed upon selection */
	int xmi_state;			/* LXMI_ACTIVE (default) or LXMI_INACTIVE */
	char *xmi_clientdata;
	Time xmi_timestamp;		/* last time that xmi_proc() was invoked */
} Menu_item;

/* Menu_items are chained within a Menu via a Menu_itemptr. This
   indirection permits a Menu_item to belong to more than one Menu. */
typedef struct Xmip_struct {
	int xmip_x, xmip_y;		/* location and size of the item's displayed */
	int xmip_h, xmip_w;		/* string or image within the containing Menu */
	Menu_item *xmip_item;		/* the Menu_item itself */
	struct Xmip_struct *xmip_prev;	/* previous item in Menu */
	struct Xmip_struct *xmip_next;	/* next item in Menu */
} Menu_itemptr;

typedef struct Xm_struct {
	int xm_magic;			/* must be LX_MENU */
	Display *xm_dpy;		/* Menu display */
	Window xm_attwin;		/* user window to which menu is attached */
	Window xm_win;			/* Menu own window ID */
	GC xm_fggc, xm_bggc;		/* Menu foreground and background GCs */
	GC xm_sgc;			/* Menu stipple GC for inactive items */
	char *xm_fontnm;		/* font name */
	XFontStruct *xm_font;		/* Menu font */
	unsigned long xm_fg, xm_bg;	/* foreground and background */
	char *xm_title;			/* title to be displayed, if any */
	Menu_itemptr *xm_items;		/* Menu_item chain */
	int xm_highlight;		/* LXM_INVERT (default) or LXM_BOX */
	int xm_h, xm_w;			/* Menu window size (computed prior to each display) */
	int xm_vmargin, xm_hmargin;	/* margin about each item */
	int xm_bwidth;			/* border width */
	char *xm_clientdata;
	struct Xm_struct *xm_caller;	/* upon display, the Menu is inserted into a chain of */
	struct Xm_struct *xm_pullright;	/* the initial Menu and any pullrights already displayed */
	caddr_t xm_hist;		/* last pullright chain invoked */
	struct Xm_struct *xm_next;
} Menu;

typedef struct Xmh_struct {
	Menu *xmh_menu;
	Menu_item *xmh_menuitem;
	struct Xmh_struct *xmh_next;
} Menu_hist;

typedef struct Xmp_struct {
	void (*xmp_proc)();
	Menu *xmp_menu;
	Menu_item *xmp_menuitem;
	struct Xmp_struct *xmp_next;
} Menu_procexec;

/* scrollbar flags */
#define LXS_BUTTONVIS		(0x00000001)

/* scrollbar orientation */
#define LXS_VERTICAL		(1)
#define LXS_HORIZONTAL		(2)

/* scrollbar bubble colors */
#define LXS_FOREGROUND		(1)
#define LXS_STIPPLE		(2)

/* default scrollbar attributes */
#define LXSDEF_MINBARLEN	(20)
#define LXSDEF_BARWIDTH		(10)
#define LXSDEF_BUBBLEMARGIN	(2)
#define LXSDEF_BUTTONLEN	(14)

typedef struct Xs_struct {
	int xs_type;
	int xs_barwidth;
	int xs_barstart;
	int xs_barlen;
	int xs_buttonlen;
	int xs_bubblemargin;
	int xs_bubblemin;
	int xs_bubblelen;
	int xs_bubblecolor;
	int xs_flags;
} Scrollbar;

/* panel attributes */
#define LXP_NULL		(0)
#define LXP_FONT		(1)
#define LXP_FOREGROUND		(2)
#define LXP_BACKGROUND		(3)
#define LXP_WIDTH		(4)
#define LXP_HEIGHT		(5)
#define LXP_BARWIDTH		(6)
#define LXP_BUBBLEMARGIN	(7)
#define LXP_BUTTONLEN		(8)
#define LXP_RIGHTMARGIN		(9)
#define LXP_BOTTOMMARGIN	(10)
#define LXP_PCURSOR		(11)
#define LXP_VSCURSOR		(12)
#define LXP_HSCURSOR		(13)
#define LXP_VISIBLE		(14)
#define LXP_CLIENTDATA		(15)
#define LXP_PROC		(16)
#define LXP_GRAB		(17)
#define LXP_VWIDTH		(18)
#define LXP_VHEIGHT		(19)
#define LXP_ACTIVE		(20)
#define LXP_ALARMINTERVAL	(21)
#define LXP_ALARMPROC		(22)
#define LXP_VSCROLL		(23)
#define LXP_HSCROLL		(24)
#define LXP_DWIDTH		(25)
#define LXP_DHEIGHT		(26)

/* panel flags */
#define LXP_FRAMEMAPPED		(0x00000001)
#define LXP_PANELVISIBLE	(0x00000002)
#define LXP_VSCROLLVIS		(0x00000004)
#define LXP_HSCROLLVIS		(0x00000008)
#define LXP_CONFIGDONE		(0x00000010)
#define LXP_REQWIDTH		(0x00000020)
#define LXP_REQHEIGHT		(0x00000040)
#define LXP_SELACTIVE		(0x00000080)
#define LXP_GRABPTR		(0x00000100)
#define LXP_PANELACTIVE		(0x00000200)

/* default panel attributes */
#define LXPDEF_FONT		"8x13"
#define LXPDEF_RIGHTMARGIN	(15)
#define LXPDEF_BOTTOMMARGIN	(15)
#define LXPDEF_ALARMINTERVAL	(0)
#define LXPDEF_TEXTSTORE	(20)
#define LXPDEF_TEXTDISPLAY	(20)
#define LXPDEF_TEXTGAP		(8)
#define LXPDEF_BUTTONHMARGIN	(6)
#define LXPDEF_BUTTONVMARGIN	(3)
#define LXPDEF_SLIDERMINVAL	(0)
#define LXPDEF_SLIDERMAXVAL	(100)
#define LXPDEF_SLIDERVAL	(0)
#define LXPDEF_SLIDERBARHEIGHT	(12)
#define LXPDEF_SLIDERBARLENGTH	(100)
#define LXPDEF_SLIDERCAPWIDTH	(4)
#define LXPDEF_ENUMVAL		(0)

/* generic panel item attributes */
#define LXPI_NULL		(0)
#define LXPI_X			(1)
#define LXPI_Y			(2)
#define LXPI_PROC		(3)
#define LXPI_FONT		(4)
#define LXPI_FOREGROUND		(5)
#define LXPI_BACKGROUND		(6)
#define LXPI_STATE		(7)
#define LXPI_STRING		(8)
#define LXPI_IMAGE		(9)
#define LXPI_DISPLAY		(10)
#define LXPI_CLIENTDATA		(11)
#define LXPI_TIMESTAMP		(12)
#define LXPI_TYPE		(13)

/* panel item state */
#define LXPI_ACTIVE		(1)
#define LXPI_INACTIVE		(2)

/* panel item display */
#define LXPI_REPAINT		(1)
#define LXPI_NOREPAINT		(2)

/* panel item types */
#define LXPI_LABEL		(0)
#define LXPI_TEXT		(1)
#define LXPI_BUTTON		(2)
#define LXPI_SLIDER		(3)
#define LXPI_CHOICE		(4)
#define LXPI_CYCLE		(5)
#define LXPI_TOGGLE		(6)

/* label attributes */

/* text attributes */
#define LXPTEXT_VALUE		(200)
#define LXPTEXT_MAXSTORE	(201)
#define LXPTEXT_MAXDISPLAY	(202)
#define LXPTEXT_IPOS		(203)
#define LXPTEXT_GAP		(204)
#define LXPTEXT_PROC		(205)
#define LXPTEXT_RDONLY		(206)

/* text flags */
#define LXPTEXT_WRPROTECT	(0x00000001)
#define LXPTEXT_SELHOLDER	(0x00000002)

/* button attributes */
#define LXPBUTTON_HMARGIN	(300)
#define LXPBUTTON_VMARGIN	(301)

/* slider attributes */
#define LXPSLIDER_MINVAL	(400)
#define LXPSLIDER_MAXVAL	(401)
#define LXPSLIDER_VALUE		(402)
#define LXPSLIDER_VALX		(403)
#define LXPSLIDER_VALY		(404)
#define LXPSLIDER_BARHEIGHT	(405)
#define LXPSLIDER_BARLENGTH	(406)
#define LXPSLIDER_BARX		(407)
#define LXPSLIDER_BARY		(408)

/* enum (choice, cycle
   and toggle) attributes */
#define LXPENUM_VALUE		(500)
#define LXPENUM_DISPLAY		(501)
#define LXPENUM_SELSTRINGS	(502)
#define LXPENUM_SELIMAGES	(503)
#define LXPENUM_MARKIMAGES	(504)
#define LXPENUM_NOMARKIMAGES	(505)
#define LXPENUM_SELXS		(506)
#define LXPENUM_SELYS		(507)
#define LXPENUM_MARKXS		(508)
#define LXPENUM_MARKYS		(509)
#define LXPENUM_INVERT		(510)
#define LXPENUM_LABELX		(511)
#define LXPENUM_LABELY		(512)
#define LXPENUM_SELSTRING	(513)
#define LXPENUM_SELIMAGE	(514)
#define LXPENUM_MARKIMAGE	(515)
#define LXPENUM_NOMARKIMAGE	(516)
#define LXPENUM_SELX		(517)
#define LXPENUM_SELY		(518)
#define LXPENUM_MARKX		(519)
#define LXPENUM_MARKY		(520)

/* maximum number of xp_esels per item
   (limited to size of integer in bits) */
#define LXPENUM_MAXESELS	(8*sizeof(int))

/* terminator for variable length location lists */
#define LXPENUM_LOCTERM		(-10000)

/* enum flags */
#define LXPENUM_DISPALL		(0x00000001)
#define LXPENUM_DISPCURRSEL	(0x00000002)
#define LXPENUM_INVERTLABEL	(0x00000004)

typedef struct Xplabel_struct {
	int xplabel_placeholder;
} xp_label;

typedef struct Xptext_struct {
	char *xptext_val;		/* value string */
	int xptext_max;			/* max storable characters */
	int xptext_disp;		/* max displayable characters */
	int xptext_dpos;		/* index of first displayed character */
	int xptext_ipos;		/* index of insertion point */
	int xptext_selstart;		/* index of selection start point */
	int xptext_selstop;		/* index of selection end point */
	int xptext_gap;			/* gap between label and value */
	int (*xptext_kpproc)();		/* user function invoked on each keypress */
	int xptext_flags;
} xp_text;

typedef struct Xpbutton_struct {
	Pixmap xpbutton_procpm;		/* Pixmap and GC for item activation */
	GC xpbutton_bgc;
	int xpbutton_hmargin;		/* margins around xpi_str */
	int xpbutton_vmargin;
} xp_button;

typedef struct Xpslider_struct {
	Pixmap xpslider_bpm;		/* grey Pixmap and GC for slider bubble */
	GC xpslider_bgc;
	int xpslider_minval;		/* min, max and current values of item */
	int xpslider_maxval;
	int xpslider_val;
	int xpslider_valx;		/* offset of [val] vis-a-vis xpi_x, xpi_y */
	int xpslider_valy;
	int xpslider_barh;		/* width of slider bar */
	int xpslider_barl;		/* length of slider bar */
	int xpslider_barx;		/* offset of bar vis-a-vis xpi_x, xpi_y */
	int xpslider_bary;
} xp_slider;

typedef struct Xpesel_struct {
	char *xpesel_str;
	XImage *xpesel_image;
	int xpesel_ord;
	boolean xpesel_sel;
	int xpesel_x, xpesel_y;
	int xpesel_w, xpesel_h;
	int xpesel_lx;
	int xpesel_ly;
	int xpesel_mx;
	int xpesel_my;
	XImage *xpesel_mimage;
	XImage *xpesel_nmimage;
	struct Xpesel_struct *xpesel_next;
} xp_esel;

typedef struct Xpenum_struct {
	int xpenum_val;
	int xpenum_lx, xpenum_ly;
	xp_esel *xpenum_sel;
	xp_esel *xpenum_list;
	int xpenum_flags;
	XImage *xpenum_choicemark;
	XImage *xpenum_choicenomark;
	XImage *xpenum_cycle;
	XImage *xpenum_togglemark;
	XImage *xpenum_togglenomark;
} xp_enum;

typedef struct Xpi_struct {
	int xpi_magic;			/* must be LX_PANELITEM */
	Display *xpi_dpy;		/* display */
	int xpi_type;			/* item type */
	int xpi_x, xpi_y;		/* position and extent */
	int xpi_w, xpi_h;
	void (*xpi_proc)();		/* function invoked after selection */
	Menu *xpi_menu;
	unsigned long xpi_fg, xpi_bg;	/* foreground and background */
	XFontStruct *xpi_font;		/* font */
	int xpi_state;			/* LXPI_ACTIVE (default) or LXPI_INACTIVE */
	int xpi_display;		/* LXPI_REPAINT (default) or LXPI_NOREPAINT */
	char *xpi_str;
	XImage *xpi_image;
	char *xpi_clientdata;
	Time xpi_timestamp;		/* last time that xpi_proc() was called */
	GC xpi_gc, xpi_igc;		/* normal, inverse, clear, */
	GC xpi_cgc, xpi_sgc;		/* stipple and or GCs */
	union {
		xp_label xpi_label;
		xp_text xpi_text;
		xp_button xpi_button;
		xp_slider xpi_slider;
		xp_enum xpi_enum;
	} xpi_item;
	struct Xpi_struct *xpi_next;
} Panel_item;

typedef struct Xp_struct {
	int xp_magic;			/* must be LX_PANEL */
	char *xp_name;			/* name of calling application */
	Display *xp_dpy;		/* display */
	Window xp_win;			/* window ID of enclosing frame */
	Window xp_pwin;			/* window ID of actual panel */
	Pixmap xp_ppm;			/* panel backing store pixmap */
	Window xp_vswin, xp_hswin;	/* window ID of scrollbars */
	Pixmap xp_vspm, xp_hspm;	/* scrollbar backing store pixmaps */
	Pixmap xp_stipplepm;		/* stipple for scrollbars */
	Cursor xp_pcursor;		/* cursors */
	Cursor xp_vscursor, xp_hscursor;
	int xp_x, xp_y;			/* position of xp_win vis-a-vis parent */
	int xp_w, xp_h;			/* size of xp_win */
	int xp_rph, xp_rpw;		/* requested panel size */
	int xp_mph, xp_mpw;		/* minimum panel size */
	int xp_aph, xp_apw;		/* actual size of xp_pwin */
	int xp_ibw;			/* internal border width inside xp_win */
	int xp_px, xp_py;		/* position of xp_pwin vis-a-vis xp_win */
	int xp_vx, xp_vy;		/* upper-leftmost visible pixel of xp_pwin */
	unsigned long xp_fg, xp_bg;	/* foreground and background */
	char *xp_fontnm;		/* font name */
	XFontStruct *xp_font;		/* font */
	int xp_alarmint;		/* blocking alarm interval in seconds */
	void (*xp_alarmproc)();		/* blocking alarm proc */
	int xp_bmargin, xp_rmargin;	/* bottom and right margin sizes */
	GC xp_gc, xp_igc;		/* normal, inverse, clear and stipple GCs */
	GC xp_cgc, xp_sgc;
	Scrollbar *xp_vscroll;		/* scrollbars */
	Scrollbar *xp_hscroll;
	Panel_item *xp_items;		/* Panel_item list */
	Panel_item *xp_selitem;		/* currently selected item */
	Panel_item *xp_seltext;		/* currently active text item */
	void (*xp_proc)();		/* user proc to be called in blocking mode */
	int xp_flags;
	char *xp_clientdata;
	struct Xp_struct *xp_next;
} Panel;

typedef struct {
	int (*xpi_idef_proc)();		/* item default initialization proc */
	int (*xpi_dst_proc)();		/* item destroy proc */
	int (*xpi_sz_proc)();		/* item resize proc */
	void (*xpi_drw_proc)();		/* item draw proc */
	void (*xpi_dsp_proc)();		/* item display proc */
	void (*xpi_bp_proc)();		/* item button press proc */
	void (*xpi_br_proc)();		/* item button release proc */
	void (*xpi_pm_proc)();		/* item pointer motion proc */
	void (*xpi_kp_proc)();		/* item key press proc */
} Panelitem_dispatch;

/* alert attributes */
#define LXA_NULL		(0)
#define LXA_FOREGROUND		(1)
#define LXA_BACKGROUND		(2)
#define LXA_BWIDTH		(3)
#define LXA_PROC		(4)
#define LXA_FONT		(5)
#define LXA_LABEL		(6)
#define LXA_TEXT		(7)
#define LXA_BUTTON		(8)
#define LXA_DEFAULTBUTTON	(9)
#define LXA_VISUAL		(10)
#define LXA_COLORMAP		(11)

/* default alert attributes */
#define LXADEF_BWIDTH		(4)
#define LXADEF_WIDTH		(250)
#define LXADEF_HEIGHT		(100)
#define LXADEF_FONT		"8x13"
#define LXADEF_HMARGIN		(12)
#define LXADEF_VMARGIN		(15)
#define LXADEF_MAXDISPLAY	(30)
#define LXADEF_MAXSTORE		(120)
#define LXADEF_BUTTONGAP	(20)
#define LXADEF_ALARMINTERVAL	(0)

/* Alert panels are built from Panel_items pointed
   to by the members of three lists of Alert_items:
   alert_labels, alert_texts and alert_buttons. */
typedef struct Xa_struct {
	Panel_item *xa_pi;		/* panel item itself */
	int xa_x, xa_y, xa_w;		/* location and size in alert panel */
	char *xa_string;		/* string label or prompt (all items) */
	char *xa_textval;		/* text item value (text items only) */
	char *xa_textvalptr;		/* pointer to user-allocated memory */
	int xa_buttonval;		/* button release value (buttons only) */
	struct Xa_struct *xa_next;
} Alert_item;

/* canvas attributes */
#define LXC_NULL		(0)
#define LXC_FOREGROUND		(1)
#define LXC_BACKGROUND		(2)
#define LXC_WIDTH		(3)
#define LXC_HEIGHT		(4)
#define LXC_BARWIDTH		(5)
#define LXC_BUBBLEMARGIN	(6)
#define LXC_BUTTONLEN		(7)
#define LXC_CCURSOR		(8)
#define LXC_VSCURSOR		(9)
#define LXC_HSCURSOR		(10)
#define LXC_VISIBLE		(11)
#define LXC_EXPOSEPROC		(12)
#define LXC_WINDOW		(13)
#define LXC_PIXMAP		(14)
#define LXC_XOFFSET		(15)
#define LXC_YOFFSET		(16)
#define LXC_MODE		(17)
#define LXC_BATCH		(18)
#define LXC_ACTIVE		(19)
#define LXC_VSCROLL		(20)
#define LXC_HSCROLL		(21)
#define LXC_DWIDTH		(22)
#define LXC_DHEIGHT		(23)

/* canvas pixmap mode */
#define LXC_STATIC		(0)
#define LXC_DYNAMICCLR		(1)
#define LXC_DYNAMICPRS		(2)

/* canvas batch mode */
#define LXC_BATCHON		(0)
#define LXC_BATCHOFF		(1)

/* default canvas attributes */
#define LXCDEF_SIZE		(500)

/* canvas flags */
#define LXC_FRAMEMAPPED		(0x00000001)
#define LXC_CANVASVISIBLE	(0x00000002)
#define LXC_VSCROLLVIS		(0x00000004)
#define LXC_HSCROLLVIS		(0x00000008)
#define LXC_CONFIGDONE		(0x00000010)
#define LXC_BATCHSET		(0x00000020)
#define LXC_CANVASACTIVE	(0x00000040)

typedef struct Xc_struct {
	int xc_magic;			/* must be LX_CANVAS */
	Display *xc_dpy;		/* display */
	Window xc_win;			/* window ID of enclosing frame */
	Window xc_cwin;			/* window ID of actual canvas */
	Pixmap xc_cpm;			/* panel backing store pixmap */
	int xc_mode;			/* static or dynamic canvas size */
	Window xc_vswin, xc_hswin;	/* window ID of scrollbars */
	Pixmap xc_vspm, xc_hspm;	/* scrollbar backing store pixmaps */
	Pixmap xc_stipplepm;		/* stipple for scrollbars */
	Cursor xc_ccursor;		/* cursors */
	Cursor xc_vscursor, xc_hscursor;
	int xc_x, xc_y;			/* position of xc_win vis-a-vis parent */
	int xc_w, xc_h;			/* size of xc_win */
	int xc_vch, xc_vcw;		/* virtual canvas size */
	int xc_ach, xc_acw;		/* actual size of xc_cwin */
	int xc_ibw;			/* internal border width inside xc_win */
	unsigned long xc_fg, xc_bg;	/* foreground and background */
	int xc_cx, xc_cy;		/* position of xc_pwin vis-a-vis xc_win */
	int xc_vx, xc_vy;		/* upper-leftmost visible pixel of xc_pwin */
	GC xc_gc, xc_cgc, xc_sgc;	/* normal, clear and stipple GCs */
	Scrollbar *xc_vscroll;		/* scrollbars */
	Scrollbar *xc_hscroll;
	void (*xc_exproc)();		/* expose proc */
	int xc_flags;
	struct Xc_struct *xc_next;
} Canvas;

#define LXT_TEXTBUFSZ		(5000)	/* initial size of xt_textbuf */
#define LXT_TEXTBUFINC		(1000)	/* amount added each time xt_text fills up */
#define LXT_LSBUFSZ		(50)	/* initial size of xt_linestarts */
#define LXT_LSBUFINC		(10)	/* amount added each time xt_linestarts fills up */
#define LXT_RDBUFSZ		(512)	/* amount of data to be read in at one time */
#define LXT_SPHOLDER		(0x01)	/* non-printable character, for new text */
#define LXT_NSPHOLDERS		(20)	/* number of insertable spaces to allocate */
#define LXT_TABLEN		(8)	/* length of a tab */
#define LXT_MAXFILENM		(255)	/* maximum filename length */
#define LXT_FINDBUFSZ		(512)	/* size of global find buffer */

/* used when scrolls need to be updated */
#define LXT_LONGESTLINEKNOWN	   	(1)
#define LXT_LONGESTLINEUNKNOWN	 	(2)

/* textsw attributes */
#define LXT_NULL			(0)
#define LXT_INPUTFILE 			(1)
#define LXT_OUTPUTFILE 			(2)
#define LXT_FOREGROUND			(3)
#define LXT_BACKGROUND			(4)
#define LXT_FONT			(5)
#define LXT_ALLOWINPUT			(6)
#define LXT_PASTEBUFFER			(7)
#define LXT_CHARPROC			(8)
#define LXT_EXITPROC			(9)
#define LXT_TCURSOR			(10)
#define LXT_VSCURSOR			(11)
#define LXT_HSCURSOR			(12)
#define LXT_BARWIDTH			(13)
#define LXT_BUBBLEMARGIN		(14)
#define LXT_BUTTONLEN			(15)
#define LXT_DRAWCURSOR			(16)
#define LXT_DRAWHIGHLIGHT		(17)
#define LXT_CURSORLINE			(18)
#define LXT_CURSORCOLUMN		(19)
#define LXT_INSERTTEXT			(20)
#define LXT_HIGHLIGHTENDLINE		(21)
#define LXT_HIGHLIGHTENDCOLUMN		(22)
#define LXT_CURSORVIEWABLE		(23)
#define LXT_NUMLINES			(24)
#define LXT_MENU 			(25)
#define LXT_TOPLINE 			(26)
#define LXT_CLIENTDATA 			(27)

/* flag bits */
#define LXT_FRAMEMAPPED			(0x00000001)

/* defaults */
#define LXTDEF_WIDTH			(750)
#define LXTDEF_HEIGHT			(800)
#define LXTDEF_FONT			"8x13"

struct Xt_xypair {
	int x, y;
};

typedef struct Xt_struct {
	int xt_magic;				/* must be LX_TEXTSW */
	char *xt_name;				/* name of calling application */
	Display *xt_dpy;			/* display */
	Window xt_win;				/* window ID of enclosing frame */
	Window xt_twin;				/* window ID of actual text */
	Window xt_vswin, xt_hswin;		/* scrollbar window IDs */
	Pixmap xt_tpm;				/* xt_twin backing store pixmap */
	Pixmap xt_stipplepm;			/* stipple pixmap */
	Cursor xt_tcursor;			/* cursors */
	Cursor xt_vscursor, xt_hscursor;
	GC xt_gc, xt_cgc, xt_igc;		/* normal, clear and inverse GCs */
	GC xt_sgc, xt_xgc;			/* stipple and xor GCs */
	int xt_w, xt_h;				/* width and height of xt_win */
	int xt_atw, xt_ath;			/* actual size of xt_twin */
	int xt_ibw;				/* internal border width inside xt_win */
	unsigned long xt_fg, xt_bg;		/* foreground and background colors */
	Menu *xt_menu;				/* menu for xt_twin */
	Menu_item *xt_smenuitem;
	int xt_hscrolllen, xt_vscrolllen;	/* scroll length without buttons */
	int xt_nbuflines;			/* number of lines in the buffer */
	int xt_nbufchars;			/* number of characters in the buffer */
	int xt_topline;				/* line number of top line in xt_twin */
	int xt_leftpix;				/* leftmost pixel in xt_twin */
	int xt_wcw, xt_wch;			/* size in characters of a window */
	int xt_lsbufsz;				/* buffer size of xt_linestarts */
	int xt_textbufsz;			/* buffer size of xt_text */
	int xt_cwidth, xt_cheight;		/* size of a character in pixels */
	int xt_cdescent;			/* character descent */
	int xt_clbearing;			/* character left bearing */
	int xt_maxlinelen;			/* pixel length of longest line in text */
	int xt_maxlinenum;			/* line number of longest line in text */
	int *xt_linestarts;			/* indices to beginning of lines */
	int xt_irow, xt_icol;			/* current cursor position */
	int xt_ichar;				/* index into xt_text where new character goes */
	int xt_nspholders;			/* number of spaces for new text */
	int xt_drawcursor;
	int xt_cursorpx, xt_cursorpy;		/* current pixel position of cursor */
	int xt_enablehlt;			/* enable highlight */
	int xt_drawhlt;
	int xt_hltstartx, xt_hltstarty;		/* used for highlighting text */
	int xt_hltendx, xt_hltendy;
	int xt_hltcursorx, xt_hltcursory;
	struct Xt_xypair xt_hltorigin;		/* upper left hand corner */
	int xt_textedited;
	int xt_allowinput;
	int xt_updatescroll;
	int (*xt_charproc)();			/* called when user types */
	int (*xt_exitproc)();			/* called when destroy requested */
	char xt_rdfilenm[LXT_MAXFILENM+1];	/* last file read */
	char xt_wrfilenm[LXT_MAXFILENM+1];	/* default name of output file */
	char *xt_text;				/* text being edited */
	Scrollbar *xt_vscroll, *xt_hscroll;	/* scrollbars */
	XFontStruct *xt_font;			/* font */
	char *xt_fontnm;			/* font name */
	int xt_flags;
	char *xt_clientdata;
	struct Xt_struct *xt_next;
} Textsw;

#if defined(c_plusplus) || defined(__cplusplus)
extern "C" {

Menu *		menu_create(char *, Display *, Window, ... );
void *		menu_get(Menu *, int);
int		menu_set(Menu *, ... );
void		menu_show(Menu *, XButtonPressedEvent *);
int		menu_destroy(Menu *);
Menu_item *	menuitem_create( ... );
void *		menuitem_get(Menu_item *, int);
int		menuitem_set(Menu_item *, ... );
int		menuitem_insert(Menu *, Menu_item *);
int		menuitem_delete(Menu *, Menu_item *);
int		menuitem_destroy(Menu_item *);
Menu_item *	menuitem_find(Menu *, int, ... );

Canvas *	canvas_create(char *, Display *, Window, ... );
void *		canvas_get(Canvas *, int);
int		canvas_set(Canvas *, ... );
int		canvas_destroy(Canvas *);
void		canvas_clear(Canvas *);
void		canvas_flush(Canvas *);
int		canvas_draw_line(Canvas *, int, int, int, int, GC);
int		canvas_draw_string(Canvas *, int, int, char *, GC);

Panel *		panel_create(char *, Display *, Window, ... );
void *		panel_get(Panel *, int);
int		panel_set(Panel *, ... );
int		panel_redisplay(Panel *);
int		panel_destroy(Panel *);
int		panel_block(Panel *, int *);
int		panel_unblock(Panel *, int);
Panel_item *	panelitem_create(Panel *, int, ... );
void *		panelitem_get(Panel *, Panel_item *, int);
int		panelitem_set(Panel *, Panel_item *, ... );
int		panelitem_addsel(Panel *, Panel_item *, ... );
int		panelitem_redisplay(Panel *, Panel_item *);
int		panelitem_delete(Panel *, Panel_item *);
int		panelitem_destroy(Panel_item *);

int		alert_setdefaults( ... );
int		alert_prompt(char *, Display *, int *, ... );

Textsw *	textsw_create(char *, Display *, Window, ... );
void *		textsw_get(Textsw *, int);
int		textsw_set(Textsw *, ... );
char *		textsw_text(Textsw *, int);
boolean		textsw_active();
int		textsw_destroy(Textsw *);
void		textsw_clear(Textsw *);

XImage *	image_create(Display *, unsigned long, unsigned long, char *,
			int, int, int);

boolean		lxt_event(XEvent *);

}

#else

extern Menu *		menu_create();
extern Void *		menu_get();
extern int		menu_set();
extern void		menu_show();
extern int		menu_destroy();
extern Menu_item *	menuitem_create();
extern Void *		menuitem_get();
extern int		menuitem_set();
extern int		menuitem_insert();
extern int		menuitem_delete();
extern int		menuitem_destroy();
extern Menu_item *	menuitem_find();

extern Canvas *		canvas_create();
extern Void *		canvas_get();
extern int		canvas_set();
extern int		canvas_destroy();
extern void		canvas_clear();
extern void		canvas_flush();
extern int		canvas_draw_line();
extern int		canvas_draw_string();

extern Panel *		panel_create();
extern Void *		panel_get();
extern int		panel_set();
extern int		panel_redisplay();
extern int		panel_destroy();
extern int		panel_block();
extern int		panel_unblock();
extern Panel_item *	panelitem_create();
extern Void *		panelitem_get();
extern int		panelitem_set();
extern int		panelitem_addsel();
extern int		panelitem_redisplay();
extern int		panelitem_delete();
extern int		panelitem_destroy();

extern int		alert_setdefaults();
extern int		alert_prompt();

extern Textsw *		textsw_create();
extern Void *		textsw_get();
extern int		textsw_set();
extern char *		textsw_text();
extern boolean		textsw_active();
extern int		textsw_destroy();
extern void		textsw_clear();

extern XImage *		image_create();

extern boolean		lxt_event();

extern char *strcat(), *strcpy(), *strncpy();
#ifdef NeXT
extern void cfree(), *calloc(), *malloc(), *realloc();
#else
extern char *calloc(), *malloc(), *realloc();
#endif NeXT

#ifdef IRIX
extern int sprintf();
#else
#ifndef NeXT
extern char *sprintf();
#endif NeXT
#endif IRIX

#endif defined(c_plusplus) || defined(__cplusplus)

#endif __LXT_DEFINES__
