' filter table maker for the TX16W

' the remez part of this is from the C version by Jake Janovetz of the
' Oppenheim and Schaffer version of the FORTRAN IEEE version of
' the McClelland and Parker version of the Remez original.

' 9/6/94 d schaaf

' NOTE: Doesn't do level correction (first 4 bits of filter table.) Some
' filters may distort.  If this is a problem, complain. I think that the
' log of the peak filter response (over 0 db) is the correction to use,
' but haven't tried it.

DECLARE SUB FreqSample ()
DECLARE SUB CalcError ()
DECLARE SUB Search ()
DECLARE FUNCTION IsDone# ()
DECLARE SUB InitialGuess ()
DECLARE SUB CreateDenseGrid ()
DECLARE FUNCTION ComputeA# (freq AS DOUBLE)
DECLARE SUB Calcparms ()
'          **** remez exchange for tx16w   ****

DIM SHARED h(66), bands(20), x(66), y(66), d(1045), w(1045), taps(66)
DIM SHARED Ext(66) AS INTEGER, ad(66) AS DOUBLE, e(1045) AS DOUBLE
DIM SHARED des(1045) AS SINGLE, weight(1045) AS SINGLE, grid(1045) AS DOUBLE
COMMON SHARED r AS INTEGER, numband AS INTEGER, gridsize AS INTEGER
COMMON SHARED numtaps AS INTEGER, delta AS DOUBLE
CONST pi = 3.1415926536#
CONST pi2 = pi * 2#
ON ERROR GOTO 5230

REDIM af8(256, 2)
CONST points% = 256
CONST ringer% = 3' graphics  scaling
'****************************
normalize! = 40000
row$ = "FREQ": column$ = "LEVEL"

 r = 16: numband = 2: numtaps = 31

'***********************

PRINT : PRINT :
200
 SCREEN 12
210
    WINDOW SCREEN (1, 1)-(480, 640)
 PRINT
 PRINT
 PRINT " ************ Remez Exchange for Yamaha TX16W Filters *************"
 PRINT
 PRINT "Assumes 31 tap filter (yamaha)"
top:
 PRINT
 PRINT
 PRINT "Number of bands, now:"; numband;
 INPUT n%: IF n% <> 0 THEN numband = n%


270
 delta = 0
 jb = 2 * numband - 1
 bands(0) = 0: bands(jb) = .5
PRINT
PRINT "Assumes Frequncies from 0 hz to 20 kHz."

 FOR i = 1 TO jb - 1
    PRINT "Input Frequency in Hz. for (corner) #"; i; " now:"; bands(i) * normalize!;
    INPUT f: IF f <> 0 THEN bands(i) = f / normalize!' normalize to .5 Hz
 NEXT i
 PRINT
 FOR i = 0 TO numband - 1
   IF des(i) = 0 THEN des(i) = .00000001#
   PRINT "Band"; i + 1; "Input gain, now:"; des(i);
   INPUT n$: IF n$ <> "" THEN des(i) = VAL(n$)
    IF weight(i) = 0 THEN weight(i) = 1
   PRINT "       Weight, now:"; weight(i);
   INPUT f: IF f <> 0 THEN weight(i) = f
   PRINT
 NEXT i
  CLS
  GOSUB dat
  GOSUB grid
  GOSUB show.desire
  INPUT "Ok (y/n)"; n$: IF n$ <> "Y" AND n$ <> "y" THEN CLS : GOTO top
 
 gridsize = 0

 FOR i% = 0 TO numband - 1
   gridsize = gridsize + 32 * (bands(2 * i% + 1) - bands(2 * i%)) + .5
 NEXT i%

GOSUB remez

1430

 PRINT "Impulse responce:"

 grope = 0


 FOR j = 0 TO r - 1
  k = numtaps - 1 - j
  h = h(j)
'  PRINT "H("; j; ")   "; h; "  H("; k; ")"
  h = h(j): IF ABS(h) > grope THEN grope = ABS(h)
 NEXT j

 grope = 1 / grope: ' PRINT "Grope"; grope
'     INPUT t
   GOSUB plot.fft
   GOSUB show.desire

  GOSUB 5070
  INPUT "Try again? (Y or N)"; n$
  IF n$ = "N" OR n$ = "n" THEN PRINT "fin": END
  CLS
GOTO top

remez:
CreateDenseGrid
InitialGuess

  FOR iter% = 1 TO 25
    Calcparms
    CalcError
    Search
    PRINT "after pass:"; iter%
    IF IsDone THEN GOTO fin
  NEXT iter%
 
  PRINT
  PRINT "Didn't converge but may be ok."
  PRINT

fin: PRINT "almost done"
 Calcparms

 FOR i% = 0 TO numtaps / 2
  taps(i%) = ComputeA#(i% / numtaps)
 NEXT i%
 FreqSample


RETURN


5070
 INPUT "Save to file"; n$: IF UCASE$(n$) <> "Y" THEN RETURN
 IF file$ = "" THEN
   INPUT "Name of filter file:", file$:  IF INSTR(file$, ".") = 0 THEN file$ = file$ + ".t99"
5080
 FILES file$
5085
   OPEN "remez.log" FOR APPEND AS #1
 END IF
  
   LINE INPUT "Enter comment for log: ", n$: PRINT #1, "COMMENT: "; n$

PRINT #1, "TYPE: "; jtype
 FOR k = 0 TO numband - 1
  PRINT #1, "BAND: "; k; bands((2 * k)) * normalize!; bands(2 * k + 1) * normalize!; "Hz.  ";
 IF jtype <> 2 THEN
  PRINT #1, "GAIN:"; des(k);
 ELSE
  PRINT #1, "SLOPE:"; des(k);
 END IF

  PRINT #1, "WIEGHT:"; weight(k);
 IF jtype = 1 THEN
   PRINT deviat(k); "db"
  END IF
  PRINT #1,
 NEXT k
 
  man$ = ""
  
   FOR i = r - 1 TO 0 STEP -1
   m% = (h(i) * grope * &H7FF)
   h% = m% AND &HFFF
   man$ = man$ + CHR$((h% \ &H100) AND &HFF) + CHR$(h% AND &HFF)
   NEXT i

   GOSUB make.copy
PRINT #1,


RETURN


5230

 IF ERL = 200 THEN SCREEN 2: RESUME 210
 IF ERL = 5080 THEN GOSUB make.new.one: RESUME 5085
 IF ERL = 8000 THEN RESUME NEXT

PRINT "ERROR"; ERL
RESUME NEXT


' program for ibm-pc's to read Yamaha filter files and display
' impulse response and frequncy response.
' Uses fft from cooley, lewis and welch via loy

' corrected 8/29/94 for mirror image of impulse about first parameter
' added sweep of filter valiables
' added level data in first 4 bits of filter data



plot.fft:
 
  level% = 1

bing:
CLS : colour% = 2
 GOSUB grid
gree:

big.bag:
   GOSUB get.data
   GOSUB fft
   GOSUB plot
   colour% = (colour% AND &HF) + 1: IF colour% = 8 THEN colour% = 9
   LOCATE 1, 1: GOSUB dat
RETURN

fft:

jF8% = 1

 FOR iF8% = 1 TO points% - 1

  IF iF8% < jF8% THEN
    SWAP af8(jF8%, 1), af8(iF8%, 1): SWAP af8(jF8%, 2), af8(iF8%, 2)
  END IF

  Kf8% = points% \ 2' 128

fink:
  IF Kf8% < jF8% THEN jF8% = jF8% - Kf8%: Kf8% = Kf8% \ 2: GOTO fink

  jF8% = jF8% + Kf8%

 NEXT iF8%

 FOR Lf8% = 1 TO 8
  lef8% = 2 ^ Lf8%
  leIf8% = lef8% \ 2
  U1f8 = 1
  u2F8 = 0
  W1f8 = COS(pi# / leIf8%)
  w2F8 = SIN(pi# / leIf8%)

 FOR jF8% = 1 TO leIf8%
   FOR iF8% = jF8% TO points% STEP lef8%
   
    iPf8% = iF8% + leIf8%
    temp1 = af8(iPf8%, 1) * U1f8: temp1 = temp1 - af8(iPf8%, 2) * u2F8
    temp2 = af8(iPf8%, 1) * u2F8: temp2 = temp2 + af8(iPf8%, 2) * U1f8

    af8(iPf8%, 1) = af8(iF8%, 1) - temp1
    af8(iPf8%, 2) = af8(iF8%, 2) - temp2
    af8(iF8%, 1) = af8(iF8%, 1) + temp1
    af8(iF8%, 2) = af8(iF8%, 2) + temp2


   NEXT iF8%
  
   temp9 = U1f8
   U1f8 = U1f8 * W1f8: U1f8 = U1f8 - u2F8 * w2F8
   temp0 = u2F8
   u2F8 = temp9 * w2F8
   u2F8 = u2F8 + temp0 * W1f8

 NEXT jF8%
 NEXT Lf8%

RETURN

get.data:
   REDIM af8(256, 2)
 show.y% = 120
  LINE (18 * 6, show.y%)-(18 * 6, show.y%)

 FOR j = 0 TO r - 1
 k = numtaps - j
 'IF neg = 0 THEN af8(j, 1) = H(j): af8(k, 1) = H(j)
  'IF neg = 1 THEN
  af8(j + 1, 1) = h(j) * grope * &H800: af8(k, 1) = h(j) * &H800 * grope
'             PRINT j, H(j)
  LINE -((18 - j) * 6, show.y% + h(j) * grope * &H40), colour%

 NEXT j

RETURN

plot:

 LOCATE 14: PRINT "Frequency Response:"

 LINE (12, 600 - 230)-(12, 600 - 230)
8000
 FOR l% = 1 TO points% \ 2
  master = SQR(af8(l%, 1) * af8(l%, 1) + af8(l%, 2) * af8(l%, 2))
  LINE -(l% * ringer% + 10, 615 - LOG(master + .001) * 30 + 20 * level%), colour%
 NEXT l%
8010
RETURN

show.desire:
 LINE (12, 600 - 230)-(12, 600 - 230)
     ming% = 256 * 3
 FOR l% = 0 TO jb
  master = des(l% \ 2) * &HF00
  LINE -(bands(l%) * ming% + 12, 565 - LOG(master + .001) * 26), 9
 NEXT l%

RETURN

grid:

 muck% = 0
 LINE (12, 600 - 230)-(12, 600 - 230)
 FOR l% = 1 TO points% \ 2 + 1 STEP 16
  IF muck% = 7 THEN muck% = 8 ELSE muck% = 7
  LINE (10 + ringer% * l%, 600)-(10 + ringer% * l%, 310), muck%, , &HFEFF
 NEXT l%

 muck% = 0
 LINE (12, 600 - 230)-(12, 600 - 230)
 FOR l% = 0 TO 261 STEP 30
  IF muck% = 7 THEN muck% = 8 ELSE muck% = 7
  LINE (12, 350 + l%)-(400, 350 + l%), muck%, , &HEFEF
 NEXT l%

 RETURN' grid



dat:
 FOR k = 0 TO numband - 1
  PRINT "Band"; k + 1; bands((2 * k)) * normalize!;
  PRINT "Hz to"; bands(2 * k + 1) * normalize!; "Hz.  ";

  PRINT "Gain:"; des(k);

  deviat(k) = ABS(delta) / weight(k)
'  PRINT "Dev:"; deviat(k);
   deviat(k) = (20 / 2.303) * LOG(.0000001 + deviat(k) + des(k))
   PRINT deviat(k); "db ";
 
  PRINT "Wieght:"; weight(k)

NEXT k

RETURN

make.new.one:
 
 OPEN file$ FOR OUTPUT AS #2

 PRINT #2, "LM8953"; STRING$(10, 0);

 lm$ = CHR$(&H7) + CHR$(&HFF) + STRING$(15 * 2, 0)
            PRINT LEN(lm$)
 FOR l% = 1 TO 11 * 11
   PRINT #2, lm$;
 NEXT l%
  
 PRINT #2, "freq      level     "; STRING$(12, 0);
   FOR l% = 1 TO 9
     PRINT #2, STRING$(16, 0);
   NEXT l%

 PRINT #2, "freq    "; STRING$(8, 0); "level   " + STRING$(8, 0);
 CLOSE #2

RETURN

 PRINT ERL, ERR
 END

copy.data:

   OPEN file$ FOR RANDOM AS 2 LEN = 16
   FIELD #2, 16 AS fridge$

   LSET fridge$ = LEFT$(man$, 16)
   PUT #2, 2 + pinfo% * 2
   LSET fridge$ = RIGHT$(man$, 16)
   PUT #2, 3 + pinfo% * 2
   CLOSE #2

   RETURN

make.copy:

   LOCATE 5, 1
    PRINT "Enter "; row$; " (1-11) of "; file$; " to copy to:";
    INPUT " ", bb%: IF bb% = 0 THEN RETURN

    PRINT "Enter "; column$; " (1 - 11) of "; file$; " to copy to:";
    INPUT " ", cco%: IF cco% = 0 THEN RETURN

    pinfo% = bb% - 1 + (cco% - 1) * 11

    GOSUB copy.data
RETURN



mid:
FOR l% = 1 TO 30
PRINT l%; grid(l%),
NEXT l%

SUB CalcError
  FOR i% = 0 TO gridsize - 1
   a# = ComputeA#(grid(i%))
   e(i%) = w(i%) * (d(i%) - a#)
'   PRINT "a-e(i%)"; a#, e(i%)
  NEXT i%
END SUB

SUB Calcparms
 
  ' x[]

  FOR i% = 0 TO r: x(i%) = COS(pi2 * grid(Ext(i%))): NEXT i%

  'ad[]

  ld% = (r - 1) / 15 + 1

  FOR i% = 0 TO r
    denom# = 1#
    xi# = x(i%)
   
    FOR j% = 0 TO ld% - 1
       FOR k% = j% TO r STEP ld%
         IF k% <> i% THEN denom# = denom# * 2 * (xi# - x(k%))
       NEXT k%
    NEXT j%
      
    IF denom# = 0# THEN denom# = 9.999999999999999D-41
    ad(i%) = 1 / denom#
'    PRINT ad(i%),
  NEXT i%

  'delta

  numer# = 0#
  denom# = 0#

  sign = 1

  FOR i% = 0 TO r
    numer# = numer# + ad(i%) * d(Ext(i%))
    denom# = denom# + sign * ad(i%) / w(Ext(i%))
    sign = -sign
  NEXT i%
   
  IF denom# = 0# THEN denom# = 9.999999999999999D-41
  delta = numer# / denom#
  sign = 1
 PRINT "Delta:"; delta;

   
  'y()

  FOR i% = 0 TO r
   y(i%) = d(Ext(i%)) - sign * delta / w(Ext(i%))
   sign = -sign
  NEXT i%
END SUB

FUNCTION ComputeA# (freq AS DOUBLE)

 denom# = 0#
 numer# = 0#
 xc# = COS(pi2 * freq)
 'PRINT "freq."; freq, xc#
 FOR i% = 0 TO r
   c# = xc# - x(i%)
   IF ABS(c#) < .0000001 THEN numer# = y(i%): denom# = 1: GOTO link
   c# = ad(i%) / c#
   denom# = denom# + c#
   numer# = numer# + c# * y(i%)
 NEXT i%
link:
'PRINT "numer#:"; numer#, denom#

 ComputeA# = numer# / denom#

END FUNCTION

SUB CreateDenseGrid
  delf = 1# / 32# / r

  j% = 0

  FOR band% = 0 TO numband - 1
   grid(j%) = bands(2 * band%)
   lowf = bands(2 * band%)
   highf = bands(2 * band% + 1)
  
   k% = (highf - lowf) / delf + .5
  
     FOR i% = 0 TO k% - 1
       d(j%) = des(band%)
       w(j%) = weight(band%)
       grid(j%) = lowf
       lowf = lowf + delf
       j% = j% + 1
     NEXT i%
   
   grid(j% - 1) = highf

  NEXT band%
gridsize = j%: PRINT : PRINT "gridsize:"; j%

END SUB

SUB FreqSample
 m# = (numtaps - 1) / 2
    PRINT m#

 FOR n% = 0 TO m#'numtaps / 2 - 1
   vl# = taps(0)
   x# = pi2 * (n% - m#) / numtaps
   
      FOR k% = 1 TO m#
        vl# = vl# + 2 * taps(k%) * COS(x# * k%)
      NEXT k%
     
   h(n%) = vl# / numtaps
   PRINT "H("; n%; ") = "; h(n%),
 NEXT n%

END SUB

SUB InitialGuess
  FOR i% = 0 TO r
    Ext(i%) = i% * (gridsize - 1) / r
'    PRINT Ext(i%),
  NEXT i%
'    END
END SUB

FUNCTION IsDone#

  min# = ABS(e(Ext(0)))
  max# = min#

  FOR i% = 1 TO r
    current# = ABS(e(Ext(i%)))
'    PRINT current#
    IF current# < min# THEN min# = current#
    IF current# > max# THEN max# = current#
  NEXT i%

  IsDone# = (((max# - min#) / max#) < .0001)


END FUNCTION

SUB Search
  DIM foundExt(100)
  
  k% = 0
  IF (((e(0) > 0) AND (e(0) > e(1))) OR ((e(0) < 0) AND (e(0) < e(1)))) THEN
   foundExt(k%) = 0: k% = k% + 1
   END IF

   FOR i% = 1 TO gridsize - 2
     f% = ((e(i%) >= e(i% - 1)) AND (e(i%) > e(i% + 1)) AND (e(i%) > 0))
     f% = f% OR ((e(i%) <= e(i% - 1)) AND (e(i%) < e(i% + 1)) AND (e(i%) < 0))
     IF f% THEN foundExt(k%) = i%: k% = k% + 1
   NEXT i%

   j% = gridsize - 1
  IF (((e(j%) > 0) AND (e(j%) > e(j% - 1))) OR ((e(j%) < 0) AND (e(j%) < e(j% - 1)))) THEN
   foundExt(k%) = j%: k% = k% + 1
  END IF

  extra = k% - r - 1

  WHILE extra > 0
    IF e(foundExt(0)) > 0 THEN up = -1 ELSE up = 0
    l% = 0
    alt% = -1

    FOR j% = 1 TO k% - 1
      IF ABS(e(foundExt(j%))) < ABS(e(foundExt(l%))) THEN l% = j%
      IF up AND (e(foundExt(j%)) < 0) THEN
         up = 0
      ELSE
           IF (up = 0) AND (e(foundExt(j%)) > 0) THEN
             up = -1
           ELSE alt% = 0: GOTO link1
           END IF
      END IF
     NEXT j%
link1:
     IF alt% AND (extra = 1) THEN
        IF ABS(e(foundExt(k% - 1))) < ABS(e(foundExt(0))) THEN
           l% = foundExt(k% - 1)
        ELSE
           l% = foundExt(0)
        END IF
     END IF

     FOR j% = l% TO k% - 1
        foundExt(j%) = foundExt(j% + 1)
     NEXT j%
     k% = k% - 1
     extra = extra - 1

  WEND

     FOR i% = 0 TO r
       Ext(i%) = foundExt(i%)
     NEXT i%
END SUB

