h51396
s 00002/00004/00050
d D 1.3 86/09/12 15:58:07 dgl 3 2
c getheader does not return anything.
e
s 00000/00000/00054
d D 1.2 85/11/26 23:00:45 dgl 2 1
c eliminated LOOKED_ALREADY from getheader to cure bug 
c re. trying to add property to stdin if no header exists yet.
e
s 00054/00000/00000
d D 1.1 85/11/25 09:56:52 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <carl/defaults.h>
#include <carl/carl.h>
#include <carl/procom.h>

/*
 * fgetfloat - get floatsam 
 * takes:
 * 	fp - pointer to a float
 * 	iop - file descriptor
 * returns:
 * 	fbp->ssize if successful
 * 	-1 on errors
 * 	0 if out of input
 * side effects:
 * 	sets up buffer for samples
 * 	if a header is present, it is read in and stored on the
 * 		property list associated with this iop
 * notes:
 * 	see the macro for getfloat()
 */


fgetfloat(fp, iop)
	float *fp;
	FILE *iop;
{
	register struct fltbuf *fbp;

	fbp = &fb[fileno(iop)];			/* get fid buffer pointer */
	if (fbp->gpflt == 0) {			/* first time? */
		set_sample_size(sizeof(float));
		if (finitbuf(iop))		/* setup buffer */
			return(-1);
D 3
		if (!fbp->prop) {		/* go get header */
			if (getheader(iop) < 0)
				return(-1);
		}
E 3
I 3
		if (!fbp->prop) 		/* go get header */
			getheader(iop);
E 3
	}

	if (fbp->pos >= fbp->n) {	/* get floatsam */
		if ((fbp->n = read(fileno(iop),(char *)fbp->fbuf,P_BUFSIZE))<=0)
			return(fbp->n);
		fbp->pos = 0;
		fbp->n /= fbp->ssize;
	}


	*fp = fbp->fbuf[fbp->pos++];	/* copy out of buffer */

	return(fbp->ssize);		/* success */
}
E 1
