.RP
.TL 
Sndpath - A Program to Interactively Create/Edit Sound Trajectories
.AU
Gareth Loy
.AI
Computer Audio Research Laboratory,
Center for Music Experiment, 
University of California, San Diego
.AB 
.B sndpath 
is an interactive program to produce and edit two dimensional sound 
trajectories or
paths on ordinary CRT terminals.  The user marks points on the sound
space, and on command, 
.B sndpath
draws a spline-fit curve through them.  Commands exist in
.B sndpath 
to modify, append and delete points on the path as well as to manipulate
the path as a whole. 
The area
covered by the screen display can be scaled to represent 
a range from a few meters to many kilometers.
The output of 
.B sndpath
is spline-fit [x,y] coordinate pairs, monotonic in time. 
That is, it simply produces the path,
it does not apply any particular
interpretation on how to fit the path to any acoustic space, making
it possible to use 
.B sndpath
with any of a variety of suitable methods for doing so.
.AE
.SH 
DESCRIPTION
.PP
.B sndpath
is an interactive graphic editor of two-dimensional functions that provides
a composer with a tool to describe the path of a sound through space.
Upon starting the program, the user is presented with a rectangle drawn
around the screen, which represents the boundary of the total sound field
available (the scope of this boundary is adjustable).
A smaller rectangle of numbers in the center is
are taken as 
the boundary of the physical listening space.  If reproduction is taking
place in 4 loudspeakers placed in the corners of the room, these numbers
can stand for the speakers.
The sound space is divided into four quadrants, numbered
according to the cartesian coordinate system, counterclockwise from 1 in
the upper right hand quadrant.  A '+' is in the middle of the screen,
corresponding to the ideal listener location.
The cursor is positioned in the upper left
hand corner.  The top line of the screen is used for status information.
.PP
After the points that define the path are laid out, 
a smooth curve is laid over it on command (described below).  
The location and number of points can be edited at any time,
and the path as a whole can be modified.  When the desired
result is achieved, the path is saved on a file for later use in synthesizing
a sound on the path.
.SH 
CURSOR MOTION
.PP
To draw a path, the composer moves the cursor to a sequence of
desired positions relative to the listener, marking 'x' where the sound
is to pass.  The cursor can be moved by a set of commands as follows.
The keys: 'u' 'i' 'o' 'j' 'l' 'm' ',' '.' form a matrix of adjacent keys
on the keyboard.  The key 'i' moves up, ',' down, 'j' left and 'l' right.
In addition the 'u' key moves up-left, 'o' up-right, 'm' down-left and '.'
down-right.  The 'k' key, in the middle of the matrix has the special function
of jumping back to the most recently marked position.  If any of these keys
are capitalized, the cursor is "slammed" to the following positions: 'U'
upper left corner, 'O' upper right, 'M' lower left '>' lower right.  The
key 'I' slams straight up, '<' straight down, 'J' leftmost margin and 'L'
rightmost margin.  The 'K' key jumps the cursor to the center of the screen.
.SH
MARKING THE PATH
.PP
When the cursor is correctly positioned, 
pressing the 'x' key marks the spot.  The
character 'X' appears under the cursor on the screen.  Points must be put
down in order.  It is not possible to re-order existing points.  Rather,
wrongly placed points can be moved, new points can be interpolated between
two existing ones, new points can be appended to those already there, and
points can be deleted.
.PP
To erase a point, put the cursor on it and press the spacebar.  To append
a point to a path, simply mark a new 'x' on the desired location, it will
automatically be appended to the path.  To interpolate a new point between
two existing points, put the cursor on the first of the two and press 'n'.
A new point will be placed in between the two, and the cursor
will be positioned on it.  (You can not use 'n' to put a point after
the last point.  Simply append the new point in this case with the 'x'
key in the usual way.)
.PP
Points can be moved around.  For instance, once a new point is interpolated
between two existing ones, you usually want to move it.  You can "yank"
and "put" points.  Put the cursor on the point to be yanked and type 'y'.
The point under the cursor goes from 'X' to 'O' to indicate it can be moved.
Subsequent cursor movement takes the point along with it.  Finally, 
type 'p' to put it down at the position to which you have moved.
.PP
It is possible for more than one mark to exist on the same character
position, so that a sound can dwell in one location, or return to the
same point later.  Care must be excersized here since it is not 
casually obvious how many points occupy a single location.
.PP
If the cursor is positioned on a point, you can jump forward to the next point
with 'f', and backwards to the previous point with 'b'.  These commands are very
useful in showing the progress of a path where the screen gets dense with
points.  Also, when more than one point occupies a position, 'f' and 'b'
are guaranteed to move to the right point, i.e., the one which lies just
forward (or backward) from the ajoining point.  (This may not be true if
you move the cursor from a non-Xed location
onto a doubled point with regular cursor moving commands.
In that case, the point "found" is always the first point placed there,
relative to the beginning of the path.)
.SH
PLOTTING THE PATH
.PP
To plot the path after X'ing it in, press the [RETURN] key.  A smooth curve
represented by '*' characters
is drawn between all the points.  It may not appear smooth because of the
limited resolution of the CRT terminal, but it is in fact a spline curve
with two continuous derivatives, using the same algorithm as described in
spline(1) but modified to allow for x to be non-monotonic.  By default,
the path is plotted with 128 points*.  
.FS
*But note that the number of points actually plotted may vary, see below.
.FE
After plotting the path, the points
can be moved around, invented or deleted as previously described.
.PP
Two commands exist to erase the screen: 'e' and 'E'.  'e' removes the
spline curve leaving the Xes.  'E' removes the Xes too.
.SH 
FILES
.PP
.B sndpath
reads and writes three kinds of files: "plot" files,
binary floating point (floatsam) files, and "text" files.
Plot files contain the information about the points Xed, and the state of 
.B sndpath
for that particular path.  After a path is Xed in, typing 'P' causes the
status line to say "Plot file name: (writes name.p)", 
to which you respond with the
name of the file, and [RETURN].  
The file written will have a .p added to it.
To read in a previously written plot
file, type 'r'.  The status line says "Read plot file:" to which you
respond with the name as before.
It is also possible to append the points in a plot file to any current
path on the screen with 'a' which asks "Append plot file:".  This way
you can build up complex paths.
When using 'r' and 'a', just supply the filename, the extension (the .p
part) will be added automatically.
.PP
The 'W' 
command
will write a text version of the path.  The status line says: 
"Text function file name (writes name.t)"
and you supply the name.  It is not possible to read back text
files, but they can be regenerated from the plot file.
The file generated contains two numbers per line of the x,y values of
the path.  It will have a .t appended to the filename automatically.
This format is useful for
.I graph(1), plot(1)
and
.I quad(1carl).
.PP
The 'w'
command writes two files, one called filename.x which contains the
floatsam version of the x component of the path, the other filename.y
which contains the y component.  Again, the .x and .y parts are 
added automatically.  This format is useful for direct read-in to a 
.I cmusic(1carl)
score via
.I genraw(1carl).
.SH
THE SOUND FIELD 
.PP 
When the cursor is on an X, the status line
displays the current location, giving its x and
y coordinates in meters, the ordinal number of the point, its velocity
and its time value.  
There are two character positions between the speakers
to start with, and the distance between them is initailly set to 5 meters.
Thus, each character position initially occupies an area of 2.5 by 2.5 meters.  
Given that there are 80 characters horizontally and 23 characters vertically
(24 less 1 at the top used for a status line)
that makes the range and domain 
200 by 57.5 meters, respectively.
.SH
ZOOMING
.PP
It is possible to change the scope of the display with the zoom command.
It is an "extend mode" command.  (Extend mode commands are explaned below.)
The zoom scale is equal to the number of character positions between the 
speakers, which starts out being 2 (that is, there are two blanks between
each speaker number).  Setting it to 4 magnifies the picture
by double.  The distance in meters between the speakers is kept the same,
so that the path is expanded.
Points you have plotted may now lie outside the display area.  After
altering the zoom scale, the spline
plot is removed and the Xes are put in the correct places. 
The spline function can be redrawn to the correct scale by pressing
[RETURN].
.SH
CHANGING SPEAKER SEPARATION 
.PP
As already stated, the default speaker separation is 5 meters.  Another
extend mode command changes this value.  The number of character positions
between the speakers does not change, however, so the result is to
alter the size of the area covered by each character position.  E.g., 
to double the speaker separation to 10 meters increases the area covered by each
character to 5 meters.  This forces rescaling any displayed path, which
removes the spline curve (if any) and replots the Xes to the new scale.
.SH
VELOCITY AND TIME
.PP
Ordinarily, when a point is Xed on the screen, an arbitrary time is
associated with it.  The time given to a new point is always one second
greater than the last point.  (In the case where points are created with
the 'n' command, the time value of the new point is scaled to lie halfway
between the adjacent points.)  The velocity of a point is calculated as
the distance in meters from the last point divided by the elapsed time
from the previous point (thus, the velocity of the first point is
always 0).  
.PP
To change the velocity of an Xed point, either change its location
relative to the previous point, or change its time.
To change the time of a point, put the cursor on it and type 't'.
The old value is given on the status line, 
and you are prompted for the new value.  
The time value of any X may not be changed beyond the range of adjacent
times.
.PP
The time duration of the whole path
can also be scaled via an extend mode command.  
All points are simply rescaled to update their time and velocity values.
.PP
There is a side effect of changing the time value of a point without
changing its location.  For instance, if we have three Xes that form
a right angle with times 0, 1, 2, a parabolic curve will be fitted with
the middle X at the apex.  If the time of the middle X is changed
to .5 without moving its location, we've doubled its velocity, and the
number of spline points plotted between the first two Xes is cut in half.
Likewise, we've increased by 3/4's the number of points plotted between
the second two Xes.  This alters the shape of the curve, moving the
apex of the parabola
over between the last two Xes, and slightly extending it.
.SH 
EXTEND MODE COMMANDS
.PP
Extend mode is entered by typing ':', which moves the cursor up to
the status line and prints ':'.  At that point the following commands
can be given.  Default values are given in parentheses.
.IP z
Set zoom scale (2.0).  Adjusts the scale of the displayed screen.
The zoom size is the distance in character positions between the speakers.
The spline curve is erased, the Xes are rescaled and the size of the
speaker matrix is changed.  After a zoom, the status line shows the
range and domain in meters of the boundaries of the screen.
Given the nature of CRT screens, only zoom sizes of 2, 4, 6, 8...
move the speakers to the correct character positions.  Odd number values
do scale the screen correctly, but the character positions 
of the speakers are rounded down to the nearest even number.  Values less
than 2 are also usable.  In this case the speaker numbers vanish altogether
and only the '+' is left.  The zoom size must always be greater than 0,
but can otherwise be arbitrarily small, giving a total span of many
kilometers as it approaches 0.  The area of a character position is affected
by a zoom, meaning, for large values of zoom that more precision is
available.  As the zoom gets smaller, the precision degrades.
As the zoom size goes over about 16, the speaker matrix may be bigger than
the screen.
.IP c
Set location of center of screen (0 0).
The screen can be visualized as a camera looking down at the ground from
above.  This command allows the camera to be moved over a different
portion of the terrain.  When set to (0 0), the screen has the '+' in
the middle.  Changing it moves the center of the screen to a new
position.  With this and the zoom command, any portion of a path
can be viewed with arbitrary precision.  To change the x,y values,
you must type two blank-separated numbers when prompted to do so.  
(Do not put a comma between them!)  For instance
giving values of -100 -50 puts the center of the screeen into
the middle of cartesian coordinate 3.
.IP C
Set current location of cursor to be center of screen.
This is similar to the 'c' command above, but whereas 'c' moves to an
absolute position in 2D space, 'C' moves relatively, so that the
current position of the cursor is moved to the center of the display.
.IP d
Set distance between speakers in meters (5).  The spline curve
is removed, the speaker matrix and the Xes are redrawn to scale.
.IP P
Print nodes.  Useful for looking at the exact figures for the Xes.
Information printed is: actual screen [x,y] coordinates, node number,
time, [x,y] values of the node in meters.
.IP t
Set time to scale duration of entire function.  Time values of all nodes are
scaled proportionately to the new total time.
.IP n
Set number of total spline points plotted (128).  Ordinarily, 
the spline curve is created with 128 total points interpolated between
the Xes.  For especially complicated or otherwise critical paths, this
should be raised.  1024 is a good number.  It should be noted that as an
artifact of the spline algorithm, the number of points actually
interpolated may not agree with this number!  It can be off by as many
as 5 points in each direction, depending on the path, the number of points
and how the spline function is feeling today.
.IP i
Toggle spline interpolation mode (reset).  If it is really important to
have a fixed number of spline points, giving the 'i' command will instruct
the spline function to do linear interpolation to make the spline curve
fit the number of points you specify.  However, this means that the
spline curve is no longer guaranteed to go through the points you have Xed,
(although it will still go near them) so you can't win.
.IP k
Set spline constant (0).  This does strange and wonderful
things to the way the spline
generator fits the curves between points.  Try it, it's fun.  Beware of
setting it to -2 however (and don't give in to temptation!).
.IP p
Toggle spline periodic mode (reset).  When set, and if the path to
be plotted begins and ends on the same point, this will attempt to make
the curve look closed by matching the derivatives at each end.
.IP T
Toggle spline time mode (set).  Ordinarily, the number of points between
Xes is determined by the time difference between them.  Thus, changing
the time of a point forces a refitting of the spline curve to the Xes.
Clearing this mode causes the number of points to always be made equal
between the Xes.
.SH
PATH EDITING COMMANDS
.PP
In addition to the above extend mode commands, there are other 
extend mode commands that operate on the whole path:
.IP o
Add an offset to the x,y values of each X.  Type two blank-separated
numbers which stand for the number of meters to offset the x and
y values, respectively, of each point on the path.  
.IP s
Scale the x,y values of each X.  Type two blank-separated
numbers which are coefficients to multiply against the x and
y values, respectively, of each point on the path.  For instance, 
-1 1  will produce a right-left mirror image; 1 -1 will produce a
top-bottom mirror image.  Also, .5 .5 scales the size down by 1/2.
.IP r
Rotate the path.  Supply one number specifying a rotation in degrees.
The path is converted to polar coordinates, rotated, and converted
back to cartesian and plotted.
.SH
COMMAND SUMMARY
.PP
.DS
.nf
q	quit sndpath,
?	print a help message,
u i o j l m , .	move cursor one position,
U I O J  K L M < >	slam cursor to window edge, K to center,
x [spacebar]	put/remove a node where cursor is,
y p	yank a node, place a node,
[RETURN]	draw spline curve through nodes,
e E	erase spline curve, erase whole screen,
f b	move forward/back to next/previous node,
n	interpolate new point between this and next node,
w	write binary x and y files
W       write text format path file
r a	read in node file, append node file to screen,
t	set time of a node,
:	enter extend mode,

Extend mode commands:
z		set set zoom size (2.0),
c		set x,y coordinates of center of terrain displayed (0 0)
d		set distance between speakers in meters (5),
P		write plot file
o		add offset to path (type two blank-separated numbers)
s		scale path (type two blank-separated numbers)
r		rotate path (type degrees of rotation)
i		toggle spline interpolation mode (reset),
n		set number of total spline points plotted (128 average),
t		set time in seconds to scale duration of entire function,
k		set spline constant (0),
p		toggle spline periodic mode (reset),
T		toggle spline time mode (set)
.DE
.SH
SYNTHESIZING THE PATH
.PP
For information on how to actually utilize the path so written by
.B sndpath,
refer to 
.B cmusic(1carl),
.B quad(1carl)
and
.B genraw(1carl)
manual page entries and documents.
