
#import "sndio.h"

// short to float conversion functions

void stof(short *sp_in,long begin,long end,int chan_num)
{
    if(ascii_out == YES)	astof(sp_in,begin,end,chan_num);

    else if(chanspec == NULL)	ncstof(sp_in,begin,end);

    else			cstof(sp_in,begin,end,chan_num);
}

//  short to float--pipe or file output with no channel filtering

void ncstof(short *sp_in,long begin,long end,int chan_num)
{
    register long	i;
    register short	*sp;
    register long	full;
    register float	fac = 1.0 / 32767.0;
    register int	bmax = (BUFSIZE / sizeof(float)) - 1;

    sp = sp_in;
    full = -1;

    for(i = begin; i < end; i++, sp++) {

	fbuffer[++full] = ((float) *sp) * fac;

	if(full == bmax) {
	    fwrite((void *) fbuffer,BUFSIZE,1,ofp);
	    full = -1;
	}
    }
    if(full >= 0)	fwrite((void *) fbuffer,((full + 1) * sizeof(float)),1,ofp);
}

// short to float--pipe or file output with channel filtering

void cstof(short *sp_in,long begin,long end,int chan_num)
{
    register long	i;
    register short	*sp;
    register int	nc;
    register long	full;
    register float	fac = 1.0 / 32767.0;
    register int	bmax = (BUFSIZE / sizeof(float)) - 1;
    register int	y = -1;

    sp = sp_in;
    nc = chan_num;

    full = -1;

    for(i = begin; i < end; i++, sp++) {

	if(!chans[++y >= nc ? (y = 0) : y])	continue;

	fbuffer[++full] = ((float) *sp) * fac;

	if(full == bmax) {
	    fwrite((void *) fbuffer,BUFSIZE,1,ofp);
	    full = -1;
	}
    }
    if(full >= 0)	fwrite((void *) fbuffer,((full + 1) * sizeof(float)),1,ofp);
}

// short to float--ascii output

void astof(short *sp_in,long begin,long end,int chan_num)
{
    register long	i;
    register short	*sp;
    register int	nc;
    register float	fac = 1.0 / 32767.0;
    register int	y = -1;
    int			floor;

    sp = sp_in;
    nc = chan_num;

    if(out_index == 's') {

	for(i = begin; i < end; i++, sp++) {
    
	    if(chans[++y >= nc ? (y = 0) : y]) {
    
		fprintf(ofp,"%d\t%f\n",(int) i / nc,((float) *sp) * fac);
	    }
	}
    }
    else if(out_index == 't') {

	for(i = begin; i < end; i++, sp++) {
    
	    if(chans[++y >= nc ? (y = 0) : y]) {

		floor = (int) i / nc;

		fprintf(ofp,"%f\t%f\n",((float) floor) / samrate,((float) *sp) * fac);
	    }
	}
    }
    else {

	for(i = begin; i < end; i++, sp++) {
    
	    if(chans[++y >= nc ? (y = 0) : y])	fprintf(ofp,"%f\n",((float) *sp) * fac);
	}
    }
}

// short to float--"headless file" binary buffering before call to stof()
//		    we know dataSize but have no snd_pointer to data

void stofhf(FILE *bbfo,long begin,long end,int chan_total)
{
    short	*nhp;
    int		whole_frms;		// number of sample frames to buffer
    int		pass_end;

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	fread((void *) sinbuf,(sizeof(short) * (pass_end - begin)),1,bbfo);

	nhp = sinbuf;			// nhp subs for snd_pointer

	stof(nhp,begin,pass_end,chan_total);

	begin = pass_end;

	pass_end = begin + whole_frms;

	if(pass_end > end)	pass_end = end;
    }
}

// short to float--piped binary input buffering before call to stof()
//		    we don't know dataSize or have snd_pointer to data

void stofp(FILE *bbfp,long begin,long end,int chan_total)
{
    short		*nhp;
    int			whole_frms;	// number of sample frames to buffer
    int			pass_end;
    unsigned long	num_in;		// actual number of smaples in sobuf[]

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;			// want to process by whole frames

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	num_in = fread((void *) sinbuf,sizeof(short),pass_end - begin,bbfp);

	nhp = sinbuf;			// nhp subs for snd_pointer
    
	if(num_in < (pass_end - begin)) {	// ran out of data

	    pass_end = begin + num_in;

	    stof(nhp,begin,pass_end,chan_total);

	    begin = end;		// we are done
	}
	else {
    
	    stof(nhp,begin,pass_end,chan_total);
    
	    begin = pass_end;
    
	    pass_end = begin + whole_frms;
    
	    if(pass_end > end)	pass_end = end;
	}
    }
}

// short to float--ascii input buffering before call to stof()
//		    we don't know dataSize or have snd_pointer to data

void stofa(FILE *bbfp,long begin,long end,int chan_total)
{
    short		*nhp;
    int			i_tmp;
    int			whole_frms;	// number of sample frames to buffer
    int			pass_end;
    unsigned long	num_in;		// actual number of smaples in sobuf[]

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;			// want to process by whole frames

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	for(num_in = 0; num_in < whole_frms; num_in++) {

	    if(in_index == 's') {
	
		if(fscanf(ifp,"%*d %d",&i_tmp) == EOF)	break;		
	    }
	    else if(in_index == 't') {
	
		if(fscanf(ifp,"%*f %d",&i_tmp) == EOF)	break;		
	    }
	    else {
		if(fscanf(ifp,"%d",&i_tmp) == EOF)		break;		
	    }
	    sinbuf[num_in] = (short) i_tmp;
	}
	nhp = sinbuf;			// nhp subs for snd_pointer
    
	if(num_in < (pass_end - begin)) {	// ran out of data

	    pass_end = begin + num_in;

	    stof(nhp,begin,pass_end,chan_total);

	    begin = end;		// we are done
	}
	else {
    
	    stof(nhp,begin,pass_end,chan_total);
    
	    begin = pass_end;
    
	    pass_end = begin + whole_frms;
    
	    if(pass_end > end)	pass_end = end;
	}
    }
}
