
#import "sndio.h"

// float to float format output functions

void ftof(float *sp_in,long begin,long end,int chan_num)
{
    if(ascii_out == YES)	aftof(sp_in,begin,end,chan_num);

    else if(chanspec == NULL)	ncftof(sp_in,begin,end);

    else			cftof(sp_in,begin,end,chan_num);
}

// float to float--pipe or file output with no channel filtering

void ncftof(float *sp_in,long begin,long end,int chan_num)
{
    register long	i;
    register float	*sp;
    register long	full;
    register int	bmax = (BUFSIZE / sizeof(float)) - 1;

    sp = sp_in;

    full = -1;

    for(i = begin; i < end; i++, sp++) {

	fbuffer[++full] = *sp;

	if(full == bmax) {
	    fwrite((void *) fbuffer,BUFSIZE,1,ofp);
	    full = -1;
	}
    }
    if(full >= 0)	fwrite((void *) fbuffer,((full + 1) * sizeof(float)),1,ofp);
}

// float to float--pipe or file output with channel filtering

void cftof(float *sp_in,long begin,long end,int chan_num)
{
    register long	i;
    register float	*sp;
    register int	nc;
    register long	full;
    register int	bmax = (BUFSIZE / sizeof(float)) - 1;
    register int	y = -1;

    sp = sp_in;
    nc = chan_num;

    full = -1;

    for(i = begin; i < end; i++, sp++) {

	if(!chans[++y >= nc ? (y = 0) : y])	continue;

	fbuffer[++full] = *sp;

	if(full == bmax) {
	    fwrite((void *) fbuffer,BUFSIZE,1,ofp);
	    full = -1;
	}
    }
    if(full >= 0)	fwrite((void *) fbuffer,((full + 1) * sizeof(float)),1,ofp);
}

// float to float--ascii output

void aftof(float *sp_in,long begin,long end,int chan_num)
{
    register long	i;
    register float	*sp;
    register int	nc;
    register int	y = -1;
    int			floor;

    sp = sp_in;
    nc = chan_num;

    if(out_index == 's') {

	for(i = begin; i < end; i++, sp++) {
    
	    if(chans[++y >= nc ? (y = 0) : y])	fprintf(ofp,"%d\t%f\n",(int) i / nc,*sp);
	}
    }
    else if(out_index == 't') {

	for(i = begin; i < end; i++, sp++) {
    
	    if(chans[++y >= nc ? (y = 0) : y]) {

		floor = (int) i / nc;

		fprintf(ofp,"%f\t%f\n",((float) floor) / samrate,*sp);
	    }
	}
    }
    else {

	for(i = begin; i < end; i++, sp++) {
    
	    if(chans[++y >= nc ? (y = 0) : y])	fprintf(ofp,"%f\n",*sp);
	}
    }
}

// float to float--"headless file" binary buffering before call to ftof()
//		    we know dataSize but have no snd_pointer to data

void ftofhf(FILE *bbfp,long begin,long end,int chan_total)

{
    float	*nhp;
    int		whole_frms;		// number of sample frames to buffer
    int		pass_end;

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	fread((void *) finbuf,(sizeof(float) * (pass_end - begin)),1,bbfp);

	nhp = finbuf;			// nhp subs for snd_pointer

	ftof(nhp,begin,pass_end,chan_total);

	begin = pass_end;

	pass_end = begin + whole_frms;

	if(pass_end > end)	pass_end = end;
    }
}

// float to float--piped binary input buffering before call to ftof()
//		    we don't know dataSize or have snd_pointer to data

void ftofp(FILE * bbfp,long begin,long end,int chan_total)
{
    float		*nhp;
    int			whole_frms;	// number of sample frames to buffer
    int			pass_end;
    unsigned long	num_in;		// actual number of smaples in sobuf[]

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;			// want to process by whole frames

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	num_in = fread((void *) finbuf,sizeof(float),pass_end - begin,bbfp);

	nhp = finbuf;			// nhp subs for snd_pointer
    
	if(num_in < (pass_end - begin)) {	// ran out of data

	    pass_end = begin + num_in;

	    ftof(nhp,begin,pass_end,chan_total);

	    begin = end;		// we are done
	}
	else {
    
	    ftof(nhp,begin,pass_end,chan_total);
    
	    begin = pass_end;
    
	    pass_end = begin + whole_frms;
    
	    if(pass_end > end)	pass_end = end;
	}
    }
}

// float to float--ascii input buffering before call to ftof()
//		    we don't know dataSize or have snd_pointer to data

void ftofa(FILE *bbfp,long begin,long end,int chan_total)
{
    float		*nhp;
    float		f_tmp;
    int			whole_frms;	// number of sample frames to buffer
    int			pass_end;
    unsigned long	num_in;		// actual number of smaples in sobuf[]

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;			// want to process by whole frames

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	for(num_in = 0; num_in < whole_frms; num_in++) {

	    if(in_index == 's') {
	
		if(fscanf(ifp,"%*d %f",&f_tmp) == EOF)	break;		
	    }
	    else if(in_index == 't') {
	
		if(fscanf(ifp,"%*f %f",&f_tmp) == EOF)	break;		
	    }
	    else {
		if(fscanf(ifp,"%f",&f_tmp) == EOF)	break;		
	    }
	    finbuf[num_in] = f_tmp;
	}
	nhp = finbuf;			// nhp subs for snd_pointer
    
	if(num_in < (pass_end - begin)) {	// ran out of data

	    pass_end = begin + num_in;

	    ftof(nhp,begin,pass_end,chan_total);

	    begin = end;		// we are done
	}
	else {
    
	    ftof(nhp,begin,pass_end,chan_total);
    
	    begin = pass_end;
    
	    pass_end = begin + whole_frms;
    
	    if(pass_end > end)	pass_end = end;
	}
    }
}
