.RT
.DS C
Installation of the CARL Software Distribution
.DE
.LP
We have tried to make the installation of this software
as straightforward as possible.
To do this we have used the \fIm4\fP macro processor in
conjunction with \fImake\fP.
.LP
The makefiles typically have the destination directories and
pathnames to the libraries embedded in them, changing all of
the makefiles would normally be a chore.  What we have done
is to have a ``master makefile'' that has m4 macros in it
for defining the directories, libraries, etc.  and have the
definitions for these macros in one file.
All of the makefiles include a ``configuration'' 
file which defines the macro names
used in the master makefiles.
Each program has its own master makefile, and a ``super makefile''
for all of the sources runs m4 on each of the master makefiles
producing the makefile that \fImake\fP uses.
What follows are the steps that must be followed to install it.
.LP
The configuration file is named
\f(TYinclude/carl/config.m4\fP.   It has all of the definitions for
the destination directory, libraries, and other site-specific
information.  It should be edited to reflect your installation.   Note
that because this file is used by \fIm4\fP that any macros that
\fIm4\fP recognizes must be quoted; in particular you will see
lines of the form
.DS I
\f(HRinclude(/usr/``include''/carl)dnl\fP
.DE
the double set of quotes around the word \f(HRinclude\fP \fRprevent
\fIm4\fP \fRfrom interpreting it as an \fIm4\fP command.   Normally only one
set of quotes would be needed but because the macros in this
file are seen twice two sets of quotes must be used.
.LP
Note, if you change the macro m4INCLUDE, you must do a further manual
step described below in \fBRetargeting /usr/include/carl\fP.  Read that
first before continuing here.
.LP
The manual pages need a little attention.  
Installation of manual pages is done by the Makefile in \f(TYman\fP.
Before running that makefile, however edit the file
\f(TYman/man1/srcvt\fP.  This 
is a shell script that will fix the documentation to reflect the sampling
rates of your system.   Modify it to reflect local values.
This script is run on the manual pages after they are
copied to their target directory, so the manual page sources are not
changed.  
.LP
The file include/carl/defaults.h contains default values for many of
the programs, including the default sampling rate for the DSC converters.
Edit and modify this program as required, but read the next paragraph first.
.LP
If your version of UNIX did not come with a file named
\f(TY/usr/include/whoami.h\fP,
(Berkeley seems to have taken this file out of their standard release
for some obscure reason), you can use this one:
\f(TYinclude/whoami.h\fP.  Put it in \f(TY/usr/include\fP.
It is supposed to contain a
macro definition that is the name of your system.  
This file is included by any CARL programs that need to know the 
particular hardware environment of your site.  
For instance, the file include/carl/defaults.h has one set of
values used at CARL, and another set used at IRCAM.
By saying
.br
# ifdef CARL
.br
 ...
.br
# endif CARL
.br
such site-specific code has been isolated.
The easiest way to install CARL software is to pretend that you are at CARL,
and use the whoami.h and defaults.h files as they are.  If that is not
possible (e.g., if your converters run at a different rate), 
the next easiest thing to do is to still pretend you are at CARL,
and just change the values in defaults.h that you must.
The most general approach is to copy the code that depends on the
macro CARL, change it to depend on your own site's name, and change
the site name definition in whoami.h.
.LP
So you have done the following steps:
.IP \(bu
modified config.m4 as needed,
.IP \(bu
the manual pages have been attended to,
.IP \(bu
whoami.h is in /usr/include,
.IP \(bu
and defaults.h looks ok.
.LP
Proceed to install the CARL software by issuing the command
.DS
% make -f Makefirst
.DE
or
.DS
% make -f Makefirst >& errs &
.DE
The latter form saves a record of the compilation process
in the file \f(TYerrs\fP.  You can periodically check on its progress
by saying
.DS
% tail errs
.DE
or
.DS
% tail -f errs
.DE
The second form allows you to watch the continuing progress.
.LP
If, after having run Makefirst, compilation does not go to completion,
first do whatever you need to do to correct the situation, then from
then on it suffices to just say
.DS
make
.DE
.LP
The first step of Makefirst is to clean out all executables, .o files
and everything needed to force recompilation of everything.
It then runs m4 on the super Makefile.m4 file in the root directory
of the CARL software,
which causes the new Makefile to have all the right values you put
in config.m4.  Makefirst then executes this new super Makefile.
The super Makefile first creates the target directories for executables,
libraries, manual pages, include files etc., then it copies the config.m4
file, and all the other include files to their destination.  Then
it starts recursively executing the makefiles in subdirectories that
compile the sources; first libraries, then application programs.
.LP
When it is done, and you are satisfied that everything compiled
correctly, say
.DS
% make install
.DE
in the CARL software root directory.  This will go through all
directories installing the compiled code.
.SH
Retargeting /usr/include/carl
.LP
By default, CARL software uses \f(TY/usr/include\fP as the home
for a subdirectory named \f(TYcarl\fP which contains all .h files.
If you specify a different target location for CARL include files in 
\f(TYinclude/carl/config.m4\fP, a script \f(TYfixmakefiles\fP will
be executed in the super Makefile to change all Makefile.m4 files to 
refer to the place you have specified.
NOTE: it is highly recommended to usr \f(TY/usr/include/carl\fP,
as otherwise another step must be done manually to change many of the
include statements in the program sources.
.LP
At this moment, if you want to put CARL include files anywhere besides
\f(TY/usr/include/carl\fP
you will have to modify all .c and .h files so that any reference
to \f(TY<carl/...>\fP is changed to \f(TY<wherever/...>\fP.  This
can be done with a combination of find and sed, such as the following,
which changes all instances of 
.br
\f(TY<carl/\fP
.br
to
.br
\f(TY<local/carl/\fP.
.br
find . \\( -name '*.h' -o -name '*.c' \\) -exec 
sed "s:<carl/:<local/carl/:" {} > /tmp/xxx \\; -exec 
mv /tmp/xxx {} \\;
.br
(The foregoing was a single command.)
This would convert define statements in .c and .h files of the form
.br
# include <carl/carl.h>
.br
to
.br
# include <local/carl/carl.h>.
.br
.\" if you are looking at this with a text editor, you should
.\" remember that there's one level of `\' in the above that you
.\" would leave out to execute the find command.
You might want to try your luck with the shell script 
\f(TYfixinclude\fP in this directory.
.SH
CARL Directory Usage
.LP
By default,
CARL Software touches only one standard UNIX directory: \f(TY/usr/include\fP.
It expects to have a file \f(TYwhoami.h\fP and
a directory \f(TY/usr/include/carl\fP containing the configuration
file \f(TYconfig.m4\fP and the rest of the .h files.
.LP
All other files are ordinarily put in a common directory tree 
named the same as the host machine on which it is installed.  For instance,
at CARL, the directory tree is named /carl, which is one of our large
partitions where we also put all other local files, such as user accounts.
We avoid the use of \f(TY/usr/local\fP, as this has come to be considered
a part of the regular UNIX directory structure, and changes character
from one UNIX port or version to another.
.LP
Under the host directory (\f(TY/carl\fP, at CARL), 
we have several subdirectories:
\f(TY/host/lib\fP, \f(TY/host/bin\fP and \f(TY/host/man\fP
(\f(TY/carl/{lib,bin,man}\fP at CARL).
The CARL software itself, according to this logic, belongs in
subdirectory \f(TY/host/src/import/carl\fP.
.LP
A worthwhile step is to make 
\f(TY/usr/local/lib\fP a symbolic link to \f(TY/host/lib\fP so that
the compiler load flag works; e.g., you can say
.DS
cc .\|.\|. -lcarl
.DE
.LP
To access the manual pages, set your MANPATH shell environment
variable to
.DS
set MANPATH  /usr/man:/host/man
.DE
.NH
Code Supplied ``As Is''
.LP
The subdirectory ./src/AsIs contains 
software supplied "as is", i.e., they
may or may not be complete, work, or produce useful results.  On the
other hand, this does not distinguish them from most software, and
these programs are free!
.LP
The subdirectory ./src/AsIs/SysV contains versions of cmusic, 
various unit generators,
and some other programs, that have been modified to work under UNIX System V.
