#include "../H/sfheader.h"
#include "../H/ugens.h"
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <errno.h>

#ifdef sgi
#include <audiofile.h>
#if LIBAUDIOFILE_VERSION == 2
typedef int AF_INT;
#else
typedef long AF_INT;
#define AF_SAMPFMT_FLOAT 403
#endif
#endif

static SFCODE	ampcode = {
	SF_MAXAMP,
	sizeof(SFMAXAMP) + sizeof(SFCODE)
}; 

int
getheadersize(header)
SFHEADER *header;
{
#if defined(NeXT) || defined(NEXT)
	if(nsfmagic(header) == SND_MAGIC) {
		/* native NeXT files may have arbitrary offset size */
		int offset = (header)->sfinfo.NeXTheader.dataLocation;
		/* make sure we dont return bad or negative value! */
		return (offset >= SIZEOF_NeXT_HEADER) ? offset : SIZEOF_NeXT_HEADER;
	}
	else if(nsfmagic(header) == SF_MAGIC)
		return(SIZEOF_BSD_HEADER);
#endif
#ifdef sgi
	if(header->sfinfo.handle) {
	/* get fdesc, save location, seek to 1st samp, get file loc, reseek */
	int fd = AFgetfd(header->sfinfo.handle);
#if LIBAUDIOFILE_VERSION == 2
	int saved_frame = AFtellframe(header->sfinfo.handle,
	                              AF_DEFAULT_TRACK);
#else
	int saved_frame = 0;
#endif
	int size = 0;
	AFseekframe(header->sfinfo.handle, AF_DEFAULT_TRACK, 0);
	size = tell(fd);
	AFseekframe(header->sfinfo.handle, AF_DEFAULT_TRACK, saved_frame);
	return size;
	}
	else return 0;
#endif /* sgi */
#if !defined(NeXT) && !defined(NEXT) && !defined(sgi)
	return(SIZEOF_BSD_HEADER); /* falls through to this */
#endif
}

#ifdef sgi
int readSGIHeader(int sf, SFHEADER *header)
{
	AF_INT sampfmt, sampwidth;
	int i;
	SFMAXAMP sfmnew;
	if(lseek(sf, 0, SEEK_SET) < 0) {
		fprintf(stderr, "failed to seek to beginning of file\n");
		return 1;
	}
	if((header->sfinfo.handle = AFopenfd(sf, "r", NULL)) == NULL)
		return 1;
		
	if(AFgetcompression(header->sfinfo.handle, AF_DEFAULT_TRACK)
	        != AF_COMPRESSION_NONE) {
	    fprintf(stderr, "Cmix cannot handle compressed files.\n");
	    return 1;
	}

	/* load all values from AFfilehandle into hybrid header */

	sfmagic(header) = SGI_MAGIC;
#ifdef NEXT
	nsfmagic(header) = SGI_MAGIC;
#endif
	(header)->sfinfo.sf_srate = AFgetrate(header->sfinfo.handle,
                                	      AF_DEFAULT_TRACK);
	(header)->sfinfo.sf_chans = AFgetchannels(header->sfinfo.handle,
                                	          AF_DEFAULT_TRACK);
	/* this must be zeroed to allow putsfcode() to work */
	*((short *) &(header)->sfinfo.sf_codes) = 0;
	AFgetsampfmt(header->sfinfo.handle, AF_DEFAULT_TRACK,
	             &sampfmt, &sampwidth);
	switch(sampfmt) {
	case AF_SAMPFMT_FLOAT:
	    (header)->sfinfo.sf_packmode = SF_FLOAT;
	    break;
	case AF_SAMPFMT_TWOSCOMP:
	    if(sampwidth > 8 && sampwidth <= 16)
        	(header)->sfinfo.sf_packmode = SF_SHORT;
	    else goto nogood;
	    break;
	default:
nogood:
	    fprintf(stderr, "Cmix can only read float and short files.\n");
	    return 1;
	}
	for(i=0; i<2 /*(header)->sfinfo.sf_chans*/; i++) {
		sfmaxamp(&sfmnew,i)=0;
		sfmaxamploc(&sfmnew,i)=0;
	}
	sfmaxamptime(&sfmnew) = 0;
	putsfcode(header,&sfmnew,&ampcode);
	return 0;
}

/* the assumption is that an AIFF or WAVE file already exists with a 
   complete header on disk, and all we do is open it in order to write
   new data into it, and eventually update its size and framecount.
   Because the SGI AF library does not allow read/write, and truncates
   when opening write-only, we punt and we don't do anything here.
   readSGIHeader() will have already created a handle in the SFHEADER.
*/

int writeSGIHeader(int sf, SFHEADER *header)
{
	return 0;
}

/* since the handle was created for read-only, we have to do the update
   by hand.  Here we update the file size, frame count, and SSND data size
*/

putSGILength(char *sfname, int sf, SFHEADER *header)
{
	struct stat st;
	int value, frames, match = 0;
	int headersize;
	char buf[4];

	if(stat(sfname,&st))  {
		fprintf(stderr, "putSGILength:  Couldn't stat file\n");
		return(-1);
	}
	value = st.st_size;
	lseek(sf, 0, SEEK_SET);
	if(read(sf, buf, 4) != 4) {
	    perror("read");
	    return (-1);
	}
	if(strncmp(buf, "FORM", 4))
	    return -1;
	headersize = lseek(sf, 0, SEEK_CUR);

	if(write(sf, &value, 4) != 4) {  /* file size */
	    perror("write");
	    return (-1);
	}
	/* find COMM chunk */
	while(strncmp(buf, "COMM", 4) != 0) {
	    if(read(sf, buf, 4) != 4) {
		perror("read");
		return (-1);
	    }
	}
	/* seek to sample count location */
	lseek(sf, 6, SEEK_CUR);
	value -= headersize;
	frames = value/(sfchans(header) * sfclass(header));
	if(write(sf, &frames, 4) != 4) { /* sample count */
	    perror("write");
	    return (-1);
	}
	/* find SSND chunk */
	while(match != 2) {
	    if(read(sf, buf, 2) != 2) {
		perror("read");
		return (-1);
	    }
	    if(match == 0 && strncmp(buf, "SS", 2) == 0) match++;
	    else if(match == 1 && strncmp(buf, "ND", 2) == 0) match++;
	}
	if(write(sf, &value, 4) != 4) { /* SSND SIZE */
	    perror("write");
	    return (-1);
	}
	/* seek to sample count location */
	lseek(sf, headersize, SEEK_SET);
	return (0);
}

#endif

#if defined(NeXT) || defined(NEXT)

putlength(sfname,sf,header)
SFHEADER *header;
char *sfname;
{
	struct stat st;
	int bytes;
	int headersize = 0;
	if(stat(sfname,&st))  {
		fprintf(stderr, "putlength:  Couldn't stat file\n");
		return(-1);
	}
#ifdef sgi
	if(nsfmagic(header) == SGI_MAGIC)
		return putSGILength(sfname,sf,header);
#endif
	/* dont do anything if file is Ircam style */
	if((header)->sfinfo.NeXTheader.magic != SND_MAGIC)
		return 1;
	if(lseek(sf,0,0) < 0) {
		fprintf(stderr, "putlength: Bad lseek trying to write NeXT header\n");
		return(-1);
	}
	if((header)->sfinfo.sf_magic == 0) headersize = SIZEOF_NeXT_HEADER;
	else headersize = SIZEOF_BSD_HEADER;
	(header)->sfinfo.NeXTheader.dataSize = (int)st.st_size - headersize;
	/* only re-write out NeXT portion of file */
	if((bytes = write(sf,header,SIZEOF_NeXT_HEADER)) != SIZEOF_NeXT_HEADER)
	{
		fprintf(stderr, "putlength:  Bad header write on file\n");
		return(-1);
	}
	/* then seek to wherever the end really is */
	if(lseek(sf, headersize, SEEK_SET) < 0) {
		fprintf(stderr, "putlength:  Bad seek on file\n");
		return(-1);
	}
	return(1);
}

int
readHeader(sf,header)
SFHEADER *header;
int sf;
{
        int i, status;
	static int remainder =  sizeof(SFHEADER) - SIZEOF_NeXT_HEADER;
	SFMAXAMP sfmnew;
        char *pointer;
        /* read in 28 bytes first, to see if NeXT header is present */
        if((i=read(sf,(char *) header, 28)) != 28)
                return 1;
        /* if file has IRCAM-style header */
        if((header)->sfinfo.NeXTheader.magic == SF_MAGIC)
                return(readIrcamHeader(sf, header));

#if defined(NeXT) && defined(i386) 
	/* for this we must try reading whole 1024 first */
	read(sf, (char *) &header->sfinfo.sf_magic, remainder);
	if((status = check_byte_order(header, "cmix", "soundfile")) < 0) {
		fprintf(stderr, "File unrecognizable in either byte order\n");
		return status;
	}
#else
        /* if magic number is neither IRCAM nor local, we cant read it */
	/* in case it is byte-swapped, give a message saying so */
        if((header)->sfinfo.NeXTheader.magic == 1688404224) {
		fprintf(stderr, "This file must be byte-swapped before using!\n");
		return 1;
	}
#endif
        if(nsfmagic(header) != SND_MAGIC)
#ifdef sgi
		return readSGIHeader(sf, header);
#else
                return 1;
#endif

        /* check to see if this is hybrid header */

	if(read(sf, (char *) &header->sfinfo.sf_magic, remainder) == remainder
		&& (header)->sfinfo.sf_magic == SF_MAGIC) {
#ifdef sgi
	        header->sfinfo.handle = NULL;
#endif
		/* now seek to beginning of sound since the above reads
		   may have overshot the beginning */

		if(lseek(sf, SIZEOF_BSD_HEADER, SEEK_SET) < 0) {
			fprintf(stderr, "can't seek to beginning of sound\n");
			perror("lseek");
			return 1;
		}
		return 0;
	}

        /* else, if file being read is native NeXT soundfile... */

	/* zero out new header after NeXT portion */
	pointer = (char *)header;
	for(i=29; i<SIZEOF_BSD_HEADER; i++) *(pointer+i) = 0;
        /* set file pointer to beginning of sound data */
        if(lseek(sf, header->sfinfo.NeXTheader.dataLocation, L_SET) < 0) {
                fprintf(stderr, "Unable to reset file pointer.\n");
                return 1;
        }
        /* load all values from native header into hybrid header */
        (header)->sfinfo.sf_magic = 0; /* so we know it is native NeXT file */
        (header)->sfinfo.sf_srate = (header)->sfinfo.NeXTheader.samplingRate;
        (header)->sfinfo.sf_chans = (header)->sfinfo.NeXTheader.channelCount;
        switch(header->sfinfo.NeXTheader.dataFormat) {
        case SND_FORMAT_FLOAT:
                (header)->sfinfo.sf_packmode = SF_FLOAT;
                break;
        case SND_FORMAT_LINEAR_16:
                (header)->sfinfo.sf_packmode = SF_SHORT;
                break;
        default:
                fprintf(stderr, "Cmix can only read float and short files.\n");
                return 1;
        }
	for(i=0; i<2 /*(header)->sfinfo.sf_chans*/; i++) {
			sfmaxamp(&sfmnew,i)=0;
			sfmaxamploc(&sfmnew,i)=0;
		}
		sfmaxamptime(&sfmnew) = 0;
		putsfcode(header,&sfmnew,&ampcode);
        return 0;
}

int
readIrcamHeader(sf, hd)
	int sf;
        SFHEADER *hd;
{
        char *ptr = (char *) hd;
	int i;

	SFMAXAMP sfmnew;
	if(lseek(sf, 0, SEEK_SET) < 0) {
		fprintf(stderr, "can't seek to beginning of header\n");
		perror("lseek");
		return 1;
	}
        /* read header again, this time into the location
           in the header it needs to be in a hybrid header.  We loose 28 chars
           from the end of the comment, but who uses that much comment?  */

	if(read(sf, (char *) &hd->sfinfo.sf_magic,
		     sizeof(SFHEADER)) < sizeof(SFHEADER)) {
		fprintf(stderr, "cannot read truncated IRCAM header\n");
		return 1;
	}

	/* zero out NeXT portion of header */
        bzero(ptr, SIZEOF_NeXT_HEADER);
#ifdef sgi
	/* this is needed for closesf() */
        hd->sfinfo.handle = NULL;
#endif
	/* if no amp code in header, put one */

	if(getsfcode(hd, SF_MAXAMP) == NULL) {
		for(i=0; i<2; i++) {
			sfmaxamp(&sfmnew,i)=0;
			sfmaxamploc(&sfmnew,i)=0;
		}
		sfmaxamptime(&sfmnew) = 0;
		putsfcode(hd,&sfmnew,&ampcode);
	}
	/* set the magic number at the beginning to be the IRCAM magic number,
	   to signal that this should be written back out as such.	*/

        hd->sfinfo.NeXTheader.magic = SF_MAGIC;

	/* now seek to beginning of sound since the above reads may have 
	   overshot the beginning
	*/

	if(lseek(sf, SIZEOF_BSD_HEADER, SEEK_SET) < 0) {
		fprintf(stderr, "can't seek to beginning of sound\n");
		perror("lseek");
		return 1;
	}
        return 0;
}

writeHeader(sf,header)	/* writes out whatever type of header was read in */
SFHEADER  *header;
int sf;
{
	int headersize, dataloc, bytes, remainder;
	static char blank[SIZEOF_NeXT_HEADER + 4];
#if defined(NeXT) && defined(i386)
        SFHEADER headerCopy;
#endif
	switch((header)->sfinfo.NeXTheader.magic) {
	case SND_MAGIC:		/* native or hybrid NeXT soundfile */
		if((header)->sfinfo.sf_packmode == SF_FLOAT)
			(header)->sfinfo.NeXTheader.dataFormat =
				SND_FORMAT_FLOAT;
		else (header)->sfinfo.NeXTheader.dataFormat =
			SND_FORMAT_LINEAR_16;
		(header)->sfinfo.NeXTheader.samplingRate =
			(header)->sfinfo.sf_srate;
		(header)->sfinfo.NeXTheader.channelCount =
			(header)->sfinfo.sf_chans;
		if((header)->sfinfo.sf_magic == 0) {	/* Native */
			dataloc = SIZEOF_NeXT_HEADER;
			headersize = SIZEOF_NeXT_HEADER; 
		}
		else {					/* Hybrid */
			dataloc = SIZEOF_BSD_HEADER;
			headersize = SIZEOF_BSD_HEADER; 
		}
		(header)->sfinfo.NeXTheader.dataLocation = dataloc;
#if defined(NeXT) && defined(i386)
        	bcopy(header,&headerCopy,SIZEOF_BSD_HEADER);
		reset_byte_order(sf,&headerCopy);
		header = &headerCopy;
#endif /* NeXT && i386 */
		/* write NeXT portion first */
		if((bytes=write(sf,header,SIZEOF_NeXT_HEADER))
				!= SIZEOF_NeXT_HEADER)
			return 1;
		/* then write rest of header if writing hybrid */
		if(bytes < headersize) {
			remainder = headersize - bytes;
			if((bytes=write(sf,(char *) &header->sfinfo.sf_magic,
					remainder)) != remainder)
				return 1;
		}
		return 0;
		break; /*NOTREACHED*/
	case SF_MAGIC:		/* IRCAM style soundfile */
		/* try to write out 1 Kbyte starting right after NeXT header */
#ifdef sgi
		headersize = sizeof(SFHEADER) - SIZEOF_NeXT_HEADER - 4;
#else
		headersize = sizeof(SFHEADER) - SIZEOF_NeXT_HEADER;
#endif
		if((bytes=write(sf, (char *) &header->sfinfo.sf_magic,
				headersize)) != headersize)
			return 1;
		/* this fills in the last 28 bytes */
		remainder = sizeof(SFHEADER) - bytes;
		if((bytes=write(sf, blank, remainder)) != remainder)
			return 1;
		else return 0;
		break;
#ifdef sgi
	/* this is for future use -- right now files are always written as either
	   NeXT or as IRCAM
	*/
	case SGI_MAGIC:
		return writeSGIHeader(sf, header);
		break; /*NOTREACHED*/
#endif
	default:
		fprintf(stderr, "Unknown magic number: %d\n",
			(header)->sfinfo.NeXTheader.magic);
		return 1;
		break;
	}
}
#else

putlength(sfname,sf,header)
SFHEADER *header;
char *sfname;
{
	return 0;	/* do nothing */
}

#endif /* NeXT */
