#include <stdio.h>
#include <linux/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>
#include <math.h>

#define BUFSIZE 8192

main (int argc, char* argv[]) 
{
  int len,format,stereo,speed,cycle,frag_size,samps,srate,chans;
  int audio_fd;
  int arg,i;
  char c;
  short sampbuff[BUFSIZE];
  FILE *ifp;
  
  if (argc != 4) {
    printf("Usage:  %s  soundfile rate chans\n",argv[0]);
    exit(1);
  }

  /* Open the input file */
  ifp = fopen(argv[1],"r");
  if (ifp == NULL)
    printf("Cannot open file:  %s\n",argv[1]);
  
  speed = atoi(argv[2]);
  printf("Rate:  %d\n",speed);
  chans = atoi(argv[3]);
  printf("Chans:  %d\n",chans);

  /* Open the audio port */
  if ((audio_fd = (int)open("/dev/dsp", O_WRONLY, 0)) == -1) { 
    perror("/dev/dsp");
    exit(1);
  }

  /* Set the fragment size */
  arg = 0x777f000d;
  if (ioctl(audio_fd, SNDCTL_DSP_SETFRAGMENT, &arg)==-1) {
    perror("FRAGMENT SIZE");
    exit(1);
  }

  /* Put the audio port in "sync" mode */
  ioctl(audio_fd, SNDCTL_DSP_SYNC, 0);

  /* Set the format for output samples */
  format = AFMT_S16_LE;
  if (ioctl(audio_fd, SNDCTL_DSP_SETFMT, &format)==-1) { 
    perror("SNDCTL_DSP_SETFMT");
    exit(1);
  }

  /* Set stereo / mono (1/0) */
  stereo = chans-1;
  if (ioctl(audio_fd, SNDCTL_DSP_STEREO, &stereo)==-1) { 
    perror("SNDCTL_DSP_STEREO");
    exit(1);
  }

  /* Set sample rate */
  if (ioctl(audio_fd, SNDCTL_DSP_SPEED, &speed)==-1)
    { /* Fatal error */
      perror("SNDCTL_DSP_SPEED");
      exit(1);
    }

  /* Get the size of the audio buffer */
  /* Note that the driver computes this optimally */
  if (ioctl(audio_fd, SNDCTL_DSP_GETBLKSIZE, &frag_size) == -1) {
    exit(1);
  }
  printf("Audio buffer:  %d\n",frag_size);

  /* Skip the soundfile header */
  fread(sampbuff,1,1024,ifp);

  printf("%s\n",sampbuff);

  for (i=0;i<BUFSIZE;i++)
    sampbuff[i] = 0;

  while(samps = fread(sampbuff, 2, BUFSIZE, ifp) > 0) {
    if ((len = write(audio_fd, sampbuff, 2*BUFSIZE)) == -1) {
      perror("AUDIO WRITE");
      exit(1);
    }
  }
  
  /* Close the audio port */
  close(audio_fd);
}




