#include <stdio.h>
#include <linux/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>
#include <math.h>
#include "../H/sfheader.h"

#define BUFSIZE 8192

main (int argc, char* argv[]) 
{
  int len,format,stereo,speed,cycle,frag_size,samps,srate,chans;
  int audio_fd;
  int arg,i,c1,c2;
  int ifp, ifp2;
  SFHEADER sfh;
  short sampbuff[BUFSIZE];
  
  /* Check % of args */
  if (argc < 2) {
    fprintf(stderr, "Usage:  play <sfname>\n");
    exit(1);
  }

  /* Open the input file */
  ifp = open(argv[1], O_RDONLY);
  if (!ifp) {
    fprintf(stderr,"Cannot open file:  %s\n",argv[1]);
    exit (1);
  }

  read(ifp, &sfh,sizeof(SFHEADER));

  speed = sfsrate(&sfh);
  chans = sfchans(&sfh);

  printf("======== RTCmix (play) LINUX ========\n");
  printf("File:  %s\n",argv[1]);
  printf("rate: %d\n", speed);
  printf("chans: %d\n", chans);

  /* Open the audio port */
  if ((audio_fd = (int)open("/dev/dsp", O_WRONLY, 0)) == -1) { 
    perror("/dev/dsp");
    exit(1);
  }

  /* Set the fragment size */
  arg = 0x777f000f;
  if (ioctl(audio_fd, SNDCTL_DSP_SETFRAGMENT, &arg)==-1) {
    perror("FRAGMENT SIZE");
    exit(1);
  }

  /* Put the audio port in "sync" mode */
  ioctl(audio_fd, SNDCTL_DSP_SYNC, 0);

  /* Set the format for output samples */
  format = AFMT_S16_LE;
  if (ioctl(audio_fd, SNDCTL_DSP_SETFMT, &format)==-1) { 
    perror("SNDCTL_DSP_SETFMT");
    exit(1);
  }

  /* Set stereo / mono (1/0) */
  stereo = chans-1;
  if (ioctl(audio_fd, SNDCTL_DSP_STEREO, &stereo)==-1) { 
    perror("SNDCTL_DSP_STEREO");
    exit(1);
  }

  /* Set sample rate */
  if (ioctl(audio_fd, SNDCTL_DSP_SPEED, &speed)==-1)
    { /* Fatal error */
      perror("SNDCTL_DSP_SPEED");
      exit(1);
    }

  /* Get the size of the audio buffer */
  /* Note that the driver computes this optimally */
  if (ioctl(audio_fd, SNDCTL_DSP_GETBLKSIZE, &frag_size) == -1) {
    exit(1);
  }
  printf("Audio buffer:  %d\n",frag_size);

  while(samps = read(ifp, sampbuff, BUFSIZE*sizeof(short)) > 0) {
    if ((len = write(audio_fd, sampbuff, 2*BUFSIZE)) == -1) {
      perror("AUDIO WRITE");
      exit(1);
    }
  }
  
  /* Close the audio port */
  close(audio_fd);
  /* Close the audio file */
  close(ifp);

}




