#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "strums.h"
extern strumq strumq1;

extern SFHEADER      sfdesc[NFILES];

start(p,n_args)
 
 /* Plucked string instrument using strum.
    Use with fret.c and bend.c to play single pluck sounds.

    start(start time, dur, pitch, tf0, tNy, amp, squish, stereo-spread[optional])

    tf0 is the decay time at the fundamental frequency of the note.
    tNy is high freq decay time.
    squish is an integer 0 or greater that specifies how 'squishy' the
      plucking implement is.  0 is a hard implement.  5 is more like a finger.

    tNy is normally a lot smaller than tf0.

    Normally the random generator is not started with the same seed for each
    note.  Thus a note called with identical parameters will sound slightly
    different each time it it played, unless the random generator is reseeded
    with the same seed before each note.  This can be done from inside Minc 
    with a call to srand(seed).

    Decay times need not equal the duration of the note.  Short decay times   
    with small squish sound like plucked violins, etc.  Long decay times with
    larger squish sound more like electric guitars, basses, etc.

    Use fret to change some parameter of the sound after it is started with
    start.  For example, a note with a long duration will end abruptly unless
    you call fret right before it stops with a very short decay time.

    Use bend to gliss or add vibrato, or whatever.  If you want to start 
    the gliss immediately, just call start with zero duration.   */


 float *p;
 int n_args;
  {
  float freq,out[4],strum();
  int squish;
  long i,nsamps;
  int chans;
  float spread;

  out[0]=out[1]=out[2]=out[3]=0.0;

  nsamps=setnote(p[0],p[1],1);

  freq=cpspch(p[2]);
  squish = p[6];
  spread = p[7];
   
  sset(freq,p[3],p[4],&strumq1);
  randfill(p[5],squish,&strumq1);
  chans = sfchans(&sfdesc[1]);

  for (i=0;i<nsamps;i++) {
      out[0]=strum(0.,&strumq1);
      if (chans == 2) {
         out[1] = (1.0 - spread) * out[0];
         out[0] *= spread;
         }
      ADDOUT(out,1);
      }
  
  endnote(1);
}
