
#include "../H/ugens.h"
#include "../H/sfheader.h"
#include "mix.h"
#include <stdio.h>

extern int  sfd[NFILES];
extern int  pointer[NFILES];
extern char peakoff[NFILES];
extern int  bufsize[NFILES];
extern char *sndbuf[NFILES];
extern char *peak[NFILES];
extern char *peakloc[NFILES];
			   
extern SFHEADER      sfdesc[NFILES];

/* a cmix routine to surgically alter segments of one or more channels in
 * a soundfile.   Arguments are 
 *	          p[0]	starting time;
 *		  p[1]  duration;
 *		  p[2]  overall amp;
 *	          p[3]	alter channel 0?  1 if yes, 0 if no;
 *	          p[4]	"     "       1?  " "  "    " "  "
 *		  p[5]  "     "       2?  " "  "    " "  "
 *		  p[6]	"     "       3?  " "  "    " "  "
*/
extern float array[SIZE];
float ztabs[2];
extern int RESET;  /* times per sec to reinitialize envelope */
extern int lineset;

alter(p,n_args)   
float *p;
int n_args;
{
	long nsamps,i;
	int chlist[4],j,counter,non,skip,unit;
	float amp;

	unit = 1;
	if(!lineset) for(j=0;j<SIZE;j++) array[j] = 1;
	nsamps = setnote(p[0],p[1],unit);
	counter = 0;
	skip = SR/(float)RESET;
	tableset(p[1],SIZE,ztabs);
	for(j=0,non=0;j<sfchans(&sfdesc[unit]);j++) { 
	    	if(chlist[j] = (int)p[j+3]) non++;
		if((j+3) >= n_args) chlist[j] = 0;
	}

	if((non == 0) || (non > sfchans(&sfdesc[unit]))) {
		fprintf(stderr,"Something wrong with this card, check args\n");
		return;
		}

	for (i=nsamps; i>0; i -= skip) {
		counter = i>skip? skip : i;
		amp=tablei(nsamps-i,array,ztabs) * p[2];
		bmultout(amp,chlist,unit,counter*sfchans(&sfdesc[unit]));
	}
	endnote(unit);
}
bmultout(amp,chlist,fno,size)
float amp;
int *chlist;
{
	int i,j;
	short *ibuf;
	float *fbuf;
	int todo,remains;
	int nchans;
	int len = bufsize[fno]; 

	nchans = sfchans(&sfdesc[fno]);

refill:	todo = ((pointer[fno] + size) > len) 
				? len - pointer[fno] : size;
	if(sfclass(&sfdesc[fno]) == SF_SHORT) {
		for(i=0,ibuf = (short *)sndbuf[fno] + pointer[fno];i<todo;
								i += nchans)
			for(j=0; j<nchans; j++,ibuf++)
				if(chlist[j]) *ibuf *= amp;	
	}
	
	else {
		for(i=0,fbuf = (float *)sndbuf[fno] + pointer[fno];i<todo;
								i += nchans)
			for(j=0; j<nchans; j++,fbuf++)
				if(chlist[j]) *fbuf *= amp;
	}
	pointer[fno] += todo;

	if(pointer[fno] == len) {
		_backup(fno);
		if(!peakoff[fno])
			_chkpeak(fno);
		_writeit(fno);
		_readit(fno);
		pointer[fno] = 0;
	}

	if(size -= todo) goto refill;
}
