extern "C" {
	#include "../H/ugens.h"
	#include <ctype.h>
	#include <math.h>
	#include "defs.h"  /* parser */
	#include <stdio.h>
}

#include <iostream.h>
#include <unistd.h>
#ifdef sgi
	#include <dmedia/audio.h>
#endif
#ifdef LINUX
	#include <sys/soundcard.h>
	#include <signal.h>
#endif
#include "../rtstuff/heap/heap.h"
#include "../rtstuff/rt.h"  // need this to avoid strange compile errors?

extern "C" {
        int ug_intro();
	int profile();
	int yyparse();
	Tree exct(Tree);
	int closesf();
#ifdef sgi
	void flush_all_underflows_to_zero();
#endif
#ifdef LINUX
	void flush_fpe (int sig);
#endif
}

#ifdef sgi
	extern ALport out_port;
#endif
#ifdef LINUX 
	extern int out_port;   // this is the descriptor for the audio port.
#endif

heap rtHeap;  // DT:  main heap structure used to queue instruments
              // formerly Qobject *rtqueue[];

extern float SR;
int NCHANS;
int rtInteractive;
int interactive;
Tree     program;            
#define CMAX 16     /* allow up to 16 command line args to be passed to subs */
int aargc;
char *aargv[CMAX];  /* this are declared in ugens.h */
char name[NAMESIZE];/* to store file name found by card scanner, accessed by
                       m_open in sound.c */
FILE *fp;


main(int argc, char *argv[])
{
	int	j;
	char    *cp,*infile;

	extern void rtprofile();
	extern void traverse();

	rtInteractive = 0;

	/*
	THE FOLLOWING FUNCTION IS SGI ONLY
	set the special "flush zero" but (FS, bit 24) in the
	Control Status Register of the FPU of R4k and beyond
	so that the result of any underflowing operation will
	be clamped to zero, and no exception of any kind will
	be generated on the CPU.  This has no effect on 
	an R3000.
	*/

#ifdef sgi
	flush_all_underflows_to_zero();
#endif
#ifdef LINUX
	/* Install signal handler */
	signal(SIGFPE,flush_fpe);
#endif
	/* copy command-line args, if any*/
	for(j=1; j<argc; j++) aargv[j-1]=argv[j];
	aargc = argc;
	/* Now, command-line args will be available to any subroutine
	   in aargc; and char *aargv[], (both declared extern in ugens.h)
	   parsing is exactly the same then as standard C routine.
	   Maximum of CMAX arguments allowed. */


	interactive = 1; /* default is interactive mode */

	fprintf(stderr," ---------> RTcmix/%s <----------\n",argv[0]);
	/*
	 * "Introduce" functions and stuff to program
	 */
	fp = NULL;

	if(argc >= 3) {
	while((*++argv)[0] == '-') {
		argc -= 2; /* Take away two args */
		for(cp = argv[0]+1; *cp; cp++) {
			switch(*cp) { /* Grap options */
			case 'f':
				infile = *++argv;
				fp = fopen(infile,"r+");
				if(fp == NULL) {
					printf("Can't open %s\n",infile);
					exit(-1);
					}
				fprintf(stderr,"Using file %s\n",infile);
				break;
			default:  
				printf("don't know about option %c\n",*cp);
				}
			}
	        if(argc == 1) break;
		}
	}

	ug_intro();	/* introduce standard routines */
	profile();	/* introduce user-written routines etc. */
	rtprofile();	/* introduce real-time user-written routines */

	setbuf(stdout, NULL);	/*  Want to see stdout errors	*/

	/*
	 *    The program is read from stdin, but this can be changed
	 */


	yyparse();    /* create intermediate representation */
	
	/* Mainly for historical reasons ... don't think we'll ever be */
	/* !interactive any more */
	if(!interactive) exct(program);

        traverse();  /* play instruments on the heap */
                     /* this may change when we get RT interactive */

#ifdef sgi
	if (out_port) while (ALgetfilled(out_port) > 0) {};
#endif
	closesf();
	fprintf(stderr,"--------->Goodbye<---------");
}
















