/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	ibmpc_iconqnx
#include <stdio.h>
#include "common.h"

#define DOS_EOF	0x1A		/* MS-DOS old end-of-file */
#define ESCAPE	0x19		/* Escape for diacritic application */
#define ENDLINE	0x1E		/* End-line code for QNX */

#define TRANSLATE_AND_BREAK(c2, c3) \
  putc (ESCAPE, output_file); \
  putc (c2, output_file); \
  putc (c3, output_file); \
  input_char = getc (input_file); \
  break;

void
STEP (FILE *input_file, FILE *output_file)
{
  int input_char;

  input_char = getc (input_file);
  while (input_char != EOF && input_char != DOS_EOF)
    switch (input_char)
      {
      case 0x85: TRANSLATE_AND_BREAK ('A', 'a');
      case 0x8A: TRANSLATE_AND_BREAK ('A', 'e');
      case 0x97: TRANSLATE_AND_BREAK ('A', 'u');
      case 0x82: TRANSLATE_AND_BREAK ('B', 'e');
      case 0x90: TRANSLATE_AND_BREAK ('B', 'E');
      case 0x83: TRANSLATE_AND_BREAK ('C', 'a');
      case 0x88: TRANSLATE_AND_BREAK ('C', 'e');
      case 0x8C: TRANSLATE_AND_BREAK ('C', 'i');
      case 0x93: TRANSLATE_AND_BREAK ('C', 'o');
      case 0x96: TRANSLATE_AND_BREAK ('C', 'u');
      case 0x89: TRANSLATE_AND_BREAK ('H', 'e');
      case 0x8B: TRANSLATE_AND_BREAK ('H', 'i');
      case 0x81: TRANSLATE_AND_BREAK ('H', 'u');
      case 0x87: TRANSLATE_AND_BREAK ('K', 'c');
      case 0x80: TRANSLATE_AND_BREAK ('K', 'C');

      case 0x0D:
	input_char = getc (input_file);
	if (input_char == 0x0A)
	  {
	    putc (ENDLINE, output_file);
	    input_char = getc (input_file);
	  }
	else
	  putc (0x0D, output_file);
	break;

      default:
	putc (input_char, output_file);
	input_char = getc (input_file);
      }
}
