#! /usr/local/bin/python

# Read #define's from stdin and translate to Python code on stdout.
# Very primitive: non-#define's are ignored.
# You will have to edit the output in some cases.
# If one or more filenames are given, output is written to corresponding
# filenames in the local directory, translated to all uppercase, with
# the extension replaced by ".py".

# XXX To do:
# - turn trailing C comments into Python comments
# - turn C string quotes into Python comments
# - turn C Boolean operators "&& || !" into Python "and or not"
# - what to do about #if(def)?
# - what to do about macros with parameters?
# - reject definitions with semicolons in them

import sys, regex, string, getopt, os

p_define = regex.compile('^#[\t ]*define[\t ]+\([a-zA-Z0-9_]+\)[\t ]+')

p_comment = regex.compile('/\*\([^*]+\|\*+[^/]\)*\(\*+/\)?')

def main():
	opts, args = getopt.getopt(sys.argv[1:], '')
	if not args:
		args = ['-']
	for filename in args:
		if filename == '-':
			sys.stdout.write('# Generated by h2py from stdin\n')
			process(sys.stdin, sys.stdout)
		else:
			fp = open(filename, 'r')
			outfile = os.path.basename(filename)
			i = string.rfind(outfile, '.')
			if i > 0: outfile = outfile[:i]
			outfile = string.upper(outfile)
			outfile = outfile + '.py'
			outfp = open(outfile, 'w')
			outfp.write('# Generated by h2py from %s\n' % filename)
			process(fp, outfp)
			outfp.close()
			fp.close()

def process(fp, outfp):
	env = {}
	lineno = 0
	while 1:
		line = fp.readline()
		if not line: break
		lineno = lineno + 1
		if p_define.match(line) >= 0:
			# gobble up continuation lines
			while line[-2:] == '\\\n':
				nextline = fp.readline()
				if not nextline: break
				lineno = lineno + 1
				line = line + nextline
			regs = p_define.regs
			a, b = regs[1] # where the macro name is
			name = line[a:b]
			a, b = regs[0] # the whole match
			body = line[b:]
			# replace comments by spaces
			while p_comment.search(body) >= 0:
				a, b = p_comment.regs[0]
				body = body[:a] + ' ' + body[b:]
			stmt = '%s = %s\n' % (name, string.strip(body))
			ok = 0
			try:
				exec stmt in env
				ok = 1
			except:
				sys.stderr.write('Skipping: %s' % stmt)
			if ok:
				outfp.write(stmt)

main()
