/* kill.c, created from kill.def. */
#line 23 "(null)kill.def"

#line 35 "(null)kill.def"

#include <sys/types.h>
#include <errno.h>
extern int errno;

#include "../shell.h"
#include "../trap.h"
#include "../jobs.h"

#if defined (JOB_CONTROL)
extern int job_control;

#if !defined (CONTINUE_AFTER_KILL_ERROR)
#  define CONTINUE_OR_FAIL return (EXECUTION_FAILURE)
#else
#  define CONTINUE_OR_FAIL goto continue_killing
#endif /* CONTINUE_AFTER_KILL_ERROR */

/* Here is the kill builtin.  We only have it so that people can type
   kill -KILL %1?  No, if you fill up the process table this way you
   can still kill some. */
int
kill_builtin (list)
     WORD_LIST *list;
{
  int signal = SIGTERM;
  int any_succeeded = 0, listing = 0, saw_signal = 0;
  char *sigspec;
  pid_t pid;

  if (!list)
    return (EXECUTION_SUCCESS);

  /* Process options. */
  while (list)
    {
      if (strcmp (list->word->word, "-l") == 0)
	{
	  listing++;
	  list = list->next;
	}
      else if (strcmp (list->word->word, "-s") == 0)
	{
	  list = list->next;
	  if (list)
	    {
	      sigspec = list->word->word;
	      if (strcmp (sigspec, "0") == 0)
		signal = 0;
	      else
		signal = decode_signal (sigspec);
	      list = list->next;
	    }
	  else
	    {
	      builtin_error ("-s requires an argument");
	      return (EXECUTION_FAILURE);
	    }
	}
      else if (strcmp (list->word->word, "--") == 0)
	{
	  list = list->next;
	  break;
	}
      /* If this is a signal specification then process it.  We only process
	 the first one seen; other arguments may signify process groups (e.g,
	 -num == process group num). */
      else if ((*(list->word->word) == '-') && !saw_signal)
	{
	  sigspec = &(list->word->word)[1];
	  signal = decode_signal (sigspec);
	  saw_signal++;
	  list = list->next;
	}
      else
	break;
    }

  if (listing)
    {
      if (!list)
	{
	  register int i, column = 0;
	  for (i = 1; i < NSIG; i++)
	    {
	      char *name = signal_name (i);
	      if ((strncmp (name, "SIGJUNK", 7) == 0) ||
		  (strncmp (name, "Unknown", 7) == 0))
		continue;

	      printf ("%2d) %s", i, name);

	      if (++column < 4)
		printf ("\t");
	      else
		{
		  printf ("\n");
		  column = 0;
		}
	    }

	  if (column != 0)
	    printf ("\n");
	}
      else
	{
	  /* List individual signal names. */
	  while (list)
	    {
	      int signum;
	      char *name;

	      if ((sscanf (list->word->word, "%d", &signum) != 1) ||
		  (signum <= 0))
		{
	    list_error:
		  builtin_error ("bad signal number: %s", list->word->word);
		  list = list->next;
		  continue;
		}

	      /* This is specified by Posix.2 so that exit statuses can be
		 mapped into signal numbers. */
	      if (signum > 128)
		signum -= 128;

	      if (signum > NSIG)
		goto list_error;

	      name = signal_name (signum);
	      if ((strncmp (name, "SIGJUNK", 7) == 0) ||
		  (strncmp (name, "Unknown", 7) == 0))
		{
		  list = list->next;
		  continue;
		}
	      printf ("%s\n", name);
	      list = list->next;
	    }
	}
      return (EXECUTION_SUCCESS);
    }

  /* OK, we are killing processes. */
  if (signal == NO_SIG)
    {
      builtin_error ("bad signal spec `%s'", sigspec);
      return (EXECUTION_FAILURE);
    }

  while (list)
    {
      char *word = list->word->word;

      if (*word == '-')
	word++;

      if (all_digits (word))
	{
	  /* Use the entire argument in case of minus sign presence. */
	  pid = (pid_t) atoi (list->word->word);

	  if (kill_pid (pid, signal, 0) < 0)
	    goto signal_error;
	  else
	    any_succeeded++;
	}
      else if (*list->word->word != '%')
	{
	  builtin_error ("No such pid %s", list->word->word);
	  CONTINUE_OR_FAIL;
	}
      else if (job_control)	/* can't kill jobs if not using job control */
	{			/* Must be a job spec.  Check it out. */
	  int job;
	  sigset_t set, oset;

	  BLOCK_CHILD (set, oset);
	  job = get_job_spec (list);

	  if (job < 0 || job >= job_slots || !jobs[job])
	    {
	      if (job != DUP_JOB)
		builtin_error ("No such job %s", list->word->word);
	      UNBLOCK_CHILD (oset);
	      CONTINUE_OR_FAIL;
	    }

	  /* Job spec used.  Kill the process group. If the job was started
	     without job control, then its pgrp == shell_pgrp, so we have
	     to be careful.  We take the pid of the first job in the pipeline
	     in that case. */
	  if (jobs[job]->job_control)
	    pid = jobs[job]->pgrp;
	  else
	    pid = jobs[job]->pipe->pid;

	  UNBLOCK_CHILD (oset);

	  if (kill_pid (pid, signal, 1) < 0)
	    {
	    signal_error:
	      if (errno == EPERM)
		builtin_error ("(%d) - Not owner", (int)pid);
	      else if (errno == ESRCH)
		builtin_error ("(%d) - No such pid", (int)pid);
	      else
		builtin_error ("Invalid signal %d", signal);
	      CONTINUE_OR_FAIL;
	    }
	  else
	    any_succeeded++;
	}
      else
	{
	  builtin_error ("bad process specification `%s'", list->word->word);
	  CONTINUE_OR_FAIL;
	}
    continue_killing:
      list = list->next;
    }

  if (any_succeeded)
    return (EXECUTION_SUCCESS);
  else
    return (EXECUTION_FAILURE);
}
#endif /* JOB_CONTROL */
