/**************************************************************************
*                                                                         *
*  Author      : Werner Meurer, GMD, I1.HR                                *
*  Date        : Jan 93                                                   *
*  Last Update :                                                          *
*                                                                         *
*  Module      : xreadint                                                 *
*                                                                         *
*  Function    : Athena Widget for Input natural number                   *
*                                                                         *
*  Export :                                                               *
*                                                                         *
*  void open_integer_input_window(w,client_data,call_data)                *
*                                                                         *
**************************************************************************/

#include "xglobal.h"
#define _ABS
#include <math.h>
#include "xoptions.h"
#include "xhelp.h"
#include "xreadint.h" /* variables and callbackprocedure */

#define DEBUG(x)

Widget sshell;

Widget intdialog,intdone,inputint;

/************************************************************************/
/* reverse()        */
/* INPUT: string is an array of char    */
/* OUTPUT: the reverse string     */
/************************************************************************/
void reverse(string)
char *string;
{
       int length = strlen(string);
       int i;
DEBUG(printf("reverse\n"));
       for (i=0;i<(int) (length /2);i++)
       {
        int dummy;
        dummy = string[length-1-i];
        string[length-1-i] = string[i];
        string[i] = dummy;
       }
       string[length] = '\0';
}

/************************************************************************/
/* itoa()        */
/* INPUT: number is an integer value    */
/*      string is an allocated string (array of char)  */
/* OUTPUT: in the string is the number    */
/* return value: string      */
/* the procedure converts a number to a string    */
/************************************************************************/
char *itoa(number,string)
int number;
char *string;
{
       int i = 0;
DEBUG(printf("itoa\n"));
       while (number > 0)
       {
        string[i] = number % 10;
        number = (int) (number / 10);
        string[i] = string[i] + '0';
        i++;
       }
       string[i] = '\0';
       reverse(string);
       return(string);
}

/************************************************************************/
/* ArrayChoosed()       */
/* INPUT: w is the widget which called the procedure  */
/*      client_data is the user defined data (parameter) */
/*      call_data is x-window defined data   */
/* OUTPUT: failure messages in the message window   */
/* Translates the String from the TextWidget into an integer   */
/* ArraySize        */
/************************************************************************/
void ArrayChoosed (w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    Arg args[10];
    int n = 0;
    char *string;
    int letternumber;
    Widget caller = (Widget) client_data;
    char name[MAXLENGTH];
       /* Static Array is choosed    */
       /* Get and check the String from the widget  */
DEBUG(printf("ArrayChoosed\n"));
    n = 0;
    strcpy(name,XtName(XtParent(XtParent(w))));
    XtSetArg(args[n],XtNstring,&string);n++;
    XtGetValues(caller,args,n);
    letternumber = strlen(string);
    /* check if there are only digits or not */
    {
       int i = 0;
       while (isdigit(string[i]))
       {
        i++;
       }
       if (i == letternumber) /* only digits */
       {
           if (letternumber > (int)(log10((double)MAXSIZE)))
           {
        strcpy(last_message,"number too big, MAXSIZE choosed");
        set_message();
        sshell = 0;
        XtPopdown(XtParent(XtParent(w)));
        integer_init_or_writeback(name,MAXSIZE,WRITEBACK);
        return;
           }
           else
           {
        int number;
        sshell = 0;
        string[i] = '\0';
        XtPopdown(XtParent(XtParent(w)));
        number = atoi(string);
        if (number > MAXSIZE)
        {
         strcpy(last_message,"number too big, MAXSIZE choosed");
         set_message();
         integer_init_or_writeback(name,MAXSIZE,WRITEBACK);
         return;
        }
        else
        {
         integer_init_or_writeback(name,number,WRITEBACK);
         return;
        }
           }
       }
       strcpy(last_message,"Only positive integers are allowed");
       set_message();
    }
}

/************************************************************************/
/* return_key()        */
/* INPUT: w is the Widget in which the event happened  */
/*      event is the pointer to the eventstructure  */
/* OUTPUT: none       */
/* The Procedure simulates the callback from the Accept button  */
/************************************************************************/
void return_key(w,event)
Widget w;
XEvent *event;
{
       DEBUG(printf("return_key\n"));
       ArrayChoosed(w,(XtPointer) w,(XtPointer) 0);
}

/************************************************************************/
/* is_no_digit_or_return()      */
/* INPUT: w is the Widget in which the event happened  */
/*      event is the pointer to the eventstructure  */
/* OUTPUT: failure message in the message window   */
/************************************************************************/
void is_no_digit_or_return(w,event)
Widget w;
XEvent *event;
{
DEBUG(printf("is_no_digit_or_return\n"));
       strcpy(last_message,"Only digits or return is allowd");
       set_message();
}

/************************************************************************/
/* open_integer_input_window()      */
/* INPUT: w is the widget which called the procedure  */
/*      client_data is the user defined data (parameter) */
/*      call_data is x-window defined data   */
/* OUTPUT: none       */
/* The procedure opens the windows for an integer input   */
/* REMARK: This procedure is written to use again. It is only */
/*      opened, if it is not open, no second window of this */
/*      procedure will be opened.    */
/*      Only the Widgets must be global (sshell,intdialog, */
/*      intdone,inputint)     */
/************************************************************************/
void open_integer_input_window(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data ;
{
       char *name;
       Widget parent;
       Widget poswidget = w;
       Arg args[10];
       int n = 0;
       char string[MAXLENGTH];
       Position x, y;
       Dimension width, height;
       name = XtName (w);
DEBUG(printf("open_integer_input_window\n"));

       if (sshell != 0)
       {
        strcpy(last_message,"Window is open");
        set_message();
        return;
       }
        sshell = XtVaCreatePopupShell(
              name, /* same name as calling widget  */
              transientShellWidgetClass,
              XtParent (w),
              NULL);              /* terminate varargs list */
   /* * get the coordinates of the middle of poswidget widget.  */

       XtVaGetValues(poswidget,
              XtNwidth, &width,
              XtNheight, &height,
              NULL);

   /* translate coordinates in application top-level window
    * into coordinates from root window origin.               */

        XtTranslateCoords(poswidget,        /* Widget */
           (Position) width/2,        /* x */
           (Position) height/2,       /* y */
           &x, &y);          /* coords on root window */

   /* move popup shell to this position (it's not visible yet) */

       XtVaSetValues(sshell,
                   XtNx, x,
                   XtNy, y,
                   NULL);
       intdialog = XtVaCreateManagedWidget(
              "intdialog",            /* widget name   */
              formWidgetClass,        /* widget class */
              sshell,                 /* parent widget*/
              NULL);                  /* terminate varargs list */

       intdone = XtVaCreateManagedWidget(
          "Accept",                      /* widget name   */
          commandWidgetClass,             /* widget class */
          intdialog,                      /* parent widget*/
          NULL);              /* terminate varargs list */

/* set the arguments for the text widget    */
       n = 0;
       XtSetArg(args[n],XtNwidth,200);n++;
       XtSetArg(args[n],XtNheight,30);n++;
       XtSetArg(args[n],XtNfromVert,intdone);n++;
       itoa(integer_init_or_writeback(name,strlen(name),INIT),string);
       XtSetArg(args[n],XtNstring,string);n++;
       XtSetArg(args[n],XtNeditType,"edit");n++;
       inputint = XtCreateManagedWidget ("Input", asciiTextWidgetClass,
                          intdialog, args, n);

/* make the new translationtables known     */

        make_help_available (inputint);

       XtOverrideTranslations(inputint,
        XtParseTranslationTable(KeyTranslation));

        XtAddCallback (intdone, XtNcallback,ArrayChoosed, inputint);
        XtPopup(sshell,XtGrabNone);
}


