# include "Transfor.h"
# include "yyATrans.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 32 "AdaptTransform.puma"

# include <stdio.h>
# include "Idents.h"
# include "StringMe.h"
# include "Types.h"

# include "protocol.h"

# include "Transfor.h"       /* IsHost, Replace*, Make* */
# include "Dalib.h"           /* MakeDalibId, ... */

# include "Shapes.h"          /* SetAllocateShapes, ResetDeallocateShapes */
# include "Local.h"      /* local operations on distributed arrays */
# include "Vars.h"       /* all exported functions */
# include "Scalar.h"
# include "Movement.h"
# include "On.h"         /* AdaptOn */
# include "CM.h"
# include "Broadcas.h"  /* MakeParamBroadcast */

# include "MakeStaA.h"   /* MakeStatic */

extern void exit ();

bool IsMainUnit;              /* true in a PROGRAM_DECL, needed to decide
                                 for (de)allocate of common variables     */

tIdent unitname;        /* global used for translation in the current unit */

tIdent NewUnitName (id)
tIdent id;
{ char string[250];
  GetString (id,string);
  if (IsHost)
     strcat (string, "_H");
    else
     strcat (string, "_N");
  return (MakeIdent (string, strlen (string)));
}

tTree MakeDalibPid ()
{ tTree h1, h2;
  tIdent id;
  id = MakeDalibId ("pid");
  h1 = mVAR_DECL (id, 0, mINTEGER_TYPE (4));
  h2 = mEXT_PROC_DECL (id, 0, mDECL_EMPTY());
  return mDECL_LIST (h1, mDECL_LIST (h2, mDECL_EMPTY ()));
}

tTree MakeDalibHaveI ()
{ tTree h1, h2;
  tIdent id;
  id = MakeDalibId ("have_i");
  h1 = mVAR_DECL (id, 0, mBOOLEAN_TYPE (4));
  h2 = mEXT_PROC_DECL (id, 0, mDECL_EMPTY());
  return mDECL_LIST (h1, mDECL_LIST (h2, mDECL_EMPTY ()));
}



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AdaptTransform, routine %s failed\n", yyFunction);
 exit (1);
}

void HostAdapt ARGS((tTree t));
void NodeAdapt ARGS((tTree t));
static tTree UnitsAdapt ARGS((tTree t));
static tTree TransformDECL ARGS((tTree t));
static tTree TransformCommonDECL ARGS((tTree t));
static tTree TransformACF ARGS((tTree t));
static tTree TransformActuals ARGS((tTree t));
static tTree AdaptAssign ARGS((tTree assign, int rankvar, int rankexp));
static tTree AdaptArrayAssign ARGS((tTree assign, int vardistribution, int expdistribution));
static void UpdateLocal ARGS((tTree t));
static void UpdateFuncCall ARGS((tTree e));
static void RemoveOverlaps ARGS((tTree t));

void HostAdapt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kCOMP_UNIT) {
# line 94 "AdaptTransform.puma"
  {
# line 95 "AdaptTransform.puma"
   IsHost = 1;
# line 96 "AdaptTransform.puma"
   open_protocol ("adaptor.tra");
# line 97 "AdaptTransform.puma"
 t->COMP_UNIT.COMP_ELEMENTS = UnitsAdapt (t->COMP_UNIT.COMP_ELEMENTS);
# line 98 "AdaptTransform.puma"
   close_protocol ();
  }
   return;

  }
;
}

void NodeAdapt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kCOMP_UNIT) {
# line 103 "AdaptTransform.puma"
  {
# line 104 "AdaptTransform.puma"
   IsHost = 0;
# line 105 "AdaptTransform.puma"
   open_protocol ("adaptor.tra");
# line 106 "AdaptTransform.puma"
 t->COMP_UNIT.COMP_ELEMENTS = UnitsAdapt (t->COMP_UNIT.COMP_ELEMENTS);
# line 107 "AdaptTransform.puma"
   close_protocol ();
# line 108 "AdaptTransform.puma"
   gen_makefile ();
  }
   return;

  }
;
}

static tTree UnitsAdapt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 119 "AdaptTransform.puma"

char string[256];
tIdent  pid;


  switch (t->Kind) {
  case kDECL_LIST:
# line 126 "AdaptTransform.puma"
 {
  tTree new_decl;
  {
# line 128 "AdaptTransform.puma"

# line 130 "AdaptTransform.puma"
 new_decl = UnitsAdapt (t->DECL_LIST.Elem);
       t->DECL_LIST.Next     = UnitsAdapt (t->DECL_LIST.Next);
       new_decl = ReplaceDECL (t, new_decl, t->DECL_LIST.Next);

  }
  {
   return new_decl;
  }
 }

  case kDECL_EMPTY:
# line 137 "AdaptTransform.puma"
   return t;

  case kPROGRAM_DECL:
# line 141 "AdaptTransform.puma"
 {
  tDefinitions Obj;
  {
# line 142 "AdaptTransform.puma"
   set_protocol_unit (t);
# line 143 "AdaptTransform.puma"

# line 144 "AdaptTransform.puma"
   Obj = GetDeclEntry (t->PROGRAM_DECL.Name, GetUnitEntries ());
# line 145 "AdaptTransform.puma"
   OpenScope (Obj->ProcObject.Declarations);
# line 146 "AdaptTransform.puma"
 if (IsHost)
           pid = MakeIdent ("HOSTMODULE",10);
         else
           pid = MakeIdent ("NODEMODULE",10);
       unitname = pid;
       t = mPROC_DECL (pid, t->PROGRAM_DECL.Pos, t->PROGRAM_DECL.FORMALS, t->PROGRAM_DECL.PROGRAM_BODY);

# line 153 "AdaptTransform.puma"
   IsMainUnit = true;
# line 154 "AdaptTransform.puma"
   IsPure = false;
# line 155 "AdaptTransform.puma"
 t->PROGRAM_DECL.PROGRAM_BODY = UnitsAdapt (t->PROGRAM_DECL.PROGRAM_BODY);
# line 156 "AdaptTransform.puma"
   CloseScope ();
  }
  {
   return t;
  }
 }

  case kPROC_DECL:
# line 160 "AdaptTransform.puma"
  {
# line 161 "AdaptTransform.puma"
   if (! ((IsHost && t->PROC_DECL.IsPure))) goto yyL4;
  {
# line 162 "AdaptTransform.puma"
   set_protocol_unit (t);
# line 163 "AdaptTransform.puma"
   print_protocol ("Pure Subroutine is removed in host.f");
  }
  }
   return NoTree;
yyL4:;

# line 167 "AdaptTransform.puma"
 {
  tDefinitions Obj;
  {
# line 168 "AdaptTransform.puma"
   set_protocol_unit (t);
# line 169 "AdaptTransform.puma"

# line 170 "AdaptTransform.puma"
   Obj = GetDeclEntry (t->PROC_DECL.Name, GetUnitEntries ());
# line 171 "AdaptTransform.puma"
   OpenScope (Obj->ProcObject.Declarations);
# line 172 "AdaptTransform.puma"
 t->PROC_DECL.FORMALS = TransformDECL (t->PROC_DECL.FORMALS);
# line 173 "AdaptTransform.puma"
   t->PROC_DECL.Name = NewUnitName (t->PROC_DECL.Name);
# line 175 "AdaptTransform.puma"
   unitname = t->PROC_DECL.Name;
# line 176 "AdaptTransform.puma"
   IsMainUnit = false;
# line 177 "AdaptTransform.puma"
   IsPure = t->PROC_DECL.IsPure;
# line 178 "AdaptTransform.puma"
 t->PROC_DECL.PROC_BODY = UnitsAdapt (t->PROC_DECL.PROC_BODY);
# line 179 "AdaptTransform.puma"
   CloseScope ();
# line 180 "AdaptTransform.puma"
 t->PROC_DECL.IsPure = false;
  }
  {
   return t;
  }
 }

  case kFUNC_DECL:
# line 184 "AdaptTransform.puma"
  {
# line 185 "AdaptTransform.puma"
   if (! ((IsHost && t->FUNC_DECL.IsPure))) goto yyL6;
  {
# line 186 "AdaptTransform.puma"
   set_protocol_unit (t);
# line 187 "AdaptTransform.puma"
   print_protocol ("Pure Function is removed in host.f");
  }
  }
   return NoTree;
yyL6:;

# line 191 "AdaptTransform.puma"
 {
  tDefinitions Obj;
  {
# line 192 "AdaptTransform.puma"
   set_protocol_unit (t);
# line 193 "AdaptTransform.puma"

# line 194 "AdaptTransform.puma"
   Obj = GetDeclEntry (t->FUNC_DECL.Name, GetUnitEntries ());
# line 195 "AdaptTransform.puma"
   OpenScope (Obj->FuncObject.Declarations);
# line 196 "AdaptTransform.puma"
 t->FUNC_DECL.FORMALS = TransformDECL (t->FUNC_DECL.FORMALS);
# line 197 "AdaptTransform.puma"
   t->FUNC_DECL.Name = NewUnitName (t->FUNC_DECL.Name);
# line 198 "AdaptTransform.puma"
   unitname = t->FUNC_DECL.Name;
# line 199 "AdaptTransform.puma"
   IsMainUnit = false;
# line 200 "AdaptTransform.puma"
   IsPure = t->FUNC_DECL.IsPure;
# line 201 "AdaptTransform.puma"
 t->FUNC_DECL.FUNC_BODY = UnitsAdapt (t->FUNC_DECL.FUNC_BODY);
# line 202 "AdaptTransform.puma"
   CloseScope ();
# line 203 "AdaptTransform.puma"
 t->FUNC_DECL.IsPure = false;
  }
  {
   return t;
  }
 }

  case kBLOCK_DATA_DECL:
# line 207 "AdaptTransform.puma"
 {
  tDefinitions Obj;
  {
# line 208 "AdaptTransform.puma"
   set_protocol_unit (t);
# line 209 "AdaptTransform.puma"

# line 210 "AdaptTransform.puma"
   GetString (t->BLOCK_DATA_DECL.Name, string);
# line 211 "AdaptTransform.puma"
   Obj = GetDeclEntry (t->BLOCK_DATA_DECL.Name, GetUnitEntries ());
# line 212 "AdaptTransform.puma"
   OpenScope (Obj->BlockObject.Declarations);
# line 213 "AdaptTransform.puma"
   t->BLOCK_DATA_DECL.Name = NewUnitName (t->BLOCK_DATA_DECL.Name);
# line 214 "AdaptTransform.puma"
   unitname = t->BLOCK_DATA_DECL.Name;
# line 215 "AdaptTransform.puma"
   IsMainUnit = false;
# line 216 "AdaptTransform.puma"
   IsPure = false;
# line 217 "AdaptTransform.puma"
 t->BLOCK_DATA_DECL.DATA_BODY = UnitsAdapt (t->BLOCK_DATA_DECL.DATA_BODY);
# line 218 "AdaptTransform.puma"
   CloseScope ();
  }
  {
   return t;
  }
 }

  case kBODY_NODE:
# line 222 "AdaptTransform.puma"
  {
# line 223 "AdaptTransform.puma"
 NewDefines = NoTree;
       t->BODY_NODE.DECLS = TransformDECL (t->BODY_NODE.DECLS);
       t->BODY_NODE.STATS = TransformACF (t->BODY_NODE.STATS);
       t->BODY_NODE.STATS = CombineACF (NewDefines, t->BODY_NODE.STATS);

       RemoveOverlaps (t->BODY_NODE.DECLS);

       MakeStatic (t, unitname);

       if ( (!IsHost) && (target_model != UNI_PROC) )
          t->BODY_NODE.DECLS = AppendDECLS (t->BODY_NODE.DECLS, MakeDalibHaveI ());

       if (target_model == ONLY_NODE)
          t->BODY_NODE.DECLS = AppendDECLS (t->BODY_NODE.DECLS, MakeDalibPid());

  }
   return t;

  }

 yyAbort ("UnitsAdapt");
}

static tTree TransformDECL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kDECL_LIST:
# line 249 "AdaptTransform.puma"
 {
  tTree new_decl;
  {
# line 251 "AdaptTransform.puma"

# line 253 "AdaptTransform.puma"
 new_decl = TransformDECL (t->DECL_LIST.Elem);
       t->DECL_LIST.Next     = TransformDECL (t->DECL_LIST.Next);
       new_decl = ReplaceDECL (t, new_decl, t->DECL_LIST.Next);

  }
  {
   return new_decl;
  }
 }

  case kDECL_EMPTY:
# line 260 "AdaptTransform.puma"
   return t;

  case kVAR_DECL:
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 264 "AdaptTransform.puma"
 {
  int var_dist;
  tTree new_decl;
  tDefinitions Obj;
  {
# line 266 "AdaptTransform.puma"

# line 267 "AdaptTransform.puma"

# line 268 "AdaptTransform.puma"

# line 270 "AdaptTransform.puma"
   Obj = GetLocalDecl (t->VAR_DECL.Name);
# line 271 "AdaptTransform.puma"
   var_dist = VarDistribution (Obj);
# line 272 "AdaptTransform.puma"
   new_decl = AdaptVarDecl (t, var_dist, IsMainUnit);
  }
  {
   return new_decl;
  }
 }

  }
# line 277 "AdaptTransform.puma"
 {
  tDefinitions Obj;
  {
# line 279 "AdaptTransform.puma"

# line 280 "AdaptTransform.puma"
   Obj = GetLocalDecl (t->VAR_DECL.Name);
# line 281 "AdaptTransform.puma"
 if ((Obj != NoObject) && (Obj == GetDeclEntry (t->VAR_DECL.Name, GetUnitEntries())))
          t->VAR_DECL.Name = NewUnitName (t->VAR_DECL.Name);

  }
  {
   return t;
  }
 }

  case kVAR_PARAM_DECL:
# line 287 "AdaptTransform.puma"
 {
  int var_dist;
  tTree new_decl;
  tDefinitions Obj;
  {
# line 291 "AdaptTransform.puma"

# line 292 "AdaptTransform.puma"

# line 293 "AdaptTransform.puma"

# line 295 "AdaptTransform.puma"
   Obj = GetLocalDecl (t->VAR_PARAM_DECL.Name);
# line 296 "AdaptTransform.puma"
   var_dist = VarDistribution (Obj);
# line 297 "AdaptTransform.puma"
   new_decl = AdaptParamDecl (t, var_dist);
  }
  {
   return new_decl;
  }
 }

  case kPARAMETER_DECL:
# line 301 "AdaptTransform.puma"
   return t;

  case kEXTERNAL_DECL:
# line 305 "AdaptTransform.puma"
 {
  tDefinitions Obj;
  {
# line 309 "AdaptTransform.puma"

# line 310 "AdaptTransform.puma"
   Obj = GetLocalDecl (t->EXTERNAL_DECL.Name);
# line 312 "AdaptTransform.puma"
 if ((Obj != NoObject) && (Obj == GetDeclEntry (t->EXTERNAL_DECL.Name, GetUnitEntries())))
          t->EXTERNAL_DECL.Name = NewUnitName (t->EXTERNAL_DECL.Name);

  }
  {
   return t;
  }
 }

  case kINTRINSIC_DECL:
# line 318 "AdaptTransform.puma"
   return NoTree;

  case kIMPLICIT_DECL:
# line 322 "AdaptTransform.puma"
   return t;

  case kCOMMON_DECL:
# line 327 "AdaptTransform.puma"
  {
# line 328 "AdaptTransform.puma"
 t->COMMON_DECL.IDS = TransformCommonDECL (t->COMMON_DECL.IDS);
  }
   return t;

  case kNAMELIST_DECL:
# line 332 "AdaptTransform.puma"
   return t;

  case kDATA_DECL:
# line 336 "AdaptTransform.puma"
   return t;

  case kSAVE_DECL:
# line 340 "AdaptTransform.puma"
   return t;

  case kSEQUENCE_DECL:
# line 344 "AdaptTransform.puma"
   return NoTree;

  case kNOSEQUENCE_DECL:
# line 348 "AdaptTransform.puma"
   return NoTree;

  case kEQV_DECL:
# line 352 "AdaptTransform.puma"
   return t;

  case kTEMPLATE_DECL:
# line 356 "AdaptTransform.puma"
   return NoTree;

  case kALIGN_DECL:
# line 360 "AdaptTransform.puma"
   return NoTree;

  case kDISTRIBUTE_DECL:
# line 364 "AdaptTransform.puma"
   return NoTree;

  case kSTMT_FUNC_DECL:
# line 368 "AdaptTransform.puma"
   return t;

  }

# line 373 "AdaptTransform.puma"
  {
# line 374 "AdaptTransform.puma"
   printf ("TransformDECL failed\n");
# line 375 "AdaptTransform.puma"
   WriteTree (stdout, t);
# line 376 "AdaptTransform.puma"
   exit (- 1);
  }
   return t;

}

static tTree TransformCommonDECL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 382 "AdaptTransform.puma"
 {
  tTree new_decl;
  {
# line 384 "AdaptTransform.puma"

# line 386 "AdaptTransform.puma"
 new_decl = TransformCommonDECL (t->DECL_LIST.Elem);
       t->DECL_LIST.Next     = TransformCommonDECL (t->DECL_LIST.Next);
       new_decl = ReplaceDECL (t, new_decl, t->DECL_LIST.Next);

  }
  {
   return new_decl;
  }
 }

  }
  if (t->Kind == kDECL_EMPTY) {
# line 393 "AdaptTransform.puma"
   return t;

  }
  if (t->Kind == kVAR_DECL) {
# line 397 "AdaptTransform.puma"
   return AdaptCommonVarDecl (t, VarDistribution (GetLocalDecl (t->VAR_DECL.Name)));

  }
# line 401 "AdaptTransform.puma"
  {
# line 402 "AdaptTransform.puma"
   failure_protocol ("AdaptTransform", "TransformCommonDECL", t);
  }
   return t;

}

static tTree TransformACF
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 414 "AdaptTransform.puma"

tTree newacf;

  if (t->Kind == kACF_LIST) {
# line 418 "AdaptTransform.puma"
  {
# line 420 "AdaptTransform.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 422 "AdaptTransform.puma"
 newacf = TransformACF (t->ACF_LIST.Elem);
       t->ACF_LIST.Next   = TransformACF (t->ACF_LIST.Next);

# line 426 "AdaptTransform.puma"
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
   return newacf;

  }
  if (t->Kind == kACF_EMPTY) {
# line 431 "AdaptTransform.puma"
   return t;

  }
  if (t->Kind == kACF_BASIC) {

  switch (t->ACF_BASIC.BASIC_STMT->Kind) {
  case kIO_STMT:
 {
  tTree iostmt;
  if (equaltIdent (t->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident, MakeIdent ("READ", 4))) {
# line 435 "AdaptTransform.puma"
  {
# line 437 "AdaptTransform.puma"

# line 438 "AdaptTransform.puma"
 newacf = CombineACF (MakeReadSpecBroadcast (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS),
                            MakeParamBroadcast (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS));
       iostmt = DoSingleNode (t);
       if (iostmt != NoTree)
          newacf = mACF_LIST (iostmt, newacf);

  }
  {
   return newacf;
  }

  }
 }
# line 447 "AdaptTransform.puma"
  {
# line 448 "AdaptTransform.puma"
 newacf = DoSingleNode (t);
       UpdateFuncCall (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS);

  }
   return newacf;

  case kALLOCATE_STMT:
# line 454 "AdaptTransform.puma"
  {
# line 455 "AdaptTransform.puma"
   SetAllocateShapes (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS);
# line 456 "AdaptTransform.puma"
 newacf = AdaptAllocate (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS, IsMainUnit);
  }
   return newacf;

  case kDEALLOCATE_STMT:
# line 460 "AdaptTransform.puma"
  {
# line 461 "AdaptTransform.puma"
   ResetDeallocateShapes (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS);
# line 462 "AdaptTransform.puma"
 newacf = AdaptDeallocate (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS, IsMainUnit);
  }
   return newacf;

  case kCALL_STMT:
# line 466 "AdaptTransform.puma"
  {
# line 470 "AdaptTransform.puma"
   if (! (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Object == GetDeclEntry (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Ident, GetIntrinsicEntries ()))) goto yyL7;
  {
# line 472 "AdaptTransform.puma"
  newacf = t;
       if (IsCMSubroutine (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Ident))
         {
           newacf = AdaptCMIntrinsic (t);
         }
       else
         error_protocol ("Adaption of intrinsic subroutine failed");

# line 481 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS);
  }
  }
   return newacf;
yyL7:;

# line 485 "AdaptTransform.puma"
 {
  tTree iostmt;
  {
# line 489 "AdaptTransform.puma"
   if (! (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Object == GetDeclEntry (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Ident, GetExternalEntries ()))) goto yyL8;
  {
# line 491 "AdaptTransform.puma"

# line 492 "AdaptTransform.puma"
 newacf = MakeParamBroadcast (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS);
      iostmt = DoSingleNode (t);
      if (iostmt != NoTree)
         newacf = mACF_LIST (iostmt, newacf);

# line 498 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS);
  }
  }
  {
   return newacf;
  }
 }
yyL8:;

# line 502 "AdaptTransform.puma"
  {
# line 506 "AdaptTransform.puma"
   t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Ident = NewUnitName (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Ident);
# line 507 "AdaptTransform.puma"
 t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS = TransformActuals (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS);
# line 508 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS);
  }
   return t;

  case kSTOP_STMT:
# line 512 "AdaptTransform.puma"
  {
# line 513 "AdaptTransform.puma"
 if (IsHost)
         newacf = t;
       else
         newacf = NoTree;

  }
   return newacf;

  case kGOTO_STMT:
# line 521 "AdaptTransform.puma"
   return t;

  case kCOMP_IF_STMT:
# line 525 "AdaptTransform.puma"
   return t;

  case kASSIGN_STMT:
# line 535 "AdaptTransform.puma"
  {
# line 536 "AdaptTransform.puma"
 UpdateFuncCall (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
         UpdateFuncCall (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

  }
   return (AdaptAssign (t, TreeRank (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), TreeRank (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)));

  }

# line 542 "AdaptTransform.puma"
   return t;

  }

  switch (t->Kind) {
  case kACF_DUMMY:
# line 546 "AdaptTransform.puma"
   return t;

  case kACF_WHILE:
# line 550 "AdaptTransform.puma"
  {
# line 551 "AdaptTransform.puma"
  if (TreeDistribution (t->ACF_WHILE.WHILE_EXP) != 0)
            error_protocol ("while condition is not replicated");
         t->ACF_WHILE.WHILE_BODY = TransformACF (t->ACF_WHILE.WHILE_BODY);
         UpdateFuncCall (t->ACF_WHILE.WHILE_EXP);

  }
   return t;

  case kACF_DO:
# line 559 "AdaptTransform.puma"
  {
# line 560 "AdaptTransform.puma"
 if (TreeDistribution (t->ACF_DO.DO_RANGE) != 0)
            error_protocol ("for slice is not replicated");
        t->ACF_DO.DO_BODY = TransformACF (t->ACF_DO.DO_BODY);

  }
   return t;

  case kACF_DOVEC:
# line 567 "AdaptTransform.puma"
  {
# line 568 "AdaptTransform.puma"
 if (TreeDistribution (t->ACF_DOVEC.DOVEC_RANGE) != 0)
            error_protocol ("vecfor slice is not replicated");
        t->ACF_DOVEC.DOVEC_BODY = TransformACF (t->ACF_DOVEC.DOVEC_BODY);

  }
   return t;

  case kACF_ON:
# line 575 "AdaptTransform.puma"
 {
  tTree new;
  {
# line 577 "AdaptTransform.puma"

# line 581 "AdaptTransform.puma"
   new = AdaptOn (t);
# line 582 "AdaptTransform.puma"
   UpdateLocal (new);
  }
  {
   return new;
  }
 }

  case kACF_IF:
# line 587 "AdaptTransform.puma"
  {
# line 589 "AdaptTransform.puma"
 if (TreeDistribution (t->ACF_IF.IF_EXP) != 0)
            error_protocol ("if condition is not replicated");
        t->ACF_IF.THEN_PART = TransformACF (t->ACF_IF.THEN_PART);
        t->ACF_IF.ELSE_PART = TransformACF (t->ACF_IF.ELSE_PART);
        UpdateFuncCall (t->ACF_IF.IF_EXP);

  }
   return t;

  case kACF_WHERE:
# line 598 "AdaptTransform.puma"
  {
# line 599 "AdaptTransform.puma"
 if (!IsHost)
          { t->ACF_WHERE.TRUE_PART = TransformACF (t->ACF_WHERE.TRUE_PART);
            t->ACF_WHERE.FALSE_PART = TransformACF (t->ACF_WHERE.FALSE_PART);
            newacf = t;
          }
         else newacf = NoTree;

  }
   return newacf;

  case kACF_NODE:
  case kACF_BASIC:
  case kACF_SWITCH:
  case kACF_ALTER:
  case kACF_CASE:
  case kACF_REPEAT:
  case kACF_WITH:
  case kACF_LOOP:
  case kACF_DOLOCAL:
  case kACF_DOALL:
  case kACF_FORALL:
  case kACF_BODY:
  case kACF_FLOW_GRAPH:
  case kACF_ENTRY:
# line 609 "AdaptTransform.puma"
   return t;

  }

# line 613 "AdaptTransform.puma"
  {
# line 614 "AdaptTransform.puma"
   printf ("TransformACF failed\n");
# line 615 "AdaptTransform.puma"
   WriteTree (stdout, t);
# line 616 "AdaptTransform.puma"
   exit (- 1);
  }
   return t;

}

static tTree TransformActuals
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 630 "AdaptTransform.puma"

tTree newdecl, hdecl, p;
int dist;

  if (t->Kind == kBTP_EMPTY) {
# line 635 "AdaptTransform.puma"
   return t;

  }
  if (t->Kind == kBTP_LIST) {
# line 639 "AdaptTransform.puma"
  {
# line 640 "AdaptTransform.puma"
 newdecl = TransformActuals (t->BTP_LIST.Elem);
       t->BTP_LIST.Next    = TransformActuals (t->BTP_LIST.Next);
       if (newdecl == NoTree)
          newdecl = t->BTP_LIST.Next;
       else if (newdecl->Kind == kBTP_EMPTY)
          newdecl = t->BTP_LIST.Next;
        else if (newdecl->Kind == kBTP_LIST)
          { hdecl = newdecl;
            while (hdecl->BTP_LIST.Next->Kind == kBTP_LIST)
              hdecl = hdecl->BTP_LIST.Next;
            hdecl->BTP_LIST.Next = t->BTP_LIST.Next;
          }
        else
          newdecl = t;

  }
   return newdecl;

  }
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 658 "AdaptTransform.puma"
  {
# line 659 "AdaptTransform.puma"
 dist = TreeDistribution (t);
       if (dist == 1)
         {
           if (IsHost)
             {
               newdecl = mBTP_EMPTY ();
             }
            else
             {
               newdecl = mBTP_EMPTY ();
               p = MakeUsedVarA (t->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Ident, "_HIGH");
               newdecl = mBTP_LIST (mVAR_PARAM (p), newdecl);
               p = MakeUsedVarA (t->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Ident, "_LOW");
               newdecl = mBTP_LIST (mVAR_PARAM (p), newdecl);
               newdecl = mBTP_LIST (t, newdecl);
             }
         }
        else
         newdecl = t;

  }
   return newdecl;

  }
# line 682 "AdaptTransform.puma"
   return t;

  }
  if (t->Kind == kPROC_PARAM) {
# line 686 "AdaptTransform.puma"
   return t;

  }
  if (t->Kind == kFUNC_PARAM) {
# line 690 "AdaptTransform.puma"
   return t;

  }
# line 694 "AdaptTransform.puma"
  {
# line 695 "AdaptTransform.puma"
   failure_protocol ("AdaptTransform", "TransformActuals", t);
  }
   return t;

}

static tTree AdaptAssign
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register int rankvar, register int rankexp)
# else
(assign, rankvar, rankexp)
 register tTree assign;
 register int rankvar;
 register int rankexp;
# endif
{
# line 708 "AdaptTransform.puma"

char string[256];     /* for error message */

  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 718 "AdaptTransform.puma"
  {
# line 719 "AdaptTransform.puma"
   if (! ((IsPure == true))) goto yyL1;
  }
   return assign;
yyL1:;

# line 729 "AdaptTransform.puma"
  {
# line 730 "AdaptTransform.puma"
   if (! (IsArrayOverlapped (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) == true)) goto yyL2;
  }
   return (AdaptOverlappedMovement (assign));
yyL2:;

  if (equalint (rankvar, 0)) {
  if (equalint (rankexp, 0)) {
# line 740 "AdaptTransform.puma"
   return (AdaptScalarAssign (assign, TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)));

  }
  }
  if (equalint (rankexp, 0)) {
# line 751 "AdaptTransform.puma"
   return (AdaptArrayAssign (assign, TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)));

  }
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 765 "AdaptTransform.puma"
  {
# line 770 "AdaptTransform.puma"
   if (! (rankvar == rankexp)) goto yyL5;
  {
# line 771 "AdaptTransform.puma"
   if (! (IsIntrFunc (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP) == true)) goto yyL5;
  {
# line 772 "AdaptTransform.puma"
   if (! (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("CSHIFT", 6))) goto yyL5;
  }
  }
  }
   return AdaptCShift (assign);
yyL5:;

# line 783 "AdaptTransform.puma"
  {
# line 788 "AdaptTransform.puma"
   if (! (rankvar == rankexp)) goto yyL6;
  {
# line 789 "AdaptTransform.puma"
   if (! (IsIntrFunc (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP) == true)) goto yyL6;
  {
# line 790 "AdaptTransform.puma"
   if (! (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("TRANSPOSE", 9))) goto yyL6;
  }
  }
  }
   return AdaptTranspose (assign);
yyL6:;

  }
# line 801 "AdaptTransform.puma"
  {
# line 802 "AdaptTransform.puma"
   if (! (rankvar == rankexp)) goto yyL7;
  {
# line 805 "AdaptTransform.puma"
 assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = MakeFullShape (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
  }
  }
   return (AdaptArrayMovement (assign, TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), TreeDistribution (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)));
yyL7:;

  }
  }
# line 812 "AdaptTransform.puma"
  {
# line 813 "AdaptTransform.puma"
   sprintf (string, "AdapptAssign: rank lvar = %d, Rank rvar = %d", rankvar, rankexp);
# line 814 "AdaptTransform.puma"
   failure_protocol ("AdaptTransform", "AdaptAssign: rank error", assign);
  }
   return NoTree;

}

static tTree AdaptArrayAssign
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register int vardistribution, register int expdistribution)
# else
(assign, vardistribution, expdistribution)
 register tTree assign;
 register int vardistribution;
 register int expdistribution;
# endif
{
# line 827 "AdaptTransform.puma"

tTree t, index, new;
char string[250];

  if (equalint (vardistribution, 0)) {
  if (equalint (expdistribution, 0)) {
# line 838 "AdaptTransform.puma"
   return assign;

  }
  }
  if (equalint (vardistribution, - 1)) {
  if (equalint (expdistribution, 0)) {
# line 848 "AdaptTransform.puma"
  {
# line 849 "AdaptTransform.puma"
 if (IsHost)
        t = assign;
      else
        t = NoTree;

  }
   return t;

  }
  }
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR->Kind == kINDEXED_VAR) {
  if (equalint (vardistribution, 1)) {
  if (equalint (expdistribution, 0)) {
# line 867 "AdaptTransform.puma"
  {
# line 868 "AdaptTransform.puma"
 if (IsHost)
        t = NoTree;
       else
        t = LocalArrayAssignment (assign);

  }
   return t;

  }
  }
  }
  }
  }
# line 876 "AdaptTransform.puma"
  {
# line 877 "AdaptTransform.puma"
   sprintf (string, "%s: vardist = %d, expdist = %d\n", "Adapting Array Assignment", vardistribution, expdistribution);
# line 879 "AdaptTransform.puma"
   error_protocol (string);
  }
   return assign;

}

static void UpdateLocal
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kACF_LIST:
# line 891 "AdaptTransform.puma"
  {
# line 892 "AdaptTransform.puma"
   UpdateLocal (t->ACF_LIST.Elem);
# line 893 "AdaptTransform.puma"
   UpdateLocal (t->ACF_LIST.Next);
  }
   return;

  case kACF_EMPTY:
# line 896 "AdaptTransform.puma"
   return;

  case kACF_DUMMY:
# line 899 "AdaptTransform.puma"
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 902 "AdaptTransform.puma"
  {
# line 903 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
# line 904 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 907 "AdaptTransform.puma"
  {
# line 908 "AdaptTransform.puma"
 if (    (GetDeclEntry (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Ident, GetUnitEntries ()) == t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Object)
          && (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Object != NoObject))

       { t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Ident = NewUnitName (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID->PROC_OBJ.Ident);

         t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS = TransformActuals (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS);
       }

# line 916 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS);
  }
   return;

  }
# line 919 "AdaptTransform.puma"
   return;

  case kACF_WHILE:
# line 922 "AdaptTransform.puma"
  {
# line 923 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_WHILE.WHILE_EXP);
# line 924 "AdaptTransform.puma"
   UpdateLocal (t->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_DO:
# line 927 "AdaptTransform.puma"
  {
# line 928 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_DO.DO_RANGE);
# line 929 "AdaptTransform.puma"
   UpdateLocal (t->ACF_DO.DO_BODY);
  }
   return;

  case kACF_DOVEC:
# line 932 "AdaptTransform.puma"
  {
# line 933 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_DOVEC.DOVEC_RANGE);
# line 934 "AdaptTransform.puma"
   UpdateLocal (t->ACF_DOVEC.DOVEC_BODY);
  }
   return;

  case kACF_IF:
# line 937 "AdaptTransform.puma"
  {
# line 938 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_IF.IF_EXP);
# line 939 "AdaptTransform.puma"
   UpdateLocal (t->ACF_IF.THEN_PART);
# line 940 "AdaptTransform.puma"
   UpdateLocal (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHERE:
# line 943 "AdaptTransform.puma"
  {
# line 944 "AdaptTransform.puma"
   UpdateFuncCall (t->ACF_WHERE.WHERE_EXP);
# line 945 "AdaptTransform.puma"
   UpdateLocal (t->ACF_WHERE.TRUE_PART);
# line 946 "AdaptTransform.puma"
   UpdateLocal (t->ACF_WHERE.FALSE_PART);
  }
   return;

  }

# line 949 "AdaptTransform.puma"
  {
# line 950 "AdaptTransform.puma"
   failure_protocol ("AdaptTransform", "UpdateLocal", t);
  }
   return;

;
}

static void UpdateFuncCall
# if defined __STDC__ | defined __cplusplus
(register tTree e)
# else
(e)
 register tTree e;
# endif
{
  if (e == NoTree) return;

  switch (e->Kind) {
  case kVAR_OBJ:
# line 963 "AdaptTransform.puma"
  {
# line 964 "AdaptTransform.puma"
 if ((GetDeclEntry (e->VAR_OBJ.Ident, GetUnitEntries ()) == e->VAR_OBJ.Object)
         && (e->VAR_OBJ.Object != NoObject))

       e->VAR_OBJ.Ident = NewUnitName (e->VAR_OBJ.Ident);

  }
   return;

  case kUSED_VAR:
# line 971 "AdaptTransform.puma"
  {
# line 972 "AdaptTransform.puma"
   UpdateFuncCall (e->USED_VAR.VARNAME);
  }
   return;

  case kLOOP_VAR:
# line 975 "AdaptTransform.puma"
   return;

  case kINDEXED_VAR:
# line 978 "AdaptTransform.puma"
  {
# line 979 "AdaptTransform.puma"
   UpdateFuncCall (e->INDEXED_VAR.IND_EXPS);
  }
   return;

  case kSUBSTRING_VAR:
# line 982 "AdaptTransform.puma"
  {
# line 983 "AdaptTransform.puma"
   UpdateFuncCall (e->SUBSTRING_VAR.IND_EXP);
  }
   return;

  case kDO_VAR:
# line 986 "AdaptTransform.puma"
  {
# line 987 "AdaptTransform.puma"
   UpdateFuncCall (e->DO_VAR.BODY);
  }
   return;

  case kBTV_LIST:
# line 990 "AdaptTransform.puma"
  {
# line 991 "AdaptTransform.puma"
   UpdateFuncCall (e->BTV_LIST.Elem);
# line 992 "AdaptTransform.puma"
   UpdateFuncCall (e->BTV_LIST.Next);
  }
   return;

  case kBTV_EMPTY:
# line 995 "AdaptTransform.puma"
   return;

  case kBTE_LIST:
# line 998 "AdaptTransform.puma"
  {
# line 999 "AdaptTransform.puma"
   UpdateFuncCall (e->BTE_LIST.Elem);
# line 1000 "AdaptTransform.puma"
   UpdateFuncCall (e->BTE_LIST.Next);
  }
   return;

  case kBTE_EMPTY:
# line 1003 "AdaptTransform.puma"
   return;

  case kADDR:
# line 1006 "AdaptTransform.puma"
  {
# line 1007 "AdaptTransform.puma"
   UpdateFuncCall (e->ADDR.E);
  }
   return;

  case kDUMMY_EXP:
# line 1010 "AdaptTransform.puma"
   return;

  case kCONST_EXP:
# line 1013 "AdaptTransform.puma"
   return;

  case kSLICE_EXP:
# line 1016 "AdaptTransform.puma"
   return;

  case kOP_EXP:
# line 1019 "AdaptTransform.puma"
  {
# line 1020 "AdaptTransform.puma"
   UpdateFuncCall (e->OP_EXP.OPND1);
# line 1021 "AdaptTransform.puma"
   UpdateFuncCall (e->OP_EXP.OPND2);
  }
   return;

  case kOP1_EXP:
# line 1024 "AdaptTransform.puma"
  {
# line 1025 "AdaptTransform.puma"
   UpdateFuncCall (e->OP1_EXP.OPND);
  }
   return;

  case kVAR_EXP:
# line 1028 "AdaptTransform.puma"
  {
# line 1029 "AdaptTransform.puma"
   UpdateFuncCall (e->VAR_EXP.V);
  }
   return;

  case kFUNC_CALL_EXP:
# line 1032 "AdaptTransform.puma"
  {
# line 1033 "AdaptTransform.puma"
   UpdateFuncCall (e->FUNC_CALL_EXP.FUNC_PARAMS);
# line 1034 "AdaptTransform.puma"
 if ((GetDeclEntry (e->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, GetUnitEntries ()) == e->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object) && (e->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object != NoObject))

       e->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = NewUnitName (e->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);

  }
   return;

  case kARRAY_EXP:
# line 1040 "AdaptTransform.puma"
  {
# line 1041 "AdaptTransform.puma"
   UpdateFuncCall (e->ARRAY_EXP.ELEMENTS);
  }
   return;

  case kDO_EXP:
# line 1044 "AdaptTransform.puma"
  {
# line 1045 "AdaptTransform.puma"
   UpdateFuncCall (e->DO_EXP.BODY);
  }
   return;

  case kBTP_LIST:
# line 1048 "AdaptTransform.puma"
  {
# line 1049 "AdaptTransform.puma"
   UpdateFuncCall (e->BTP_LIST.Elem);
# line 1050 "AdaptTransform.puma"
   UpdateFuncCall (e->BTP_LIST.Next);
  }
   return;

  case kBTP_EMPTY:
# line 1053 "AdaptTransform.puma"
   return;

  case kVAR_PARAM:
# line 1056 "AdaptTransform.puma"
  {
# line 1057 "AdaptTransform.puma"
   UpdateFuncCall (e->VAR_PARAM.V);
  }
   return;

  case kPROC_PARAM:
# line 1060 "AdaptTransform.puma"
  {
# line 1061 "AdaptTransform.puma"
 if (    (GetDeclEntry (e->PROC_PARAM.P->PROC_OBJ.Ident, GetUnitEntries ()) == e->PROC_PARAM.P->PROC_OBJ.Object)
          && (e->PROC_PARAM.P->PROC_OBJ.Object != NoObject))

       e->PROC_PARAM.P->PROC_OBJ.Ident = NewUnitName (e->PROC_PARAM.P->PROC_OBJ.Ident);

  }
   return;

  case kFUNC_PARAM:
# line 1068 "AdaptTransform.puma"
  {
# line 1069 "AdaptTransform.puma"
 if (    (GetDeclEntry (e->FUNC_PARAM.F->PROC_OBJ.Ident, GetUnitEntries ()) == e->FUNC_PARAM.F->PROC_OBJ.Object)
          && (e->FUNC_PARAM.F->PROC_OBJ.Object != NoObject))

       e->FUNC_PARAM.F->PROC_OBJ.Ident = NewUnitName (e->FUNC_PARAM.F->PROC_OBJ.Ident);

  }
   return;

  }

# line 1076 "AdaptTransform.puma"
  {
# line 1077 "AdaptTransform.puma"
   printf ("UpdateFuncCall failed (usually no problems)\n");
# line 1078 "AdaptTransform.puma"
   error_protocol ("no update of func call possible");
# line 1079 "AdaptTransform.puma"
   FileUnparse (stdout, e);
# line 1080 "AdaptTransform.puma"
   WriteTree (stdout, e);
  }
   return;

;
}

static void RemoveOverlaps
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kDECL_LIST) {
# line 1091 "AdaptTransform.puma"
  {
# line 1092 "AdaptTransform.puma"
   RemoveOverlaps (t->DECL_LIST.Elem);
# line 1093 "AdaptTransform.puma"
   RemoveOverlaps (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 1096 "AdaptTransform.puma"
  {
# line 1097 "AdaptTransform.puma"
   RemoveOverlaps (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
  }
   return;

  }
  }
  if (t->Kind == kTYPE_LIST) {
# line 1100 "AdaptTransform.puma"
  {
# line 1101 "AdaptTransform.puma"
   RemoveOverlaps (t->TYPE_LIST.Elem);
# line 1102 "AdaptTransform.puma"
   RemoveOverlaps (t->TYPE_LIST.Next);
  }
   return;

  }
  if (t->Kind == kINDEX_TYPE) {
# line 1105 "AdaptTransform.puma"
  {
# line 1106 "AdaptTransform.puma"
   t->INDEX_TYPE.left_overlap = 0;
# line 1107 "AdaptTransform.puma"
   t->INDEX_TYPE.right_overlap = 0;
  }
   return;

  }
  if (t->Kind == kDYNAMIC) {
# line 1110 "AdaptTransform.puma"
  {
# line 1111 "AdaptTransform.puma"
   t->DYNAMIC.left_overlap = 0;
# line 1112 "AdaptTransform.puma"
   t->DYNAMIC.right_overlap = 0;
  }
   return;

  }
;
}

void BeginAdaptTransform ()
{
}

void CloseAdaptTransform ()
{
}
