# include "ShowDefs.h"
# include "yyShDefs.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 8 "ShowDefs.puma"

# include "Idents.h"
# include "StringMe.h"

FILE *SemFile;


static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ShowDefs, routine %s failed\n", yyFunction);
 exit (1);
}

void ShowDeclarations ARGS((tDefinitions d));
static void ShowType ARGS((tTree t));
static void ShowDistribution ARGS((tDefinitions distribution));

void ShowDeclarations
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
# line 23 "ShowDefs.puma"

unsigned char string[256];
int varrank;

  if (d == NoDefinitions) return;

  switch (d->Kind) {
  case kSCOPE_LIST:
# line 28 "ShowDefs.puma"
  {
# line 29 "ShowDefs.puma"
   ShowDeclarations (d->SCOPE_LIST.Table);
# line 30 "ShowDefs.puma"
   ShowDeclarations (d->SCOPE_LIST.Hidden);
  }
   return;

  case kSCOPE_EMPTY:
# line 33 "ShowDefs.puma"
   return;

  case kENTRY_LIST:
# line 36 "ShowDefs.puma"
  {
# line 37 "ShowDefs.puma"
   ShowDeclarations (d->ENTRY_LIST.Next);
# line 38 "ShowDefs.puma"
   ShowDeclarations (d->ENTRY_LIST.Elem);
  }
   return;

  case kENTRY_EMPTY:
# line 41 "ShowDefs.puma"
   return;

  case kProcObject:
  if (d->ProcObject.decl->Kind == kPROC_DECL) {
# line 44 "ShowDefs.puma"
  {
# line 45 "ShowDefs.puma"
   GetString (d->ProcObject.ident, string);
# line 46 "ShowDefs.puma"
   fprintf (SemFile, "User defined subroutine %s\n", string);
  }
   return;

  }
  if (d->ProcObject.decl->Kind == kEXT_PROC_DECL) {
# line 49 "ShowDefs.puma"
  {
# line 50 "ShowDefs.puma"
   GetString (d->ProcObject.ident, string);
# line 51 "ShowDefs.puma"
   fprintf (SemFile, "External subroutine %s\n", string);
  }
   return;

  }
  if (d->ProcObject.decl->Kind == kPROC_PARAM_DECL) {
# line 54 "ShowDefs.puma"
  {
# line 55 "ShowDefs.puma"
   GetString (d->ProcObject.ident, string);
# line 56 "ShowDefs.puma"
   fprintf (SemFile, "Parameter subroutine %s\n", string);
  }
   return;

  }
  if (d->ProcObject.decl->Kind == kINTRINSIC_DECL) {
# line 59 "ShowDefs.puma"
  {
# line 60 "ShowDefs.puma"
   GetString (d->ProcObject.ident, string);
# line 61 "ShowDefs.puma"
   fprintf (SemFile, "Intrinsic subroutine %s\n", string);
  }
   return;

  }
  break;
  case kFuncObject:
  if (d->FuncObject.decl->Kind == kFUNC_DECL) {
# line 64 "ShowDefs.puma"
  {
# line 65 "ShowDefs.puma"
   GetString (d->FuncObject.ident, string);
# line 66 "ShowDefs.puma"
   fprintf (SemFile, "User-defined Function %s\n", string);
  }
   return;

  }
  if (d->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 69 "ShowDefs.puma"
  {
# line 70 "ShowDefs.puma"
   GetString (d->FuncObject.ident, string);
# line 71 "ShowDefs.puma"
   fprintf (SemFile, "Statement Function %s\n", string);
  }
   return;

  }
  if (d->FuncObject.decl->Kind == kEXT_FUNC_DECL) {
# line 74 "ShowDefs.puma"
  {
# line 75 "ShowDefs.puma"
   GetString (d->FuncObject.ident, string);
# line 76 "ShowDefs.puma"
   fprintf (SemFile, "External Function %s\n", string);
  }
   return;

  }
  if (d->FuncObject.decl->Kind == kFUNC_PARAM_DECL) {
# line 79 "ShowDefs.puma"
  {
# line 80 "ShowDefs.puma"
   GetString (d->FuncObject.ident, string);
# line 81 "ShowDefs.puma"
   fprintf (SemFile, "Parameter Function %s\n", string);
  }
   return;

  }
  if (d->FuncObject.decl->Kind == kINTRINSIC_DECL) {
# line 84 "ShowDefs.puma"
  {
# line 85 "ShowDefs.puma"
   GetString (d->FuncObject.ident, string);
# line 86 "ShowDefs.puma"
   fprintf (SemFile, "Intrinsic Function %s\n", string);
  }
   return;

  }
  break;
  case kBlockObject:
# line 89 "ShowDefs.puma"
  {
# line 90 "ShowDefs.puma"
   GetString (d->BlockObject.ident, string);
# line 91 "ShowDefs.puma"
   fprintf (SemFile, "Block Data %s\n", string);
  }
   return;

  case kVarObject:
  if (d->VarObject.Kind->Kind == kVarDummy) {
# line 94 "ShowDefs.puma"
  {
# line 95 "ShowDefs.puma"
   GetString (d->VarObject.ident, string);
# line 96 "ShowDefs.puma"
   fprintf (SemFile, "Parameter %s, type = ", string);
# line 97 "ShowDefs.puma"
   ShowType (d->VarObject.decl);
# line 98 "ShowDefs.puma"
   varrank = VarRank (d);
# line 99 "ShowDefs.puma"
   fprintf (SemFile, " rank = %d", varrank);
# line 100 "ShowDefs.puma"
   fprintf (SemFile, " uses = %d ", d->VarObject.uses);
# line 101 "ShowDefs.puma"
   fprintf (SemFile, " optional = %d ", d->VarObject.Kind->VarDummy.optional);
# line 102 "ShowDefs.puma"
   ShowDistribution (d->VarObject.Dist);
# line 103 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->VarObject.Kind->Kind == kVarConstant) {
# line 106 "ShowDefs.puma"
  {
# line 107 "ShowDefs.puma"
   GetString (d->VarObject.ident, string);
# line 108 "ShowDefs.puma"
   fprintf (SemFile, "Constant %s, val = ", string);
# line 109 "ShowDefs.puma"
   FileUnparse (SemFile, d->VarObject.Kind->VarConstant.Val);
# line 110 "ShowDefs.puma"
   fprintf (SemFile, " type = ");
# line 111 "ShowDefs.puma"
   ShowType (d->VarObject.Kind->VarConstant.Type);
# line 112 "ShowDefs.puma"
   varrank = TreeRank (d->VarObject.Kind->VarConstant.Type);
# line 113 "ShowDefs.puma"
   fprintf (SemFile, " rank = %d", varrank);
# line 114 "ShowDefs.puma"
   fprintf (SemFile, " uses = %d ", d->VarObject.uses);
# line 115 "ShowDefs.puma"
   ShowDistribution (d->VarObject.Dist);
# line 116 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->VarObject.Kind->Kind == kVarLocal) {
# line 119 "ShowDefs.puma"
  {
# line 120 "ShowDefs.puma"
   GetString (d->VarObject.ident, string);
# line 121 "ShowDefs.puma"
   fprintf (SemFile, "Local variable %s, type = ", string);
# line 122 "ShowDefs.puma"
   ShowType (d->VarObject.decl);
# line 123 "ShowDefs.puma"
 if (d->VarObject.Kind->VarLocal.IsSave != 0) fprintf (SemFile, ", save ");
# line 124 "ShowDefs.puma"
   varrank = VarRank (d);
# line 125 "ShowDefs.puma"
   fprintf (SemFile, ", rank = %d", varrank);
# line 126 "ShowDefs.puma"
   fprintf (SemFile, ", uses = %d ", d->VarObject.uses);
# line 127 "ShowDefs.puma"
   ShowDistribution (d->VarObject.Dist);
# line 128 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->VarObject.Kind->Kind == kVarCommon) {
# line 131 "ShowDefs.puma"
  {
# line 132 "ShowDefs.puma"
   GetString (d->VarObject.ident, string);
# line 133 "ShowDefs.puma"
   fprintf (SemFile, "Common Variable %s (in ", string);
# line 134 "ShowDefs.puma"
   GetString (d->VarObject.Kind->VarCommon.Block, string);
# line 135 "ShowDefs.puma"
   fprintf (SemFile, "/%s/), type = ", string);
# line 136 "ShowDefs.puma"
   ShowType (d->VarObject.decl);
# line 137 "ShowDefs.puma"
   varrank = VarRank (d);
# line 138 "ShowDefs.puma"
   fprintf (SemFile, " rank = %d", varrank);
# line 139 "ShowDefs.puma"
   fprintf (SemFile, " uses = %d ", d->VarObject.uses);
# line 140 "ShowDefs.puma"
   ShowDistribution (d->VarObject.Dist);
# line 141 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  break;
  }

  if (d->Kind == kTypeObject) {
# line 144 "ShowDefs.puma"
  {
# line 145 "ShowDefs.puma"
   GetString (d->TypeObject.ident, string);
# line 146 "ShowDefs.puma"
   fprintf (SemFile, "Type %s (derived)\n", string);
  }
   return;

  }
  if (d->Kind == kTemplateObject) {
# line 149 "ShowDefs.puma"
  {
# line 150 "ShowDefs.puma"
   GetString (d->TemplateObject.ident, string);
# line 151 "ShowDefs.puma"
   fprintf (SemFile, "Template %s, dim = (", string);
# line 152 "ShowDefs.puma"
   ShowType (d->TemplateObject.decl);
# line 153 "ShowDefs.puma"
   fprintf (SemFile, ") ");
# line 154 "ShowDefs.puma"
   ShowDistribution (d->TemplateObject.Dist);
# line 155 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->Kind == kProcessorsObject) {
# line 158 "ShowDefs.puma"
  {
# line 159 "ShowDefs.puma"
   GetString (d->ProcessorsObject.ident, string);
# line 160 "ShowDefs.puma"
   fprintf (SemFile, "Processors %s, dim = (", string);
# line 161 "ShowDefs.puma"
   ShowType (d->ProcessorsObject.decl);
# line 162 "ShowDefs.puma"
   fprintf (SemFile, ")\n");
  }
   return;

  }
  if (d->Kind == kNameListObject) {
# line 165 "ShowDefs.puma"
  {
# line 166 "ShowDefs.puma"
   GetString (d->NameListObject.ident, string);
# line 167 "ShowDefs.puma"
   fprintf (SemFile, "Namelist %s\n", string);
  }
   return;

  }
  if (Definitions_IsType (d, kObject)) {
# line 170 "ShowDefs.puma"
  {
# line 171 "ShowDefs.puma"
   GetString (d->Object.ident, string);
# line 172 "ShowDefs.puma"
   fprintf (SemFile, "Object %s\n", string);
  }
   return;

  }
;
}

static void ShowType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 183 "ShowDefs.puma"

unsigned char string[256];

  if (t == NoTree) return;

  switch (t->Kind) {
  case kDUMMY_TYPE:
# line 187 "ShowDefs.puma"
  {
# line 187 "ShowDefs.puma"
   fprintf (SemFile, "IMPLICIT");
  }
   return;

  case kINTEGER_TYPE:
# line 189 "ShowDefs.puma"
  {
# line 189 "ShowDefs.puma"
   fprintf (SemFile, "INTEGER*%d", t->INTEGER_TYPE.size);
  }
   return;

  case kBOOLEAN_TYPE:
# line 191 "ShowDefs.puma"
  {
# line 191 "ShowDefs.puma"
   fprintf (SemFile, "LOGICAL*%d", t->BOOLEAN_TYPE.size);
  }
   return;

  case kCOMPLEX_TYPE:
# line 193 "ShowDefs.puma"
  {
# line 193 "ShowDefs.puma"
   fprintf (SemFile, "COMPLEX*%d", t->COMPLEX_TYPE.size);
  }
   return;

  case kREAL_TYPE:
# line 195 "ShowDefs.puma"
  {
# line 195 "ShowDefs.puma"
   fprintf (SemFile, "REAL*%d", t->REAL_TYPE.size);
  }
   return;

  case kSTRING_TYPE:
# line 197 "ShowDefs.puma"
  {
# line 198 "ShowDefs.puma"
   fprintf (SemFile, "CHARACTER *");
# line 199 "ShowDefs.puma"
   FileUnparse (SemFile, t->STRING_TYPE.LENGTH);
  }
   return;

  case kARRAY_TYPE:
# line 202 "ShowDefs.puma"
  {
# line 203 "ShowDefs.puma"
   ShowType (t->ARRAY_TYPE.ARRAY_COMP_TYPE);
# line 204 "ShowDefs.puma"
   fprintf (SemFile, " (");
# line 205 "ShowDefs.puma"
   ShowType (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);
# line 206 "ShowDefs.puma"
   fprintf (SemFile, ")");
  }
   return;

  case kTYPE_LIST:
  if (t->TYPE_LIST.Next->Kind == kTYPE_LIST) {
# line 209 "ShowDefs.puma"
  {
# line 210 "ShowDefs.puma"
   ShowType (t->TYPE_LIST.Elem);
# line 211 "ShowDefs.puma"
   fprintf (SemFile, ",");
# line 212 "ShowDefs.puma"
   ShowType (t->TYPE_LIST.Next);
  }
   return;

  }
  if (t->TYPE_LIST.Next->Kind == kTYPE_EMPTY) {
# line 215 "ShowDefs.puma"
  {
# line 216 "ShowDefs.puma"
   ShowType (t->TYPE_LIST.Elem);
  }
   return;

  }
  break;
  case kINDEX_TYPE:
  if (equalint (t->INDEX_TYPE.left_overlap, 0)) {
  if (equalint (t->INDEX_TYPE.right_overlap, 0)) {
# line 219 "ShowDefs.puma"
  {
# line 220 "ShowDefs.puma"
   FileUnparse (SemFile, t->INDEX_TYPE.LOWER);
# line 221 "ShowDefs.puma"
   fprintf (SemFile, ":");
# line 222 "ShowDefs.puma"
   FileUnparse (SemFile, t->INDEX_TYPE.UPPER);
  }
   return;

  }
  }
# line 225 "ShowDefs.puma"
  {
# line 226 "ShowDefs.puma"
   FileUnparse (SemFile, t->INDEX_TYPE.LOWER);
# line 227 "ShowDefs.puma"
   fprintf (SemFile, ":");
# line 228 "ShowDefs.puma"
   FileUnparse (SemFile, t->INDEX_TYPE.UPPER);
# line 229 "ShowDefs.puma"
   fprintf (SemFile, "[%d:%d]", t->INDEX_TYPE.left_overlap, t->INDEX_TYPE.right_overlap);
  }
   return;

  case kDYNAMIC:
  if (equalint (t->DYNAMIC.left_overlap, 0)) {
  if (equalint (t->DYNAMIC.right_overlap, 0)) {
# line 232 "ShowDefs.puma"
  {
# line 233 "ShowDefs.puma"
   fprintf (SemFile, ":");
  }
   return;

  }
  }
# line 236 "ShowDefs.puma"
  {
# line 237 "ShowDefs.puma"
   fprintf (SemFile, ":[%d:%d]", t->DYNAMIC.left_overlap, t->DYNAMIC.right_overlap);
  }
   return;

  case kVAR_DECL:
# line 240 "ShowDefs.puma"
  {
# line 240 "ShowDefs.puma"
   ShowType (t->VAR_DECL.VAL);
  }
   return;

  case kVAR_PARAM_DECL:
# line 241 "ShowDefs.puma"
  {
# line 241 "ShowDefs.puma"
   ShowType (t->VAR_PARAM_DECL.VAL);
  }
   return;

  case kTEMPLATE_DECL:
# line 242 "ShowDefs.puma"
  {
# line 242 "ShowDefs.puma"
   ShowType (t->TEMPLATE_DECL.DIMENSIONS);
  }
   return;

  case kPROCESSORS_DECL:
# line 243 "ShowDefs.puma"
  {
# line 243 "ShowDefs.puma"
   ShowType (t->PROCESSORS_DECL.DIMENSIONS);
  }
   return;

  }

;
}

static void ShowDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions distribution)
# else
(distribution)
 register tDefinitions distribution;
# endif
{
  if (distribution == NoDefinitions) return;
  if (distribution->Kind == kDefaultDistribution) {
# line 248 "ShowDefs.puma"
  {
# line 249 "ShowDefs.puma"
   fprintf (SemFile, "default");
  }
   return;

  }
  if (distribution->Kind == kHostDistribution) {
# line 252 "ShowDefs.puma"
  {
# line 253 "ShowDefs.puma"
   fprintf (SemFile, "only host");
  }
   return;

  }
  if (distribution->Kind == kSerialDistribution) {
# line 256 "ShowDefs.puma"
  {
# line 257 "ShowDefs.puma"
   fprintf (SemFile, "replicated");
  }
   return;

  }
  if (distribution->Kind == kNodeDistribution) {
# line 260 "ShowDefs.puma"
 {
  int i;
  {
# line 261 "ShowDefs.puma"
   fprintf (SemFile, "distributed(");
# line 262 "ShowDefs.puma"

# line 263 "ShowDefs.puma"
 for (i=0; i<distribution->NodeDistribution.dims.no_dims; i++)
      { if (distribution->NodeDistribution.dims.DimsArray[i] == 0)
           fprintf (SemFile,"*");
         else if (distribution->NodeDistribution.dims.DimsArray[i] == 1)
           fprintf (SemFile,"B");
         else if (distribution->NodeDistribution.dims.DimsArray[i] == 2)
           fprintf (SemFile,"C");
         else
           fprintf (SemFile,"-");
       }

# line 274 "ShowDefs.puma"
   fprintf (SemFile, ")");
  }
   return;
 }

  }
  if (distribution->Kind == kAlignDistribution) {
# line 277 "ShowDefs.puma"
 {
  int i;
  {
# line 278 "ShowDefs.puma"
   fprintf (SemFile, "aligned(");
# line 279 "ShowDefs.puma"

# line 280 "ShowDefs.puma"
 for (i=0; i<distribution->AlignDistribution.dims.no_dims; i++)
      { if (distribution->AlignDistribution.dims.DimsArray[i] == 0)
           fprintf (SemFile,"*");
         else if (distribution->AlignDistribution.dims.DimsArray[i] == -1)
           fprintf (SemFile,"#");
         else
           fprintf (SemFile,"%d", distribution->AlignDistribution.dims.DimsArray[i]);

      }

# line 290 "ShowDefs.puma"
   fprintf (SemFile, ")");
  }
   return;
 }

  }
;
}

void BeginShowDefs ()
{
}

void CloseShowDefs ()
{
}
