# include "SetDefs.h"
# include "yySDefs.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 31 "SetDefs.puma"


# include "Idents.h"
# include "StringMe.h"
# include "protocol.h"

# include "Types.h"
# include "Transfor.h"    /* MakeFuncCall */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SetDefs, routine %s failed\n", yyFunction);
 exit (1);
}

void MakeACFDefs ARGS((tTree t));
static void MakeStmtDefs ARGS((tTree t));
static void MakeFuncCallDefs ARGS((tTree t));
static void MakeParamDefs ARGS((tTree t));
void MakeIndexDefs ARGS((tTree t));
void MakeVarDefs ARGS((tTree t));
static void MakeSubstring ARGS((tTree t));
tTree CheckExp ARGS((tTree t));
static tTree ObjTypePtr ARGS((tDefinitions v));
static tTree TreeTypePtr ARGS((tTree t));
static tTree VarSelect ARGS((tTree var, tTree stype));
static tTree MakeTypeExp ARGS((tIdent id, tTree exps));

void MakeACFDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kACF_LIST:
# line 50 "SetDefs.puma"
  {
# line 51 "SetDefs.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 52 "SetDefs.puma"
   MakeACFDefs (t->ACF_LIST.Elem);
# line 53 "SetDefs.puma"
   MakeACFDefs (t->ACF_LIST.Next);
  }
   return;

  case kACF_DUMMY:
# line 56 "SetDefs.puma"
   return;

  case kACF_EMPTY:
# line 59 "SetDefs.puma"
   return;

  case kACF_BASIC:
# line 62 "SetDefs.puma"
  {
# line 63 "SetDefs.puma"
   MakeStmtDefs (t->ACF_BASIC.BASIC_STMT);
  }
   return;

  case kACF_IF:
# line 66 "SetDefs.puma"
  {
# line 68 "SetDefs.puma"
 t->ACF_IF.IF_EXP = CheckExp (t->ACF_IF.IF_EXP);
# line 69 "SetDefs.puma"
   MakeACFDefs (t->ACF_IF.THEN_PART);
# line 70 "SetDefs.puma"
   MakeACFDefs (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHERE:
# line 73 "SetDefs.puma"
  {
# line 74 "SetDefs.puma"
 t->ACF_WHERE.WHERE_EXP = CheckExp (t->ACF_WHERE.WHERE_EXP);
# line 75 "SetDefs.puma"
   MakeACFDefs (t->ACF_WHERE.TRUE_PART);
# line 76 "SetDefs.puma"
   MakeACFDefs (t->ACF_WHERE.FALSE_PART);
  }
   return;

  case kACF_CASE:
# line 79 "SetDefs.puma"
  {
# line 80 "SetDefs.puma"
 t->ACF_CASE.CASE_EXP = CheckExp (t->ACF_CASE.CASE_EXP);
# line 81 "SetDefs.puma"
   MakeACFDefs (t->ACF_CASE.CASE_ALTS);
# line 82 "SetDefs.puma"
   MakeACFDefs (t->ACF_CASE.CASE_OTHERWISE);
  }
   return;

  case kSELECTED_ACF_LIST:
# line 85 "SetDefs.puma"
  {
# line 86 "SetDefs.puma"
   MakeACFDefs (t->SELECTED_ACF_LIST.Elem);
# line 87 "SetDefs.puma"
   MakeACFDefs (t->SELECTED_ACF_LIST.Next);
  }
   return;

  case kSELECTED_ACF_EMPTY:
# line 90 "SetDefs.puma"
   return;

  case kSELECTED_ACF_NODE:
# line 93 "SetDefs.puma"
  {
# line 94 "SetDefs.puma"
   MakeIndexDefs (t->SELECTED_ACF_NODE.SELECT_LIST);
# line 95 "SetDefs.puma"
   MakeACFDefs (t->SELECTED_ACF_NODE.SELECT_ACFS);
  }
   return;

  case kACF_WHILE:
# line 98 "SetDefs.puma"
  {
# line 99 "SetDefs.puma"
 t->ACF_WHILE.WHILE_EXP = CheckExp (t->ACF_WHILE.WHILE_EXP);
# line 101 "SetDefs.puma"
   MakeACFDefs (t->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_LOOP:
# line 104 "SetDefs.puma"
  {
# line 105 "SetDefs.puma"
   MakeACFDefs (t->ACF_LOOP.LOOP_BODY);
  }
   return;

  case kACF_DO:
# line 108 "SetDefs.puma"
  {
# line 109 "SetDefs.puma"
   MakeVarDefs (t->ACF_DO.DO_ID);
# line 110 "SetDefs.puma"
 t->ACF_DO.DO_RANGE = CheckExp (t->ACF_DO.DO_RANGE);
# line 111 "SetDefs.puma"
   MakeACFDefs (t->ACF_DO.DO_BODY);
  }
   return;

  case kACF_DOLOCAL:
# line 114 "SetDefs.puma"
  {
# line 115 "SetDefs.puma"
   MakeVarDefs (t->ACF_DOLOCAL.DOLOCAL_ID);
# line 116 "SetDefs.puma"
 t->ACF_DOLOCAL.DOLOCAL_RANGE = CheckExp (t->ACF_DOLOCAL.DOLOCAL_RANGE);
# line 117 "SetDefs.puma"
   MakeACFDefs (t->ACF_DOLOCAL.DOLOCAL_BODY);
  }
   return;

  case kACF_FORALL:
# line 120 "SetDefs.puma"
  {
# line 121 "SetDefs.puma"
   MakeVarDefs (t->ACF_FORALL.FORALL_ID);
# line 122 "SetDefs.puma"
 t->ACF_FORALL.FORALL_RANGE = CheckExp (t->ACF_FORALL.FORALL_RANGE);
# line 123 "SetDefs.puma"
   MakeACFDefs (t->ACF_FORALL.FORALL_BODY);
  }
   return;

  case kACF_DOALL:
# line 126 "SetDefs.puma"
  {
# line 127 "SetDefs.puma"
   MakeVarDefs (t->ACF_DOALL.DOALL_NEW);
# line 128 "SetDefs.puma"
   MakeVarDefs (t->ACF_DOALL.DOALL_ID);
# line 129 "SetDefs.puma"
 t->ACF_DOALL.DOALL_RANGE = CheckExp (t->ACF_DOALL.DOALL_RANGE);
# line 130 "SetDefs.puma"
   MakeACFDefs (t->ACF_DOALL.DOALL_BODY);
  }
   return;

  case kACF_ENTRY:
# line 133 "SetDefs.puma"
  {
# line 134 "SetDefs.puma"
   tree_error_protocol ("entry statement not supported", t);
  }
   return;

  }

# line 137 "SetDefs.puma"
  {
# line 138 "SetDefs.puma"
   printf ("MakeACFDefs failed\n");
# line 139 "SetDefs.puma"
   FileUnparse (stdout, t);
# line 140 "SetDefs.puma"
   WriteTree (stdout, t);
# line 141 "SetDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void MakeStmtDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 152 "SetDefs.puma"

char string[100];

  if (t == NoTree) return;

  switch (t->Kind) {
  case kASSIGN_STMT:
# line 156 "SetDefs.puma"
  {
# line 157 "SetDefs.puma"
   MakeVarDefs (t->ASSIGN_STMT.ASSIGN_VAR);
# line 158 "SetDefs.puma"
   if (! (t->ASSIGN_STMT.ASSIGN_EXP = CheckExp (t->ASSIGN_STMT.ASSIGN_EXP))) goto yyL1;
  }
   return;
yyL1:;

  break;
  case kCALL_STMT:
# line 161 "SetDefs.puma"
 {
  tDefinitions Obj;
  tTree Decl;
  {
# line 163 "SetDefs.puma"

# line 164 "SetDefs.puma"

# line 166 "SetDefs.puma"
 Obj = GetLocalDecl (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident);
     if (Obj == NoObject)
       { Obj = GetOtherDecl (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident);
         if (Obj != NoObject)
            InsertEntry (Obj);
       }
     GetString (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, string);
     if (Obj == NoObject)
       { printf ("**** subroutine %s not declared (external)\n",string);
         Decl = mEXT_PROC_DECL (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, 0, mDECL_EMPTY());
         Obj = mProcObject (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, Decl, 1, mENTRY_EMPTY());
         InsertExternalEntry (Obj);
       }
     else if (Obj->Kind != kProcObject)
       error_protocol ("Not a subroutine");

# line 182 "SetDefs.puma"
   t->CALL_STMT.CALL_ID->PROC_OBJ.Object = Obj;
# line 183 "SetDefs.puma"
   MakeParamDefs (t->CALL_STMT.CALL_PARAMS);
  }
   return;
 }

  case kIO_STMT:
# line 186 "SetDefs.puma"
  {
# line 187 "SetDefs.puma"
   MakeParamDefs (t->IO_STMT.IO_SPECS);
# line 188 "SetDefs.puma"
   MakeParamDefs (t->IO_STMT.IO_ITEMS);
  }
   return;

  case kGOTO_STMT:
# line 191 "SetDefs.puma"
   return;

  case kLABEL_ASSIGN_STMT:
# line 194 "SetDefs.puma"
  {
# line 195 "SetDefs.puma"
   MakeVarDefs (t->LABEL_ASSIGN_STMT.LABEL_VAR);
  }
   return;

  case kPTR_ASSIGN_STMT:
# line 198 "SetDefs.puma"
  {
# line 199 "SetDefs.puma"
   error_protocol ("pointer assignment not supported");
  }
   return;

  case kASS_GOTO_STMT:
# line 202 "SetDefs.puma"
  {
# line 203 "SetDefs.puma"
   MakeVarDefs (t->ASS_GOTO_STMT.GOTO_VAR);
  }
   return;

  case kCOMP_GOTO_STMT:
# line 206 "SetDefs.puma"
  {
# line 207 "SetDefs.puma"
 t->COMP_GOTO_STMT.GOTO_EXP = CheckExp (t->COMP_GOTO_STMT.GOTO_EXP);
  }
   return;

  case kCOMP_IF_STMT:
# line 210 "SetDefs.puma"
  {
# line 211 "SetDefs.puma"
 t->COMP_IF_STMT.IF_EXP = CheckExp (t->COMP_IF_STMT.IF_EXP);
  }
   return;

  case kRETURN_STMT:
# line 214 "SetDefs.puma"
  {
# line 215 "SetDefs.puma"
 t->RETURN_STMT.RETURN_EXP = CheckExp (t->RETURN_STMT.RETURN_EXP);
  }
   return;

  case kFORMAT_STMT:
# line 218 "SetDefs.puma"
   return;

  case kSTOP_STMT:
# line 221 "SetDefs.puma"
  {
# line 222 "SetDefs.puma"
 t->STOP_STMT.STOP_CONST = CheckExp (t->STOP_STMT.STOP_CONST);
  }
   return;

  case kEXIT_STMT:
# line 225 "SetDefs.puma"
   return;

  case kCYCLE_STMT:
# line 228 "SetDefs.puma"
   return;

  case kALLOCATE_STMT:
# line 231 "SetDefs.puma"
  {
# line 232 "SetDefs.puma"
   MakeParamDefs (t->ALLOCATE_STMT.PARAMS);
# line 233 "SetDefs.puma"
   MakeVarDefs (t->ALLOCATE_STMT.STAT);
  }
   return;

  case kDEALLOCATE_STMT:
# line 236 "SetDefs.puma"
  {
# line 237 "SetDefs.puma"
   MakeParamDefs (t->DEALLOCATE_STMT.PARAMS);
# line 238 "SetDefs.puma"
   MakeVarDefs (t->DEALLOCATE_STMT.STAT);
  }
   return;

  case kREDUCE_STMT:
# line 241 "SetDefs.puma"
  {
# line 242 "SetDefs.puma"
 t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Object = GetDeclEntry (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident, GetIntrinsicEntries ());
     if (!IntrFuncRed (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident))
        error_protocol ("reduce function no reduction");
     if (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Object == NoObject)
        error_protocol ("reduce function not intrinsic");

# line 248 "SetDefs.puma"
   MakeParamDefs (t->REDUCE_STMT.RED_PARAMS);
  }
   return;

  case kALIGN_STMT:
# line 251 "SetDefs.puma"
  {
# line 252 "SetDefs.puma"
   error_protocol ("realign not supported");
  }
   return;

  case kDISTRIBUTE_STMT:
# line 255 "SetDefs.puma"
  {
# line 256 "SetDefs.puma"
   error_protocol ("distribute not supported");
  }
   return;

  case kNULLIFY_STMT:
# line 259 "SetDefs.puma"
  {
# line 260 "SetDefs.puma"
   error_protocol ("nullify not supported");
  }
   return;

  }

# line 263 "SetDefs.puma"
  {
# line 264 "SetDefs.puma"
   printf ("MakeStmtDefs failed\n");
# line 265 "SetDefs.puma"
   FileUnparse (stdout, t);
# line 266 "SetDefs.puma"
   WriteTree (stdout, t);
# line 267 "SetDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void MakeFuncCallDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 278 "SetDefs.puma"

tObject Obj;
tTree   Decl;
char string[100];

  if (t == NoTree) return;
  if (t->Kind == kFUNC_CALL_EXP) {
# line 284 "SetDefs.puma"
  {
# line 289 "SetDefs.puma"
 Obj = GetLocalDecl (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
     if (Obj != NoObject)
       {
         if (Obj->Kind != kFuncObject)
           { MakeObjExternal (t, Obj);
             Obj = GetLocalDecl (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
           }
       }
      else
       { Obj = GetLocalDecl (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
         if (Obj == NoObject)
            Obj = GetOtherDecl (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
         if (Obj != NoObject)
            InsertEntry (Obj);
       }

     if (Obj == NoObject)
       { tree_protocol ("new external function detected : ", t);
         Decl = mEXT_FUNC_DECL (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, 0, mDECL_EMPTY(), mDUMMY_TYPE());
         Obj = mFuncObject (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, Decl, 1, mENTRY_EMPTY ());
         InsertExternalEntry (Obj);
         InsertEntry (Obj);
       }
      else if (Obj->Kind != kFuncObject)
         tree_error_protocol ("no function in function call ", t);
     t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object = Obj;

  }
   return;

  }
# line 318 "SetDefs.puma"
  {
# line 319 "SetDefs.puma"
   printf ("MakeFuncCallDefs failed\n");
# line 320 "SetDefs.puma"
   FileUnparse (stdout, t);
# line 321 "SetDefs.puma"
   WriteTree (stdout, t);
# line 322 "SetDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void MakeParamDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 342 "SetDefs.puma"

tObject Obj;
tTree   Decl;
char    string[100];

  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVALUE_PARAM) {
  if (t->BTP_LIST.Elem->VALUE_PARAM.E->Kind == kVAR_EXP) {
  if (t->BTP_LIST.Elem->VALUE_PARAM.E->VAR_EXP.V->Kind == kUSED_VAR) {
# line 354 "SetDefs.puma"
 {
  tDefinitions Obj;
  tTree to;
  {
# line 357 "SetDefs.puma"

# line 358 "SetDefs.puma"

# line 360 "SetDefs.puma"
   Obj = GetLocalDecl (t->BTP_LIST.Elem->VALUE_PARAM.E->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident);
# line 362 "SetDefs.puma"
   if (! (Obj != NoObject)) goto yyL1;
  {
# line 363 "SetDefs.puma"
   if (! ((Obj -> Kind == kFuncObject) || (Obj -> Kind == kProcObject))) goto yyL1;
  {
# line 364 "SetDefs.puma"
 to = mPROC_OBJ (t->BTP_LIST.Elem->VALUE_PARAM.E->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident);
     to->PROC_OBJ.Object = Obj;
     if (Obj->Kind == kFuncObject)
       t->BTP_LIST.Elem = mFUNC_PARAM (to);
      else
       t->BTP_LIST.Elem = mPROC_PARAM (to);

# line 371 "SetDefs.puma"
   MakeParamDefs (t->BTP_LIST.Next);
  }
  }
  }
   return;
 }
yyL1:;

  }
  }
# line 374 "SetDefs.puma"
  {
# line 375 "SetDefs.puma"
 t->BTP_LIST.Elem->VALUE_PARAM.E = CheckExp (t->BTP_LIST.Elem->VALUE_PARAM.E);
     if (t->BTP_LIST.Elem->VALUE_PARAM.E->Kind == kVAR_EXP)
        t->BTP_LIST.Elem = mVAR_PARAM(t->BTP_LIST.Elem->VALUE_PARAM.E->VAR_EXP.V);
      else
        t->BTP_LIST.Elem = mVAR_PARAM (mADDR (t->BTP_LIST.Elem->VALUE_PARAM.E));
# line 380 "SetDefs.puma"
   MakeParamDefs (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
  if (t->BTP_LIST.Elem->NAMED_PARAM.VAL->Kind == kVALUE_PARAM) {
# line 383 "SetDefs.puma"
  {
# line 384 "SetDefs.puma"
 t->BTP_LIST.Elem->NAMED_PARAM.VAL->VALUE_PARAM.E = CheckExp (t->BTP_LIST.Elem->NAMED_PARAM.VAL->VALUE_PARAM.E);
     if (t->BTP_LIST.Elem->NAMED_PARAM.VAL->VALUE_PARAM.E->Kind == kVAR_EXP)
        t->BTP_LIST.Elem->NAMED_PARAM.VAL = mVAR_PARAM(t->BTP_LIST.Elem->NAMED_PARAM.VAL->VALUE_PARAM.E->VAR_EXP.V);
      else
        t->BTP_LIST.Elem->NAMED_PARAM.VAL = mVAR_PARAM (mADDR (t->BTP_LIST.Elem->NAMED_PARAM.VAL->VALUE_PARAM.E));
# line 389 "SetDefs.puma"
   MakeParamDefs (t->BTP_LIST.Next);
  }
   return;

  }
  }
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 392 "SetDefs.puma"
  {
# line 393 "SetDefs.puma"
   MakeVarDefs (t->BTP_LIST.Elem->VAR_PARAM.V);
# line 394 "SetDefs.puma"
   MakeParamDefs (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
# line 397 "SetDefs.puma"
  {
# line 398 "SetDefs.puma"
   error_protocol ("no function param from parsing");
  }
   return;

  }
  if (t->BTP_LIST.Elem->Kind == kRETURN_PARAM) {
# line 401 "SetDefs.puma"
  {
# line 402 "SetDefs.puma"
   error_protocol ("actual return parameter not handled");
  }
   return;

  }
  }
  if (t->Kind == kBTP_EMPTY) {
# line 405 "SetDefs.puma"
   return;

  }
# line 408 "SetDefs.puma"
  {
# line 409 "SetDefs.puma"
   printf ("MakeParamDefs failed\n");
# line 410 "SetDefs.puma"
   FileUnparse (stdout, t);
# line 411 "SetDefs.puma"
   WriteTree (stdout, t);
# line 412 "SetDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

void MakeIndexDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTE_LIST) {
# line 426 "SetDefs.puma"
  {
# line 427 "SetDefs.puma"
   if (! (t->BTE_LIST.Elem = CheckExp (t->BTE_LIST.Elem))) goto yyL1;
  {
# line 428 "SetDefs.puma"
   MakeIndexDefs (t->BTE_LIST.Next);
  }
  }
   return;
yyL1:;

  }
  if (t->Kind == kBTE_EMPTY) {
# line 431 "SetDefs.puma"
   return;

  }
# line 434 "SetDefs.puma"
  {
# line 435 "SetDefs.puma"
   printf ("MakeIndexDefs failed\n");
# line 436 "SetDefs.puma"
   FileUnparse (stdout, t);
# line 437 "SetDefs.puma"
   WriteTree (stdout, t);
# line 438 "SetDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

void MakeVarDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kBTV_LIST:
# line 455 "SetDefs.puma"
  {
# line 456 "SetDefs.puma"
   MakeVarDefs (t->BTV_LIST.Elem);
# line 457 "SetDefs.puma"
   MakeVarDefs (t->BTV_LIST.Next);
  }
   return;

  case kBTV_EMPTY:
# line 460 "SetDefs.puma"
   return;

  case kDUMMY_VAR:
# line 463 "SetDefs.puma"
   return;

  case kUSED_VAR:
# line 466 "SetDefs.puma"
  {
# line 467 "SetDefs.puma"
   MakeVarDefs (t->USED_VAR.VARNAME);
  }
   return;

  case kLOOP_VAR:
# line 470 "SetDefs.puma"
  {
# line 471 "SetDefs.puma"
   MakeVarDefs (t->LOOP_VAR.LOOP_VARNAME);
  }
   return;

  case kDO_VAR:
# line 474 "SetDefs.puma"
  {
# line 475 "SetDefs.puma"
   MakeVarDefs (t->DO_VAR.DO_ID);
# line 476 "SetDefs.puma"
 t->DO_VAR.RANGE = CheckExp (t->DO_VAR.RANGE);
# line 477 "SetDefs.puma"
   MakeVarDefs (t->DO_VAR.BODY);
  }
   return;

  case kVAR_OBJ:
# line 486 "SetDefs.puma"
 {
  tDefinitions Obj;
  tTree type;
  {
# line 488 "SetDefs.puma"

# line 489 "SetDefs.puma"

# line 491 "SetDefs.puma"
   Obj = GetLocalDecl (t->VAR_OBJ.Ident);
# line 493 "SetDefs.puma"
 if (Obj == NoObject)
      {
        type = mDUMMY_TYPE ();
        Obj  = mVarObject (t->VAR_OBJ.Ident, mVAR_DECL (t->VAR_OBJ.Ident, t->VAR_OBJ.Pos, type),
                  mVarLocal (0,0), 0,
                  mDefaultDistribution (0,0)   ) ;
        InsertEntry (Obj);
      }
     else if (Obj->Kind == kProcObject)
      { error_protocol ("variable and not subroutine expected");
        tree_protocol ("the element is : ", t);
      }
     else if (Obj->Kind == kFuncObject)
        {
        }
     else if (Obj->Kind == kVarObject)
        {
        }

# line 512 "SetDefs.puma"
   t->VAR_OBJ.Object = Obj;
  }
   return;
 }

  case kINDEXED_VAR:
# line 521 "SetDefs.puma"
 {
  tTree tp;
  tDefinitions Obj;
  {
# line 523 "SetDefs.puma"
   MakeVarDefs (t->INDEXED_VAR.IND_VAR);
# line 524 "SetDefs.puma"
   MakeIndexDefs (t->INDEXED_VAR.IND_EXPS);
# line 528 "SetDefs.puma"

# line 529 "SetDefs.puma"

# line 531 "SetDefs.puma"
 tp = TreeTypePtr (t->INDEXED_VAR.IND_VAR);
     if (tp == NoTree)
        tree_error_protocol ("type of indexed var unknown", t);
      else if (tp->Kind == kSTRING_TYPE)
        MakeSubstring (t);
      else if (tp->Kind != kARRAY_TYPE)
        tree_error_protocol ("indexed var not an array",t);

  }
   return;
 }

  case kSELECTED_VAR:
# line 541 "SetDefs.puma"
 {
  tTree tp;
  tDefinitions Obj;
  {
# line 543 "SetDefs.puma"
   MakeVarDefs (t->SELECTED_VAR.SELEC_VAR);
# line 547 "SetDefs.puma"

# line 548 "SetDefs.puma"

# line 550 "SetDefs.puma"
 tp = TreeTypePtr (t->SELECTED_VAR.SELEC_VAR);
     if (tp == NoTree)
        tree_error_protocol ("type of var to be selected unknown", t);
      else if (tp->Kind != kTYPE_ID)
        tree_error_protocol ("type of var to be selected not derived type",t);
      else
        { Obj = tp->TYPE_ID.ID->TYPE_OBJ.Object;
          t->SELECTED_VAR.SELECTOR->REC_COMP.Object = GetDeclEntry (t->SELECTED_VAR.SELECTOR->REC_COMP.Ident, Obj->TypeObject.Components);
          if (t->SELECTED_VAR.SELECTOR->REC_COMP.Object == NoObject)
           tree_error_protocol ("component does not exist in derived type", t);
        }

  }
   return;
 }

  }

# line 564 "SetDefs.puma"
  {
# line 565 "SetDefs.puma"
   printf ("Unknown Tree for MakeVarDefs\n");
# line 566 "SetDefs.puma"
   FileUnparse (stdout, t);
# line 567 "SetDefs.puma"
   WriteTree (stdout, t);
# line 568 "SetDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void MakeSubstring
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_EXPS->Kind == kBTE_LIST) {
  if (t->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->INDEXED_VAR.IND_EXPS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 574 "SetDefs.puma"
  {
# line 575 "SetDefs.puma"
 t->INDEXED_VAR.IND_EXPS = t->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem;
    t->Kind = kSUBSTRING_VAR;

  }
   return;

  }
  }
  }
  }
# line 580 "SetDefs.puma"
  {
# line 581 "SetDefs.puma"
   tree_error_protocol ("indexed access to string illegal", t);
  }
   return;

;
}

tTree CheckExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 592 "SetDefs.puma"

tObject Obj;
int rank;
unsigned char string[256];

  switch (t->Kind) {
  case kDUMMY_EXP:
# line 597 "SetDefs.puma"
   return t;

  case kCONST_EXP:
# line 601 "SetDefs.puma"
   return t;

  case kARRAY_EXP:
# line 605 "SetDefs.puma"
  {
# line 606 "SetDefs.puma"
   MakeIndexDefs (t->ARRAY_EXP.ELEMENTS);
  }
   return t;

  case kSLICE_EXP:
# line 610 "SetDefs.puma"
  {
# line 611 "SetDefs.puma"
 t->SLICE_EXP.START = CheckExp (t->SLICE_EXP.START);
     t->SLICE_EXP.STOP  = CheckExp (t->SLICE_EXP.STOP);
     t->SLICE_EXP.INC   = CheckExp (t->SLICE_EXP.INC);

  }
   return t;

  case kOP_EXP:
# line 618 "SetDefs.puma"
  {
# line 619 "SetDefs.puma"
 t->OP_EXP.OPND1 = CheckExp (t->OP_EXP.OPND1);
     t->OP_EXP.OPND2 = CheckExp (t->OP_EXP.OPND2);

  }
   return t;

  case kOP1_EXP:
# line 625 "SetDefs.puma"
  {
# line 626 "SetDefs.puma"
 t->OP1_EXP.OPND = CheckExp (t->OP1_EXP.OPND);
  }
   return t;

  case kNAMED_EXP:
# line 630 "SetDefs.puma"
  {
# line 631 "SetDefs.puma"
 t->NAMED_EXP.VAL = CheckExp (t->NAMED_EXP.VAL);
  }
   return t;

  case kVAR_EXP:
  if (t->VAR_EXP.V->Kind == kINDEXED_VAR) {
  if (t->VAR_EXP.V->INDEXED_VAR.IND_EXPS->Kind == kBTE_LIST) {
  if (t->VAR_EXP.V->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->VAR_EXP.V->INDEXED_VAR.IND_EXPS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 636 "SetDefs.puma"
  {
# line 640 "SetDefs.puma"
   MakeVarDefs (t->VAR_EXP.V);
  }
   return t;

  }
  }
  }
  if (t->VAR_EXP.V->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 644 "SetDefs.puma"
 {
  tDefinitions Obj;
  {
# line 648 "SetDefs.puma"

# line 650 "SetDefs.puma"
   Obj = GetLocalDecl (t->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
# line 651 "SetDefs.puma"
   if (! (Obj != NoObject)) goto yyL9;
  {
# line 652 "SetDefs.puma"
   if (! (Obj -> Kind == kVarObject)) goto yyL9;
  {
# line 653 "SetDefs.puma"
   if (! (VarRank (Obj) > 0)) goto yyL9;
  {
# line 657 "SetDefs.puma"
   MakeIndexDefs (t->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
# line 658 "SetDefs.puma"
   t->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object = Obj;
  }
  }
  }
  }
  {
   return t;
  }
 }
yyL9:;

# line 662 "SetDefs.puma"
 {
  tDefinitions Obj;
  tTree e;
  {
# line 666 "SetDefs.puma"

# line 668 "SetDefs.puma"
   Obj = GetGlobalDecl (t->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
# line 669 "SetDefs.puma"
   if (! (Obj != NoObject)) goto yyL10;
  {
# line 670 "SetDefs.puma"
   if (! (Obj -> Kind == kTypeObject)) goto yyL10;
  {
# line 674 "SetDefs.puma"
   MakeIndexDefs (t->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
# line 676 "SetDefs.puma"

# line 678 "SetDefs.puma"
  e = mTYPE_OBJ (t->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
      e->TYPE_OBJ.Object = GetGlobalDecl (t->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
      e = mTYPE_EXP (e, t->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
  }
  }
  }
  {
   return e;
  }
 }
yyL10:;

# line 685 "SetDefs.puma"
 {
  tTree f;
  {
# line 689 "SetDefs.puma"

# line 691 "SetDefs.puma"
   MakeIndexDefs (t->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
# line 692 "SetDefs.puma"
   f = MakeFuncCall (t->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, t->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
# line 693 "SetDefs.puma"
   MakeFuncCallDefs (f);
  }
  {
   return f;
  }
 }

  }
  }
# line 698 "SetDefs.puma"
  {
# line 702 "SetDefs.puma"
   MakeVarDefs (t->VAR_EXP.V);
  }
   return t;

  case kFUNC_CALL_EXP:
# line 706 "SetDefs.puma"
   return t;

  case kDO_EXP:
# line 710 "SetDefs.puma"
  {
# line 711 "SetDefs.puma"
   MakeVarDefs (t->DO_EXP.DO_ID);
# line 712 "SetDefs.puma"
 t->DO_EXP.RANGE = CheckExp (t->DO_EXP.RANGE);
# line 713 "SetDefs.puma"
   MakeIndexDefs (t->DO_EXP.BODY);
  }
   return t;

  }

# line 717 "SetDefs.puma"
  {
# line 718 "SetDefs.puma"
   printf ("CheckExp failed\n");
# line 719 "SetDefs.puma"
   FileUnparse (stdout, t);
# line 720 "SetDefs.puma"
   WriteTree (stdout, t);
# line 721 "SetDefs.puma"
   kill_in_protocol ();
  }
   return t;

}

static tTree ObjTypePtr
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_DECL) {
# line 740 "SetDefs.puma"
   return v->VarObject.decl->VAR_DECL.VAL;

  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 744 "SetDefs.puma"
   return v->VarObject.decl->VAR_PARAM_DECL.VAL;

  }
# line 748 "SetDefs.puma"
  {
# line 749 "SetDefs.puma"
   printf ("Unknown VarObject for ObjTypePtr\n");
# line 750 "SetDefs.puma"
   FileUnparse (stdout, v->VarObject.decl);
# line 751 "SetDefs.puma"
   exit (- 1);
  }
   return NoTree;

  }
# line 755 "SetDefs.puma"
  {
# line 756 "SetDefs.puma"
   printf ("Unknown Object for ObjTypePtr\n");
# line 757 "SetDefs.puma"
   FileUnparse (stdout, v->Object.decl);
# line 758 "SetDefs.puma"
   exit (- 1);
  }
   return NoTree;

}

static tTree TreeTypePtr
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 772 "SetDefs.puma"
 tTree result;
  if (t->Kind == kVAR_OBJ) {
# line 774 "SetDefs.puma"
  {
# line 775 "SetDefs.puma"
 if (t->VAR_OBJ.Object != NoObject)
         result = ObjTypePtr (t->VAR_OBJ.Object);
        else
         result = NoTree;
  }
   return result;

  }
  if (t->Kind == kUSED_VAR) {
# line 782 "SetDefs.puma"
   return TreeTypePtr (t->USED_VAR.VARNAME);

  }
  if (t->Kind == kLOOP_VAR) {
# line 786 "SetDefs.puma"
   return TreeTypePtr (t->LOOP_VAR.LOOP_VARNAME);

  }
  if (t->Kind == kINDEXED_VAR) {
# line 790 "SetDefs.puma"
   return VarSelect (t, TreeTypePtr (t->INDEXED_VAR.IND_VAR));

  }
  if (t->Kind == kSELECTED_VAR) {
# line 794 "SetDefs.puma"
  {
# line 795 "SetDefs.puma"
 if (t->SELECTED_VAR.SELECTOR->REC_COMP.Object != NoObject)
         result = ObjTypePtr (t->SELECTED_VAR.SELECTOR->REC_COMP.Object);
        else
         result = NoTree;
  }
   return result;

  }
 yyAbort ("TreeTypePtr");
}

static tTree VarSelect
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stype)
# else
(var, stype)
 register tTree var;
 register tTree stype;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (stype->Kind == kARRAY_TYPE) {
# line 804 "SetDefs.puma"
   return stype->ARRAY_TYPE.ARRAY_COMP_TYPE;

  }
# line 808 "SetDefs.puma"
   return NoTree;

  }
# line 812 "SetDefs.puma"
  {
# line 813 "SetDefs.puma"
   printf ("Illegal VarSelect, var = ");
# line 814 "SetDefs.puma"
   FileUnparse (stdout, var);
# line 815 "SetDefs.puma"
   printf (" with type ");
# line 816 "SetDefs.puma"
   FileUnparse (stdout, stype);
# line 817 "SetDefs.puma"
   kill_in_protocol ();
# line 818 "SetDefs.puma"
   exit (- 1);
  }
   return stype;

}

static tTree MakeTypeExp
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree exps)
# else
(id, exps)
 register tIdent id;
 register tTree exps;
# endif
{
# line 830 "SetDefs.puma"

tTree v;

# line 834 "SetDefs.puma"
  {
# line 835 "SetDefs.puma"
 v = mTYPE_OBJ (id);
      v->TYPE_OBJ.Object = GetGlobalDecl (id);
      v = mTYPE_EXP (v, exps);
  }
   return v;

}

void BeginSetDefs ()
{
}

void CloseSetDefs ()
{
}
