# include "SemDecls.h"
# include "yySDecls.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 38 "SemDecls.puma"

# include "Idents.h"
# include "StringMe.h"
# include "Types.h"
# include "protocol.h"


# include "SemExp.h"  /* import SemExp  */

int IsDistributed;   /* global variable needed for GetArrayKind */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemDecls, routine %s failed\n", yyFunction);
 exit (1);
}

void SemDeclarations ARGS((tTree t, tTree current_unit));
static void UpdateCommon ARGS((tDefinitions t, tTree common, bool is_main));
void SemDefinitions ARGS((tDefinitions t));
static void SemObjectType ARGS((tDefinitions o));
static bool CorrectType ARGS((tTree t));
static void GetArrayKind ARGS((tTree t, int * yyP2, int * yyP1));
static int GetOverlap ARGS((tTree elem));
static int LocalSize ARGS((int size, int overlap, int MinProc));
static int TypeCombination ARGS((int kind1, int kind2));
static bool CheckArrayKind ARGS((tTree type, tDefinitions desc, tDefinitions dist));
static void SetDefaultDistribution ARGS((tDefinitions t));
static tDefinitions GetDefaultDistribution ARGS((tTree d));
static tDefinitions MakeLastDimDistribution ARGS((int rank));
static tDefinitions EvalAlignDistribution ARGS((tDefinitions d, int rank));
static int GetCommonDistVars ARGS((tTree t));
static void MatchCommonDecls ARGS((tTree cd1, tTree cd2, bool only_warning));
static int GetCommonSize ARGS((tTree t));
static int GetTypeSize ARGS((tTree t));
static int GetIndexSize ARGS((tTree t));

void SemDeclarations
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree current_unit)
# else
(t, current_unit)
 register tTree t;
 register tTree current_unit;
# endif
{
  if (t == NoTree) return;
  if (current_unit == NoTree) return;

  switch (t->Kind) {
  case kDECL_EMPTY:
# line 61 "SemDecls.puma"
   return;

  case kDECL_LIST:
# line 64 "SemDecls.puma"
  {
# line 65 "SemDecls.puma"
   SemDeclarations (t->DECL_LIST.Elem, current_unit);
# line 66 "SemDecls.puma"
   SemDeclarations (t->DECL_LIST.Next, current_unit);
  }
   return;

  case kVAR_DECL:
# line 75 "SemDecls.puma"
   return;

  case kTEMPLATE_DECL:
# line 79 "SemDecls.puma"
   return;

  case kDIMENSION_DECL:
# line 83 "SemDecls.puma"
  {
# line 84 "SemDecls.puma"
   error_protocol ("there should be no longer any DIMENSION_DECL");
  }
   return;

  case kPARAMETER_DECL:
# line 87 "SemDecls.puma"
   return;

  case kCOMMON_DECL:
# line 91 "SemDecls.puma"
  {
# line 95 "SemDecls.puma"
   UpdateCommon (GetDeclEntry (t->COMMON_DECL.Name, GetCommonEntries ()), t, (current_unit -> Kind == kPROGRAM_DECL));
  }
   return;

  case kNAMELIST_DECL:
# line 99 "SemDecls.puma"
   return;

  case kEQV_DECL:
# line 103 "SemDecls.puma"
   return;

  case kDATA_DECL:
# line 107 "SemDecls.puma"
   return;

  case kSAVE_DECL:
# line 110 "SemDecls.puma"
   return;

  case kSEQUENCE_DECL:
# line 114 "SemDecls.puma"
   return;

  case kNOSEQUENCE_DECL:
# line 117 "SemDecls.puma"
   return;

  case kEXT_PROC_DECL:
# line 120 "SemDecls.puma"
   return;

  case kEXTERNAL_DECL:
# line 123 "SemDecls.puma"
   return;

  case kINTRINSIC_DECL:
# line 126 "SemDecls.puma"
   return;

  case kIMPLICIT_DECL:
# line 129 "SemDecls.puma"
   return;

  case kDISTRIBUTE_DECL:
# line 133 "SemDecls.puma"
   return;

  case kALIGN_DECL:
# line 137 "SemDecls.puma"
   return;

  case kSTMT_FUNC_DECL:
# line 141 "SemDecls.puma"
   return;

  }

# line 145 "SemDecls.puma"
  {
# line 146 "SemDecls.puma"
   failure_protocol ("SemDecls", "SemDeclarations", t);
  }
   return;

;
}

static void UpdateCommon
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t, register tTree common, register bool is_main)
# else
(t, common, is_main)
 register tDefinitions t;
 register tTree common;
 register bool is_main;
# endif
{
# line 157 "SemDecls.puma"

char msg[150];

  if (t == NoDefinitions) return;
  if (common == NoTree) return;
# line 161 "SemDecls.puma"
  {
# line 165 "SemDecls.puma"
   if (! ((t == NoObject))) goto yyL1;
  {
# line 166 "SemDecls.puma"
   tree_error_protocol ("No Object for Common", common);
  }
  }
   return;
yyL1:;

  if (t->Kind == kCommonObject) {
# line 169 "SemDecls.puma"
  {
# line 171 "SemDecls.puma"
   if (! ((t->CommonObject.decl == common))) goto yyL2;
  {
# line 173 "SemDecls.puma"
 t->CommonObject.size        = GetCommonSize     (common);
     t->CommonObject.distributed_vars = GetCommonDistVars (common);
     t->CommonObject.main     = is_main;

  }
  }
   return;
yyL2:;

# line 179 "SemDecls.puma"
 {
  int no;
  int size;
  {
# line 183 "SemDecls.puma"

# line 184 "SemDecls.puma"

# line 186 "SemDecls.puma"
 t->CommonObject.main = t->CommonObject.main || is_main;
     no = GetCommonDistVars (common);
     if (no != t->CommonObject.distributed_vars)
       { simple_error_protocol ("different distributions in common");
         sprintf (msg,"this use has %d distributed variables", t->CommonObject.distributed_vars);
         tree_protocol (msg, t->CommonObject.decl);
         sprintf (msg,"this use has %d distributed variables", no);
         tree_protocol (msg, common);
       }
     size = GetCommonSize (common);
     if (size != t->CommonObject.size)
       { if (t->CommonObject.distributed_vars > 0)
           simple_error_protocol ("incompatible lengths for common block data");
          else
           simple_warning_protocol
              ("incompatible lengths for common block data");
         sprintf (msg,"first use has size %d : ", t->CommonObject.size);
         tree_protocol (msg, t->CommonObject.decl);
         sprintf (msg,"this use has size %d : ", size);
         tree_protocol (msg, common);
     }
     MatchCommonDecls (t->CommonObject.decl, common, (t->CommonObject.distributed_vars == 0));


  }
   return;
 }

  }
# line 212 "SemDecls.puma"
  {
# line 213 "SemDecls.puma"
   failure_protocol ("SemDecls", "UpdateCommon", common);
  }
   return;

;
}

void SemDefinitions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t == NoDefinitions) return;

  switch (t->Kind) {
  case kENTRY_LIST:
# line 226 "SemDecls.puma"
  {
# line 227 "SemDecls.puma"
   SemObjectType (t->ENTRY_LIST.Elem);
# line 229 "SemDecls.puma"
   SetDefaultDistribution (t->ENTRY_LIST.Elem);
# line 230 "SemDecls.puma"
   SemDefinitions (t->ENTRY_LIST.Elem);
# line 231 "SemDecls.puma"
   SemDefinitions (t->ENTRY_LIST.Next);
  }
   return;

  case kENTRY_EMPTY:
# line 234 "SemDecls.puma"
   return;

  case kVarObject:
  if (t->VarObject.decl->Kind == kVAR_DECL) {
# line 237 "SemDecls.puma"
  {
# line 238 "SemDecls.puma"
 if (!CheckArrayKind (t->VarObject.decl->VAR_DECL.VAL, t->VarObject.Kind, t->VarObject.Dist))
         obj_error_protocol ("Array Declaration illegal ", t);

  }
   return;

  }
  if (t->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 243 "SemDecls.puma"
  {
# line 244 "SemDecls.puma"
 if (!CheckArrayKind (t->VarObject.decl->VAR_PARAM_DECL.VAL, t->VarObject.Kind, t->VarObject.Dist))
          tree_error_protocol ("Array Declaration illegal ", t->VarObject.decl);

  }
   return;

  }
  if (t->VarObject.decl->Kind == kPARAMETER_DECL) {
  if (t->VarObject.Kind->Kind == kVarConstant) {
# line 249 "SemDecls.puma"
   return;

  }
  }
  break;
  case kTemplateObject:
  if (t->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
# line 252 "SemDecls.puma"
   return;

  }
  break;
  case kProcessorsObject:
  if (t->ProcessorsObject.decl->Kind == kPROCESSORS_DECL) {
# line 257 "SemDecls.puma"
   return;

  }
  break;
  case kFuncObject:
  if (t->FuncObject.decl->Kind == kFUNC_DECL) {
# line 261 "SemDecls.puma"
   return;

  }
  if (t->FuncObject.decl->Kind == kEXT_FUNC_DECL) {
# line 265 "SemDecls.puma"
   return;

  }
  if (t->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 269 "SemDecls.puma"
   return;

  }
  if (t->FuncObject.decl->Kind == kFUNC_PARAM_DECL) {
# line 273 "SemDecls.puma"
   return;

  }
  if (t->FuncObject.decl->Kind == kINTRINSIC_DECL) {
# line 277 "SemDecls.puma"
   return;

  }
  break;
  case kProcObject:
  if (t->ProcObject.decl->Kind == kPROC_DECL) {
# line 281 "SemDecls.puma"
   return;

  }
  if (t->ProcObject.decl->Kind == kEXT_PROC_DECL) {
# line 284 "SemDecls.puma"
   return;

  }
  if (t->ProcObject.decl->Kind == kINTRINSIC_DECL) {
# line 287 "SemDecls.puma"
   return;

  }
  if (t->ProcObject.decl->Kind == kPROC_PARAM_DECL) {
# line 290 "SemDecls.puma"
   return;

  }
  break;
  }

  if (t->Kind == kTypeObject) {
# line 293 "SemDecls.puma"
  {
# line 294 "SemDecls.puma"
   SemDefinitions (t->TypeObject.Components);
  }
   return;

  }
  if (t->Kind == kNameListObject) {
# line 297 "SemDecls.puma"
   return;

  }
  if (Definitions_IsType (t, kObject)) {
# line 300 "SemDecls.puma"
  {
# line 302 "SemDecls.puma"
   tree_error_protocol ("Unknown/Illegal object in Semantic Analysis : ", t->Object.decl);
  }
   return;

  }
;
}

static void SemObjectType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions o)
# else
(o)
 register tDefinitions o;
# endif
{
  if (o == NoDefinitions) return;
  if (o->Kind == kVarObject) {
  if (o->VarObject.decl->Kind == kVAR_DECL) {
# line 315 "SemDecls.puma"
  {
# line 316 "SemDecls.puma"
   if (! ((! CorrectType (o->VarObject.decl->VAR_DECL.VAL)))) goto yyL1;
  {
# line 317 "SemDecls.puma"
   obj_error_protocol ("Illegal type in variable declaration : ", o);
  }
  }
   return;
yyL1:;

  }
  if (o->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 320 "SemDecls.puma"
  {
# line 321 "SemDecls.puma"
   if (! ((! CorrectType (o->VarObject.decl->VAR_PARAM_DECL.VAL)))) goto yyL2;
  {
# line 322 "SemDecls.puma"
   obj_error_protocol ("Illegal type for dummy declaration : ", o);
  }
  }
   return;
yyL2:;

  }
  if (o->VarObject.decl->Kind == kPARAMETER_DECL) {
  if (o->VarObject.Kind->Kind == kVarConstant) {
# line 325 "SemDecls.puma"
  {
# line 326 "SemDecls.puma"
   if (! ((! CorrectType (o->VarObject.Kind->VarConstant.Type)))) goto yyL3;
  {
# line 327 "SemDecls.puma"
   obj_error_protocol ("Illegal type for constant value : ", o);
  }
  }
   return;
yyL3:;

  }
  }
  }
  if (o->Kind == kFuncObject) {
  if (o->FuncObject.decl->Kind == kFUNC_DECL) {
# line 330 "SemDecls.puma"
  {
# line 331 "SemDecls.puma"
   if (! ((! CorrectType (o->FuncObject.decl->FUNC_DECL.RESULT_TYPE)))) goto yyL4;
  {
# line 332 "SemDecls.puma"
   obj_error_protocol ("Illegal result type for user function: ", o);
  }
  }
   return;
yyL4:;

  }
  if (o->FuncObject.decl->Kind == kEXT_FUNC_DECL) {
# line 335 "SemDecls.puma"
  {
# line 336 "SemDecls.puma"
   if (! ((! CorrectType (o->FuncObject.decl->EXT_FUNC_DECL.RESULT_TYPE)))) goto yyL5;
  {
# line 337 "SemDecls.puma"
   obj_error_protocol ("Illegal result type for external function: ", o);
  }
  }
   return;
yyL5:;

  }
  if (o->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 340 "SemDecls.puma"
  {
# line 341 "SemDecls.puma"
   if (! ((! CorrectType (o->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE)))) goto yyL6;
  {
# line 342 "SemDecls.puma"
   obj_error_protocol ("Illegal result type for statement function: ", o);
  }
  }
   return;
yyL6:;

  }
  if (o->FuncObject.decl->Kind == kFUNC_PARAM_DECL) {
# line 345 "SemDecls.puma"
  {
# line 346 "SemDecls.puma"
   if (! ((! CorrectType (o->FuncObject.decl->FUNC_PARAM_DECL.RESULT_TYPE)))) goto yyL7;
  {
# line 347 "SemDecls.puma"
   obj_error_protocol ("Illegal result type for formal function: ", o);
  }
  }
   return;
yyL7:;

  }
  }
;
}

static bool CorrectType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return false;

  switch (t->Kind) {
  case kDUMMY_TYPE:
# line 358 "SemDecls.puma"
  {
# line 359 "SemDecls.puma"
   tree_protocol ("Dummy Type not allowed", t);
# line 360 "SemDecls.puma"
   return false;
  }

  case kINTEGER_TYPE:
  if (equalint (t->INTEGER_TYPE.size, 4)) {
# line 363 "SemDecls.puma"
   return true;

  }
# line 366 "SemDecls.puma"
  {
# line 367 "SemDecls.puma"
   tree_protocol ("Only INTEGER*4 allowed, not : ", t);
# line 368 "SemDecls.puma"
   return false;
  }

  case kREAL_TYPE:
  if (equalint (t->REAL_TYPE.size, 4)) {
# line 371 "SemDecls.puma"
   return true;

  }
  if (equalint (t->REAL_TYPE.size, 8)) {
# line 372 "SemDecls.puma"
   return true;

  }
# line 374 "SemDecls.puma"
  {
# line 375 "SemDecls.puma"
   tree_protocol ("Only REAL*4 | REAL*8 allowed, not : ", t);
# line 376 "SemDecls.puma"
   return false;
  }

  case kBOOLEAN_TYPE:
  if (equalint (t->BOOLEAN_TYPE.size, 1)) {
# line 379 "SemDecls.puma"
   return true;

  }
  if (equalint (t->BOOLEAN_TYPE.size, 4)) {
# line 380 "SemDecls.puma"
   return true;

  }
# line 382 "SemDecls.puma"
  {
# line 383 "SemDecls.puma"
   tree_protocol ("Only LOGICAL*1 | LOGICAL*4 allowed, not : ", t);
# line 384 "SemDecls.puma"
   return false;
  }

  case kCOMPLEX_TYPE:
  if (equalint (t->COMPLEX_TYPE.size, 8)) {
# line 387 "SemDecls.puma"
   return true;

  }
  if (equalint (t->COMPLEX_TYPE.size, 16)) {
# line 388 "SemDecls.puma"
   return true;

  }
# line 390 "SemDecls.puma"
  {
# line 391 "SemDecls.puma"
   tree_protocol ("Only COMPLEX*8 | COMPLEX*16 allowed, not : ", t);
# line 392 "SemDecls.puma"
   return false;
  }

  case kCHAR_TYPE:
# line 395 "SemDecls.puma"
   return true;

  case kSTRING_TYPE:
  if (t->STRING_TYPE.LENGTH->Kind == kDUMMY_EXP) {
# line 397 "SemDecls.puma"
   return true;

  }
# line 399 "SemDecls.puma"
 {
  int rank;
  {
# line 401 "SemDecls.puma"

# line 402 "SemDecls.puma"
   SemExp (t->STRING_TYPE.LENGTH, & rank);
# line 403 "SemDecls.puma"
   if (! ((TreeRank (t->STRING_TYPE.LENGTH) != 0))) goto yyL15;
  {
# line 404 "SemDecls.puma"
   tree_protocol ("rank of string length not equal 0 : ", t);
# line 405 "SemDecls.puma"
   return false;
  }
  }
 }
yyL15:;

# line 408 "SemDecls.puma"
 {
  int len;
  bool found;
  {
# line 409 "SemDecls.puma"

# line 410 "SemDecls.puma"

# line 411 "SemDecls.puma"
   GetIntConstValue (t->STRING_TYPE.LENGTH, & found, & len);
# line 412 "SemDecls.puma"
   if (! (found == true)) goto yyL16;
  }
   return true;
 }
yyL16:;

# line 415 "SemDecls.puma"
  {
# line 416 "SemDecls.puma"
   tree_protocol ("string length unknown : ", t->STRING_TYPE.LENGTH);
# line 417 "SemDecls.puma"
   return false;
  }

  case kARRAY_TYPE:
# line 420 "SemDecls.puma"
  {
# line 421 "SemDecls.puma"
   if (! (CorrectType (t->ARRAY_TYPE.ARRAY_INDEX_TYPES))) goto yyL18;
  {
# line 422 "SemDecls.puma"
   if (! (CorrectType (t->ARRAY_TYPE.ARRAY_COMP_TYPE))) goto yyL18;
  }
  }
   return true;
yyL18:;

  break;
  case kTYPE_LIST:
# line 425 "SemDecls.puma"
  {
# line 426 "SemDecls.puma"
   if (! (CorrectType (t->TYPE_LIST.Elem))) goto yyL19;
  {
# line 427 "SemDecls.puma"
   if (! (CorrectType (t->TYPE_LIST.Next))) goto yyL19;
  }
  }
   return true;
yyL19:;

  break;
  case kTYPE_EMPTY:
# line 430 "SemDecls.puma"
   return true;

  case kINDEX_TYPE:
# line 433 "SemDecls.puma"
 {
  int rank;
  {
# line 435 "SemDecls.puma"

# line 436 "SemDecls.puma"
   SemExp (t->INDEX_TYPE.LOWER, & rank);
# line 437 "SemDecls.puma"
   if (! ((rank != 0))) goto yyL21;
  {
# line 438 "SemDecls.puma"
   tree_protocol ("Tree Rank lower bound in DIMENSION > 0 : ", t);
# line 439 "SemDecls.puma"
   return false;
  }
  }
 }
yyL21:;

# line 442 "SemDecls.puma"
 {
  int rank;
  {
# line 444 "SemDecls.puma"

# line 445 "SemDecls.puma"
   SemExp (t->INDEX_TYPE.UPPER, & rank);
# line 446 "SemDecls.puma"
   if (! ((rank != 0))) goto yyL22;
  {
# line 447 "SemDecls.puma"
   tree_protocol ("Tree Rank upper bound in DIMENSION > 0 : ", t);
# line 448 "SemDecls.puma"
   return false;
  }
  }
 }
yyL22:;

# line 451 "SemDecls.puma"
   return true;

  case kDYNAMIC:
# line 454 "SemDecls.puma"
   return true;

  case kTYPE_ID:
# line 460 "SemDecls.puma"
   return true;

  }

  return false;
}

static void GetArrayKind
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int * yyP2, register int * yyP1)
# else
(t, yyP2, yyP1)
 register tTree t;
 register int * yyP2;
 register int * yyP1;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kINDEX_TYPE) {
  if (t->INDEX_TYPE.UPPER->Kind == kDUMMY_EXP) {
# line 481 "SemDecls.puma"
   * yyP2 = arr_assumed_size;
   * yyP1 = 0;
   return;

  }
# line 485 "SemDecls.puma"
 {
  int k;
  int size;
  int val;
  bool found;
  {
# line 489 "SemDecls.puma"

# line 490 "SemDecls.puma"

# line 491 "SemDecls.puma"

# line 492 "SemDecls.puma"

# line 494 "SemDecls.puma"
   GetIntConstValue (t->INDEX_TYPE.LOWER, & found, & val);
# line 495 "SemDecls.puma"
   if (! (found)) goto yyL2;
  {
# line 496 "SemDecls.puma"
   GetIntConstValue (t->INDEX_TYPE.UPPER, & found, & size);
# line 497 "SemDecls.puma"
   if (! (found)) goto yyL2;
  {
# line 498 "SemDecls.puma"
   size = size - val + 1 + t->INDEX_TYPE.left_overlap + t->INDEX_TYPE.right_overlap;
  }
  }
  }
   * yyP2 = arr_fixed_size;
   * yyP1 = size;
   return;
 }
yyL2:;

# line 501 "SemDecls.puma"
   * yyP2 = arr_automatic;
   * yyP1 = 0;
   return;

  }
  if (t->Kind == kDYNAMIC) {
# line 506 "SemDecls.puma"
   * yyP2 = 2;
   * yyP1 = 0;
   return;

  }
  if (t->Kind == kARRAY_TYPE) {
# line 521 "SemDecls.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 523 "SemDecls.puma"
   GetArrayKind (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (t->Kind == kTYPE_LIST) {
  if (t->TYPE_LIST.Next->Kind == kTYPE_EMPTY) {
# line 526 "SemDecls.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 528 "SemDecls.puma"
   GetArrayKind (t->TYPE_LIST.Elem, & yyV1, & yyV2);
# line 530 "SemDecls.puma"
 if (IsDistributed)
        yyV2 = LocalSize (yyV2, GetOverlap(t->TYPE_LIST.Elem), MinProc);

  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
# line 535 "SemDecls.puma"
 {
  int yyV1;
  int yyV2;
  int yyV3;
  int yyV4;
  {
# line 537 "SemDecls.puma"
   GetArrayKind (t->TYPE_LIST.Elem, & yyV1, & yyV2);
# line 538 "SemDecls.puma"
   GetArrayKind (t->TYPE_LIST.Next, & yyV3, & yyV4);
  }
   * yyP2 = TypeCombination (yyV1, yyV3);
   * yyP1 = yyV2 * yyV4;
   return;
 }

  }
# line 541 "SemDecls.puma"
  {
# line 542 "SemDecls.puma"
   printf ("GetArrayKind fails\n");
# line 543 "SemDecls.puma"
   kill_in_protocol ();
  }
   * yyP2 = 0;
   * yyP1 = 0;
   return;

;
}

static int GetOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree elem)
# else
(elem)
 register tTree elem;
# endif
{
  if (elem->Kind == kINDEX_TYPE) {
# line 548 "SemDecls.puma"
   return elem->INDEX_TYPE.left_overlap + elem->INDEX_TYPE.right_overlap;

  }
  if (elem->Kind == kDYNAMIC) {
# line 552 "SemDecls.puma"
   return elem->DYNAMIC.left_overlap + elem->DYNAMIC.right_overlap;

  }
 yyAbort ("GetOverlap");
}

static int LocalSize
# if defined __STDC__ | defined __cplusplus
(register int size, register int overlap, register int MinProc)
# else
(size, overlap, MinProc)
 register int size;
 register int overlap;
 register int MinProc;
# endif
{
  if (equalint (size, 0)) {
# line 558 "SemDecls.puma"
   return 0;

  }
# line 562 "SemDecls.puma"
 {
  int lsize;
  {
# line 563 "SemDecls.puma"

# line 564 "SemDecls.puma"
 lsize = size - overlap;
     lsize = (lsize + MinProc - 1) / MinProc;
     lsize = lsize + overlap;

  }
  {
   return lsize;
  }
 }

}

static int TypeCombination
# if defined __STDC__ | defined __cplusplus
(register int kind1, register int kind2)
# else
(kind1, kind2)
 register int kind1;
 register int kind2;
# endif
{
  if (equalint (kind1, arr_illegal)) {
# line 573 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind2, arr_illegal)) {
# line 575 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind1, arr_allocatable)) {
  if (equalint (kind2, arr_allocatable)) {
# line 577 "SemDecls.puma"
   return arr_allocatable;

  }
  }
  if (equalint (kind1, arr_allocatable)) {
# line 580 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind2, arr_allocatable)) {
# line 583 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind1, arr_assumed_size)) {
# line 586 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind1, arr_fixed_size)) {
  if (equalint (kind2, arr_fixed_size)) {
# line 589 "SemDecls.puma"
   return arr_fixed_size;

  }
  }
  if (equalint (kind1, arr_fixed_size)) {
  if (equalint (kind2, arr_automatic)) {
# line 592 "SemDecls.puma"
   return arr_automatic;

  }
  }
  if (equalint (kind1, arr_fixed_size)) {
  if (equalint (kind2, arr_assumed_size)) {
# line 595 "SemDecls.puma"
   return arr_assumed_size;

  }
  }
  if (equalint (kind1, arr_automatic)) {
  if (equalint (kind2, arr_fixed_size)) {
# line 598 "SemDecls.puma"
   return arr_fixed_size;

  }
  }
  if (equalint (kind1, arr_automatic)) {
  if (equalint (kind2, arr_automatic)) {
# line 601 "SemDecls.puma"
   return arr_automatic;

  }
  }
  if (equalint (kind1, arr_automatic)) {
  if (equalint (kind2, arr_assumed_size)) {
# line 604 "SemDecls.puma"
   return arr_assumed_size;

  }
  }
 yyAbort ("TypeCombination");
}

static bool CheckArrayKind
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tDefinitions desc, register tDefinitions dist)
# else
(type, desc, dist)
 register tTree type;
 register tDefinitions desc;
 register tDefinitions dist;
# endif
{
# line 611 "SemDecls.puma"

int  k, size;
bool okay;

  if (type->Kind == kARRAY_TYPE) {
  if (desc->Kind == kVarDummy) {
# line 616 "SemDecls.puma"
  {
# line 618 "SemDecls.puma"
 IsDistributed=(dist->Kind == kNodeDistribution);
     GetArrayKind (type, &k, &size);
     desc->VarDummy.dynamic = k;
     dist->Distribution.size = size;
     okay = true;
     if (k == arr_illegal)
       { print_protocol ("illegal specification for dummy variable");
         okay = false;
       }

  }
   return okay;

  }
  if (desc->Kind == kVarLocal) {
# line 631 "SemDecls.puma"
  {
# line 633 "SemDecls.puma"
 IsDistributed=(dist->Kind == kNodeDistribution);
     GetArrayKind (type, &k, &size);
     desc->VarLocal.dynamic = k;
     dist->Distribution.size = size;
     okay = true;
     if (k == arr_assumed_size)
       { print_protocol ("assumed size not allowed for local variable");
         okay = false;
       }
     if (k == arr_illegal)
       { print_protocol ("illegal specification for local variable");
         okay = false;
       }

  }
   return okay;

  }
  if (desc->Kind == kVarCommon) {
# line 650 "SemDecls.puma"
  {
# line 652 "SemDecls.puma"
 IsDistributed=(dist->Kind == kNodeDistribution);
     GetArrayKind (type, &k, &size);
     dist->Distribution.size = size;
     okay = true;
     if (k != arr_fixed_size)
       { okay = false;
         print_protocol ("size of common variable is unknown");
       }

  }
   return okay;

  }
  }
# line 664 "SemDecls.puma"
   return true;

}

static void SetDefaultDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t == NoDefinitions) return;
  if (t->Kind == kVarObject) {
  if (t->VarObject.Kind->Kind == kVarCommon) {
  if (t->VarObject.Dist->Kind == kDefaultDistribution) {
# line 681 "SemDecls.puma"
 {
  tDefinitions Obj;
  {
# line 682 "SemDecls.puma"

# line 683 "SemDecls.puma"
   Obj = GetDeclEntry (t->VarObject.Kind->VarCommon.Block, GetCommonEntries ());
# line 684 "SemDecls.puma"
   if (! ((Obj->CommonObject.sequence == 1))) goto yyL1;
  {
# line 685 "SemDecls.puma"
 t->VarObject.Dist = mSerialDistribution (0,0);
  }
  }
   return;
 }
yyL1:;

  }
  if (t->VarObject.Dist->Kind == kArrayUseDistribution) {
# line 688 "SemDecls.puma"
 {
  tDefinitions Obj;
  {
# line 689 "SemDecls.puma"

# line 690 "SemDecls.puma"
   Obj = GetDeclEntry (t->VarObject.Kind->VarCommon.Block, GetCommonEntries ());
# line 691 "SemDecls.puma"
   if (! ((Obj->CommonObject.sequence == 1))) goto yyL2;
  {
# line 692 "SemDecls.puma"
 t->VarObject.Dist = mSerialDistribution (0,0);
  }
  }
   return;
 }
yyL2:;

  }
  }
  if (t->VarObject.Dist->Kind == kDefaultDistribution) {
# line 699 "SemDecls.puma"
  {
# line 700 "SemDecls.puma"
   if (! ((target_model == UNI_PROC))) goto yyL3;
  {
# line 701 "SemDecls.puma"
 t->VarObject.Dist = mSerialDistribution (0,0);
  }
  }
   return;
yyL3:;

# line 713 "SemDecls.puma"
  {
# line 714 "SemDecls.puma"
   if (! ((ddefault_kind == DDEFAULT_REPLICATED))) goto yyL5;
  {
# line 715 "SemDecls.puma"
 t->VarObject.Dist = mSerialDistribution (0,0);
  }
  }
   return;
yyL5:;

# line 727 "SemDecls.puma"
  {
# line 728 "SemDecls.puma"
   if (! ((ddefault_kind == DDEFAULT_CM))) goto yyL7;
  {
# line 729 "SemDecls.puma"
 t->VarObject.Dist = mSerialDistribution (0,0);
  }
  }
   return;
yyL7:;

# line 741 "SemDecls.puma"
  {
# line 742 "SemDecls.puma"
 t->VarObject.Dist = GetDefaultDistribution (t->VarObject.decl);
  }
   return;

  }
  if (t->VarObject.Dist->Kind == kArrayUseDistribution) {
# line 704 "SemDecls.puma"
  {
# line 705 "SemDecls.puma"
   if (! ((target_model == UNI_PROC))) goto yyL4;
  {
# line 706 "SemDecls.puma"
 t->VarObject.Dist = mSerialDistribution (0,0);
  }
  }
   return;
yyL4:;

# line 718 "SemDecls.puma"
  {
# line 719 "SemDecls.puma"
   if (! ((ddefault_kind == DDEFAULT_REPLICATED))) goto yyL6;
  {
# line 720 "SemDecls.puma"
 t->VarObject.Dist = mSerialDistribution (0,0);
  }
  }
   return;
yyL6:;

# line 732 "SemDecls.puma"
  {
# line 733 "SemDecls.puma"
   if (! ((ddefault_kind == DDEFAULT_CM))) goto yyL8;
  {
# line 734 "SemDecls.puma"
 t->VarObject.Dist = GetDefaultDistribution (t->VarObject.decl);
  }
  }
   return;
yyL8:;

# line 745 "SemDecls.puma"
  {
# line 746 "SemDecls.puma"
 t->VarObject.Dist = GetDefaultDistribution (t->VarObject.decl);
  }
   return;

  }
  if (t->VarObject.Dist->Kind == kAlignDistribution) {
# line 773 "SemDecls.puma"
  {
# line 774 "SemDecls.puma"
 t->VarObject.Dist = EvalAlignDistribution (t->VarObject.Dist, VarRank (t));
  }
   return;

  }
  }
  if (t->Kind == kTemplateObject) {
  if (t->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
  if (t->TemplateObject.Dist->Kind == kDefaultDistribution) {
# line 753 "SemDecls.puma"
  {
# line 755 "SemDecls.puma"
   if (! ((target_model == UNI_PROC))) goto yyL11;
  {
# line 756 "SemDecls.puma"
 t->TemplateObject.Dist = mSerialDistribution (0,0);
  }
  }
   return;
yyL11:;

# line 759 "SemDecls.puma"
  {
# line 761 "SemDecls.puma"
   if (! ((ddefault_kind == DDEFAULT_REPLICATED))) goto yyL12;
  {
# line 762 "SemDecls.puma"
 t->TemplateObject.Dist = mSerialDistribution (0,0);
  }
  }
   return;
yyL12:;

# line 765 "SemDecls.puma"
  {
# line 767 "SemDecls.puma"
 t->TemplateObject.Dist = MakeLastDimDistribution (TreeListLength (t->TemplateObject.decl->TEMPLATE_DECL.DIMENSIONS));
     simple_warning_protocol ("Default Distribution for a Template");
     obj_protocol ("template is : ", t);

  }
   return;

  }
  }
  }
# line 777 "SemDecls.puma"
   return;

;
}

static tDefinitions GetDefaultDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree d)
# else
(d)
 register tTree d;
# endif
{
  if (d->Kind == kPARAMETER_DECL) {
# line 789 "SemDecls.puma"
   return mSerialDistribution (0, 0);

  }
  if (d->Kind == kVAR_DECL) {
# line 793 "SemDecls.puma"
   return GetDefaultDistribution (d->VAR_DECL.VAL);

  }
  if (d->Kind == kVAR_PARAM_DECL) {
# line 797 "SemDecls.puma"
   return GetDefaultDistribution (d->VAR_PARAM_DECL.VAL);

  }
# line 801 "SemDecls.puma"
 {
  int dist;
  tTree comptype;
  tDefinitions result;
  {
# line 803 "SemDecls.puma"

# line 804 "SemDecls.puma"

# line 805 "SemDecls.puma"

# line 807 "SemDecls.puma"
   dist = TreeRank (d);
# line 811 "SemDecls.puma"
 if (dist > 0)
       { comptype = TreeType (d);
         if (comptype->Kind == kSTRING_TYPE)
            dist = 0;
          else if (comptype->Kind == kCHAR_TYPE)
            dist = 0;
       }

  }
  {
   return MakeLastDimDistribution (dist);
  }
 }

}

static tDefinitions MakeLastDimDistribution
# if defined __STDC__ | defined __cplusplus
(register int rank)
# else
(rank)
 register int rank;
# endif
{
# line 824 "SemDecls.puma"

int i;
DistributedDimensions dims;

  if (equalint (rank, 0)) {
# line 829 "SemDecls.puma"
   return mSerialDistribution (0, 0);

  }
# line 833 "SemDecls.puma"
  {
# line 834 "SemDecls.puma"
 dims.no_dims = rank;
    for (i = 0; i < rank; i++)
       dims.DimsArray [i] = 0;
    dims.DimsArray[rank-1] = 1;

  }
   return mNodeDistribution (0, 0, DefaultId (), dims);

}

static tDefinitions EvalAlignDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register int rank)
# else
(d, rank)
 register tDefinitions d;
 register int rank;
# endif
{
# line 856 "SemDecls.puma"

int i, trank, source_dim;
DistributedDimensions dims;
bool is_serial;
tObject dist;

  if (d->Kind == kAlignDistribution) {
  if (d->AlignDistribution.template->Kind == kTemplateObject) {
  if (d->AlignDistribution.template->TemplateObject.Dist->Kind == kSerialDistribution) {
# line 863 "SemDecls.puma"
   return mSerialDistribution (0, 0);

  }
  if (d->AlignDistribution.template->TemplateObject.Dist->Kind == kNodeDistribution) {
# line 870 "SemDecls.puma"
  {
# line 874 "SemDecls.puma"


     dims.no_dims = rank;
     for (i=0; i<rank; i++)
       dims.DimsArray[i] = 0;

     is_serial = true;

     trank = d->AlignDistribution.template->TemplateObject.Dist->NodeDistribution.dims.no_dims;

     for (i=0; i < trank; i++)
        if (d->AlignDistribution.template->TemplateObject.Dist->NodeDistribution.dims.DimsArray[i] > 0)
          {
            source_dim = d->AlignDistribution.dims.DimsArray[i];

            if (source_dim > 0)
             { dims.DimsArray[source_dim - 1] = 1;
               is_serial = false;
             }
          }

     if (is_serial)
       dist = mSerialDistribution (0,0);
      else
       dist = mNodeDistribution (0,0,DefaultId(),dims);

  }
   return dist;

  }
  if (d->AlignDistribution.template->TemplateObject.Dist->Kind == kDefaultDistribution) {
# line 903 "SemDecls.puma"
  {
# line 906 "SemDecls.puma"
   obj_error_protocol ("alignment to a not distributed template", d->AlignDistribution.template);
  }
   return mSerialDistribution (0, 0);

  }
  }
# line 910 "SemDecls.puma"
  {
# line 911 "SemDecls.puma"
   printf ("EvalAlignDistribution fails\n");
# line 912 "SemDecls.puma"
   obj_error_protocol ("can not align this object: ", d->AlignDistribution.template);
# line 913 "SemDecls.puma"
   kill_in_protocol ();
  }
   return d;

  }
 yyAbort ("EvalAlignDistribution");
}

static int GetCommonDistVars
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
# line 929 "SemDecls.puma"
   return GetCommonDistVars (t->COMMON_DECL.IDS);

  }
  if (t->Kind == kDECL_LIST) {
# line 933 "SemDecls.puma"
   return GetCommonDistVars (t->DECL_LIST.Elem) + GetCommonDistVars (t->DECL_LIST.Next);

  }
  if (t->Kind == kDECL_EMPTY) {
# line 937 "SemDecls.puma"
   return 0;

  }
  if (t->Kind == kVAR_DECL) {
# line 941 "SemDecls.puma"
 {
  int n;
  tDefinitions Obj;
  {
# line 943 "SemDecls.puma"

# line 944 "SemDecls.puma"

# line 946 "SemDecls.puma"
   Obj = GetLocalDecl (t->VAR_DECL.Name);
# line 947 "SemDecls.puma"
 if (VarDistribution(Obj) == 0)
        n = 0;
       else
        n = 1;

  }
  {
   return n;
  }
 }

  }
# line 955 "SemDecls.puma"
  {
# line 956 "SemDecls.puma"
   failure_protocol ("SemDecls", "GetCommonDistVars", t);
  }
   return 0;

}

static void MatchCommonDecls
# if defined __STDC__ | defined __cplusplus
(register tTree cd1, register tTree cd2, register bool only_warning)
# else
(cd1, cd2, only_warning)
 register tTree cd1;
 register tTree cd2;
 register bool only_warning;
# endif
{
  if (cd1 == NoTree) return;
  if (cd2 == NoTree) return;
  if (cd1->Kind == kCOMMON_DECL) {
  if (cd2->Kind == kCOMMON_DECL) {
# line 968 "SemDecls.puma"
  {
# line 969 "SemDecls.puma"
   if (! ((TreeListLength (cd1->COMMON_DECL.IDS) != TreeListLength (cd2->COMMON_DECL.IDS)))) goto yyL1;
  {
# line 970 "SemDecls.puma"
 if (only_warning)
       simple_warning_protocol ("inconsistent number of entries in common");
      else
       simple_error_protocol ("inconsistent number of entries in common");
     tree_protocol ("first use : ", cd1);
     tree_protocol ("other use : ", cd2);

  }
  }
   return;
yyL1:;

# line 979 "SemDecls.puma"
   return;

  }
  }
# line 984 "SemDecls.puma"
  {
# line 985 "SemDecls.puma"
   failure_protocol ("SemDecls", "MatchCommonDecls", cd1);
  }
   return;

;
}

static int GetCommonSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
# line 1000 "SemDecls.puma"
   return GetCommonSize (t->COMMON_DECL.IDS);

  }
  if (t->Kind == kDECL_LIST) {
# line 1004 "SemDecls.puma"
   return GetCommonSize (t->DECL_LIST.Elem) + GetCommonSize (t->DECL_LIST.Next);

  }
  if (t->Kind == kDECL_EMPTY) {
# line 1008 "SemDecls.puma"
   return 0;

  }
  if (t->Kind == kVAR_DECL) {
# line 1012 "SemDecls.puma"
 {
  tDefinitions Obj;
  {
# line 1014 "SemDecls.puma"

# line 1015 "SemDecls.puma"
   Obj = GetLocalDecl (t->VAR_DECL.Name);
  }
  {
   return GetTypeSize (Obj->VarObject.decl);
  }
 }

  }
# line 1019 "SemDecls.puma"
  {
# line 1020 "SemDecls.puma"
   failure_protocol ("SemDecls", "GetCommonSize", t);
  }
   return 0;

}

static int GetTypeSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
# line 1030 "SemDecls.puma"
   return GetTypeSize (t->VAR_DECL.VAL);

  }
  if (t->Kind == kARRAY_TYPE) {
# line 1034 "SemDecls.puma"
   return GetIndexSize (t->ARRAY_TYPE.ARRAY_INDEX_TYPES) * TreeSize (t->ARRAY_TYPE.ARRAY_COMP_TYPE);

  }
# line 1038 "SemDecls.puma"
   return TreeSize (t);

}

static int GetIndexSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kTYPE_LIST) {
  if (t->TYPE_LIST.Next->Kind == kTYPE_EMPTY) {
# line 1048 "SemDecls.puma"
   return GetIndexSize (t->TYPE_LIST.Elem);

  }
# line 1052 "SemDecls.puma"
   return GetIndexSize (t->TYPE_LIST.Elem) * GetIndexSize (t->TYPE_LIST.Next);

  }
  if (t->Kind == kINDEX_TYPE) {
  if (t->INDEX_TYPE.UPPER->Kind == kDUMMY_EXP) {
# line 1056 "SemDecls.puma"
   return 0;

  }
# line 1060 "SemDecls.puma"
 {
  int lval;
  int hval;
  int size;
  bool found;
  {
# line 1064 "SemDecls.puma"

# line 1065 "SemDecls.puma"

# line 1066 "SemDecls.puma"

# line 1067 "SemDecls.puma"

# line 1069 "SemDecls.puma"
   GetIntConstValue (t->INDEX_TYPE.LOWER, & found, & lval);
# line 1070 "SemDecls.puma"
   if (! (found)) goto yyL4;
  {
# line 1071 "SemDecls.puma"
   GetIntConstValue (t->INDEX_TYPE.UPPER, & found, & hval);
# line 1072 "SemDecls.puma"
   if (! (found)) goto yyL4;
  {
# line 1073 "SemDecls.puma"
   size = hval - lval + 1 + t->INDEX_TYPE.left_overlap + t->INDEX_TYPE.right_overlap;
  }
  }
  }
  {
   return size;
  }
 }
yyL4:;

# line 1077 "SemDecls.puma"
   return 0;

  }
  if (t->Kind == kDYNAMIC) {
# line 1081 "SemDecls.puma"
   return 0;

  }
# line 1085 "SemDecls.puma"
  {
# line 1086 "SemDecls.puma"
   failure_protocol ("SemDecls", "GetIndexSize", t);
  }
   return 0;

}

void BeginSemDecls ()
{
}

void CloseSemDecls ()
{
}
