# include "MakeDefs.h"
# include "yyMDefs.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 47 "MakeDefs.puma"


# include "Idents.h"
# include "StringMe.h"

# include "protocol.h"

# include "Types.h"
# include "Transfor.h"    /* MakeFuncCall */
# include "ChangeDe.h"  /* MakeObjType, ..., MakeObjSave, MakeObjExternal,
                             StatementFunctions                   */
# include "SetDefs.h"     /* MakeVarDefs, MakeACFDefs, CheckExp,
                             MakeIndexDefs                        */

#define WARNINGS_Sem 0  /* 1 : prints warnings */

    /*****************************************************
    *                                                    *
    *    Global Variables in Making Definitions          *
    *                                                    *
    *    ProgramCounter : counts PROGRAM_DECL            *
    *                                                    *
    *****************************************************/

int ProgramCounter;     /* counter for MAIN programs */

tTree Entity, NewEntityDecls;   /* global use for translating an entity */
bool IsParameterEntity;
bool InitValEntity;

tTree ReverseDeclList (list, newlist)
tTree list, newlist;
{ tTree x1;

  if (list == NoTree)
     return (newlist);
   else
     { /* reverse ( tail (list), cons (first(list), newlist)) */
       x1 = list->DECL_LIST.Next;
       list->DECL_LIST.Next = newlist;
       return (ReverseDeclList (x1, list));
     }
} /* ReverseDeclList */

/*********************************************************************
*                                                                    *
*    I M P L I C I T   T Y P E S   T A B L E                         *
*                                                                    *
*********************************************************************/

tTree impl_table [26];   /* A - Z */

tTree impl_dummy, impl_int4, impl_real4;   /* predefined types */

int check_impl_char (c)
char c;
{ return ( (c >= 'A') && (c <= 'Z') ); }

void cset_impl_table (first, last, val)
/* set entries form first to last character */
char first, last;
tTree val;
{ char i;
  char m[100];
  if (!check_impl_char (first) || !check_impl_char (last))
    { sprintf (m, "Implicit Declaration: %c - %c not valid\\n",
                  first, last);
      simple_error_protocol (m);
    }
  for (i=first;i<=last;i++)
      impl_table[i-'A'] = val;
}

void reset_impl_table ()
/* this is the default for implicit definitions */
{  cset_impl_table ('A','H', impl_real4);
   cset_impl_table ('I','N', impl_int4);
   cset_impl_table ('O','Z', impl_real4);
}

void init_impl_table ()
/* these type trees are used global for whole phase */
{ impl_real4 = mREAL_TYPE (4);
  impl_int4  = mINTEGER_TYPE (4);
  impl_dummy = mDUMMY_TYPE ();
  reset_impl_table ();
}

void set_impl_table (first, last, val)
/* redefine for letters in range [first-last] to val */
tIdent first, last;
tTree val;
{ char cf, cl, name[100];
  GetString (first, name);
  cf = name[0];
  GetString (last, name);
  cl = name[0];
  cset_impl_table (cf, cl, val);
}

tTree get_impl_table (name)
/* query for implicit type */
tIdent name;
{ char c, word[100];
  GetString (name, word);
  c = word[0];
  if (check_impl_char (c))
     return (impl_table[c-'A']);
   else
     return (impl_dummy);
}



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeDefs, routine %s failed\n", yyFunction);
 exit (1);
}

void MakeDefs ARGS((tTree t));
static void MakeUnitDefs ARGS((tTree t));
static void MakeFormalDefs ARGS((tTree t));
static void MakeDECLDefs ARGS((tTree t));
static void MakeTYPEDefs ARGS((tTree t));
static void DeclareUnits ARGS((tTree t));
static void MakeCommons ARGS((tTree t, tTree CommonDecl));
static void CheckImplicitDecls ARGS((tDefinitions t));
static bool IsDummyType ARGS((tTree t));
static tTree ReplaceDummyType ARGS((tTree t, tTree newval));
static void MakeInterfaceDefs ARGS((tTree t));
static tTree Normal1DECLDefs ARGS((tTree t));
static tTree TranslateCommonDECL ARGS((tTree idlist));
static void TranslateEntityDecl ARGS((tIdent id, int pos, tTree attributes, tTree current_entity));
static void UpdateEntityVal ARGS((tTree decl, tTree newval));
static void UpdateEntityDims ARGS((tTree decl, tTree newdims));
static tTree Normal2DECLDefs ARGS((tTree t));

void MakeDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kCOMP_UNIT) {
# line 175 "MakeDefs.puma"
  {
# line 176 "MakeDefs.puma"
   BeginDefinitions ();
# line 177 "MakeDefs.puma"
   ProgramCounter = 0;
# line 178 "MakeDefs.puma"
   open_protocol ("adaptor.def");
# line 179 "MakeDefs.puma"
   init_impl_table ();
# line 180 "MakeDefs.puma"
   DeclareUnits (t->COMP_UNIT.COMP_ELEMENTS);
# line 181 "MakeDefs.puma"
   MakeDefs (t->COMP_UNIT.COMP_ELEMENTS);
# line 182 "MakeDefs.puma"
   CloseDefinitions ();
# line 183 "MakeDefs.puma"
   close_protocol ();
  }
   return;

  }
  if (t->Kind == kDECL_EMPTY) {
# line 186 "MakeDefs.puma"
   return;

  }
  if (t->Kind == kDECL_LIST) {
# line 189 "MakeDefs.puma"
  {
# line 190 "MakeDefs.puma"
   MakeUnitDefs (t->DECL_LIST.Elem);
# line 191 "MakeDefs.puma"
   MakeDefs (t->DECL_LIST.Next);
  }
   return;

  }
# line 194 "MakeDefs.puma"
  {
# line 195 "MakeDefs.puma"
   printf ("MakeDefs failed\n");
# line 196 "MakeDefs.puma"
   FileUnparse (stdout, t);
# line 197 "MakeDefs.puma"
   WriteTree (stdout, t);
# line 198 "MakeDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void MakeUnitDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kPROGRAM_DECL) {
# line 209 "MakeDefs.puma"
 {
  tDefinitions Scope;
  tDefinitions Obj;
  {
# line 210 "MakeDefs.puma"

# line 211 "MakeDefs.puma"

# line 212 "MakeDefs.puma"
   set_protocol_unit (t);
# line 213 "MakeDefs.puma"
   NewScope ();
# line 214 "MakeDefs.puma"
   MakeFormalDefs (t->PROGRAM_DECL.FORMALS);
# line 215 "MakeDefs.puma"
   MakeUnitDefs (t->PROGRAM_DECL.PROGRAM_BODY);
# line 216 "MakeDefs.puma"
   Scope = GetCurrentScope ();
# line 217 "MakeDefs.puma"
   CloseScope ();
# line 218 "MakeDefs.puma"
   Obj = GetDeclEntry (t->PROGRAM_DECL.Name, GetUnitEntries ());
# line 219 "MakeDefs.puma"
   Obj->ProcObject.Declarations = Scope;
  }
   return;
 }

  }
  if (t->Kind == kPROC_DECL) {
# line 222 "MakeDefs.puma"
 {
  tDefinitions Scope;
  tDefinitions Obj;
  {
# line 223 "MakeDefs.puma"

# line 224 "MakeDefs.puma"

# line 225 "MakeDefs.puma"
   set_protocol_unit (t);
# line 226 "MakeDefs.puma"
   NewScope ();
# line 227 "MakeDefs.puma"
   MakeFormalDefs (t->PROC_DECL.FORMALS);
# line 228 "MakeDefs.puma"
   MakeUnitDefs (t->PROC_DECL.PROC_BODY);
# line 229 "MakeDefs.puma"
   Scope = GetCurrentScope ();
# line 230 "MakeDefs.puma"
   CloseScope ();
# line 231 "MakeDefs.puma"
   Obj = GetDeclEntry (t->PROC_DECL.Name, GetUnitEntries ());
# line 232 "MakeDefs.puma"
   Obj->ProcObject.Declarations = Scope;
  }
   return;
 }

  }
  if (t->Kind == kFUNC_DECL) {
# line 235 "MakeDefs.puma"
 {
  tDefinitions Scope;
  tDefinitions Obj;
  {
# line 236 "MakeDefs.puma"

# line 237 "MakeDefs.puma"

# line 238 "MakeDefs.puma"
   set_protocol_unit (t);
# line 239 "MakeDefs.puma"
   Obj = GetDeclEntry (t->FUNC_DECL.Name, GetUnitEntries ());
# line 240 "MakeDefs.puma"
   NewScope ();
# line 242 "MakeDefs.puma"
   InsertEntry (Obj);
# line 243 "MakeDefs.puma"
   MakeFormalDefs (t->FUNC_DECL.FORMALS);
# line 244 "MakeDefs.puma"
   MakeUnitDefs (t->FUNC_DECL.FUNC_BODY);
# line 245 "MakeDefs.puma"
   Scope = GetCurrentScope ();
# line 246 "MakeDefs.puma"
   CloseScope ();
# line 247 "MakeDefs.puma"
   Obj->FuncObject.Declarations = Scope;
  }
   return;
 }

  }
  if (t->Kind == kBLOCK_DATA_DECL) {
# line 250 "MakeDefs.puma"
 {
  tDefinitions Scope;
  tDefinitions Obj;
  {
# line 251 "MakeDefs.puma"

# line 252 "MakeDefs.puma"

# line 253 "MakeDefs.puma"
   set_protocol_unit (t);
# line 254 "MakeDefs.puma"
   NewScope ();
# line 255 "MakeDefs.puma"
   MakeUnitDefs (t->BLOCK_DATA_DECL.DATA_BODY);
# line 256 "MakeDefs.puma"
   Scope = GetCurrentScope ();
# line 257 "MakeDefs.puma"
   CloseScope ();
# line 258 "MakeDefs.puma"
   Obj = GetDeclEntry (t->BLOCK_DATA_DECL.Name, GetUnitEntries ());
# line 259 "MakeDefs.puma"
   Obj->BlockObject.Declarations = Scope;
  }
   return;
 }

  }
  if (t->Kind == kMODULE_DECL) {
# line 262 "MakeDefs.puma"
  {
# line 263 "MakeDefs.puma"
   tree_error_protocol ("MODULES not supported", t);
  }
   return;

  }
  if (t->Kind == kBODY_NODE) {
# line 266 "MakeDefs.puma"
  {
# line 267 "MakeDefs.puma"
   reset_impl_table ();
# line 268 "MakeDefs.puma"
 t->BODY_NODE.DECLS = Normal1DECLDefs (t->BODY_NODE.DECLS);
# line 269 "MakeDefs.puma"
   MakeDECLDefs (t->BODY_NODE.DECLS);
# line 270 "MakeDefs.puma"
 t->BODY_NODE.DECLS = Normal2DECLDefs (t->BODY_NODE.DECLS);
# line 271 "MakeDefs.puma"
   StatementFunctions (t);
# line 272 "MakeDefs.puma"
   MakeACFDefs (t->BODY_NODE.STATS);
# line 273 "MakeDefs.puma"
   CheckImplicitDecls (GetCurrentScope ());
  }
   return;

  }
# line 276 "MakeDefs.puma"
  {
# line 277 "MakeDefs.puma"
   printf ("MakeUnitDefs failed\n");
# line 278 "MakeDefs.puma"
   FileUnparse (stdout, t);
# line 279 "MakeDefs.puma"
   WriteTree (stdout, t);
# line 280 "MakeDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void MakeFormalDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kDECL_LIST) {
# line 293 "MakeDefs.puma"
  {
# line 294 "MakeDefs.puma"
   MakeFormalDefs (t->DECL_LIST.Elem);
# line 295 "MakeDefs.puma"
   MakeFormalDefs (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kVAR_PARAM_DECL) {
# line 298 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 299 "MakeDefs.puma"

# line 300 "MakeDefs.puma"
   Obj = GetLocalDecl (t->VAR_PARAM_DECL.Name);
# line 301 "MakeDefs.puma"
   MakeTYPEDefs (t->VAR_PARAM_DECL.VAL);
# line 302 "MakeDefs.puma"
 if (Obj == NoObject)
       { Obj = mVarObject (t->VAR_PARAM_DECL.Name,
                           mVAR_PARAM_DECL (t->VAR_PARAM_DECL.Name, t->VAR_PARAM_DECL.Pos, t->VAR_PARAM_DECL.VAL),
                           mVarDummy (/* intent */ -1, 0, false),
                           0,
                           mDefaultDistribution (0, 0));
         InsertEntry (Obj);
       }
      else
        tree_error_protocol ("dummy argument declared twice: ", t);

  }
   return;
 }

  }
  if (t->Kind == kPROC_PARAM_DECL) {
# line 315 "MakeDefs.puma"
  {
# line 316 "MakeDefs.puma"
   tree_error_protocol ("dummy subroutines not handled", t);
  }
   return;

  }
  if (t->Kind == kFUNC_PARAM_DECL) {
# line 319 "MakeDefs.puma"
  {
# line 320 "MakeDefs.puma"
   tree_error_protocol ("dummy functions not handled", t);
  }
   return;

  }
  if (t->Kind == kRET_PARAM_DECL) {
# line 323 "MakeDefs.puma"
  {
# line 324 "MakeDefs.puma"
   tree_error_protocol ("dummy return parameters not handled", t);
  }
   return;

  }
  if (t->Kind == kDECL_EMPTY) {
# line 327 "MakeDefs.puma"
   return;

  }
# line 330 "MakeDefs.puma"
  {
# line 331 "MakeDefs.puma"
   printf ("MakeFormalDefs failed\n");
# line 332 "MakeDefs.puma"
   FileUnparse (stdout, t);
# line 333 "MakeDefs.puma"
   WriteTree (stdout, t);
# line 334 "MakeDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void MakeDECLDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 345 "MakeDefs.puma"

tTree newdecl;

  if (t == NoTree) return;

  switch (t->Kind) {
  case kDECL_LIST:
# line 349 "MakeDefs.puma"
  {
# line 350 "MakeDefs.puma"
   MakeDECLDefs (t->DECL_LIST.Elem);
# line 351 "MakeDefs.puma"
   MakeDECLDefs (t->DECL_LIST.Next);
  }
   return;

  case kDECL_EMPTY:
# line 354 "MakeDefs.puma"
   return;

  case kVAR_DECL:
# line 365 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 367 "MakeDefs.puma"

# line 369 "MakeDefs.puma"
   MakeTYPEDefs (t->VAR_DECL.VAL);
# line 371 "MakeDefs.puma"
   Obj = GetLocalDecl (t->VAR_DECL.Name);
# line 373 "MakeDefs.puma"
 if (Obj == NoObject)
        { Obj = mVarObject (t->VAR_DECL.Name, mVAR_DECL (t->VAR_DECL.Name, t->VAR_DECL.Pos, t->VAR_DECL.VAL),
                            mVarLocal (0,0), 0,
                            mDefaultDistribution (0,0));
          InsertEntry (Obj);
        }
      else
        {
          MakeObjType (t, Obj);
        }

  }
   return;
 }

  case kDIMENSION_DECL:
# line 394 "MakeDefs.puma"
 {
  tDefinitions Obj;
  tTree type;
  {
# line 396 "MakeDefs.puma"

# line 397 "MakeDefs.puma"

# line 399 "MakeDefs.puma"
   MakeTYPEDefs (t->DIMENSION_DECL.INDEXES);
# line 401 "MakeDefs.puma"
   Obj = GetLocalDecl (t->DIMENSION_DECL.Name);
# line 403 "MakeDefs.puma"
 if (Obj == NoObject)
        { type = mARRAY_TYPE (t->DIMENSION_DECL.INDEXES, mDUMMY_TYPE ());
          Obj = mVarObject (t->DIMENSION_DECL.Name, mVAR_DECL(t->DIMENSION_DECL.Name, t->DIMENSION_DECL.Pos, type),
                            mVarLocal (0,0), 0,
                            mDefaultDistribution (0,0));
          InsertEntry (Obj);
        }
      else
        {
          MakeObjDimension (t, Obj);
        }

  }
   return;
 }

  case kSAVE_DECL:
  if (equaltIdent (t->SAVE_DECL.Name, MakeIdent (" ", 1))) {
# line 423 "MakeDefs.puma"
  {
# line 425 "MakeDefs.puma"
   tree_error_protocol ("General SAVE not handled : ", t);
  }
   return;

  }
# line 428 "MakeDefs.puma"
 {
  tDefinitions Obj;
  tTree type;
  {
# line 431 "MakeDefs.puma"

# line 432 "MakeDefs.puma"

# line 434 "MakeDefs.puma"
   Obj = GetLocalDecl (t->SAVE_DECL.Name);
# line 436 "MakeDefs.puma"
 if (Obj == NoObject)
        { type = mDUMMY_TYPE ();
          Obj  = mVarObject (t->SAVE_DECL.Name, mVAR_DECL (t->SAVE_DECL.Name, t->SAVE_DECL.Pos, type),
                    mVarLocal (1, 0), 0,
                    mDefaultDistribution (0,0)   ) ;
          InsertEntry (Obj);
        }
      else
        MakeObjSave (t, Obj);

  }
   return;
 }

  case kSEQUENCE_DECL:
  if (equaltIdent (t->SEQUENCE_DECL.Name, MakeIdent (" ", 1))) {
# line 454 "MakeDefs.puma"
  {
# line 456 "MakeDefs.puma"
   tree_error_protocol ("General SEQUENCE not handled : ", t);
  }
   return;

  }
# line 459 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 460 "MakeDefs.puma"

# line 461 "MakeDefs.puma"
   Obj = GetDeclEntry (t->SEQUENCE_DECL.Name, GetCommonEntries ());
# line 462 "MakeDefs.puma"
   if (! ((Obj != NoObject))) goto yyL8;
  {
# line 463 "MakeDefs.puma"
   MakeObjSequential (t, Obj);
  }
  }
   return;
 }
yyL8:;

# line 466 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 467 "MakeDefs.puma"

# line 468 "MakeDefs.puma"
   Obj = GetLocalDecl (t->SEQUENCE_DECL.Name);
# line 469 "MakeDefs.puma"
   if (! ((Obj != NoObject))) goto yyL9;
  {
# line 470 "MakeDefs.puma"
   tree_error_protocol ("SEQUENCE directive for non COMMON not supported", t);
  }
  }
   return;
 }
yyL9:;

# line 473 "MakeDefs.puma"
  {
# line 474 "MakeDefs.puma"
   tree_error_protocol ("SEQUENCE directive for undefined object", t);
  }
   return;

  case kNOSEQUENCE_DECL:
  if (equaltIdent (t->NOSEQUENCE_DECL.Name, MakeIdent (" ", 1))) {
# line 483 "MakeDefs.puma"
  {
# line 485 "MakeDefs.puma"
   tree_error_protocol ("General NO SEQUENCE not handled : ", t);
  }
   return;

  }
# line 488 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 489 "MakeDefs.puma"

# line 490 "MakeDefs.puma"
   Obj = GetDeclEntry (t->NOSEQUENCE_DECL.Name, GetCommonEntries ());
# line 491 "MakeDefs.puma"
   if (! ((Obj != NoObject))) goto yyL12;
  {
# line 492 "MakeDefs.puma"
   MakeObjNoSequential (t, Obj);
  }
  }
   return;
 }
yyL12:;

# line 495 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 496 "MakeDefs.puma"

# line 497 "MakeDefs.puma"
   Obj = GetLocalDecl (t->NOSEQUENCE_DECL.Name);
# line 498 "MakeDefs.puma"
   if (! ((Obj != NoObject))) goto yyL13;
  {
# line 500 "MakeDefs.puma"
   tree_error_protocol ("NO SEQUENCE directive for non COMMON not supported", t);
  }
  }
   return;
 }
yyL13:;

# line 503 "MakeDefs.puma"
  {
# line 504 "MakeDefs.puma"
   tree_error_protocol ("NO SEQUENCE directive for undefined object", t);
  }
   return;

  case kINTRINSIC_DECL:
# line 513 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 515 "MakeDefs.puma"

# line 516 "MakeDefs.puma"
   Obj = GetDeclEntry (t->INTRINSIC_DECL.Name, GetIntrinsicEntries ());
# line 517 "MakeDefs.puma"
 if (Obj == NoObject)
       tree_error_protocol ("INTRINSIC with this name does not exist : ", t);
      else
       InsertEntry (Obj);

  }
   return;
 }

  case kINTENT_DECL:
# line 524 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 526 "MakeDefs.puma"

# line 528 "MakeDefs.puma"
   Obj = GetLocalDecl (t->INTENT_DECL.Name);
# line 530 "MakeDefs.puma"
 if (Obj == NoObject)
        tree_error_protocol ("INTENT: no dummy with this name", t);
      else
        MakeObjIntent (Obj, t->INTENT_DECL.intent);

  }
   return;
 }

  case kOPTIONAL_DECL:
# line 537 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 539 "MakeDefs.puma"

# line 541 "MakeDefs.puma"
   Obj = GetLocalDecl (t->OPTIONAL_DECL.Name);
# line 543 "MakeDefs.puma"
 if (Obj == NoObject)
        tree_error_protocol ("OPTIONAL: no dummy with this name", t);
      else
        MakeObjOptional (Obj);

  }
   return;
 }

  case kALLOCATABLE_DECL:
# line 550 "MakeDefs.puma"
  {
# line 551 "MakeDefs.puma"
   tree_error_protocol ("allocatable not supported until now", t);
  }
   return;

  case kPOINTER_DECL:
# line 554 "MakeDefs.puma"
  {
# line 555 "MakeDefs.puma"
   tree_error_protocol ("pointers not supported until now", t);
  }
   return;

  case kTARGET_DECL:
# line 558 "MakeDefs.puma"
  {
# line 559 "MakeDefs.puma"
   tree_error_protocol ("targets not supported until now", t);
  }
   return;

  case kPUBLIC_DECL:
# line 562 "MakeDefs.puma"
  {
# line 563 "MakeDefs.puma"
   tree_error_protocol ("public not supported until now", t);
  }
   return;

  case kPRIVATE_DECL:
# line 566 "MakeDefs.puma"
  {
# line 567 "MakeDefs.puma"
   tree_error_protocol ("private not supported until now", t);
  }
   return;

  case kTYPE_DECL:
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
# line 578 "MakeDefs.puma"
 {
  tDefinitions Obj;
  tDefinitions Scope;
  {
# line 580 "MakeDefs.puma"

# line 581 "MakeDefs.puma"

# line 583 "MakeDefs.puma"
   Obj = GetLocalDecl (t->TYPE_DECL.Name);
# line 585 "MakeDefs.puma"
 if (Obj == NoObject)
        {
          Obj = mTypeObject (t->TYPE_DECL.Name, t, NoDefinitions);
          NewScope ();
          MakeDECLDefs (t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS);
          Scope = GetCurrentScope ();
          CloseScope ();
          Obj->TypeObject.Components = Scope;
          InsertEntry (Obj);
        }
      else
        {
          tree_error_protocol ("type name already in use", t);
        }

  }
   return;
 }

  }
  break;
  case kTEMPLATE_DECL:
# line 610 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 612 "MakeDefs.puma"

# line 614 "MakeDefs.puma"
   MakeTYPEDefs (t->TEMPLATE_DECL.DIMENSIONS);
# line 616 "MakeDefs.puma"
   Obj = GetLocalDecl (t->TEMPLATE_DECL.Name);
# line 618 "MakeDefs.puma"
 if (Obj == NoObject)
        { Obj = mTemplateObject (t->TEMPLATE_DECL.Name, mTEMPLATE_DECL (t->TEMPLATE_DECL.Name, t->TEMPLATE_DECL.Pos, t->TEMPLATE_DECL.DIMENSIONS),
                                mDefaultDistribution (0,0) );
          InsertEntry (Obj);
        }
      else
        {
          MakeObjType (t, Obj);
        }

  }
   return;
 }

  case kPROCESSORS_DECL:
# line 638 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 640 "MakeDefs.puma"

# line 642 "MakeDefs.puma"
   MakeTYPEDefs (t->PROCESSORS_DECL.DIMENSIONS);
# line 644 "MakeDefs.puma"
   Obj = GetLocalDecl (t->PROCESSORS_DECL.Name);
# line 646 "MakeDefs.puma"
 if (Obj == NoObject)
        { Obj = mProcessorsObject (t->PROCESSORS_DECL.Name, t);
          InsertEntry (Obj);
        }
      else
        {
          MakeObjType (t, Obj);
        }

  }
   return;
 }

  case kALIGN_DECL:
# line 665 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 667 "MakeDefs.puma"

# line 669 "MakeDefs.puma"
   Obj = GetLocalDecl (t->ALIGN_DECL.Name);
# line 671 "MakeDefs.puma"
 if (Obj == NoObject)
        tree_error_protocol ("alignment: name not defined", t);
      else
        MakeObjAlignment (t, Obj);

  }
   return;
 }

  case kDYNAMIC_DECL:
# line 678 "MakeDefs.puma"
  {
# line 679 "MakeDefs.puma"
   tree_error_protocol ("dynamic declaration is  not supported", t);
  }
   return;

  case kPARAMETER_DECL:
# line 690 "MakeDefs.puma"
 {
  tDefinitions Obj;
  tTree type;
  {
# line 692 "MakeDefs.puma"

# line 693 "MakeDefs.puma"

# line 695 "MakeDefs.puma"
 t->PARAMETER_DECL.VAL = CheckExp (t->PARAMETER_DECL.VAL);
# line 697 "MakeDefs.puma"
   Obj = GetLocalDecl (t->PARAMETER_DECL.Name);
# line 699 "MakeDefs.puma"
 if (Obj == NoObject)
      { type = mDUMMY_TYPE ();
        Obj = mVarObject (t->PARAMETER_DECL.Name, mPARAMETER_DECL (t->PARAMETER_DECL.Name, t->PARAMETER_DECL.Pos, t->PARAMETER_DECL.VAL),
                          mVarConstant (t->PARAMETER_DECL.VAL, type),
                          0,
                          mDefaultDistribution (0, 0));
        InsertEntry (Obj);
      }
     else
      {
        MakeObjParameter (t, Obj);
      }

  }
   return;
 }

  case kIMPLICIT_DECL:
  if (t->IMPLICIT_DECL.VAL->Kind == kDUMMY_TYPE) {
# line 722 "MakeDefs.puma"
  {
# line 724 "MakeDefs.puma"
   cset_impl_table ('A', 'Z', t->IMPLICIT_DECL.VAL);
  }
   return;

  }
# line 727 "MakeDefs.puma"
  {
# line 728 "MakeDefs.puma"
   set_impl_table (t->IMPLICIT_DECL.first, t->IMPLICIT_DECL.last, t->IMPLICIT_DECL.VAL);
  }
   return;

  case kEXTERNAL_DECL:
# line 740 "MakeDefs.puma"
 {
  tDefinitions Obj;
  tTree Decl;
  {
# line 742 "MakeDefs.puma"

# line 743 "MakeDefs.puma"

# line 745 "MakeDefs.puma"
   Obj = GetLocalDecl (t->EXTERNAL_DECL.Name);
# line 747 "MakeDefs.puma"
 if (Obj == NoObject)
       {
         Obj = GetDeclEntry (t->EXTERNAL_DECL.Name, GetUnitEntries ());
         if (Obj == NoObject)
            Obj = GetDeclEntry (t->EXTERNAL_DECL.Name, GetExternalEntries ());
         if (Obj == NoObject)
            {
              tree_protocol ("new external subroutine", t);
              Decl = mEXT_PROC_DECL (t->EXTERNAL_DECL.Name, t->EXTERNAL_DECL.Pos, mDECL_EMPTY());

              Obj = mProcObject (t->EXTERNAL_DECL.Name, Decl, 0, mENTRY_EMPTY());
              InsertExternalEntry (Obj);
            }

         InsertEntry (Obj);
       }
     else
       {
         MakeObjExternal (t, Obj);
       }

  }
   return;
 }

  case kINTERFACE_DECL:
  if (t->INTERFACE_DECL.SPEC->Kind == kNO_GENERIC_SPEC) {
# line 771 "MakeDefs.puma"
  {
# line 772 "MakeDefs.puma"
   MakeInterfaceDefs (t->INTERFACE_DECL.ITEMS);
  }
   return;

  }
# line 775 "MakeDefs.puma"
  {
# line 776 "MakeDefs.puma"
   tree_error_protocol ("interface with generic specs not supported", t);
  }
   return;

  case kCOMMON_DECL:
# line 792 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 794 "MakeDefs.puma"

# line 796 "MakeDefs.puma"
   Obj = GetDeclEntry (t->COMMON_DECL.Name, GetCommonEntries ());
# line 798 "MakeDefs.puma"
 if (Obj == NoObject)
        { Obj = mCommonObject (t->COMMON_DECL.Name, t, 0, 0, 0, 0);
          InsertCommonEntry (Obj);
        }
      else
        {
        }

# line 813 "MakeDefs.puma"
   MakeDECLDefs (t->COMMON_DECL.IDS);
# line 814 "MakeDefs.puma"
   MakeCommons (t->COMMON_DECL.IDS, t);
  }
   return;
 }

  case kNAMELIST_DECL:
# line 817 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 819 "MakeDefs.puma"

# line 821 "MakeDefs.puma"
   Obj = GetLocalDecl (t->NAMELIST_DECL.Name);
# line 823 "MakeDefs.puma"
 if (Obj == NoObject)
        { Obj = mNameListObject (t->NAMELIST_DECL.Name, t);
          InsertEntry (Obj);
        }
      else
        {
          error_protocol ("illegal redefinition");
          tree_protocol ("NAMELIST Declaration is : ", t);
        }

# line 835 "MakeDefs.puma"
   MakeDECLDefs (t->NAMELIST_DECL.IDS);
  }
   return;
 }

  case kEQV_DECL:
# line 838 "MakeDefs.puma"
  {
# line 840 "MakeDefs.puma"
   MakeVarDefs (t->EQV_DECL.VARS);
  }
   return;

  case kDATA_DECL:
# line 843 "MakeDefs.puma"
  {
# line 844 "MakeDefs.puma"
   MakeVarDefs (t->DATA_DECL.VARS);
# line 845 "MakeDefs.puma"
   MakeIndexDefs (t->DATA_DECL.VALS);
  }
   return;

  case kDISTRIBUTE_DECL:
# line 858 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 860 "MakeDefs.puma"

# line 862 "MakeDefs.puma"
   Obj = GetLocalDecl (t->DISTRIBUTE_DECL.Name);
# line 864 "MakeDefs.puma"

     if (Obj == NoObject)
        tree_error_protocol ("Layout/Distribution: name not defined:", t);
      else MakeObjDistribution (t, Obj);

  }
   return;
 }

  case kUSE_DECL:
# line 871 "MakeDefs.puma"
  {
# line 872 "MakeDefs.puma"
   tree_error_protocol ("use not handled", t);
  }
   return;

  case kONLY_USE_DECL:
# line 875 "MakeDefs.puma"
  {
# line 876 "MakeDefs.puma"
   tree_error_protocol ("only use not handled", t);
  }
   return;

  }

# line 879 "MakeDefs.puma"
  {
# line 880 "MakeDefs.puma"
   printf ("MakeDECLDefs failed\n");
# line 881 "MakeDefs.puma"
   FileUnparse (stdout, t);
# line 882 "MakeDefs.puma"
   WriteTree (stdout, t);
# line 883 "MakeDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void MakeTYPEDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;

  switch (t->Kind) {
  case kARRAY_TYPE:
# line 894 "MakeDefs.puma"
  {
# line 895 "MakeDefs.puma"
   MakeTYPEDefs (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);
# line 896 "MakeDefs.puma"
   MakeTYPEDefs (t->ARRAY_TYPE.ARRAY_COMP_TYPE);
  }
   return;

  case kTYPE_LIST:
# line 899 "MakeDefs.puma"
  {
# line 900 "MakeDefs.puma"
   MakeTYPEDefs (t->TYPE_LIST.Elem);
# line 901 "MakeDefs.puma"
   MakeTYPEDefs (t->TYPE_LIST.Next);
  }
   return;

  case kTYPE_EMPTY:
# line 904 "MakeDefs.puma"
   return;

  case kINDEX_TYPE:
# line 907 "MakeDefs.puma"
  {
# line 908 "MakeDefs.puma"
 t->INDEX_TYPE.LOWER  = CheckExp (t->INDEX_TYPE.LOWER);
     t->INDEX_TYPE.UPPER = CheckExp (t->INDEX_TYPE.UPPER);

  }
   return;

  case kDUMMY_TYPE:
# line 913 "MakeDefs.puma"
   return;

  case kCHAR_TYPE:
# line 914 "MakeDefs.puma"
   return;

  case kINTEGER_TYPE:
# line 916 "MakeDefs.puma"
   return;

  case kREAL_TYPE:
# line 917 "MakeDefs.puma"
   return;

  case kCOMPLEX_TYPE:
# line 918 "MakeDefs.puma"
   return;

  case kBOOLEAN_TYPE:
# line 919 "MakeDefs.puma"
   return;

  case kSTRING_TYPE:
# line 921 "MakeDefs.puma"
  {
# line 922 "MakeDefs.puma"
 t->STRING_TYPE.LENGTH = CheckExp (t->STRING_TYPE.LENGTH);
  }
   return;

  case kDYNAMIC:
# line 925 "MakeDefs.puma"
  {
# line 927 "MakeDefs.puma"
   t->DYNAMIC.Shape = NoTree;
  }
   return;

  case kTYPE_ID:
# line 930 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 932 "MakeDefs.puma"

# line 934 "MakeDefs.puma"
   Obj = GetGlobalDecl (t->TYPE_ID.ID->TYPE_OBJ.Ident);
# line 938 "MakeDefs.puma"
 if (Obj == NoObject)
        tree_error_protocol ("undefined type ", t);
      else if (Obj->Kind != kTypeObject)
        tree_error_protocol ("not a derived type", t);
      else
        t->TYPE_ID.ID->TYPE_OBJ.Object = Obj;

  }
   return;
 }

  }

# line 947 "MakeDefs.puma"
  {
# line 948 "MakeDefs.puma"
   printf ("MakeTYPEDefs failed\n");
# line 949 "MakeDefs.puma"
   FileUnparse (stdout, t);
# line 950 "MakeDefs.puma"
   WriteTree (stdout, t);
# line 951 "MakeDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

static void DeclareUnits
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 966 "MakeDefs.puma"

char s[50], msg[156];

  if (t == NoTree) return;

  switch (t->Kind) {
  case kDECL_LIST:
# line 970 "MakeDefs.puma"
  {
# line 971 "MakeDefs.puma"
   DeclareUnits (t->DECL_LIST.Elem);
# line 972 "MakeDefs.puma"
   DeclareUnits (t->DECL_LIST.Next);
  }
   return;

  case kPROGRAM_DECL:
# line 975 "MakeDefs.puma"
  {
# line 976 "MakeDefs.puma"
 if (GetDeclEntry (t->PROGRAM_DECL.Name, GetUnitEntries ()) != NoObject)
        { GetString (t->PROGRAM_DECL.Name, s);
          sprintf (msg, "PROGRAM %s redeclares other unit\n", s);
          simple_error_protocol (msg);
        }
       else
          InsertUnitEntry (mProcObject (t->PROGRAM_DECL.Name, t, 0, mENTRY_EMPTY()));
      ProgramCounter += 1;
      if (ProgramCounter > 1)
        { GetString (t->PROGRAM_DECL.Name, s);
          sprintf (msg, "PROGRAM %s : is %d. main program",
                   s, ProgramCounter);
          simple_error_protocol (msg);
        }

  }
   return;

  case kPROC_DECL:
# line 993 "MakeDefs.puma"
  {
# line 994 "MakeDefs.puma"
 if (GetDeclEntry (t->PROC_DECL.Name, GetUnitEntries ()) != NoObject)
        { GetString (t->PROC_DECL.Name, s);
          sprintf (msg, "SUBROUTINE %s redeclares other unit\n", s);
          simple_error_protocol (msg);
        }
       else
          InsertUnitEntry (mProcObject (t->PROC_DECL.Name,t, 0, mENTRY_EMPTY()));

  }
   return;

  case kFUNC_DECL:
# line 1004 "MakeDefs.puma"
  {
# line 1005 "MakeDefs.puma"
 if (GetDeclEntry (t->FUNC_DECL.Name, GetUnitEntries ()) != NoObject)
        { GetString (t->FUNC_DECL.Name, s);
          sprintf (msg, "FUNCTION %s redeclares other unit\n", s);
          simple_error_protocol (msg);
        }
       else
          InsertUnitEntry (mFuncObject (t->FUNC_DECL.Name, t, 0, mENTRY_EMPTY ()));

  }
   return;

  case kMODULE_DECL:
# line 1015 "MakeDefs.puma"
  {
# line 1016 "MakeDefs.puma"
 if (GetDeclEntry (t->MODULE_DECL.Name, GetUnitEntries ()) != NoObject)
        { GetString (t->MODULE_DECL.Name, s);
          sprintf (msg, "MODULE %s redeclares other unit\n", s);
          simple_error_protocol (msg);
        }
       else
          InsertUnitEntry (mModuleObject (t->MODULE_DECL.Name, t, 0, mENTRY_EMPTY ()));

  }
   return;

  case kBLOCK_DATA_DECL:
# line 1026 "MakeDefs.puma"
  {
# line 1027 "MakeDefs.puma"
 if (GetDeclEntry (t->BLOCK_DATA_DECL.Name, GetUnitEntries ()) != NoObject)
        { GetString (t->BLOCK_DATA_DECL.Name, s);
          sprintf (msg, "BLOCK DATA %s redeclares other unit\n", s);
          simple_error_protocol (msg);
        }
       else
          InsertUnitEntry (mBlockObject (t->BLOCK_DATA_DECL.Name, t, mENTRY_EMPTY ()));

  }
   return;

  case kDECL_EMPTY:
# line 1037 "MakeDefs.puma"
   return;

  }

# line 1040 "MakeDefs.puma"
  {
# line 1041 "MakeDefs.puma"
   printf ("Unknown Tree in DeclareUnits\n");
# line 1042 "MakeDefs.puma"
   FileUnparse (stdout, t);
# line 1043 "MakeDefs.puma"
   WriteTree (stdout, t);
  }
   return;

;
}

static void MakeCommons
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree CommonDecl)
# else
(t, CommonDecl)
 register tTree t;
 register tTree CommonDecl;
# endif
{
# line 1054 "MakeDefs.puma"

char string[256];
tObject Obj;

  if (t == NoTree) return;
  if (CommonDecl == NoTree) return;
  if (t->Kind == kDECL_EMPTY) {
# line 1059 "MakeDefs.puma"
   return;

  }
  if (t->Kind == kDECL_LIST) {
# line 1062 "MakeDefs.puma"
  {
# line 1063 "MakeDefs.puma"
   MakeCommons (t->DECL_LIST.Elem, CommonDecl);
# line 1064 "MakeDefs.puma"
   MakeCommons (t->DECL_LIST.Next, CommonDecl);
  }
   return;

  }
  if (t->Kind == kVAR_DECL) {
# line 1067 "MakeDefs.puma"
  {
# line 1068 "MakeDefs.puma"
   Obj = GetLocalDecl (t->VAR_DECL.Name);
# line 1069 "MakeDefs.puma"
   GetString (t->VAR_DECL.Name, string);
# line 1070 "MakeDefs.puma"
 if (Obj == NoObject)
            printf ("%s in Common Block not declared\n", string);
# line 1072 "MakeDefs.puma"
 if (Obj->Kind != kVarObject)
            printf ("%s in Common Block not a Variable\n", string);
# line 1074 "MakeDefs.puma"
   MakeObjCommon (CommonDecl, Obj);
  }
   return;

  }
  if (CommonDecl->Kind == kCOMMON_DECL) {
# line 1077 "MakeDefs.puma"
  {
# line 1078 "MakeDefs.puma"
   GetString (CommonDecl->COMMON_DECL.Name, string);
# line 1079 "MakeDefs.puma"
   printf ("Illegal Declaration in Common Block %s \n", string);
  }
   return;

  }
;
}

static void CheckImplicitDecls
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
# line 1090 "MakeDefs.puma"

char string[50], msg[100];

  if (t == NoDefinitions) return;
  if (t->Kind == kENTRY_LIST) {
# line 1094 "MakeDefs.puma"
  {
# line 1095 "MakeDefs.puma"
   CheckImplicitDecls (t->ENTRY_LIST.Elem);
# line 1096 "MakeDefs.puma"
   CheckImplicitDecls (t->ENTRY_LIST.Next);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 1099 "MakeDefs.puma"
   return;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.decl->Kind == kVAR_DECL) {
# line 1102 "MakeDefs.puma"
  {
# line 1103 "MakeDefs.puma"
 if (IsDummyType (t->VarObject.decl->VAR_DECL.VAL))
           { t->VarObject.decl->VAR_DECL.VAL = ReplaceDummyType (t->VarObject.decl->VAR_DECL.VAL, get_impl_table (t->VarObject.ident));
             GetString (t->VarObject.ident, string);
             sprintf (msg, "%s is implicitly defined, type = ",string);
             tree_warning_protocol (msg, t->VarObject.decl->VAR_DECL.VAL);
           }

  }
   return;

  }
  if (t->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 1112 "MakeDefs.puma"
  {
# line 1113 "MakeDefs.puma"
 if (IsDummyType (t->VarObject.decl->VAR_PARAM_DECL.VAL))
           { t->VarObject.decl->VAR_PARAM_DECL.VAL = ReplaceDummyType (t->VarObject.decl->VAR_PARAM_DECL.VAL, get_impl_table (t->VarObject.ident));
             GetString (t->VarObject.ident, string);
             sprintf (msg, "%s is implicitly defined, type = ",string);
             tree_warning_protocol (msg, t->VarObject.decl->VAR_PARAM_DECL.VAL);
           }

  }
   return;

  }
  if (t->VarObject.Kind->Kind == kVarConstant) {
# line 1122 "MakeDefs.puma"
  {
# line 1123 "MakeDefs.puma"
 if (IsDummyType (t->VarObject.Kind->VarConstant.Type))
           { t->VarObject.Kind->VarConstant.Type = ReplaceDummyType (t->VarObject.Kind->VarConstant.Type, get_impl_table (t->VarObject.ident));
             GetString (t->VarObject.ident, string);
             sprintf (msg, "%s is implicitly defined, type = ",string);
             tree_warning_protocol (msg, t->VarObject.Kind->VarConstant.Type);
           }

  }
   return;

  }
  }
  if (t->Kind == kFuncObject) {
  if (t->FuncObject.decl->Kind == kFUNC_DECL) {
# line 1132 "MakeDefs.puma"
  {
# line 1134 "MakeDefs.puma"
 if (IsDummyType (t->FuncObject.decl->FUNC_DECL.RESULT_TYPE))
           { t->FuncObject.decl->FUNC_DECL.RESULT_TYPE = ReplaceDummyType (t->FuncObject.decl->FUNC_DECL.RESULT_TYPE, get_impl_table (t->FuncObject.ident));
             GetString (t->FuncObject.ident, string);
             sprintf (msg, "%s is implicitly defined, type = ",string);
             tree_warning_protocol (msg, t->FuncObject.decl->FUNC_DECL.RESULT_TYPE);
           }

  }
   return;

  }
  if (t->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 1143 "MakeDefs.puma"
  {
# line 1144 "MakeDefs.puma"
 if (IsDummyType (t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE))
           { t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE = ReplaceDummyType (t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE, get_impl_table (t->FuncObject.ident));
             GetString (t->FuncObject.ident, string);
             sprintf (msg, "%s is implicitly defined, type = ",string);
             tree_warning_protocol (msg, t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE);
           }

  }
   return;

  }
  if (t->FuncObject.decl->Kind == kEXT_FUNC_DECL) {
# line 1153 "MakeDefs.puma"
  {
# line 1154 "MakeDefs.puma"
 if (IsDummyType (t->FuncObject.decl->EXT_FUNC_DECL.RESULT_TYPE))
           { t->FuncObject.decl->EXT_FUNC_DECL.RESULT_TYPE = ReplaceDummyType (t->FuncObject.decl->EXT_FUNC_DECL.RESULT_TYPE, get_impl_table (t->FuncObject.ident));
             GetString (t->FuncObject.ident, string);
             sprintf (msg, "%s is implicitly defined, type = ",string);
             tree_warning_protocol (msg, t->FuncObject.decl->EXT_FUNC_DECL.RESULT_TYPE);
           }

  }
   return;

  }
  }
;
}

static bool IsDummyType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return false;
  if (t->Kind == kDUMMY_TYPE) {
# line 1171 "MakeDefs.puma"
   return true;

  }
  if (t->Kind == kARRAY_TYPE) {
  if (t->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kDUMMY_TYPE) {
# line 1173 "MakeDefs.puma"
   return true;

  }
  }
  return false;
}

static tTree ReplaceDummyType
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree newval)
# else
(t, newval)
 register tTree t;
 register tTree newval;
# endif
{
  if (t->Kind == kDUMMY_TYPE) {
# line 1183 "MakeDefs.puma"
   return newval;

  }
  if (t->Kind == kARRAY_TYPE) {
  if (t->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kDUMMY_TYPE) {
# line 1187 "MakeDefs.puma"
   return mARRAY_TYPE (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, newval);

  }
  }
# line 1191 "MakeDefs.puma"
   return t;

}

static void MakeInterfaceDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1203 "MakeDefs.puma"

char s[50], msg[156];

  if (t == NoTree) return;

  switch (t->Kind) {
  case kDECL_LIST:
# line 1207 "MakeDefs.puma"
  {
# line 1208 "MakeDefs.puma"
   MakeInterfaceDefs (t->DECL_LIST.Elem);
# line 1209 "MakeDefs.puma"
   MakeInterfaceDefs (t->DECL_LIST.Next);
  }
   return;

  case kDECL_EMPTY:
# line 1212 "MakeDefs.puma"
   return;

  case kPROGRAM_DECL:
# line 1215 "MakeDefs.puma"
  {
# line 1216 "MakeDefs.puma"
   tree_error_protocol ("main program in interface not allowed", t);
  }
   return;

  case kPROC_DECL:
# line 1219 "MakeDefs.puma"
 {
  tDefinitions Scope;
  tDefinitions Obj;
  {
# line 1221 "MakeDefs.puma"

# line 1222 "MakeDefs.puma"

# line 1224 "MakeDefs.puma"
 if (GetLocalDecl (t->PROC_DECL.Name) != NoObject)
       { GetString (t->PROC_DECL.Name, s);
         sprintf (msg, "INTERFACE SUBROUTINE %s redeclares something\n", s);
         simple_error_protocol (msg);
       }
      else
       { Obj = mProcObject (t->PROC_DECL.Name,t, 0, mENTRY_EMPTY());
         InsertEntry (Obj);
         NewScope ();
         InsertEntry (Obj);

         MakeFormalDefs (t->PROC_DECL.FORMALS);
         MakeInterfaceDefs (t->PROC_DECL.PROC_BODY);
         Scope = GetCurrentScope ();
         CloseScope ();
         Obj->FuncObject.Declarations = Scope;
       }

  }
   return;
 }

  case kFUNC_DECL:
# line 1244 "MakeDefs.puma"
 {
  tDefinitions Scope;
  tDefinitions Obj;
  {
# line 1246 "MakeDefs.puma"

# line 1247 "MakeDefs.puma"

# line 1249 "MakeDefs.puma"
 if (GetLocalDecl (t->FUNC_DECL.Name) != NoObject)
       { GetString (t->FUNC_DECL.Name, s);
         sprintf (msg, "INTERFACE FUNCTION %s redeclares something\n", s);
         simple_error_protocol (msg);
       }
      else
       { Obj = mFuncObject (t->FUNC_DECL.Name, t, 0, mENTRY_EMPTY());
         InsertEntry (Obj);
         NewScope ();
         InsertEntry (Obj);

         MakeFormalDefs (t->FUNC_DECL.FORMALS);
         MakeInterfaceDefs (t->FUNC_DECL.FUNC_BODY);
         Scope = GetCurrentScope ();
         CloseScope ();
         Obj->FuncObject.Declarations = Scope;
       }

  }
   return;
 }

  case kBLOCK_DATA_DECL:
# line 1269 "MakeDefs.puma"
  {
# line 1270 "MakeDefs.puma"
   tree_error_protocol ("block data in interface not allowed", t);
  }
   return;

  case kMODULE_DECL:
# line 1273 "MakeDefs.puma"
  {
# line 1274 "MakeDefs.puma"
   tree_error_protocol ("modules in interface not allowed", t);
  }
   return;

  case kBODY_NODE:
  if (t->BODY_NODE.STATS->Kind == kACF_EMPTY) {
  if (t->BODY_NODE.INTERNALS->Kind == kDECL_EMPTY) {
# line 1277 "MakeDefs.puma"
  {
# line 1278 "MakeDefs.puma"
   reset_impl_table ();
# line 1279 "MakeDefs.puma"
 t->BODY_NODE.DECLS = Normal1DECLDefs (t->BODY_NODE.DECLS);
# line 1280 "MakeDefs.puma"
   MakeDECLDefs (t->BODY_NODE.DECLS);
# line 1281 "MakeDefs.puma"
 t->BODY_NODE.DECLS = Normal2DECLDefs (t->BODY_NODE.DECLS);
# line 1282 "MakeDefs.puma"
   CheckImplicitDecls (GetCurrentScope ());
  }
   return;

  }
  }
  if (t->BODY_NODE.INTERNALS->Kind == kDECL_EMPTY) {
# line 1285 "MakeDefs.puma"
  {
# line 1286 "MakeDefs.puma"
   tree_error_protocol ("statements in interface not allowed", t);
  }
   return;

  }
# line 1289 "MakeDefs.puma"
  {
# line 1290 "MakeDefs.puma"
   tree_error_protocol ("internal units in interface not allowed", t);
  }
   return;

  }

# line 1293 "MakeDefs.puma"
  {
# line 1294 "MakeDefs.puma"
   printf ("MakeInterfaceDefs failed\n");
# line 1295 "MakeDefs.puma"
   FileUnparse (stdout, t);
# line 1296 "MakeDefs.puma"
   WriteTree (stdout, t);
# line 1297 "MakeDefs.puma"
   kill_in_protocol ();
  }
   return;

;
}

static tTree Normal1DECLDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1321 "MakeDefs.puma"

tTree newdecl;

  if (t->Kind == kDECL_LIST) {
# line 1325 "MakeDefs.puma"
  {
# line 1326 "MakeDefs.puma"
 newdecl = Normal1DECLDefs (t->DECL_LIST.Elem);
     t->DECL_LIST.Next    = Normal1DECLDefs (t->DECL_LIST.Next);
     newdecl = ReplaceDECL (t, newdecl, t->DECL_LIST.Next);

  }
   return newdecl;

  }
  if (t->Kind == kDECL_EMPTY) {
# line 1333 "MakeDefs.puma"
   return t;

  }
  if (t->Kind == kENTITY_DECL) {
# line 1345 "MakeDefs.puma"
  {
# line 1347 "MakeDefs.puma"
   Entity = NoTree;
# line 1348 "MakeDefs.puma"
   NewEntityDecls = NoTree;
# line 1349 "MakeDefs.puma"
   IsParameterEntity = false;
# line 1350 "MakeDefs.puma"
   InitValEntity = false;
# line 1352 "MakeDefs.puma"
   TranslateEntityDecl (t->ENTITY_DECL.Name, t->ENTITY_DECL.Pos, t->ENTITY_DECL.ATTRIBUTES, t);
  }
   return NewEntityDecls;

  }
  if (t->Kind == kCOMMON_DECL) {
# line 1357 "MakeDefs.puma"
  {
# line 1361 "MakeDefs.puma"
 newdecl = TranslateCommonDECL (t->COMMON_DECL.IDS);
     if (newdecl == NoTree)
        newdecl = t;
      else
        newdecl = mDECL_LIST (t, newdecl);

  }
   return newdecl;

  }
# line 1372 "MakeDefs.puma"
   return t;

}

static tTree TranslateCommonDECL
# if defined __STDC__ | defined __cplusplus
(register tTree idlist)
# else
(idlist)
 register tTree idlist;
# endif
{
# line 1390 "MakeDefs.puma"

tTree newdecl;

  if (idlist->Kind == kDECL_LIST) {
# line 1394 "MakeDefs.puma"
  {
# line 1395 "MakeDefs.puma"
 newdecl = TranslateCommonDECL (idlist->DECL_LIST.Elem);
     if (newdecl == NoTree)
        newdecl = TranslateCommonDECL (idlist->DECL_LIST.Next);
      else
        newdecl = mDECL_LIST (newdecl, TranslateCommonDECL (idlist->DECL_LIST.Next));

  }
   return newdecl;

  }
  if (idlist->Kind == kDECL_EMPTY) {
# line 1404 "MakeDefs.puma"
   return NoTree;

  }
  if (idlist->Kind == kVAR_DECL) {
  if (idlist->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 1408 "MakeDefs.puma"
  {
# line 1409 "MakeDefs.puma"
 newdecl = mDIMENSION_DECL (idlist->VAR_DECL.Name, idlist->VAR_DECL.Pos, idlist->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
     idlist->VAR_DECL.VAL = idlist->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE;

  }
   return newdecl;

  }
# line 1417 "MakeDefs.puma"
   return NoTree;

  }
 yyAbort ("TranslateCommonDECL");
}

static void TranslateEntityDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register int pos, register tTree attributes, register tTree current_entity)
# else
(id, pos, attributes, current_entity)
 register tIdent id;
 register int pos;
 register tTree attributes;
 register tTree current_entity;
# endif
{
# line 1432 "MakeDefs.puma"

tTree newdecl;

  if (attributes == NoTree) return;
  if (current_entity == NoTree) return;
  if (attributes->Kind == kDECL_EMPTY) {
# line 1438 "MakeDefs.puma"
  {
# line 1440 "MakeDefs.puma"
 if (IsParameterEntity && (!InitValEntity))
       tree_error_protocol ("Missing initial value for PARAMETER",
                             current_entity);



    NewEntityDecls = ReverseDeclList (NewEntityDecls, NoTree);



    if (Entity != NoTree)
       NewEntityDecls = mDECL_LIST (Entity, NewEntityDecls);


  }
   return;

  }
  if (attributes->Kind == kDECL_LIST) {

  switch (attributes->DECL_LIST.Elem->Kind) {
  case kTYPESPEC_DECL:
# line 1456 "MakeDefs.puma"
  {
# line 1457 "MakeDefs.puma"
 if (Entity == NoTree)
      Entity = mVAR_DECL (id, pos, attributes->DECL_LIST.Elem->TYPESPEC_DECL.VAL);
     else
      UpdateEntityVal (Entity, attributes->DECL_LIST.Elem->TYPESPEC_DECL.VAL);

# line 1462 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kDIMENSION_DECL:
# line 1465 "MakeDefs.puma"
  {
# line 1466 "MakeDefs.puma"
 if (Entity == NoTree)
      Entity = mVAR_DECL (id, pos, mARRAY_TYPE (attributes->DECL_LIST.Elem->DIMENSION_DECL.INDEXES, mDUMMY_TYPE()));
     else
      UpdateEntityDims (Entity, attributes->DECL_LIST.Elem->DIMENSION_DECL.INDEXES);

# line 1471 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kINIT_DATA_DECL:
# line 1474 "MakeDefs.puma"
  {
# line 1475 "MakeDefs.puma"
  InitValEntity = true;
     if (IsParameterEntity)
       { newdecl = mPARAMETER_DECL (id, pos, attributes->DECL_LIST.Elem->INIT_DATA_DECL.VAL);
         NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
       }
      else

       tree_warning_protocol ("Init Val, no Parameter", current_entity);

# line 1484 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kSAVE_DECL:
# line 1487 "MakeDefs.puma"
  {
# line 1488 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->SAVE_DECL.Name = id; attributes->DECL_LIST.Elem->SAVE_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1491 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kEXTERNAL_DECL:
# line 1494 "MakeDefs.puma"
  {
# line 1495 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->EXTERNAL_DECL.Name = id; attributes->DECL_LIST.Elem->EXTERNAL_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1498 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kINTRINSIC_DECL:
# line 1501 "MakeDefs.puma"
  {
# line 1502 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->INTRINSIC_DECL.Name = id; attributes->DECL_LIST.Elem->INTRINSIC_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1505 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kINTENT_DECL:
# line 1508 "MakeDefs.puma"
  {
# line 1509 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->INTENT_DECL.Name = id; attributes->DECL_LIST.Elem->INTENT_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1512 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kOPTIONAL_DECL:
# line 1515 "MakeDefs.puma"
  {
# line 1516 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->OPTIONAL_DECL.Name = id; attributes->DECL_LIST.Elem->OPTIONAL_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1519 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPOINTER_DECL:
# line 1522 "MakeDefs.puma"
  {
# line 1523 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->POINTER_DECL.Name = id; attributes->DECL_LIST.Elem->POINTER_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1526 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kTARGET_DECL:
# line 1529 "MakeDefs.puma"
  {
# line 1530 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->TARGET_DECL.Name = id; attributes->DECL_LIST.Elem->TARGET_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1533 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPUBLIC_DECL:
# line 1536 "MakeDefs.puma"
  {
# line 1537 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PUBLIC_DECL.Name = id; attributes->DECL_LIST.Elem->PUBLIC_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1540 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPRIVATE_DECL:
# line 1543 "MakeDefs.puma"
  {
# line 1544 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PRIVATE_DECL.Name = id; attributes->DECL_LIST.Elem->PRIVATE_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1547 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPARAMETER_DECL:
# line 1550 "MakeDefs.puma"
  {
# line 1551 "MakeDefs.puma"
 IsParameterEntity = true;
# line 1552 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kTEMPLATE_DECL:
# line 1555 "MakeDefs.puma"
  {
# line 1556 "MakeDefs.puma"
 if (Entity == NoTree)
      { Entity = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->TEMPLATE_DECL.Name = id; attributes->DECL_LIST.Elem->TEMPLATE_DECL.Pos = pos; }
     else
      tree_error_protocol ("Illegal TEMPLATE", current_entity);

# line 1561 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPROCESSORS_DECL:
# line 1564 "MakeDefs.puma"
  {
# line 1565 "MakeDefs.puma"
 if (Entity == NoTree)
      { Entity = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PROCESSORS_DECL.Name = id; attributes->DECL_LIST.Elem->PROCESSORS_DECL.Pos = pos; }
     else
      tree_error_protocol ("Illegal PROCESSORS", current_entity);

# line 1570 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kALIGN_DECL:
# line 1573 "MakeDefs.puma"
  {
# line 1574 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->ALIGN_DECL.Name = id; attributes->DECL_LIST.Elem->ALIGN_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1577 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kDYNAMIC_DECL:
# line 1580 "MakeDefs.puma"
  {
# line 1581 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->DYNAMIC_DECL.Name = id; attributes->DECL_LIST.Elem->DYNAMIC_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1584 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kDISTRIBUTE_DECL:
# line 1587 "MakeDefs.puma"
  {
# line 1588 "MakeDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->DISTRIBUTE_DECL.Name = id; attributes->DECL_LIST.Elem->DISTRIBUTE_DECL.Pos = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);

# line 1591 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  }

# line 1594 "MakeDefs.puma"
  {
# line 1595 "MakeDefs.puma"
   tree_error_protocol ("Unknown Attribute", attributes->DECL_LIST.Elem);
# line 1596 "MakeDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  }
;
}

static void UpdateEntityVal
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tTree newval)
# else
(decl, newval)
 register tTree decl;
 register tTree newval;
# endif
{
  if (decl == NoTree) return;
  if (newval == NoTree) return;
  if (decl->Kind == kVAR_DECL) {
  if (decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 1601 "MakeDefs.puma"
  {
# line 1602 "MakeDefs.puma"
 decl->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE = newval;
  }
   return;

  }
# line 1605 "MakeDefs.puma"
  {
# line 1606 "MakeDefs.puma"
 decl->VAR_DECL.VAL = newval;
  }
   return;

  }
;
}

static void UpdateEntityDims
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tTree newdims)
# else
(decl, newdims)
 register tTree decl;
 register tTree newdims;
# endif
{
  if (decl == NoTree) return;
  if (newdims == NoTree) return;
  if (decl->Kind == kVAR_DECL) {
  if (decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 1611 "MakeDefs.puma"
  {
# line 1612 "MakeDefs.puma"
 decl->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES = newdims;
  }
   return;

  }
# line 1615 "MakeDefs.puma"
  {
# line 1616 "MakeDefs.puma"
 decl->VAR_DECL.VAL = mARRAY_TYPE (newdims, decl->VAR_DECL.VAL);
  }
   return;

  }
  if (decl->Kind == kTEMPLATE_DECL) {
# line 1619 "MakeDefs.puma"
  {
# line 1620 "MakeDefs.puma"
 decl->TEMPLATE_DECL.DIMENSIONS = newdims;
  }
   return;

  }
  if (decl->Kind == kPROCESSORS_DECL) {
# line 1623 "MakeDefs.puma"
  {
# line 1624 "MakeDefs.puma"
 decl->PROCESSORS_DECL.DIMENSIONS = newdims;
  }
   return;

  }
;
}

static tTree Normal2DECLDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1644 "MakeDefs.puma"

tTree newdecl;

  if (t->Kind == kDECL_LIST) {
# line 1648 "MakeDefs.puma"
  {
# line 1649 "MakeDefs.puma"
 newdecl = Normal2DECLDefs (t->DECL_LIST.Elem);
     t->DECL_LIST.Next    = Normal2DECLDefs (t->DECL_LIST.Next);
     newdecl = ReplaceDECL (t, newdecl, t->DECL_LIST.Next);

  }
   return newdecl;

  }
  if (t->Kind == kDECL_EMPTY) {
# line 1656 "MakeDefs.puma"
   return t;

  }
  if (t->Kind == kDIMENSION_DECL) {
# line 1660 "MakeDefs.puma"
 {
  tTree type;
  tDefinitions obj;
  {
# line 1664 "MakeDefs.puma"

# line 1665 "MakeDefs.puma"

# line 1667 "MakeDefs.puma"
 obj = GetLocalDecl (t->DIMENSION_DECL.Name);
      if (obj == NoObject)
         type = mDUMMY_TYPE ();
       else
         type = VarType (obj);
      type = mARRAY_TYPE (t->DIMENSION_DECL.INDEXES, type);
      t->Kind = kVAR_DECL;
      t->VAR_DECL.VAL = type;

  }
  {
   return t;
  }
 }

  }
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 1679 "MakeDefs.puma"
   return t;

  }
# line 1686 "MakeDefs.puma"
 {
  tTree newdecl;
  tDefinitions obj;
  int rank;
  {
# line 1690 "MakeDefs.puma"

# line 1691 "MakeDefs.puma"

# line 1692 "MakeDefs.puma"

# line 1694 "MakeDefs.puma"
 obj = GetLocalDecl (t->VAR_DECL.Name);
      if (obj != NoObject)
         rank = VarRank (obj);
        else
         rank = 0;
      if (rank == 0)
         newdecl = t;
       else
         newdecl = NoTree;

  }
  {
   return newdecl;
  }
 }

  }
# line 1709 "MakeDefs.puma"
   return t;

}

void BeginMakeDefs ()
{
}

void CloseMakeDefs ()
{
}
