/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                           *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Aug 92                                                   *
*  Last Update : Aug 92                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : buffer.c                                                 *
*                                                                         *
*  Function    : Combining of messages in a buffer (send + recv)          *
*                                                                         *
*  is used for combining non-continguous sections to one message          *
*  (only for internal use in the library)                                 *
*                                                                         *
*  Export :                                                               *
*                                                                         *
*   Filling and sending the buffer                                        *
*                                                                         *
*     dalib_create_buffer (size, 0);                                      *
*     dalib_fill_buffer (ptr1, size1);                                    *
*                ...                                                      *
*     dalib_fill_buffer (ptrn, sizen);                                    *
*     dalib_send_buffer (to);                                             *
*     dalib_destroy_buffer ();                                            *
*                                                                         *
*   Receiving and getting from the buffer                                 *
*                                                                         *
*     dalib_create_buffer (size, 1);                                      *
*     dalib_recv_buffer (from);                                           *
*     dalib_get_buffer (ptr1, size1);                                     *
*                ...                                                      *
*     dalib_get_buffer (ptrn, sizen);                                     *
*     dalib_destroy_buffer ();                                            *
*                                                                         *
**************************************************************************/

     /*********************************************************
     *                                                        *
     *  Global data for the buffer                            *
     *                                                        *
     *                                                        *
     *   ------    <- dalib_buffer_size                       *
     *   |    |                                               *
     *   |    |    <- dalib_buffer_pos                        *
     *   |    |                                               *
     *   |    |                                               *
     *   |    |                                               *
     *   |    |                                               *
     *   ------                                               *
     *                                                        *
     *********************************************************/

#include <stdio.h>

unsigned char *dalib_buffer;
int dalib_buffer_size;
int dalib_buffer_pos;
int dalib_buffer_kind;  /* 0 for send, 1 for recv */

     /*********************************************************
     *                                                        *
     *  Creating and Destroying of the Buffer                 *
     *                                                        *
     *********************************************************/

void dalib_create_buffer (size, kind)
int size;
int kind;

{ /* create a buffer with size bytes */

  dalib_buffer = (unsigned char*) (malloc (size));
  if (dalib_buffer == NULL)
     { printf ("Creation of a buffer with %d Bytes failed\n", size);
       exit (-1);
     }
#ifdef MEIKO_CS2
  ew_touchBuf(dalib_buffer, size);
#endif

  dalib_buffer_size = size;
  dalib_buffer_pos  = 0;
  if (kind == 0)
    dalib_buffer_kind = 0;  /* buffer is for fill and send */
   else
    dalib_buffer_kind = 1;  /* buffer is for recv and get */
}

void dalib_destroy_buffer ()

{ /* destroy the buffer */
  free (dalib_buffer);
  dalib_buffer_size = 0;
}

     /*********************************************************
     *                                                        *
     *  Fill the Buffer  / Read from Buffer                   *
     *                                                        *
     *********************************************************/

void dalib_fill_buffer (ptr, size)

unsigned char *ptr;
int size;

{
  /* make sure that filling is allowed */
  if (dalib_buffer_kind != 0)
   { printf ("Internal Error: No Buffer filling\n");
     exit(-1);
   }
 
  /* make sure that new message is not to large */
  if (dalib_buffer_pos + size > dalib_buffer_size)
   { printf ("Internal Error: Message to big for buffer filling\n");
     exit(-1);
   }
 
  dalib_memcpy (dalib_buffer+dalib_buffer_pos, ptr, size);
  dalib_buffer_pos += size;
}

void dalib_get_buffer (ptr, size)

unsigned char *ptr;
int size;

{
  /* make sure that receiving is allowed */
  if (dalib_buffer_kind != 1)
   { printf ("Internal Error: No Buffer receiving \n");
     exit(-1);
   }
 
   dalib_memcpy (ptr, dalib_buffer+dalib_buffer_pos, size);
   dalib_buffer_pos += size;
}

     /*********************************************************
     *                                                        *
     *  Sending / Receiving of the buffer                     *
     *                                                        *
     *********************************************************/

void dalib_send_buffer (to)
int to;

{ /* the whole buffer is send to process 'to' */
  int from;

  /* make sure that sending is allowed */
  if (dalib_buffer_kind != 0)
   { printf ("Internal Error: No Buffer sending \n");
     exit(-1);
   }
 
  /* make sure that the buffer is full */
  if (dalib_buffer_pos != dalib_buffer_size)
   { printf ("Internal Error: Buffer not full for sending \n");
     exit(-1);
   }
 
  from = dalib_pid_();
  asend (from, to, dalib_buffer, dalib_buffer_size);
}

void dalib_recv_buffer (from)
int from;

{ /* the whole buffer is received from process 'from' */
  int to;

  /* make sure that receiving is allowed */
  if (dalib_buffer_kind != 1)
   { printf ("Internal Error: No Buffer receiving \n");
     exit(-1);
   }
 
  /* make sure that the buffer was empty */
  if (dalib_buffer_pos != 0)
   { printf ("Internal Error: Buffer not empty for receiving\n");
     exit(-1);
   }
 
  to = dalib_pid_();
  areceive (to, from, dalib_buffer, dalib_buffer_size);
}

