
#include "pvm3.h"
#include "pvmconst.h"
#include "../src/bfunc.h"

void
FUNCTION(pvmfconfig)
	ARGS(`nhostp,
		narchp,
		tidp,
		STRING_ARG(name),
		STRING_ARG(arch),
		speedp,
		infop')

	int  *nhostp, *narchp, *tidp, *speedp, *infop;
	STRING_ARG_DECL(name);
	STRING_ARG_DECL(arch);
{
	static struct hostinfo *hip = 0;
	static int nhost = 0;
	static int narch = 0;
	static int next = 0;

	int cc;
	struct hostinfo *hip2;

	char *malloc();

	if (!hip) {
		if ((cc = pvm_config(&nhost, &narch, &hip2)) < 0) {
			*infop = cc;
			return;
		}
		hip = (struct hostinfo*)malloc(nhost * sizeof(struct hostinfo));
		BCOPY((char*)hip2, (char*)hip, nhost * sizeof(struct hostinfo));
		next = 0;
	}

	if (next < nhost) {
		*nhostp = nhost;
		*narchp = narch;
		*tidp = hip[next].hi_tid;
		ctofstr(STRING_PTR(name), STRING_LEN(name), hip[next].hi_name);
		ctofstr(STRING_PTR(arch), STRING_LEN(arch), hip[next].hi_arch);
		*speedp = hip[next].hi_speed;
		*infop = 1;
		next++;

	}

	if (next == nhost) {
		free((char*)hip);
		hip = 0;
	}
}

