#include <idmprov.hpp>
#include <idmitem.hpp>
#include <idmevent.hpp>
#include <idmhndlr.hpp>
#include <iframe.hpp>
#include <istring.hpp>
#include <IMLE.hpp>
#include <ithread.hpp>


//create a new drag item to handle file drops

class AFileItem : public IDMItem {
public:
  AFileItem ( const IDMItem::Handle &item );

virtual Boolean
  targetDrop ( IDMTargetDropEvent & );
};



// Create a Provider class to handle dragover messages

class AFileProvider : public IDMItemProviderFor< AFileItem > {

public:
virtual Boolean
  provideEnterSupport ( IDMTargetEnterEvent &event );
};





class MyFrame:public IFrameWindow{

public:
   MyFrame(const char *Title);
   void StartLoadThread();

   void SetFileName(IString &S){FileName=S;}

protected:
   void LoadFile();

   IReference<IThreadFn>    ThreadFncRef;
   IThreadMemberFn<MyFrame> *ExecuteThreadFnc;
   IThread                  ExecuteThread;

   IString FileName;

   IMultiLineEdit EditWin;
   AFileProvider FileProvider;
};





MyFrame::MyFrame(const char *Title):
   IFrameWindow(Title,IResourceId(1),  //-------------------
      IFrameWindow::titleBar|          //
      IFrameWindow::sizingBorder|      //
      IFrameWindow::minimizeButton|    // Create the Frame 
      IFrameWindow::systemMenu|        //  Window
      IFrameWindow::shellPosition|     //
      IFrameWindow::minimizeButton|    //
      IFrameWindow::windowList|        //
      IFrameWindow::maximizeButton),   //--------------------
   EditWin(10,this,this){              // Create the Edit Window
                                       // ID=10, usee this frame 
                                       // window as the parent and 
                                       //owner
                                       //---------------------

   setIcon(IResourceId(1));
   setClient(&EditWin);

   //enable default drag and drop handler
   IDMHandler::enableDragDropFor(&EditWin);
   EditWin.setItemProvider(&FileProvider);

   //Create the thread support members.
   ExecuteThreadFnc=new IThreadMemberFn<MyFrame>(*this,
                  &MyFrame::LoadFile);

   ThreadFncRef=IReference<IThreadFn>(ExecuteThreadFnc);

   show();
}



void MyFrame::StartLoadThread(){
   ExecuteThread.start(ThreadFncRef);
}

void MyFrame::LoadFile(){
   //erase the edit window
   EditWin.removeAll();

   //load the file into the edit window
   EditWin.importFromFile(FileName);
}



//File Item constructor
AFileItem::AFileItem( const IDMItem::Handle &item ):IDMItem( item ){
}

Boolean AFileItem::targetDrop( IDMTargetDropEvent & Event){
   IMultiLineEdit *DropWin=(IMultiLineEdit *)this->targetOperation()->targetWindow();


   IString
    fname = this->containerName() + this->sourceName();

   MyFrame *FrameWin=(MyFrame*) DropWin->parent();
 
   FrameWin->SetFileName(fname);
   FrameWin->StartLoadThread();

   return true;
}


Boolean AFileProvider::provideEnterSupport( IDMTargetEnterEvent &event ){

  // Get handle to the drag target operation
  IDMTargetOperation::Handle targetOp = IDMTargetOperation::targetOperation();


  // only want to accept 1 file
  if(targetOp->numberOfItems()!=1){
     event.setDropIndicator(IDM::neverOk);
     return(true);
   }

  // Get the types for the drag item.                                    
  IString strTypes = targetOp->item(1)->types();

  // See if it's marked as a "plain text" file
  if ((strTypes.indexOf(IDM::plainText))){
     event.setDropIndicator(IDM::ok);
    return(true);
  }

  // Type is not recognized - set the drop indicator to prevent a drop!  
  event.setDropIndicator(IDM::neverOk);
  return(true);
}






//------------------------------------------------------
// Main routine

int main(){
   MyFrame Frame("Test App");

   IApplication::current().run();

return 0;
}
