/* Skeleton program from the book Real World Programming for OS/2 2.1 plus */
/* modifications by Semir Patel (spatel@cs.utexas.edu)                     */

#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <process.h>
#include "skeleton.h"
#include "sound.h"

MRESULT EXPENTRY ClientWndProc      (HWND,ULONG,MPARAM,MPARAM);
MRESULT EXPENTRY SoundTestDlgProc   (HWND,ULONG,MPARAM,MPARAM);

HAB   hab;
HWND  hWndFrame,
      hWndClient;
CHAR  szTitle[64];

int main()
{
    HMQ   hmq;
    QMSG  qmsg;
    ULONG flFrameFlags    = FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER |
                            FCF_MINMAX   | FCF_SHELLPOSITION | FCF_TASKLIST |
                            FCF_ICON;
    CHAR  szClientClass[] = "CLIENT";

    hab = WinInitialize (0);
    hmq = WinCreateMsgQueue (hab, 0);

    WinRegisterClass (hab, szClientClass, (PFNWP)ClientWndProc, 0, 0);
    WinLoadString (hab, 0, ID_APPNAME, sizeof(szTitle), szTitle);

    hWndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
        &flFrameFlags, szClientClass, szTitle, 0, 0, ID_APPNAME, &hWndClient);

    while (WinGetMsg (hab, &qmsg, 0, 0, 0))
        WinDispatchMsg (hab, &qmsg);

    WinDestroyWindow (hWndFrame);
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);
    return (0);
}

MRESULT EXPENTRY ClientWndProc (HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    HPS     hps;
    BOOL    bHandled = TRUE;
    MRESULT mReturn  = 0;
    TID     tidSoundThread;

    switch (msg)
    {

        case WM_CREATE:

            /* start sound thread */
            tidSoundThread = _beginthread (SoundThread,32768, NULL);
            break;

        case WM_SOUNDS_READY:

            /* call dlg box */
             WinDlgBox(HWND_DESKTOP,
                      hWnd,
                      (PFNWP)SoundTestDlgProc,
                      NULLHANDLE,
                      DLG_SOUND,NULL);

             /* let sound cleanup after itself */
             WinSendMsg (hwndSound,WM_TERMINATE,NULL,NULL);

             WinSendMsg (hWnd, WM_QUIT, NULL,NULL);

            break;

        case WM_PAINT:
            hps = WinBeginPaint (hWnd,0,0);
            WinEndPaint (hps);
            break;

        case WM_ERASEBACKGROUND:
            mReturn = MRFROMLONG(1L);
            break;

        default:
            bHandled = FALSE;
            break;
    }

    if (!bHandled)
        mReturn = WinDefWindowProc (hWnd,msg,mp1,mp2);

    return (mReturn);
}


/*******************************************************/
/*                SoundTestDlgProc                     */
/*******************************************************/
MRESULT EXPENTRY SoundTestDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    SWP DlgInfo;

    switch (msg)
    {
        /* yes/no buttons */
        case WM_COMMAND:
              switch (SHORT1FROMMP(mp1))
              {
                      case DID_OK:
                              WinDismissDlg (hwnd,TRUE);
                              break;

                      case BUTTON_SOUND1 :
                              WinPostMsg (hwndSound, WM_PLAY, (MPARAM)0,(MPARAM)NULL);
                              break;

                      case BUTTON_SOUND2 :
                              WinPostMsg (hwndSound, WM_PLAY, (MPARAM)1,(MPARAM)NULL);
                              break;

                      case BUTTON_SOUND3 :
                              WinPostMsg (hwndSound, WM_PLAY, (MPARAM)2,(MPARAM)NULL);
                              break;
              }
            break;

        default:
            return WinDefDlgProc(hwnd,msg,mp1,mp2);
    }
    return (MRESULT)TRUE;
}


