///////////////////////////////////////////////////////////////////////////
// GIOVIONP
//


// For a VERY simple named pipe demonstration, load two copies of GIOVIONP
// at the same time.
// One copy with the command:  GIOVIONP \PIPE\GIOPIPE 1
// The other with the command: GIOVIONP \PIPE\GIOPIPE 0
//
// You can then type on one copy of the program, and have it echo on the
// other, and vice versa. Once again, this is a VERY simple example. You
// might want to modify the program so that when operating in server mode
// it not only shows what is typed, but if it receives characters from the
// client it echos the characters back to the client (much like a BBS does)
// Also some processing of controls characters is needed (like backspaces,
// and carriage returns)

#define INCL_BASE
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <io.h>

// GIO
#include "gio2.h"

#define EXITKEY 0x2D
#define CLRSCRN 0x2E

LONG CommIn(HCOMINFO);
LONG CommOut(HCOMINFO);

CHAR TempString[300];

void main(INT ArgCount, CHAR **ArgVars)
{
    BOOL    KeepLooping = TRUE;
    CHAR    ComPort[256];
    KBDINFO KBStatus;
    HCOMINFO hComInfo;
    APIRET  RetCode;
    BOOL    GotConnect = FALSE;
    BOOL    ServerFlag;

    if (ArgCount < 3)
    {
        printf("\nUsage:  GIOVIONP comport serverflag\n");

        printf("          comport = \PIPE\filename\n");

        printf("          serverflag = 1=server 0=client\n");

        printf("\n  Ex.  GIOVIONP \PIPE\MyPipeName 1\n\n");

        exit(1);
    }

    strcpy(TempString, "GIOVIONP... A VIO test pgm for Gern's Named Pipe IO routines...\n\r");
    VioWrtTTY(TempString, strlen(TempString), 0);

    // Set up keyboard

    KBStatus.cb = sizeof(KBStatus);
    KbdGetStatus(&KBStatus, 0);

    KBStatus.fsMask &= 0xFFF0;
    KBStatus.fsMask |= KEYBOARD_ECHO_OFF | KEYBOARD_BINARY_MODE;
    KbdSetStatus(&KBStatus, 0);

    strcpy(ComPort, ArgVars[1]);

    ServerFlag = atol(ArgVars[2]);

    if ((RetCode = ComOpen(ComPort, 0, 0, 0, 0, 0, ServerFlag ? ISPIPESERVER : ISPIPECLIENT, &hComInfo)))
    {
        printf("\nError (%lu) - Can't Open '%s' (%ld)!\n", RetCode, ComPort, hComInfo);

        exit(1);
    }

    do
    {
        if (ComGetDCD(hComInfo))
        {
            if (! GotConnect)
            {
                GotConnect = TRUE;

                VioWrtTTY("Named Pipe Connected!\n", 22, 0);
            }
        }
        else
        {
            if (GotConnect)
            {
                VioWrtTTY("Named Pipe DisConnected!\n", 25, 0);

                ComDisConnect(hComInfo);  // nuke pipe connection

                ComConnect(hComInfo);     // listen for new connection

                GotConnect = FALSE;
            }
        }

        CommIn(hComInfo);

        KeepLooping = (BOOL) CommOut(hComInfo);

    } while (KeepLooping);

    ComClose(hComInfo);

    strcpy(TempString, "\r\nTerminating...\r\n\n");
    VioWrtTTY(TempString, strlen(TempString), 0);

    DosExit(EXIT_PROCESS, 0);
}

LONG CommOut(HCOMINFO hComInfo)
{
    KBDKEYINFO KBInfo;

    KbdCharIn(&KBInfo, IO_NOWAIT, 0);

    if (! KBInfo.fbStatus)
        return(1);

    if ((KBInfo.chChar == 0) || (KBInfo.chChar == 0xE0))
    {
        switch (KBInfo.chScan)
        {
            case CLRSCRN:
                VioWrtTTY("\x1B[2J", 4, 0);
                break;
            case EXITKEY:
                return (0);

        }
    }

    ComTXChar(hComInfo, KBInfo.chChar, FALSE);

    return (1);
}

LONG CommIn(HCOMINFO hComInfo)
{
    BYTE     TrueChar;
    SHORT    InChar;

    if (! ComRXEmpty(hComInfo))
    {
        if (! ComRXChar(hComInfo, &InChar, 0))
        {
            if (InChar == 12)
                VioWrtTTY("\x1B[2J", 4, 0);
            else
            {
                TrueChar = (BYTE) InChar;
                VioWrtTTY(&TrueChar, 1, 0);
            }
        }
    }
    else
        DosSleep(5);

    return(0);
}

