///////////////////////////////////////////////////////////////////////////
// GIOVIO2
//

#define INCL_BASE
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <io.h>

// GIO
#include "gio2.h"

#define EXITKEY 0x2D
#define CLRSCRN 0x2E

LONG CommIn(HCOMINFO);
LONG CommOut(HCOMINFO);

CHAR TempString[300];

void main(INT ArgCount, CHAR **ArgVars)
{
    BOOL    KeepLooping = TRUE;
    CHAR    ComPort[6];
    KBDINFO KBStatus;
    HCOMINFO hComInfo;

    if (ArgCount < 2)
    {
        printf("\nUsage:  GIOVIO comport#\n");

        exit(1);
    }

    strcpy(TempString, "GIOVIO... A VIO test pgm for Gern's IO routines...\n\r");
    VioWrtTTY(TempString, strlen(TempString), 0);

    // Set up keyboard

    KBStatus.cb = sizeof(KBStatus);
    KbdGetStatus(&KBStatus, 0);

    KBStatus.fsMask &= 0xFFF0;
    KBStatus.fsMask |= KEYBOARD_ECHO_OFF | KEYBOARD_BINARY_MODE;
    KbdSetStatus(&KBStatus, 0);

    sprintf(ComPort, "COM%c", ArgVars[1][0]);

    if (ComOpen(ComPort, 0, 19200, 'N', 8, 1, 0, &hComInfo))
    {
        printf("\nCan't Open '%s' (%ld)!\n", ComPort, hComInfo);

        exit(1);
    }

    ComRXPurge(hComInfo);

    do
    {
        CommIn(hComInfo);

        KeepLooping = (BOOL) CommOut(hComInfo);

    } while (KeepLooping);

    ComClose(hComInfo);

    strcpy(TempString, "\r\nTerminating...\r\n\n");
    VioWrtTTY(TempString, strlen(TempString), 0);

    DosExit(EXIT_PROCESS, 0);
}

LONG CommOut(HCOMINFO hComInfo)
{
    KBDKEYINFO KBInfo;

    KbdCharIn(&KBInfo, IO_NOWAIT, 0);

    if (! KBInfo.fbStatus)
        return(1);

    if ((KBInfo.chChar == 0) || (KBInfo.chChar == 0xE0))
    {
        switch (KBInfo.chScan)
        {
            case CLRSCRN:
                VioWrtTTY("\x1B[2J", 4, 0);
                break;
            case EXITKEY:
                return (0);

        }
    }

    ComTXChar(hComInfo, KBInfo.chChar, FALSE);

    return (1);
}

LONG CommIn(HCOMINFO hComInfo)
{
    BYTE     TrueChar;
    SHORT    InChar;

    if (! ComRXEmpty(hComInfo))
    {
        if (! ComRXChar(hComInfo, &InChar, 0))
        {
            if (InChar == 12)
                VioWrtTTY("\x1B[2J", 4, 0);
            else
            {
                TrueChar = (BYTE) InChar;
                VioWrtTTY(&TrueChar, 1, 0);
            }
        }
    }
    else
        DosSleep(5);

    return(0);
}

