$| = 1;

$target = shift @ARGV if (@ARGV == 1);

@dirs = (".");

for(<*>) {
	push(@dirs, $_) if (-d $_);
}

open(DEFS, ">$target.def");

print DEFS <<END;
LIBRARY
DESCRIPTION 'Gcc/2 Dynamic C Library'
CODE PRELOAD
DATA MULTIPLE NONSHARED
EXPORTS
END

$skip = 0;
while(<>) {
	if (/^Object Name: (\S+),/) {
		if ($1 eq "crt0.obj" || $1 eq "crt1.obj") {
			$skip = 1;
			next;
		}
		$skip = 0;
		next if ($obj_file);
		$f = $1;
		foreach(@dirs) {
			if (-f "$_/$f") {
				$obj_file = "$_\\$f";
				last;
			}
		}
		next;
	}
	next if ($skip);
	print DEFS "\t$1\n" if (/^\s+(\S+)\s+\[/);
}
close(DEFS);

if (! $obj_file) {
	print STDERR "No object file found\n";
	exit 1;
}

open(RSP, ">$target.rsp");
print RSP <<RSPEND;
/NOI /NOL /NOD $obj_file
$target.dll

os2.lib libc.lib
$target.def

RSPEND
close(RSP);
