#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>

extern int *__textio;
extern char __textbuf[8096];

int write (int fd, const void *buf, size_t nbytes)
{
   ULONG BytesWritten;
   ULONG rc;

   if (__textio[fd] & O_APPEND)
      lseek (fd, 0, SEEK_END);

   if (__textio[fd] & O_BINARY)
   {
      rc = DosWrite (fd, (PVOID) buf, nbytes, &BytesWritten);

      if (rc)
      {
         if (rc == ERROR_INVALID_HANDLE)
         {
            errno = EBADF;
            return (-1);
         }

         if (rc == ERROR_BROKEN_PIPE)
         {
            errno = EPIPE;
            return (-1);
         }

         errno = EIO;
         return (-1);
      }

      return (nbytes);
   }
   else
   {
      int bcount = nbytes;
      register char c;
      char *fbuf = (char *)buf;

      while (bcount)
      {
         char *tbuf = (char *)__textbuf;
         int thistime = bcount > 8095 ? 8095 : bcount;
         int wcount = thistime;

         for (; 0 < thistime && 0 < bcount; --thistime)
         {
            c = *fbuf++;
            if (c == '\n')
            {
               *tbuf++ = '\r';
               if (--thistime == 0)
               {
                  *tbuf = '\n';
                  ++wcount;
                  --bcount;
                  continue;
               }
            }
               *tbuf++ = c;
               --bcount;
         }

         rc = DosWrite (fd, (PVOID) __textbuf, wcount, &BytesWritten);

         if (rc)
         {
            if (rc == ERROR_INVALID_HANDLE)
            {
               errno = EBADF;
               return (-1);
            }

            if (rc == ERROR_BROKEN_PIPE)
            {
               errno = EPIPE;
               return (-1);
            }

            errno = EIO;
            return (-1);
         }
      }

      return (nbytes - bcount);
   }
}

