#include <process.h>
#include <stdarg.h>
#include "../mkerr.h"

char **_alloc_argv(va_list va);
void _fill_argv(const char *arg0, const char **argv, va_list va);

int spawnlp (int modeflag, const char *path, const char *arg0, ...)
{
  va_list va;
  char **argv;

  /* Alloc argv array */
  va_start(va, arg0);
  argv = _alloc_argv(va);
  va_end(va);
  if (argv == 0)
    reterr(ENOMEM);

  /* Fill argv array */
  va_start(va, arg0);
  _fill_argv (arg0, (const char **)argv, va);
  va_end(va);

  return _spawn(modeflag, _SPAWN_SEARCH_PATH, path,
		(const char * const *) argv, 0);
}
