#define INCL_DOSMEMMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <sys/types.h>
#include <errno.h>

void *__start_of_data = 0;
void *__first_uncommited_block = 0;
void *__first_uncommited_byte = 0;

void * start_of_data ()
{
   ULONG rc;

   if (__start_of_data)
      return (__start_of_data);

    rc = DosAllocMem (&__start_of_data, 0x4000000, PAG_READ | PAG_WRITE);

    if (rc) {
       if (rc == ERROR_NOT_ENOUGH_MEMORY) {
          errno = ENOMEM;
          return ((void *)-1);
       }

       if (rc == ERROR_INVALID_PARAMETER) {
          errno = EINVAL;
          return ((void *)-1);
       }

       errno = -1;
       return ((void *)-1);
    }

    __first_uncommited_block = __first_uncommited_byte = __start_of_data;
    return (__start_of_data);
}

