#define INCL_DOSDATETIME
#include <os2.h>

#include <sys/time.h>
#include <sys/resource.h>

extern struct rusage _rusage;
extern DATETIME _startup_time;

int getrusage (int who, struct rusage *rusage)
{
   long diffsecs;
   DATETIME buf;

   DosGetDateTime (&buf);

   *rusage = _rusage;

   diffsecs = (buf.seconds
            + (buf.minutes * 60)
            + (buf.hours * 3600))
            - (_startup_time.seconds
            + (_startup_time.minutes * 60)
            + (_startup_time.hours * 3600));

   rusage -> ru_utime.tv_sec = diffsecs;
   rusage -> ru_utime.tv_usec =
                      (buf.hundredths - _startup_time.hundredths) * 10000;

   return (0);
}

