#include <unistd.h>
#include "../mkerr.h"

#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>

ULONG Dos32DupHandle() asm ("Dos32DupHandle");

extern int __expand_io_if_needed(int maxfd);
extern int *__textio;

int dup (int oldd)
{
   int newd = -1;
   ULONG rc;
   int first_try = 1;

 retry_alloc:
   rc = Dos32DupHandle (oldd, (PHFILE)&newd);

   /* Expand the file handle resource, if needed */
   if (rc == ERROR_TOO_MANY_OPEN_FILES && first_try)
     {
       LONG more_files = 32;
       ULONG new_file_max;
       rc = DosSetRelMaxFH(&more_files, &new_file_max);
       first_try = 0;
       if (rc == 0) goto retry_alloc;
     }

   /* Decode errors */
   if (rc)
     {
       switch (rc)
	 {
	 case ERROR_TOO_MANY_OPEN_FILES:
	   reterr(EMFILE);
	 case ERROR_INVALID_HANDLE:
	   reterr(EBADF);
	 case ERROR_INVALID_TARGET_HANDLE:
	 default:
	   /* Unexpected error */
	   reterr(EIO);
	 }
     }

   /* Increase fh attribute space */
   if (__expand_io_if_needed(newd) == -1)
     {
       DosClose(newd);
       reterr(ENOMEM);
     }

   /* Set the text/binary mode of the handle */
   __textio[newd] = __textio[oldd];

   /* return the new handle */
   return newd;
}
