/* Configuration for GNU compiler
   for an Intel i386 or later processor running OS/2 2.x.
   Copyright (C) 1993 Free Software Foundation, Inc.
   Contributed by Samuel Figueroa (figueroa@cs.nyu.edu)

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef OS2
#define OS2
#endif

#ifdef __IBMC__
#include <stdlib.h> /* this defines alloca */
#define USG
#define ONLY_INT_FIELDS
#define HAVE_PUTENV
#define USE_PROTOTYPES 1
#define bcmp(a,b,c) memcmp (a,b,c)
#define bcopy(a,b,c) memcpy (b,a,c)
#define bzero(a,b) memset (a,0,b)
#define index  strchr
#define rindex strrchr
#define kill(a,b) raise(b)
#define mktemp tmpnam
#else
#define ____386BSD____
/* Get prototypes for spawn* from system header file */
#include <process.h>
#endif /* __IBMC__ */

#include "i386/xm-i386.h"

#ifdef __GNUC__
#define HAVE_PUTENV
#endif

/* 
 * Code to simplify the environent setup under OS/2.
 * Something similar could be used for DJGPP and NT.
 */
#ifdef __GNUC__
extern char *_gcc2_get_unixish_path();
extern char *_gcc2_getpath();

#define OS_INIT								\
do {									\
  char *unix_env_gcc2 = _gcc2_get_unixish_path();			\
  char *os2_env_gcc2 = _gcc2_getpath();					\
  if (os2_env_gcc2 != 0)						\
    {									\
      ALTER_ENV("PATH",    os2_env_gcc2, "\\bin");			\
      ALTER_ENV("LIB",	   os2_env_gcc2, "\\lib");			\
      ALTER_ENV("INCLUDE", os2_env_gcc2, "\\include");			\
    }									\
  if (unix_env_gcc2 != 0)						\
    {									\
      ALTER_ENV("C_INCLUDE_PATH",     unix_env_gcc2, "/os2incl");	\
      ALTER_ENV("C_INCLUDE_PATH",     unix_env_gcc2, "/gccincl");	\
      ALTER_ENV("CPLUS_INCLUDE_PATH", unix_env_gcc2, "/os2incl");	\
      ALTER_ENV("CPLUS_INCLUDE_PATH", unix_env_gcc2, "/gccincl");	\
      ALTER_ENV("CPLUS_INCLUDE_PATH", unix_env_gcc2, "/gppincl");	\
      ALTER_ENV("OBJC_INCLUDE_PATH",  unix_env_gcc2, "/os2incl");	\
      ALTER_ENV("OBJC_INCLUDE_PATH",  unix_env_gcc2, "/gccincl");	\
      ALTER_ENV("OBJC_INCLUDE_PATH",  unix_env_gcc2, "/objcincl");	\
    }									\
  _gcc2_append_argv ("gcc", &argc, &argv);				\
} while (0)

#define ALTER_ENV(env, prefix1, prefix2)				\
do {									\
  char *newprefix = alloca (strlen (prefix1) + strlen(prefix2) + 1);	\
  strcpy (newprefix, prefix1);						\
  strcat (newprefix, prefix2);						\
  _insert_env (env, newprefix, ';');					\
} while (0);

#endif /* defined __GNUC__ */

/* OS/2 uses colons in filenames.  Semicolon is traditionally used
 * as the OS/2 path separator */
#define PATH_SEPARATOR ';'
