/* Definitions of target machine for GNU compiler
   for an Intel i386 or later processor running OS/2 2.x.
   Copyright (C) 1993 Free Software Foundation, Inc.
   Contributed by Samuel Figueroa (figueroa@cs.nyu.edu)
   Modified by Colin Jensen (cjensen@netcom.com)

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef DEFAULT_TARGET_MACHINE
#define DEFAULT_TARGET_MACHINE "i386-os2"
#endif
#ifndef STARTFILE_SPEC
#define STARTFILE_SPEC ""
#endif
#ifndef LIB_SPEC
#define LIB_SPEC "-lc"
#endif
#ifndef LINK_SPEC
#define LINK_SPEC "%{v} %{g} %{static}"
#endif
#ifndef MD_EXEC_PREFIX
#define MD_EXEC_PREFIX "\\gcc\\bin\\"
#endif
#ifndef ASM_SPEC
#define ASM_SPEC "%{g}"
#endif
#ifndef ASM_OFILE_SPEC
#define ASM_OFILE_SPEC "-I %{c:%W{o*}%{!o*:-o %w%b.obj}}%{!c:-o %d%w%u.obj}"
#endif
#undef CPP_SPEC
#define CPP_SPEC "-D_Far16= -D_Pascal= -D_Cdecl= -D_Seg16= -D_System= -D__OS2__=1"
#ifndef STANDARD_STARTFILE_PREFIX
#define STANDARD_STARTFILE_PREFIX "\\gcc\\lib\\"
#endif
#ifndef LOCAL_INCLUDE_DIR
#define LOCAL_INCLUDE_DIR "\\gcc\\include"
#endif

#define YES_UNDERSCORES
#include "i386/gstabs.h"

#define USE_COLLECT

#define BIGGEST_FIELD_ALIGNMENT \
  (maximum_field_alignment ? maximum_field_alignment : 32)

extern int maximum_field_alignment;

#undef PCC_BITFIELD_TYPE_MATTERS
#define PCC_BITFIELD_TYPE_MATTERS (maximum_field_alignment == 0)

/* Define this macro if it is advisible to hold scalars in registers
   in a wider mode than that declared by the program.  In such cases,
   the value is constrained to be within the bounds of the declared
   type, but kept valid in the wider mode.  The signedness of the
   extension may differ from that of the type.  */

#if 0 /* Is this code causing grief? */
#define PROMOTE_MODE(MODE,UNSIGNEDP,TYPE)  \
  if (GET_MODE_CLASS (MODE) == MODE_INT         \
      && GET_MODE_SIZE (MODE) < UNITS_PER_WORD) \
      (MODE) = SImode;
#endif

/* Define this if function arguments should also be promoted using the above
   procedure.  */

#define PROMOTE_FUNCTION_ARGS

/* Likewise, if the function return value is promoted.  */

#define PROMOTE_FUNCTION_RETURN


#define DBX_OUTPUT_MAIN_SOURCE_DIRECTORY(asmfile, cwd)			      \
do {									      \
    char *p;								      \
    char *os2cwd = (char *) malloc (strlen (cwd) + 1);			      \
    if (os2cwd) {							      \
	strcpy (os2cwd, cwd);						      \
	for (p = os2cwd; *p; p++)					      \
	    if (*p == '\\')						      \
		*p = '/';						      \
	fprintf (asmfile, "%s \"%s/\",%d,0,0,%s\n", ASM_STABS_OP,	      \
		 os2cwd, N_SO, &ltext_label_name[1]);			      \
	free (os2cwd);							      \
    }									      \
} while (0)

/* Proper use of the OS/2 System Header files requires the use of the
 * dreaded #pragma pack() macros. */
#define HANDLE_SYSV_PRAGMA
#define HANDLE_CXX_PRAGMA_PACK

/* Code to handle #pragma directives.  The interface is a bit messy,
   but there's no simpler way to do this while still using yylex.  */
#define HANDLE_PRAGMA(FILE)					\
  do {								\
    while (c == ' ' || c == '\t')				\
      c = getc (FILE);						\
    if (c == '\n' || c == EOF)					\
      {								\
	handle_pragma_token (0, 0);				\
	return c;						\
      }								\
    ungetc (c, FILE);						\
    switch (yylex ())						\
      {								\
      case IDENTIFIER:						\
      case TYPENAME:						\
      case STRING:						\
      case CONSTANT:						\
	handle_pragma_token (token_buffer, yylval.ttype);	\
	break;							\
      default:							\
	handle_pragma_token (token_buffer, 0);			\
      }								\
    if (nextchar >= 0)						\
      c = nextchar, nextchar = -1;				\
    else							\
      c = getc (FILE);						\
  } while (1)

/* OS/2 object code has a non-standard suffix */
#define DEPS_OUTPUT_EXTENSION ".obj : "

/* OS/2 also uses the DOSlike suffix to indicate executables */
#define EXECUTABLE_SUFFIX ".exe"

/* C++ users in DOS and OS/2 are used to using .cpp instead of .cc */
#define CPP_EXTENTION_IS_CPLUSPLUS
