/* mktime2.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int main (int argc, char *argv[])
{
  struct tm tm1, tm2;
  time_t t1, t2;
  static char tz[50];

  if (argc != 2)
    {
      puts ("Usage: mktime2 <timezone>");
      return 1;
    }

  sprintf (tz, "TZ=%s", argv[1]);
  putenv (tz);
  tzset ();

  tm1.tm_sec = 56;
  tm1.tm_min = 34;
  tm1.tm_hour = 12;
  tm1.tm_mday = 3;
  tm1.tm_mon = 3;
  tm1.tm_year = 96;
  tm1.tm_isdst = -1;

  t1 = mktime (&tm1);
  printf ("%lu\n", (unsigned long)t1);

  printf ("%d:%d:%d\n",
          (int)((t1 / 3600) % 24), (int)((t1 / 60) % 60), (int)(t1 % 60));

  tm2 = *localtime (&t1);
  printf ("%d-%d-%d %d:%d:%d\n",
          tm2.tm_year+1900, tm2.tm_mon + 1, tm2.tm_mday,
          tm2.tm_hour, tm2.tm_min, tm2.tm_sec);

  t2 = mktime (&tm2);
  printf ("%lu\n", (unsigned long)t2);
  return 0;
}
