/* mktime.c (emx+gcc) */

/* Regression test for mktime() */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

int main (int argc, char *argv[])
{
  char line[512], *p;
  struct tm t;
  time_t x;

  if (argc != 1)
    {
      puts ("Usage: mktime1");
      return 1;
    }
  while (fgets (line, sizeof (line), stdin) != NULL)
    {
      p = strchr (line, '\n');
      if (p != NULL) *p = 0;

      if (strncmp (line, "TZ=", 3) == 0)
        putenv (strdup (line));
      else if (sscanf (line, "%d/%d/%d %d:%d:%d %d",
                       &t.tm_year, &t.tm_mon, &t.tm_mday,
                       &t.tm_hour, &t.tm_min, &t.tm_sec, &t.tm_isdst) != 7)
        puts ("INVALID INPUT");
      else
        {
          --t.tm_mon; t.tm_year -= 1900;
          if ((x = mktime (&t)) == (time_t)-1)
            puts ("FAILURE");
          else
            printf ("%.2d/%.2d/%.2d %.2d:%.2d:%.2d %d %3d %d %lu\n",
                    t.tm_year + 1900, t.tm_mon + 1, t.tm_mday,
                    t.tm_hour, t.tm_min, t.tm_sec,
                    t.tm_wday, t.tm_yday, t.tm_isdst, (unsigned long)x);
        }
    }
  return 0;
}
