

TRN(1)                   USER COMMANDS                     TRN(1)



NAME
     trn - threaded read news program

SYNOPSIS
     trn [options] [newsgroups]

DESCRIPTION
     Trn is a threaded version of rn, which is a replacement  for
     the  readnews(1)  program.   Being "threaded" means that the
     articles are interconnected in reply order.  Each discussion
     thread  is  a  tree of articles, where all the reply (child)
     articles  branch  off  from  their  respective   originating
     (parent) articles.  A representation of this tree (or a por-
     tion of it) is displayed in the article header  as  you  are
     reading  news.  This gives you a better feel for how all the
     articles are related, and even lets you see at a glance when
     an article already has a plethora of replies (to avoid beat-
     ing a subject to death).  In  addition,  trn  has  a  thread
     selector menu that allows you to quickly browse the subjects
     and authors of the available threads and choose the ones you
     find interesting.  The remaining threads can either be saved
     for later or marked as read.

     If you are already familiar with rn you will  probably  want
     to skip forward to the section on the Thread Selection Mode,
     then move on to read about the Tree Display, and finish with
     the  summary of What's New?  with trn.  If you're impatient,
     just dive in and get started.  All the regular commands  are
     the  same as those in rn, and the on-line help will give you
     a quick run-down of what new commands are  available.   Just
     type 'h' from any prompt.  I'd suggest using the command:

         trn -x -X

     to make sure some of the best new features are turned on.

     Starting Trn

     If no newsgroups are specified,  all  the  newsgroups  which
     have  unread  news are displayed, and then the user is asked
     for each one whether he wants to read it, in  the  order  in
     which the newsgroups occur in the .newsrc file.  With a list
     of newsgroups, trn will start up in "add"  mode,  using  the
     list as a set of patterns to add new newsgroups and restrict
     which newsgroups are displayed.  See the discussion  of  the
     'a' command on the newsgroup selection level.

     Trn operates on four levels: the newsgroup selection  level,
     the thread selection level, the article selection level, and
     the paging level.  Each level has its own set  of  commands,
     and  its  own  help  menu.   At the paging level (the bottom
     level), trn behaves much like the more(1) program.   At  the



Sun Release 4.1        Last change: LOCAL                       1






TRN(1)                   USER COMMANDS                     TRN(1)



     thread  selection level, you are presented with the subjects
     and (optionally) authors  associated  with  each  discussion
     thread,  and given a chance to choose which ones you wish to
     read now, save for later, or manipulate in some way.  At the
     article  selection  level,  you may read them in the default
     order (which follows the  discussion  of  the  articles  and
     their  replies), or jump around from one article to another.
     At the newsgroup selection level (the top  level),  you  may
     specify  which  newsgroup you want next, or read them in the
     default order, which is the order that the newsgroups  occur
     in your .newsrc file.  (You will therefore want to rearrange
     your .newsrc file to put  the  most  interesting  newsgroups
     first.   This  can be done with the 'm' command on the News-
     group Selection  level.   WARNING:  invoking  readnews/vnews
     (the  old  user  interface)  in any way (including as a news
     checker in your login sequence!) will cause your .newsrc  to
     be disarranged again.)

     On any level, at ANY prompt, help is available in  the  form
     of  a summary of available commands and what they do by typ-
     ing an 'h'.  This is probably the most important command  to
     remember, so don't you forget it.

     Typing space to any question means to do the  normal  thing.
     You  will  know what that is because every prompt has a list
     of several plausible commands enclosed in  square  brackets.
     The  first command in the list is the one which will be done
     if you type a space.  (All input is done in cbreak mode,  so
     carriage  returns  should not be typed to terminate anything
     except certain  multi-character  commands.   Those  commands
     will be obvious in the discussion below because they take an
     argument.)

     Upon startup, trn will do several things:

     1.  It will look for your .newsrc file, which is  your  list
         of  subscribed-to  newsgroups.   If  trn  doesn't find a
         .newsrc, it will create one.  If it does  find  one,  it
         will back it up under the name ".oldnewsrc".

     2.  It will input your .newsrc file, listing out  the  first
         several newsgroups with unread news.

     3.  It will  perform  certain  consistency  checks  on  your
         .newsrc.   If  your  .newsrc  is  out  of date in any of
         several ways, trn will warn you and patch it up for you,
         but you may have to wait a little longer for it to start
         up.

     4.  Trn will next check to see if any  new  newsgroups  have
         been  created,  and give you the opportunity to add them
         to your .newsrc.



Sun Release 4.1        Last change: LOCAL                       2






TRN(1)                   USER COMMANDS                     TRN(1)



     5.  Trn goes into the top prompt level--the newsgroup selec-
         tion level.

     Newsgroup Selection Level

     In this section the words "next" and "previous" refer to the
     ordering  of  the  newsgroups  in your .newsrc file.  On the
     newsgroup selection level, the prompt looks like this:

     ******** 17 unread articles in talk.blurfl--read now? [ynq]

     and the following commands may be given at this level:

     y,SP    Do this newsgroup now.

     .command
             Do this newsgroup now, but  execute  command  before
             displaying  anything.   The  command  will be inter-
             preted as if given on the article selection level.

     +       Enter this newsgroup through the thread selector.

     =       Start  this  newsgroup,  but  list  subjects  before
             displaying articles.

     U       Enter  this  newsgroup  through  the  "Set   unread"
             prompt.

     t       Toggle the always-read-threaded flag for the current
             group.

     n       Go to the next newsgroup with unread news.

     N       Go to the next newsgroup.

     p       Go to the previous newsgroup with unread  news.   If
             there is none, stay at the current newsgroup.

     P       Go to the previous newsgroup.

     -       Go to the previously displayed newsgroup (regardless
             of  whether it is before or after the current one in
             the list).

     1       Go to the first newsgroup.

     ^       Go to the first newsgroup with unread news.

     $       Go to the end of the newsgroups list.

     g newsgroup
             Go to newsgroup.  If it isn't  currently  subscribed



Sun Release 4.1        Last change: LOCAL                       3






TRN(1)                   USER COMMANDS                     TRN(1)



             to, you will be asked if you want to subscribe.

     /pattern
             Scan forward for a newsgroup matching pattern.  Pat-
             terns  do  globbing  like  filenames, i.e., use ? to
             match a single character, * to match any sequence of
             characters,  and  [] to specify a list of characters
             to match.  ("all" may be used as a synonym for "*".)
             Unlike normal filename globbing, newsgroup searching
             is not  anchored  to  the  front  and  back  of  the
             filename, i.e. "/ski" will find rec.skiing.  You may
             use ^ or $ to  anchor  the  front  or  back  of  the
             search: "/^test$" will find newsgroup test and noth-
             ing else If you want to include  newsgroups  with  0
             unread articles, append /r.  If the newsgroup is not
             found between the current  newsgroup  and  the  last
             newsgroup, the search will wrap around to the begin-
             ning.

     ?pattern
             Same as /, but search backwards.

     u       Unsubscribe from the current newsgroup.

     l string
             List newsgroups not subscribed to which contain  the
             string specified.

     L       Lists the current state of the .newsrc,  along  with
             status information.

                  Status         Meaning
                  <number>       Count of unread articles in newsgroup.
                  READ           No unread articles in newsgroup.
                  UNSUB          Unsubscribed newsgroup.
                  BOGUS          Bogus newsgroup.
                  JUNK           Ignored line in .newsrc
                                 (e.g. readnews "options" line).

             (A bogus newsgroup is one that is not in the list of
             active  newsgroups in the active file, which on most
             systems  is  /usr/lib/news/active  unless  you   use
             NNTP.)

     m name  Move the  named  newsgroup  somewhere  else  in  the
             .newsrc.  If no name is given, the current newsgroup
             is moved.  There are a number  of  ways  to  specify
             where  you  want the newsgroup--type h for help when
             it asks where you want to put it.

     c       Catch up--mark all unread articles in this newsgroup
             as read.



Sun Release 4.1        Last change: LOCAL                       4






TRN(1)                   USER COMMANDS                     TRN(1)



     o pattern
             Only display those  newsgroups  whose  name  matches
             pattern.   Patterns are the same as for the '/' com-
             mand.  Multiple patterns may be separated by spaces,
             just  as  on the command line.  The restriction will
             remain in effect either until there are no  articles
             left in the restricted set of newsgroups, or another
             restriction command  is  given.   Since  pattern  is
             optional, 'o' by itself will remove the restriction.

     a pattern
             Add new  newsgroups  matching  pattern.   Newsgroups
             which are already in your .newsrc file, whether sub-
             scribed to or not, will not be listed.  If  any  new
             newsgroups are found, you will be asked for each one
             whether you would like to add it.  If  you  want  to
             add  all  new  newsgroups, you can type 'Y' and they
             will be added the the end of the .newsrc file and as
             groups  you want to read.  If you don't want to sub-
             scribe, all the new groups can be  added  by  typing
             'N'.   After any new newsgroups have been added, the
             'a' command also restricts the current set of  news-
             groups just like the 'o' command does.

     &       Print  out  the  current  status  of  command   line
             switches and any newsgroup restrictions.

     &switch {switch}
             Set additional command line switches.

     &&      Print out the current macro definitions.

     &&keys commands
             Define additional macros.

     !command
             Escape to a  subshell.   One  exclamation  mark  (!)
             leaves  you  in  your  own news directory.  A double
             exclamation mark (!!) leaves you in the spool direc-
             tory   for   news,   which   on   most   systems  is
             /usr/spool/news if NNTP  is  not  being  used.   The
             environment  variable SHELL will be used if defined.
             If command is null, an interactive shell is started.

     q       Quit.

     x       Quit, restoring .newsrc to its state at  startup  of
             trn.   The  .newsrc  you  would  have had if you had
             exited with 'q' will be called .newnewsrc,  in  case
             you didn't really want to type 'x'.





Sun Release 4.1        Last change: LOCAL                       5






TRN(1)                   USER COMMANDS                     TRN(1)



     ^K      Edit the global KILL file.  This  is  a  file  which
             contains  /pattern/j  commands  (one per line) to be
             applied to every newsgroup as it is started up, that
             is,  when  it is selected on the newsgroup selection
             level.  The purpose of a KILL file is to mark  arti-
             cles  as  read on the basis of some set of patterns.
             This saves considerable wear and tear  on  your  'n'
             key.  There is also a local KILL file for each news-
             group.  Because of the overhead involved in  search-
             ing  for  articles to kill, it is better if possible
             to use a local KILL  file.   Local  KILL  files  are
             edited  with  a '^K' on the article selection level.
             There are also automatic ways of adding search  com-
             mands  to  the  local KILL file--see the 'K' and 'T'
             commands, and the K search modifier on  the  article
             selection level.

             If either of the  environment  variables  VISUAL  or
             EDITOR is set, the specified editor will be invoked;
             otherwise  a  default  editor  (normally  vi(1))  is
             invoked on the KILL file.

     Thread Selection Level

     Most people who don't have all day to read news will want to
     enter  a  newsgroup  by way of the thread selector.  This is
     accomplished by using  the  '+'  command  at  the  newsgroup
     selection  level.   In fact, this may be the default command
     for entering a newsgroup, depending on how your  version  of
     trn  was  configured (see the -X option for how to turn this
     default on or off).  The thread selector displays a list  of
     article  subjects  and  (optionally)  authors  grouped  into
     threads.  A thread may contain multiple subjects if the sub-
     ject changes as the discussion continues.  Also displayed is
     a count of the number of unread  articles  in  each  thread.
     Each  thread  is  preceded by a letter or number that can be
     typed to select it.  Selected threads  are  flagged  with  a
     '+'.

     The default is to display the long mode of the thread selec-
     tor.   In  this mode, all the authors of the articles in the
     thread are summarized, one per  line  (authors  of  multiple
     articles  are  listed  only  once).  The medium display mode
     groups multiple authors onto the same  line,  so  that  more
     threads  can  be  displayed  at one time.  The short display
     mode does not display any author names, and can display more
     characters in the subject.

     The following commands are available in the thread selector:

     a-z,0-9 Select  the  discussion  thread  by  its  letter  or
             number;  press  again  to  deselect.  By default the



Sun Release 4.1        Last change: LOCAL                       6






TRN(1)                   USER COMMANDS                     TRN(1)



             letters h, k, n, p, q, and y are  omitted  to  allow
             them  to  be  typed  as  commands.  See the variable
             SELECTCHARS to customize this.

     SP      Perform the default command.  This is usually >  for
             most pages, and Z on the last page (although D and X
             are also quite popular).

     CR      Read the current thread (if none  are  selected)  or
             all the selected threads.

     Z,TAB   Begin reading the selected threads.  If none are are
             selected, read everything.

     y, '.'  Toggle the current thread's selection (the one under
             the cursor).

     k, ','  Mark the current thread as killed.

     m, \    Unmark the current thread.

     -       Set a range, as in 2 - 5.  Repeats the last  marking
             action:  selected, unselected, killed, or unmarked.

     @       Toggle all visible article selections.

     <       Go to previous page.

     >       Go to next page.

     p, [    Move up to the previous thread.

     n, ]    Move down to the next thread.

     ^       Go to first page.

     $       Go to last page.

     X       Mark all unselected articles as read and start read-
             ing.

     J       Mark all selected articles  as  read  (useful  after
             performing  some  action  on  them with the ':' com-
             mand).

     D       Mark unselected articles  on  the  current  page  as
             read.   Begin reading if articles are selected, oth-
             erwise go to the next page.

     ^K      Edit the local KILL  file  for  this  newsgroup.   A
             detailed  description  of KILL files is found in the
             Article Selection section.



Sun Release 4.1        Last change: LOCAL                       7






TRN(1)                   USER COMMANDS                     TRN(1)



     :command
             Execute a command upon all the selected threads  and
             their  articles.   If  no  threads are selected, all
             threads with unread articles are affected.

             Applicable commands include '+' and '-' (select  and
             unselect  thread),  'T'  (trash  the thread into the
             local KILL file), 't'  (display  article  tree),  "s
             dest"  (save  article  to  a  destination),  "e dir"
             (extract to directory), 'E' (end partial  uudecode),
             as well as: S, |, w, W, m, M, j, = and ','.

     /pattern
             Scan all articles for a subject  containing  pattern
             and select its thread.

     /pattern/modifiers:command{:command}
             Apply the commands listed to articles  matching  the
             search  command  (possibly with h, a, r, or K modif-
             iers).  The default action, if no command is  speci-
             fied, is to select the parent thread of the matching
             article (the '+' command).  See the section on Regu-
             lar  Expressions,  and  the  description  of pattern
             searching in the Article Selection section.

             One example:  to scan all the unread articles  look-
             ing  for  "topic"  anywhere  in the article and then
             select its thread and save the article to the  files
             topic.1, topic.2, etc. use "/topic/a:+:s topic.%#".

     N       Go to the next newsgroup with unread news.

     P       Go to the previous newsgroup with unread news.

     U       Switch between selecting read/unread articles.

     L       Switch the current display mode between the long and
             medium  modes  (with  authors)  and  the short mode.
             (See the -x option to select your favorite  mode  as
             the default.)

     &       Display or set the current status  of  command  line
             switches.

     &&      Display or set the current macro definitions.

     !command
             Escape to a subshell.

     q       Quit this group.





Sun Release 4.1        Last change: LOCAL                       8






TRN(1)                   USER COMMANDS                     TRN(1)



     ESC,+   Quit the  thread  selector  (back)  to  the  article
             level.

     Q       Quit the current newsgroup and return to  the  news-
             group selection prompt for this group.

     Article Selection Level

     On the article selection level, trn displays unread articles
     in  thread  sequence,  reading  each article and its replies
     before going on to another topic.  If threads  are  disabled
     for  a  particular  group,  the  default order is in numeric
     sequence (the order they arrived at your  site)  unless  you
     use  subject  search  (^N) to change the default order to be
     numerical order  within  each  matching  subject.   (The  -S
     switch  can  be used to make subject search mode the default
     for unthreaded groups.)

     On the article selection level you are not asked whether you
     want  to  read  an  article before the article is displayed;
     rather, trn simply displays the first page (or portion of  a
     page, at low baud rates) of the article and asks if you want
     to continue.  The normal article selection prompt  comes  at
     the  END  of  the article (though article selection commands
     can be given from within the  middle  of  the  article  (the
     pager  level)  also).   The  prompt at the end of an article
     looks like this:

     End of article 248 (of 257)--what next? [npq]

     The following are the options at this point:

     n,SP    Scan forward for next unread  article.   (Note:  the
             'n' (next) command when typed at the end of an arti-
             cle does not mark the  article  as  read,  since  an
             article  is  automaticaly  marked  as read after the
             last line of it is printed.  It is therefore  possi-
             ble  to  type  a sequence such as 'mn' and leave the
             article marked as unread.  The fact that an  article
             is marked as read by typing n, N, ^N, e, s, S, |, w,
             or W within the MIDDLE of the article is in  fact  a
             special case.)

     N       Go to the next article.

     ^N      Scan forward for the next article with the same sub-
             ject.   If  the  group is unthreaded this also makes
             subject search mode (^N) the default.

     p       Scan backward for previous unread article.  If there
             is none, stay at the current article.




Sun Release 4.1        Last change: LOCAL                       9






TRN(1)                   USER COMMANDS                     TRN(1)



     P       Go to the previous article.

     -       Go to the previously displayed  article  (regardless
             of  whether  that  article  is  before or after this
             article in the normal sequence).

     ^P      Scan backward for the previous article with the same
             subject.  Makes subject search mode (^N) the default
             if the group is unthreaded.

     <,>     Browse the previous/next  selected  thread.   If  no
             selections  have been made, all the threads that had
             unread news when you entered the newsgroup (or  last
             left  the  thread selector) are treated as selected.
             Entering an empty newsgroup makes all  the  already-
             read threads available for browsing.

     [,]     Proceed to  the  left/right  in  the  article  tree.
             Visits already-read articles as well as empty nodes.
             If you attempt to go past the left/right edge of the
             tree,  you are advanced to the previous/next line if
             available.

     {,}     Go to the root/leaf of the article tree, even if the
             node is already read or empty.  Proceeds to the very
             first/last node if you're already at a root/leaf  in
             a multi-root thread.

     t       Display the entire article tree and all its  associ-
             ated  subjects.   If  the  group  is  not  currently
             threaded, it will be  turned  on  and  processed  as
             needed.

     ^R      Restart the current article.

     v       Restart the current  article  verbosely,  displaying
             the entire header.

     ^L      Refresh the screen.

     ^X      Restart the current article, and decrypt as a  rot13
             message.

     X       Refresh the screen, and decrypt as a rot13 message.

     b       Back up one page.

     q       Quit this newsgroup and go  back  to  the  newsgroup
             selection level.

     ^       Go to the first unread article.




Sun Release 4.1        Last change: LOCAL                      10






TRN(1)                   USER COMMANDS                     TRN(1)



     $       Go to the last article (actually, one past the  last
             article).

     number  Go to the numbered article.

     range{,range}:command{:command}
             Apply a set of commands to a  set  of  articles.   A
             range   consists   of  either  <article  number>  or
             <article number>-<article number>.    A   dot    '.'
             represents  the  current  article, and a dollar sign
             '$' represents the last article.

             Applicable commands include 'm'  (mark  as  unread),
             'M' (delayed mark as unread), 'j' (mark as read), "s
             dest" (save to a destination), "e dir"" (extract  to
             directory),  "!command"  (shell  escape), "=" (print
             the subject), 'T' (trash the thread into  the  local
             KILL  file),  '+' (select the thread), '-' (deselect
             the thread), 'C' (cancel), as well as S,  |,  w,  W,
             and t.

     :command
             Apply a command to all selected  threads  and  their
             articles.   If  no  threads  are selected, apply the
             command to all the unread threads.   For  applicable
             commands,  see  the  discussion  above for the range
             command.

     j       Junk the current article--mark it as read.  If  this
             command is used from within an article, you are left
             at the end of the article, unlike 'n',  which  looks
             for the next article.

     m       Mark the current article as still unread.   (If  you
             are  in subject search mode you probably want to use
             M instead of m.  Otherwise the current  article  may
             be  selected  as  the  beginning of the next subject
             thread.)

     M       Mark the current article as still  unread,  but  not
             until  the  newsgroup  is  exited.   Until then, the
             current article will be marked  as  read.   This  is
             useful  for  returning to an article in another ses-
             sion, or in another newsgroup.

     /pattern
             Scan forward for article containing pattern  in  the
             subject.    See  the  Regular  Expressions  section.
             Together  with  the  escape  substitution   facility
             described later, it becomes easy to search for vari-
             ous attributes of the current article, such as  sub-
             ject,  article  ID,  author name, etc.  The previous



Sun Release 4.1        Last change: LOCAL                      11






TRN(1)                   USER COMMANDS                     TRN(1)



             pattern can be recalled with "<esc>/".   If  pattern
             is omitted, the previous pattern is assumed.

     /pattern/h
             Scan forward for article containing pattern  in  the
             header.

     /pattern/a
             Scan forward for article containing pattern anywhere
             in article.

     /pattern/r
             Scan read articles also.

     /pattern/c
             Make search case sensitive.  Ordinarily  upper-  and
             lower-case are considered the same.

     /pattern/modifiers:command{:command}
             Apply the commands listed to articles  matching  the
             search command (possibly with h, a, or r modifiers).
             Applicable commands include 'm'  (mark  as  unread),
             'M' (delayed mark as unread), 'j' (mark as read), "s
             dest" (save to a destination), "e dir"" (extract  to
             directory),  "!command"  (shell  escape), "=" (print
             the subject), 'T' (trash the associated  thread  and
             put  it  in  the  local  KILL file), '+' (select the
             associated  thread),  '-'  deselect  the  associated
             thread),  and 'C' (cancel).  If the first command is
             'm' or 'M', modifier r  is  assumed.   A  K  may  be
             included  in  the  modifiers  (not  the commands) to
             cause the entire command (sans K) to be saved to the
             local  KILL  file, where it will be applied to every
             article that shows up in the newsgroup.

             For example, to save all articles in a  given  news-
             group  to  the  line printer and mark them read, use
             "/^/|lpr:j".  If you type  "/^/K|lpr:j",  this  will
             happen every time you enter the newsgroup.

     ?pattern
             Scan backward for article containing pattern in  the
             subject.   May be modified as the forward search is:
             ?pattern?modifiers[:commands].  It  is  likely  that
             you will want an r modifier when scanning backward.

     k       Mark as read all articles with the same  subject  as
             the  current  article.   (Note:  there  is no single
             character command to temporarily  mark  as  read  (M
             command)  articles  matching  the  current  subject.
             That can be done with "/<esc>s/M", however.)




Sun Release 4.1        Last change: LOCAL                      12






TRN(1)                   USER COMMANDS                     TRN(1)



     ,       Mark the current article  and  all  its  replies  as
             read.

     J       Junk all the articles in the thread, even if it con-
             tains multiple subjects.

     K       Do the same as the k command, but also add a line to
             the  local KILL file for this newsgroup to kill this
             subject every time the newsgroup is started up.  For
             a  discussion  of  KILL  files, see the '^K' command
             below.  See also the K modifier on searches above.

     T       Kill the current thread, and also add a line to  the
             local KILL file for this newsgroup to kill new arti-
             cles attached to this thread every  time  the  news-
             group is started up.

     ^K      Edit the local KILL file for this  newsgroup.   Each
             line  of  the  KILL file should be a subject-killing
             command of the form /pattern/j or a  thread  killing
             command  of  the form T<number>.  The thread killing
             commands are usually followed by a  comment  to  let
             you  know the primary subject of the numbered thread
             being killed.  The first line in the KILL  file  has
             the  form  "THRU <number>", which tells trn the max-
             imum article number that  the  KILL  file  has  been
             applied  to.  (You may delete the THRU line to force
             a rescan of current articles.)  You  may  also  have
             reason  to use the m, h, or a modifiers.  Be careful
             with the M modifier in a kill file--there  are  more
             efficient  ways to never read an article.  You might
             have reason to use it  if  a  particular  series  of
             articles  is posted to multiple newsgroups.  In this
             case, M would force you to view  the  article  in  a
             different newsgroup.

             To see only newgroup articles in the  control  news-
             group, for instance, you might put

             /^/j
             /newgroup/m

             which kills all subjects not containing  "newgroup".
             You  can  add  lines automatically via the K command
             and K search modifiers, but editing is the only  way
             to remove lines.  If either of the environment vari-
             ables VISUAL or EDITOR is set, the specified  editor
             will  be  invoked;  otherwise a default editor (nor-
             mally vi) is invoked on the KILL file.

             The KILL file may also contain switch setting  lines
             beginning   with   '&'.    Additionally,   any  line



Sun Release 4.1        Last change: LOCAL                      13






TRN(1)                   USER COMMANDS                     TRN(1)



             beginning with 'X' is  executed  on  exit  from  the
             newsgroup rather than on entrance.  This can be used
             to set switches back to a default  value.   One  use
             for this capability is to set your save directory to
             a custom value upon entry to a newsgroup and set  it
             back  on  exit using the -ESAVEDIR option.  See also
             the -/ option for another solution to multiple  save
             directories without using KILL files.

     r       Reply through net mail.  The  environment  variables
             MAILPOSTER  and MAILHEADER may be used to modify the
             mailing behavior of trn (see  environment  section).
             If  on  a  nonexistent  article  such as the "End of
             newsgroup" pseudo-article (which you can get to with
             a '$' command), invokes the mailer to nobody in par-
             ticular.

     R       Reply, including the current article in  the  header
             file  generated.  (See 'F' command below).  The YOU-
             SAID environment variable controls the format of the
             attribution line.

     f       Submit a followup  article.   If  on  a  nonexistent
             article  such  as  the  "End  of  newsgroup" pseudo-
             article (which you can get to with a  '$'  command),
             posts an original article (basenote).

     F       Submit a followup article, and include the old arti-
             cle,  with  lines  prefixed  either by ">" or by the
             argument to a -F switch.  Trn will attempt  to  pro-
             vide  an  attribution  line  in  front of the quoted
             article, generated from the From: line of the  arti-
             cle.   Unfortunately,  the From: line doesn't always
             contain the right name; you should double  check  it
             against the signature and change it if necessary, or
             you may have to apologize for quoting the wrong per-
             son.   The  environment  variables NEWSPOSTER, NEWS-
             HEADER and ATTRIBUTION may be  used  to  modify  the
             posting behavior of trn (see environment section).

             If you are starting a new subject, move to  the  end
             of  the newsgroup with the '$' command before press-
             ing 'f'.  Otherwise you may have  to  do  a  lot  of
             header  editing,  including  removing the References
             line -- this is  IMPORTANT  to  remember  ONLY  when
             starting  a  new  subject.   It  is  much simpler to
             remember "$f" for new subjects, and to allways leave
             the References line alone.

     C       Cancel the current article, but only if you are  the
             contributor or superuser.




Sun Release 4.1        Last change: LOCAL                      14






TRN(1)                   USER COMMANDS                     TRN(1)



     z       Supersede the current article, but only if  you  are
             the contributor.

     c       Catch up in this newsgroup; i.e., mark all  articles
             as read.

     U       Mark some or all articles as unread.  You can choose
             to  mark the current thread, sub-thread (the current
             article and its replies), all the articles, or start
             up the thread selector to choose specific threads to
             set unread.

     u       Unsubscribe from this newsgroup.

     s destination
             Save to a filename or pipe using sh.  If  the  first
             character  of the destination is a vertical bar, the
             rest of the command is considered a shell command to
             which  the article is passed through standard input.
             The command is subject to filename expansion.   (See
             also  the  environment  variable  PIPESAVER.) If the
             destination does not begin with a vertical bar,  the
             rest  of  the command is assumed to be a filename of
             some sort.  An initial tilde '~' will be  translated
             to  the  name  of the home directory, and an initial
             environment variable substitution is  also  allowed.
             If  only a directory name is specified, the environ-
             ment variable  SAVENAME  is  used  to  generate  the
             actual  name.   If a non-absolute filename is speci-
             fied, the environment variable SAVEDIR will be  used
             to  generate  the  actual  directory.  If nothing is
             specified, then obviously  both  variables  will  be
             used.   Since  the  current  directory for trn while
             doing a save command is your private news directory,
             typing  "s  ./filename"  will force the file to your
             news directory.  Save commands are also run  through
             %   interpretation,   so   that  you  can  enter  "s
             %O/filename" to save to the directory  you  were  in
             when  you  ran trn, and "s %t" to save to a filename
             consisting of the Internet address of the sender.

             After generating the full pathname of  the  file  to
             save  to, trn determines if the file exists already,
             and if so, appends  to  it.   trn  will  attempt  to
             determine if an existing file is a mailbox or a nor-
             mal file, and save the article in the  same  format.
             If  the  output file does not yet exist, trn will by
             default ask you which format you want,  or  you  can
             make  it  skip the question with either the -M or -N
             switch.  If the article is to be  saved  in  mailbox
             format,  the  command to do so is generated from the
             environment    variable    MBOXSAVER.     Otherwise,



Sun Release 4.1        Last change: LOCAL                      15






TRN(1)                   USER COMMANDS                     TRN(1)



             NORMSAVER is used.

     S destination
             Save to a filename or pipe using a preferred  shell,
             such  as  csh.  Which shell is used depends first on
             what you have the environment variable SHELL set to,
             and  in  the  absence  of  that,  on  what your news
             administrator set for the preferred shell when he or
             she installed trn.

     | command
             Shorthand for "s | command".

     w destination
             The same as "s destination", but saves  without  the
             header.

     W destination
             The same as "S destination", but saves  without  the
             header.

     e directory
             Extract a shell archive or uuencoded binary  to  the
             designated  directory.  The article is first scanned
             to try discover what type of data  is  encapsulated.
             If  a  "cut here" line is found, the first non-blank
             line after it must be either the  start  of  a  shar
             header,  or  the  "begin" or "table" line of a uuen-
             coded binary.  The default for extracting  shars  is
             to send the data portion of the file to /bin/sh, but
             that can be overridden with the UNSHAR variable (see
             the ENVIRONMENT section).  Uudecoding is done inter-
             nally by a decoder that can handle  the  data  being
             split  up  over multiple articles, and extracted one
             piece at a time.  To decode  a  multi-article  file,
             either  execute  the  'e' command in each article in
             sequence, use an article range to execute  the  com-
             mand,  or use the ":e" command to repeat the command
             for each of the currently selected  articles.   When
             the 'e' command is not followed by any arguments, it
             will repeat the arguments from the last  extraction.
             All  directory  specifications  are  relative to the
             value of SAVEDIR, so you can use the command  "e  ."
             to  force  an  extraction  to  SAVEDIR itself.  If a
             uudecoding is  in  progress  (i.e.  the  last  piece
             wasn't  extracted  yet)  and you exit the group, the
             partial file will be removed.  This also  occurs  if
             you start to extract a new uuencoded file before the
             previous one was finished.  See also the 'E' command
             for ending a multi-part uudecoding manually.

             There  is  one  special   case   that   is   handled



Sun Release 4.1        Last change: LOCAL                      16






TRN(1)                   USER COMMANDS                     TRN(1)



             differently:   if  the  first file in a recognizable
             shar file is a uuencoded binary that was packed with
             lines  starting  with an 'X', we will not unshar the
             file but instead uudecode it.  If this causes  prob-
             lems, you can override the default extraction method
             by following the directory with an explicit  command
             to execute, as described below.

     e directory|command
             This form of the 'e' command allows you  to  extract
             other  data  formats than shar or uuencoded files or
             to override the  decisions  made  by  the  automatic
             extraction  selection  described  above.   In normal
             operation, all data following what we recognize as a
             "cut  here"  line will be sent to the specified com-
             mand.  Additionally, the distinctive beginning of  a
             shell archive is also recognized without a preceding
             cut line.  When the  command  is  run,  the  default
             directory will be set to the specified directory, or
             the value of SAVEDIR if unspecified.   Entering  the
             'e'  command without arguments will repeat your pre-
             vious extract command.  You can use the  command  "e
             dir|"  to  extract  to  a  new  directory  using the
             previously-specified command.

     E       This command  ends  any  multi-part  uuencoded  file
             extraction that you began, but are unable (or unwil-
             ling) to complete.  The partially extracted file  is
             removed.

     &       Print  out  the  current  status  of  command   line
             switches.

     &switch {switch}
             Set additional command line switches.

     &&      Print out current macro definitions.

     &&keys commands
             Define an additional macro.

     !command
             Escape to a  subshell.   One  exclamation  mark  (!)
             leaves  you  in  your  own news directory.  A double
             exclamation mark (!!) leaves you in the spool direc-
             tory  of  the  current  newsgroup.   The environment
             variable SHELL will be used if defined.  If  command
             is null, an interactive shell is started.

             You can use escape key substitutions described later
             to get to many run-time values.  The command is also
             run through % interpretation, in case  it  is  being



Sun Release 4.1        Last change: LOCAL                      17






TRN(1)                   USER COMMANDS                     TRN(1)



             called from a range or search command.

     +       Start the thread  selector.   If  the  newsgroup  is
             unthreaded, the subject lister is called instead.

     =       List subjects of unread articles.

     #       Print last article number.

     Pager Level

     At the pager level (within an  article),  the  prompt  looks
     like this:

     --MORE--(17%)

     and a number of commands may be given:

     SP      Display next page.

     x       Display next page and decrypt as a rot13 message.

     d       Display half a page more.

     CR      Display one more line.

     q       Go to the end of the current article (don't mark  it
             either  read  or  unread).   Leaves you at the "What
             next?" prompt.

     j       Junk the current article.  Mark it read  and  go  to
             the end of the article.

     ^L      Refresh the screen.

     X       Refresh the screen and decrypt as a rot13 message.

     b       Back up one page.

     t       Display the entire article tree, including its asso-
             ciated subjects, and continue reading.  If the group
             is not currently threaded, it will be turned on  and
             processed as needed.

     gpattern
             Goto (search forward  for)  pattern  within  current
             article.   Note  that  there is no space between the
             command and the pattern.  If the pattern  is  found,
             the  page  containing the pattern will be displayed.
             Where on the page the line matching the pattern goes
             depends  on  the value of the -g switch.  By default
             the matched line goes at the top of the screen.



Sun Release 4.1        Last change: LOCAL                      18






TRN(1)                   USER COMMANDS                     TRN(1)



     G       Search for g pattern again.

     ^G      This is a special version of the 'g' command that is
             for skipping articles in a digest.  It is equivalent
             to setting "-g4"  and  then  executing  the  command
             "g^Subject:".

     TAB     This is another special version of the  'g'  command
             that  is  for skipping inclusions of older articles.
             It is equivalent to setting "-g4" and then executing
             the command "g^[^c]", where c is the first character
             of the last line on the screen.  It searches for the
             first  line that doesn't begin with the same charac-
             ter as the last line on the screen.

     !command
             Escape to a subshell.

     The following commands skip the rest of the current article,
     then  behave  just as if typed to the "What next?" prompt at
     the end of the article.  See the documentation at the  arti-
     cle selection level for these commands.

         # $ & / = ? c C f F k K T ^K J , m M r R ^R u U v Y ^
         p P ^P - < > [ ] { } number
         range{,range} command{:command}

     The following commands also skip to the end of the  article,
     but  have the additional effect of marking the current arti-
     cle as read:

         n N ^N e s S | w W


     Miscellaneous facts about commands

     An 'n' typed at either the  "Last  newsgroup"  prompt  or  a
     "Last  article"  prompt  will  cycle  back to the top of the
     newsgroup or article list,  whereas  a  'q'  will  quit  the
     level.   (Note  that  'n'  does  not  mean  "no", but rather
     "next".) A space will of course do whatever is shown as  the
     default, which will vary depending on whether trn thinks you
     have more articles or newsgroups to read.

     The 'b' (backup page) command  may  be  repeated  until  the
     beginning  of  the  article is reached.  If trn is suspended
     (via a ^Z), then when the job is  resumed,  a  refresh  (^L)
     will automatically be done (Berkeley-type systems only).  If
     you type a command such as '!' or 's' which takes  you  from
     the  middle  of  the  article to the end, you can always get
     back into the middle by typing '^L'.




Sun Release 4.1        Last change: LOCAL                      19






TRN(1)                   USER COMMANDS                     TRN(1)



     In multi-character commands such as '!', 's', '/', etc,  you
     can interpolate various run-time values by typing escape and
     a character.  To find out what  you  can  interpolate,  type
     escape  and 'h', or check out the single character % substi-
     tutions for environment variables in the Interpretation  and
     Interpolation  section,  which  are the same.  Additionally,
     typing a double escape will cause any % substitutions in the
     string already typed in to be expanded.

     The Tree Display

     When reading a threaded newsgroup, trn displays a  character
     representation of the article tree in the upper right corner
     of the header.  For example, consider the following display:

         (1)+-(1)--(2)--[2]
            |-(1)+-[3]
            |    \-[1]
            \-(1)+-[1]--[1]
                 \-[1]

     This tree represents  an  initial  article  that  has  three
     direct  replies  (the second column with three (1)'s).  Each
     reply has further replies branching off from them.   In  two
     cases  the  subject  line was altered in the reply, as indi-
     cated by the increasing numbers.  When  there  is  only  one
     subject  associated  with a thread, all the nodes are marked
     with the number 1.  When the first subject  change  arrives,
     it  is  marked with the number 2, and so on.  If you were to
     look at this thread in the thread selector, the  three  sub-
     jects  associated  with it would be listed in the same order
     as the ascending digits.  In those  rare  cases  where  more
     than  9  subjects are associated with each thread, the nodes
     are marked with the letters A-Z, and then by a-z.  The arti-
     cles  that  have  already  been  read  are enclosed in ()'s.
     Unread  articles  are  displayed  in  []'s.   The  currently
     displayed  article  has  its  entire node highlighted in the
     display.  The previously  displayed  article  has  only  its
     number highlighted.

     Options

     Trn has a nice set of options to allow  you  to  tailor  the
     interaction  to  your  liking.  (You might like to know that
     the author swears by "-x6ls -e +m -S -XX -N".) These options
     may  be set on the command line, via the TRNINIT environment
     variable, via a file pointed to by the TRNINIT variable,  or
     from within trn via the & command.  Options may generally be
     unset by typing "+switch".  Options include:

     -a   causes trn to always thread a group that doesn't have a
          pre-created  thread file.  Without this option you have



Sun Release 4.1        Last change: LOCAL                      20






TRN(1)                   USER COMMANDS                     TRN(1)



          to toggle each group with the 't' command at the  news-
          group prompt to force it to be read threaded even if no
          thread file for the group exists.

     -c   checks for news without reading news.   If  a  list  of
          newsgroups  is  given  on  the command line, only those
          newsgroups will be checked; otherwise all subscribed-to
          newsgroups  are  checked.   Whenever  the  -c switch is
          specified, a non-zero exit status from trn  means  that
          there  is unread news in one of the checked newsgroups.
          The -c switch does not disable the  printing  of  news-
          groups  with  unread news; this is controlled by the -s
          switch.  (The -c switch is not  meaningful  when  given
          via the & command.)

     -C<number>
          tells trn how often to checkpoint the .newsrc, in arti-
          cles  read.   Actually,  this number says when to start
          thinking about doing a checkpoint if the  situation  is
          right.  If a reasonable checkpointing situation doesn't
          arise within 10 more articles, the  .newsrc  is  check-
          pointed willy-nilly.

     -d<directory name>
          sets the default save directory to something other than
          ~/News.   The  directory name will be globbed (via csh)
          if necessary (and if possible).  Articles saved by  trn
          may  be  placed in the save directory or in a subdirec-
          tory thereof depending on the command that you give and
          the  state  of  the  environment  variables SAVEDIR and
          SAVENAME.  Any KILL files (see the  K  command  in  the
          Article  Selection  section) also reside in this direc-
          tory and its subdirectories, by default.  In  addition,
          shell escapes leave you in this directory.

     -D<flags>
          enables  debugging  output.   See  common.h  for   flag
          values.  Warning: normally trn attempts to restore your
          .newsrc when an unexpected  signal  or  internal  error
          occurs.   This is disabled when any debugging flags are
          set.

     -e   causes each page within an article to be started at the
          top  of  the  screen,  not just the first page.  (It is
          similar to the -c switch of more(1).) You never have to
          read  scrolling text with this switch.  This is helpful
          especially at certain baud rates because you can  start
          reading  the  top  of the next page without waiting for
          the whole page to be printed.  It works nicely in  con-
          junction  with  the  -m  switch,  especially if you use
          half-intensity for your highlight mode.  See  also  the
          -L switch.



Sun Release 4.1        Last change: LOCAL                      21






TRN(1)                   USER COMMANDS                     TRN(1)



     -E<name>=<val>
          sets the  environment  variable  <name>  to  the  value
          specified.   Within trn, "&-ESAVENAME=%t" is similar to
          "setenv  SAVENAME  '%t'"  in  csh,  or  "SAVENAME='%t';
          export  SAVENAME" in sh.  Any environment variables set
          with -E will be inherited by subprocesses of trn.

     -F<string>
          sets the prefix string for the 'F' followup command  to
          use  in prefixing each line of the quoted article.  For
          example, "-F<tab>" inserts a tab on the front  of  each
          line  (which  will  cause  long  lines  to wrap around,
          unfortunately), "-F>>>>" inserts ">>>>" on every  line,
          and  "-F"  by  itself causes nothing to be inserted, in
          case you want to reformat the text, for instance.   The
          initial default prefix is ">".

     -g<line>
          tells trn which line of the screen you  want  searched-
          for  strings to show up on when you search with the 'g'
          command within an  article.   The  lines  are  numbered
          starting with 1.  The initial default is "-g1", meaning
          the first line of the screen.  Setting the line to less
          than  1  or more than the number of lines on the screen
          will set it to the last line of the screen.

     -h<string>
          hides (disables  the  printing  of)  all  header  lines
          beginning with string. For instance, -hexp will disable
          the printing of the "Expires:" line.  Case is  insigni-
          ficant.   If  <string> is null, all header lines except
          Subject are hidden, and you may then use +h  to  select
          those  lines  you want to see.  You may wish to use the
          baud-rate switch modifier below to hide more  lines  at
          lower baud rates.

     -H<string>
          works just like -h except that instead of  setting  the
          hiding  flag  for a header line, it sets the magic flag
          for that header line.  Certain header lines have  magic
          behavior  that can be controlled this way.  At present,
          the following actions are caused by the  flag  for  the
          particular line: the Date line prints the date in local
          time if the group is threaded; the From line will  only
          print the commented portion of the user name; the News-
          groups line will only print  when  there  are  multiple
          newsgroups;  the  Subject  line  will be underlined and
          (when threaded) the keyword 'Subject:' is  replaced  by
          its  subject  number  (e.g.  [1]); and the Expires line
          will always be suppressed if there is  nothing  on  it.
          In  fact, all of these actions are the default, and you
          must use +H to undo them.



Sun Release 4.1        Last change: LOCAL                      22






TRN(1)                   USER COMMANDS                     TRN(1)



     -i=<number>
          specifies how long (in lines) to consider  the  initial
          page   of   an  article--normally  this  is  determined
          automatically depending on baud rate.   (Note  that  an
          entire article header will always be printed regardless
          of the specified initial page length.  If you are work-
          ing at low baud rate and wish to reduce the size of the
          headers, you may hide certain header lines with the  -h
          switch.)

     -l   disables the clearing of the screen at the beginning of
          each article, in case you have a bizarre terminal.

     -L   tells trn to leave information on the screen as long as
          possible  by not blanking the screen between pages, and
          by using clear to end-of-line.   (The  more(1)  program
          does  this.)  This  feature  works only if you have the
          requisite termcap  capabilities.   The  switch  has  no
          effect unless the -e switch is set.

     -m=<mode>
          enables the marking of the last line  of  the  previous
          page  printed,  to  help the user see where to continue
          reading.  This is most helpful when less  than  a  full
          page  is going to be displayed.  It may also be used in
          conjunction with the -e switch, in which case the  page
          is  erased,  and the first line (which is the last line
          of the previous  page)  is  highlighted.   If  -m=s  is
          specified,  the standout mode will be used, but if -m=u
          is specified, underlining will be used.  If neither  =s
          or =u is specified, standout is the default.  Use +m to
          disable highlighting.

     -M   forces mailbox  format  in  creating  new  save  files.
          Ordinarily you are asked which format you want.

     -N   forces normal (non-mailbox) format in creating new save
          files.  Ordinarily you are asked which format you want.

     -o   will act like old versions of trn and not  chase  xrefs
          when  junking  articles via thread commands.  Using -o2
          will also disable the database lookup for all  article-
          junking  commands.  This slows down the junking of non-
          xrefed articles, but enables trn 2.0 to be run using  a
          database from a pre-2.0 mthreads.

     -q   bypasses the automatic check for  new  newsgroups  when
          starting trn.

     -r   causes trn to restart in the last newsgroup read during
          a  previous  session  with  trn.   It  is equivalent to
          starting up normally and then getting to the  newsgroup



Sun Release 4.1        Last change: LOCAL                      23






TRN(1)                   USER COMMANDS                     TRN(1)



          with a g command.

     -s   with no argument  suppresses  the  initial  listing  of
          newsgroups with unread news, whether -c is specified or
          not.  Thus -c and -s  can  be  used  together  to  test
          "silently"  the  status of news from within your .login
          file.  If -s is followed by a number, the initial list-
          ing  is  suppressed  after  that  many  lines have been
          listed.  Presuming that you have  your  .newsrc  sorted
          into  order  of  interest, -s5 will tell you the 5 most
          interesting newsgroups that have unread news.  This  is
          also  a  nice feature to use in your .login file, since
          it not only tells you whether there is unread news, but
          also  how  important the unread news is, without having
          to wade through the entire list of  unread  newsgroups.
          If  no  -s switch is given -s5 is assumed, so just put-
          ting "rn -c" into your .login file is fine.

     -S<number>
          causes trn to enter subject search mode (^N)  automati-
          cally  whenever  an  unthreaded newsgroup is started up
          with <number> unread articles or  more.   Additionally,
          it causes any 'n' typed while in subject search mode to
          be interpreted as '^N' instead.  (To get  back  out  of
          subject search mode, the best command is probably '^'.)
          If <number> is omitted, 3 is assumed.

     -t   puts trn into terse mode.  This  is  more  cryptic  but
          useful  for  low  baud  rates.   (Note that your system
          administrator may have compiled trn with either verbose
          or terse messages only to save memory.) You may wish to
          use the baud-rate switch modifier below to enable terse
          mode only at lower baud rates.

     -T   allows you to type ahead of rn.  Ordinarily rn will eat
          typeahead  to prevent your autorepeating space bar from
          doing a very frustrating thing  when  you  accidentally
          hold it down.  If you don't have a repeating space bar,
          or you are working at low baud rate, you can  set  this
          switch  to  prevent this behavior.  You may wish to use
          the baud-rate switch modifier below to  disable  typea-
          head only at lower baud rates.

     -v   sets verification mode for  commands.   When  set,  the
          command  being executed is displayed to give some feed-
          back that the key has actually been typed.  Useful when
          the  system  is  heavily  loaded and you give a command
          that takes a while to start up.

     -x<number><list>
          Enable the extended (threaded) features of  trn  beyond
          the  traditional  rn  compatibility mode.  (This may be



Sun Release 4.1        Last change: LOCAL                      24






TRN(1)                   USER COMMANDS                     TRN(1)



          the default on your system, use +x if you yearn for the
          good  ol'  days.) The <number> is the maximum number of
          article-tree lines (from 0 to 11) you want displayed in
          your  header.   Use  the  <list> to choose which thread
          selector modes you like (s - short, m - medium, or l  -
          long), and in what order they are selected with the 'L'
          command.  For example, use -xls to start with the  long
          display  mode  and only switch between it and the short
          mode.  You can omit either or both of  the  parameters,
          in which case a default of -x6lsm is assumed.

     -X<number><commands>
          If you like using the thread selector, you'll  probably
          want  to  use  this  option to make the thread selector
          command (+) the default when a newsgroup is started  up
          with   at   least   <number>  unread  articles.   (Your
          installer may have chosen to make -X1  the  default  on
          your  system.) It is also used to select which commands
          you want to be the  defaults  while  using  the  thread
          selector.   For  example,  -X2XD  will  make the thread
          selector the default command for entering  a  newsgroup
          with  at  least  2 unread articles, and set the default
          command for the LAST page of the thread selector to  be
          the  X  command  and  the default command for all other
          pages to be the D command.  Either or  both  parameters
          can  be  omitted, as well as the second default command
          (e.g.  -XX would change the default newsgroup entry  to
          use  the  selector and the default command for the last
          page of the selector to be 'X').  The default is  -X1Z>
          if  just  -X is specified.  To set the default selector
          commands without affecting the  default  entry  into  a
          newsgroup, specify a high number, like 9999.

     -/   sets SAVEDIR to "%p/%c" and  SAVENAME  to  "%a",  which
          means that by default articles are saved in a subdirec-
          tory of your private news  directory  corresponding  to
          the  name  of  the  the  current  newsgroup,  with  the
          filename being the article number.  +/ sets SAVEDIR  to
          "%p"  and  SAVENAME  to  "%^C",  which by default saves
          articles directly to your private news directory,  with
          the  filename  being the name of the current newsgroup,
          first letter capitalized.  (Either  +/  or  -/  may  be
          default  on  your  system, depending on the feelings of
          your news administrator when he, she  or  it  installed
          trn.)  You  may,  of course, explicitly set SAVEDIR and
          SAVENAME  to  other  values--see  discussion   in   the
          environment section.

     Any switch may  be  selectively  applied  according  to  the
     current  baud-rate.  Simply prefix the switch with +speed to
     apply the switch at that speed or  greater,  and  -speed  to
     apply   the   switch  at  that  speed  or  less.   Examples:



Sun Release 4.1        Last change: LOCAL                      25






TRN(1)                   USER COMMANDS                     TRN(1)



     -1200-hposted suppresses the Posted line  at  1200  baud  or
     less; +9600-m enables marking at 9600 baud or more.  You can
     apply the modifier recursively to itself  also:  +300-1200-t
     sets terse mode from 300 to 1200 baud.

     Similarly, switches may be selected based on terminal type:

          -=vt100+T      set +T on vt100
          -=tvi920-ETERM=mytvi     get a special termcap entry
          -=tvi920-ERNMACRO=%./.rnmac.tvi
                         set up special keymappings
          +=paper-v      set verify mode if not hardcopy

     Some switch arguments, such as environment variable  values,
     may  require  spaces  in them.  Such spaces should be quoted
     via ", ', or \ in the conventional fashion, even when passed
     via TRNINIT or the & command.

     Regular Expressions

     The patterns used in article searching are  regular  expres-
     sions  such as those used by ed(1).  In addition, \w matches
     an alphanumeric character and \W  a  nonalphanumeric.   Word
     boundaries  may  be matched by \b, and non-boundaries by \B.
     The bracketing construct \( ... \) may  also  be  used,  and
     \digit matches the digit'th substring, where digit can range
     from 1 to 9.  \0 matches whatever  the  last  bracket  match
     matched.   Up  to  10  alternatives  may given in a pattern,
     separated by \|, with the caveat  that  \( ... \| ... \)  is
     illegal.

     Interpretation and Interpolation

     Many  of  the  strings  that  trn  handles  are  subject  to
     interpretations of several types.  Under filename expansion,
     an initial "~/" is translated  to  the  name  of  your  home
     directory,  and "~name" is translated to the login directory
     for the user specified.  Filename expansion will also expand
     an   initial   environment   variable,  and  also  does  the
     backslash, uparrow and percent expansion mentioned below.

     All interpreted strings go through  backslash,  uparrow  and
     percent  interpretation.  The backslash escapes are the nor-
     mal ones (such as \n, \t, \nnn, etc.).  The uparrow  escapes
     indicate  control  codes in the normal fashion.  Backslashes
     or uparrows to be passed  through  should  be  escaped  with
     backslash.   The  special  percent  escapes  are  similar to
     printf percent escapes.  These  cause  the  substitution  of
     various  run-time values into the string.  The following are
     currently recognized:





Sun Release 4.1        Last change: LOCAL                      26






TRN(1)                   USER COMMANDS                     TRN(1)



     %a      Current article number.

     %A      Full name of current article (%P/%c/%a).

     %b      Destination of last save command, often a mailbox.

     %B      The byte offset to the beginning of the part of  the
             article  to  be saved, set by the save command.  The
             's' and 'S' commands set it to 0, and  the  'w'  and
             'W'  commands  set it to the byte offset of the body
             of the article.

     %c      Current newsgroup, directory form.

     %C      Current newsgroup, dot form.

     %d      Full name of newsgroup directory (%P/%c).

     %D      "Distribution:" line from the current article.

     %e      The last command executed to extract  data  from  an
             article.

     %E      The last directory where an extracted file went.

     %f      "From:"  line  from  the  current  article,  or  the
             "Reply-To:" line if there is one.  This differs from
             %t in that comments (such as the full name) are  not
             stripped out with %f.

     %F      "Newsgroups:" line for a  new  article,  constructed
             from   "Newsgroups:"  and  "Followup-To:"  lines  of
             current article.

     %h      Name of the header file to pass to the mail or  news
             poster,  containing  all  the  information  that the
             poster program  needs  in  the  form  of  a  message
             header.   It  may also contain a copy of the current
             article.  The format of  the  header  file  is  con-
             trolled by the MAILHEADER and NEWSHEADER environment
             variables.

     %H      Host name (your machine's name).

     %i      "Message-I.D.:" line from the current article,  with
             <> guaranteed.

     %I      The reference indication mark (see the -F switch.)

     %l      The news administrator's login name, if any.





Sun Release 4.1        Last change: LOCAL                      27






TRN(1)                   USER COMMANDS                     TRN(1)



     %L      Login name (yours).

     %m      The current mode of trn, for use in conditional mac-
             ros.

                  i    Initializing.
                  n    Newsgroup selection level.
                  t    Thread selection level.
                  a    Article selection level (What next?).
                  p    Pager level (MORE prompt).
                  u    Set unread? prompt.
                  A    Add this newsgroup?
                  B    aBandon confirmation.
                  C    Catchup confirmation.
                  D    Delete bogus newsgroups?
                  F    Is followup a new topic?
                  M    Use mailbox format?
                  R    Resubscribe to this newsgroup?

             Note that yes/no questions are all upper-case modes.
             If,  for example, you wanted to disallow defaults on
             all yes/no questions, you could define the following
             macro:

             \040 %(%m=[A-Z]?h: )

     %M      The number of articles marked to return via the  'M'
             command.   If  the  same  article is Marked multiple
             times, "%M" counts it multiple times in the  current
             implementation.

     %n      "Newsgroups:" line from the current article.

     %N      Full name (yours).

     %o      Organization (yours).

     %O      Original working directory (where you ran rn from).

     %p      Your private news directory, normally ~/News.

     %P      Public    news     spool     directory,     normally
             /usr/spool/news on systems that don't use NNTP.

     %r      Last reference on references line of current article
             (parent article id).

     %R      References list for a new article, constructed  from
             the  references  and article ID of the current arti-
             cle.





Sun Release 4.1        Last change: LOCAL                      28






TRN(1)                   USER COMMANDS                     TRN(1)



     %s      Subject, with all Re's and (nf)'s stripped off.

     %S      Subject, with one "Re:" stripped off.

     %t      "To:" line derived from the "From:" and  "Reply-To:"
             lines  of  the current article.  This always returns
             an Internet format address.

     %T      "To:" line derived from  the  "Path:"  line  of  the
             current article to produce a uucp path.

     %u      The number of unread articles in the  current  news-
             group.

     %U      The number of unread articles in the  current  news-
             group,  not  counting the the current article.  When
             threads  are  selected,  this  count  reflects  only
             selected articles.

     %v      The number of unselected articles, not counting  the
             current article if it is unselected.

     %w      The directory where mthreads keeps its tmp files.

     %W      The directory where thread files are placed.

     %x      The news library directory.

     %X      The rn library directory.

     %z      The length of the current article in bytes.

     %Z      The number of selected threads.

     %~      Your home directory.

     %.      The directory containing your dot  files,  which  is
             your  home directory unless the environment variable
             DOTDIR is defined when rn is invoked.

     %#      The current count for a  multi-file  save,  starting
             with  1.   This value is incremented by one for each
             file saved or extracted within a single command.

     %$      Current process number.

     %/      Last search string.

     %%      A percent sign.

     %{name} or %{name-default}
             The environment variable "name".



Sun Release 4.1        Last change: LOCAL                      29






TRN(1)                   USER COMMANDS                     TRN(1)



     %[name] The value of header line "Name:"  from  the  current
             article.  The "Name: " is not included.  For example
             "%D" and "%[distribution]" are equivalent.  The name
             must be spelled out in full.

     %`command`
             Inserts the output of the command, with any embedded
             newlines translated to space.

     %"prompt"
             Prints prompt  on  the  terminal,  then  inputs  one
             string, and inserts it.

     %(test_text=pattern?then_text:else_text)
             If  test_text  matches  pattern,   has   the   value
             then_text, otherwise else_text.  The ":else_text" is
             optional,  and  if  absent,  interpolates  the  null
             string.  The = may be replaced with != to negate the
             test.  To quote any of the metacharacters ('=', '?',
             ':', or ')'), precede with a backslash.

     %digit  The  digits  1  through  9  interpolate  the  string
             matched by the nth bracket in the last pattern match
             that had brackets.  If the last pattern had alterna-
             tives,  you  may  not know the number of the bracket
             you want--%0 will give you the last bracket matched.

     Modifiers: to capitalize the first letter, insert '^': "%^C"
     produces  something  like "Net.jokes".  Inserting '_' causes
     the first letter following the last '/' to  be  capitalized:
     "%_c" produces "net/Jokes".

     Inserting '\' will insert a backslash before any  characters
     that  would be magic in a regular expression: "%\C" produces
     "net\.jokes".  This is called regexp quoting.

ENVIRONMENT
     The following environment variables are paid attention to by
     trn.   In general the default values assumed for these vari-
     ables by trn are reasonable, so if you are using trn for the
     first  time,  you can safely ignore this section.  Note that
     the defaults below  may  not  correspond  precisely  to  the
     defaults  on  your  system.  To find the actual defaults you
     would need to look in  config.h  and  common.h  in  the  trn
     source directory, and the file INIT in the trn library.

     Those variables marked (%) are subject to  %  interpolation,
     and those marked (~) are subject to both % interpolation and
     ~ interpretation.

     ATTRIBUTION (%)
             Gives the format of the attribution line in front of



Sun Release 4.1        Last change: LOCAL                      30






TRN(1)                   USER COMMANDS                     TRN(1)



             the quoted article included by an F command.

             Default: In article %i %f writes:

     AUTOSUBSCRIBE
             When trn is checking for new  newsgroups  and  finds
             one  matching  one of the patterns in AUTOSUBSCRIBE,
             the new group is automatically added to the  end  of
             the  .newsrc,  subscribed.   Newsgroups not matching
             this or AUTOUNSUBSCRIBE, below, are offered  to  the
             user.

             AUTOSUBSCRIBE is a comma separated list of newsgroup
             patterns  ala  It can also include "but not" entries
             preceded by '!'.  "a,b,!c,d" is read as "matching  a
             or  b,  unless it also matches c; matching d regard-
             less".  Another way to look at it is "(((a or b) and
             not  c)  or  d)".  To automatically subscribe to all
             local groups but be choosy about  non-local  groups,
             one might say "*,!*.*".

             Default: (none)

     AUTOUNSUBSCRIBE
             AUTOUNSUBSCRIBE is very  similar  to  AUTOSUBSCRIBE,
             above,  but new newsgroups matching it are automati-
             cally added to the end of the .newsrc  file,  unsub-
             scribed.   If  a  newsgroup  matches  AUTOSUBSCRIBE,
             AUTOUNSUBSCRIBE is not consulted.

             Default: (none)

     CANCEL (~)
             The shell command used to cancel an article.

             Default: inews -h < %h

     CANCELHEADER (%)
             The format of the file to pass to the CANCEL command
             in order to cancel an article.

             Default:
             Newsgroups: %n
             Subject: cmsg cancel %i
             References: %R
             Reply-To: %L@%H (%N)
             Distribution: %D
             Organization: %o

             %i cancelled from rn.





Sun Release 4.1        Last change: LOCAL                      31






TRN(1)                   USER COMMANDS                     TRN(1)



     DOTDIR  Where to find your dot files, if they aren't in your
             home directory.  Can be interpolated using "%.".

             Default: $HOME

     EDITOR (~)
             The name of your editor, if VISUAL is undefined.

             Default: whatever your news  administrator  compiled
             in, usually vi.

     EXSAVER (%)
             The shell command to execute  in  order  to  extract
             data to either /bin/sh or a user-specified command.

             Default: tail +%Bc %A | %e

     EDITOR (~)
             The name of your editor, if VISUAL is undefined.

             Default: whatever your news  administrator  compiled
             in, usually vi.

     FIRSTLINE (%)
             Controls the format of the line displayed at the top
             of an article.  Warning: this may go away.

             The default in an unthreaded group is approximately:

             Article  %a  %(%U%M!=^00$?(%U  more%(%M!=^0$?  +  %M
             Marked to return)\) )in %C:

             While the default in a threaded group is almost:

             %C #%a%(%Z=^0$?%(%U!=^0$?  (%U  more\)):  (%U  +  %v
             more\))

     HIDELINE
             If defined,  contains  a  regular  expression  which
             matches  article  lines  to be hidden, in order, for
             instance, to suppress  quoted  material.   A  recom-
             mended  string  for  this  purpose is "^>...", which
             doesn't hide lines with only '>', to give some indi-
             cation  that  quoted  material is being skipped.  If
             you want to hide more than one pattern, you can  use
             "|"  to separate the alternatives.  You can view the
             hidden lines by restarting the article with the  'v'
             command.

             There is some overhead  involved  in  matching  each
             line  of  the  article against a regular expression.
             You might wish to use a baud-rate modifier to enable



Sun Release 4.1        Last change: LOCAL                      32






TRN(1)                   USER COMMANDS                     TRN(1)



             this feature only at low baud rates.

             Default: undefined

     HOME    Your home directory.  Affects ~ interpretation,  and
             the  location  of  your  dot  files if DOTDIR is not
             defined.

             Default: $LOGDIR

     KILLGLOBAL (~)
             Where to find the KILL file to apply to every  news-
             group.  See the '^K' command at the newsgroup selec-
             tion level.

             Default: %p/KILL

     KILLLOCAL (~)
             Where to find the KILL file for  the  current  news-
             group.  See the commands 'K' and '^K' at the article
             selection level, and the search modifier 'K'.

             Default: %p/%c/KILL

     LOGDIR  Your home directory if HOME is undefined.  Affects ~
             interpretation,  and  the location of your dot files
             if DOTDIR is not defined.

             Default: none.

             Explanation: you must have either $HOME or $LOGDIR.

     LOGNAME Your login name,  if  USER  is  undefined.   May  be
             interpolated using "%L".

             Default: value of getlogin().

     LOCALTIMEFMT
             The format used by strftime()  to  print  the  local
             time.  The Date line is only displayed in local time
             if the group is threaded (see the -H option for more
             information on Date).

             Default: %a %b %e %X %Z %Y

             which is the same format as the date(1) command.

     MAILCALL (~)
             What to say when there is new mail.

             Default: (Mail)




Sun Release 4.1        Last change: LOCAL                      33






TRN(1)                   USER COMMANDS                     TRN(1)



     MAILFILE (~)
             Where to check for mail.

             Default: /usr/spool/mail/%L

     MAILHEADER (%)
             The format of the header file for replies.  See also
             MAILPOSTER.

             Default:

             To: %T
             Subject: %(%i=^$?:Re: %S
             Newsgroups: %n
             In-Reply-To: %i)
             %(%[references]!=^$?References\: %[references]
             )Organization: %o
             Cc:
             Bcc: \n\n

     MAILPOSTER (~)
             The shell command to be used by the  reply  commands
             (r and R) in order to allow you to enter and deliver
             the response.  trn will not itself call upon an edi-
             tor  for  replies--this is a function of the program
             called by trn.  See also MAILHEADER.

             Default: Rnmail -h %h

     MBOXSAVER (~)
             The shell command to save an article in mailbox for-
             mat.

             Default: %X/mbox.saver %A %P %c %a %B %C "%b" \
             "From: %T %`date`"

             Explanation: the first seven arguments are the  same
             as  for NORMSAVER.  The eighth argument to the shell
             script is  the  new  From:  line  for  the  article,
             including  the posting date, derived either directly
             from the Posted: line, or not-so-directly  from  the
             Date: line.  Header munging at its finest.

     MODSTRING
             The string to insert  in  the  group  summary  line,
             which  heads  each  article,  for a moderated group.
             See also NOPOSTRING.

             Default: " (moderated)"

     NAME    Your full name.  May be interpolated using "%N".




Sun Release 4.1        Last change: LOCAL                      34






TRN(1)                   USER COMMANDS                     TRN(1)



             Default: name from /etc/passwd, or ~/.fullname.

     NEWSHEADER (%)
             The format of the header file  for  followups.   See
             also NEWSPOSTER.

             Default:

             Newsgroups: %(%F=^$?%C:%F)
             Subject: %(%S=^$?%"\n\nSubject: ":Re: %S)
             Summary:
             Expires:
             %(%R=^$?:References: %R
             )Sender:
             Reply-To: %L@%H (%N)
             Followup-To:
             Distribution: %(%i=^$?%"\nDistribution: ":%D)
             Organization: %o
             Keywords: \n\n

     NEWSORG Either the name of your organization, or the name of
             a  file  containing  the  name of your organization.
             (For use at sites where the ORGANIZATION environmen-
             tal  variable is already in use.  NEWSORG will over-
             ride ORGANIZATION  if  both  are  present.)  May  be
             interpolated using "%o".

             Default: whatever your news  administrator  compiled
             in.

     NEWSPOSTER (~)
             The shell command to be used by  the  followup  com-
             mands  (f  and F) in order to allow you to enter and
             post a followup news article.  trn will  not  itself
             call  upon  an editor for followups--this is a func-
             tion of the program called by trn.  See  also  NEWS-
             HEADER.

             Default: Pnews -h %h

     NEWSRC  Your newsgroup subscription list.

             Default: $HOME/.newsrc

     NNTPSERVER
             The hostname of your  NNTPSERVER.   [This  does  not
             apply  unless  you  are  running the NNTP version of
             rn.]

             Default: the hostname listed  in  the  server  file,
             usually /usr/local/lib/rn/server.




Sun Release 4.1        Last change: LOCAL                      35






TRN(1)                   USER COMMANDS                     TRN(1)



     NOPOSTRING
             The string to insert  in  the  group  summary  line,
             which heads each article, for a group to which local
             posting is not allowed.  See also MODSTRING.

             Default: " (no posting)"

     NORMSAVER (~)
             The shell command to save an article in  the  normal
             (non-mailbox) format.

             Default: %X/norm.saver %A %P %c %a %B %C "%b"

     ORGANIZATION
             Either the name of your organization, or the name of
             a  file  containing  the  name of your organization.
             (If NEWSORG is set, it will override  ORGANIZATION.)
             May be interpolated using "%o".

             Default: whatever your news  administrator  compiled
             in.

     PAGESTOP
             If defined,  contains  a  regular  expression  which
             matches  article  lines to be treated as form-feeds.
             There are at least two things you might want  to  do
             with this.  To cause page breaks between articles in
             a digest, you might define it  as  "^--------".   To
             force  a  page  break  before a signature, you could
             define it as "^-- $".  (Then, when you see  "--"  at
             the  bottom  of the page, you can skip the signature
             if you so desire by typing 'n' instead of space.) To
             do  both, you could use "^--".  If you want to break
             on more  than  one  pattern,  you  can  use  "|"  to
             separate the alternatives.

             There is some overhead  involved  in  matching  each
             line  of  the  article against a regular expression.
             You might wish to use a baud-rate modifier to enable
             this feature only at low baud rates.

             Default: undefined

     PIPESAVER (%)
             The shell command to execute in order to  accomplish
             a  save  to a pipe ("s | command" or "w | command").
             The command typed by the user is substituted  in  as
             %b.

             Default: %(%B=^0$?<%A:tail +%Bc %A |) %b

             Explanation: if %B is 0, the command  is  "<%A  %b",



Sun Release 4.1        Last change: LOCAL                      36






TRN(1)                   USER COMMANDS                     TRN(1)



             otherwise the command is "tail +%Bc %A | %b".

     REPLYTO The value of the "Reply-To:" header, if needed.


     RNINIT  Default values for switches may be passed to trn  by
             placing them in either RNINIT or TRNINIT.  RNINIT is
             used when in rn-compatibility  mode  or  if  TRNINIT
             isn't found.  Any switch that is set in this way may
             be overruled on the command line,  or  via  the  '&'
             command  from  within  trn.   Binary-valued switches
             that are set  with  "-switch"  may  be  unset  using
             "+switch".

             If RNINIT begins with a '/' it is assumed to be  the
             name  of a file containing switches.  If you want to
             set many environment variables  but  don't  want  to
             keep  them all in your environment, or if the use of
             any of these variables  conflicts  with  other  pro-
             grams,  you  can  use this feature along with the -E
             switch  to  set  the  environment   variables   upon
             startup.

             Default: " ".

     RNMACRO (~)
             The name of the file containing macros and key  map-
             pings.  See the MACROS section.

             Default: %./.rnmac

     SAVEDIR (~)
             The name of the directory to save to,  if  the  save
             command does not specify a directory name.

             Default:
                If -/ is set: %p/%c
                If +/ is set: %p

     SAVENAME (%)
             The name of the file to save to, if the save command
             contains only a directory name.

             Default:
                If -/ is set: %a
                If +/ is set: %^C

     SELECTCHARS
             The characters used by the thread selector to select
             the   associated  thread  of  discussion.   You  can
             specify  up  to  64  visible  characters,  including
             upper-  and  lower-case  letters,  numbers, and many



Sun Release 4.1        Last change: LOCAL                      37






TRN(1)                   USER COMMANDS                     TRN(1)



             punctuation characters.  Selection characters  over-
             ride command characters in the selector, but are not
             excluded from macro expansion, so be careful.
             Default: abcdefgijlorstuvwxz1234567890
             (h, k, n, p, q, and y are omitted to allow  them  to
             be typed as commands).

     SHELL   The name of your preferred shell.  It will  be  used
             by the '!', 'S' and 'W' commands.

             Default: whatever your news  administrator  compiled
             in.

     SUBJLINE (%)
             Controls the format of the lines  displayed  by  the
             '=' command at the article selection level.

             Default: %s

     SUPERSEDEHEADER (%)
             The format of the header file for a supersede  arti-
             cle.

             Default:

             From: %L@%H (%N)
             Newsgroups: %n
             Subject: %S
             Distribution: %D
             Organization: %o
             Supersedes: %i

     TERM    Determines  which  termcap  entry  to  use,   unless
             TERMCAP contains the entry.

     TERMCAP Holds either the name of your  termcap  file,  or  a
             termcap entry.

             Default: /etc/termcap, normally.

     TRNINIT Trn's version of the  RNINIT  environment  variable.
             See RNINIT for a description.

     UNSHAR (~)
             The shell command to execute in order to  accomplish
             the unshar'ing of a shell archive.

             Default: /bin/sh

     USER    Your login name.  May be interpolated using "%L".

             Default: $LOGNAME



Sun Release 4.1        Last change: LOCAL                      38






TRN(1)                   USER COMMANDS                     TRN(1)



     VISUAL (~)
             The name of your editor.

             Default: $EDITOR

     YOUSAID (%)
             Gives the format of the attribution line in front of
             the quoted article included by an R command.

             Default: In article %i you write:

MACROS
     When trn starts up, it looks for  a  file  containing  macro
     definitions   (see   environment   variable  RNMACRO).   Any
     sequence of commands may be bound to any sequence  of  keys,
     so  you  could  remap  your  entire  keyboard if you desire.
     Blank lines or lines beginning with # in the macro file  are
     considered  comments;  otherwise  trn  looks  for two fields
     separated  by  white  space.   The  first  field  gives  the
     sequence  of  keystrokes  that  trigger  the  macro, and the
     second field gives the  sequence  of  commands  to  execute.
     Both  fields are subject to % interpolation, which will also
     translate backslash and uparrow sequences.   (The  keystroke
     field  is interpreted at startup time, but the command field
     is interpreted at macro execution time so that you may refer
     to % values in a macro.) For example, if you want to reverse
     the roles of carriage return and space in trn

     ^J   \040
     ^M   \040
     \040 ^J

     will do just that.  By default, all characters in  the  com-
     mand  field are interpreted as the canonical trn characters,
     i.e. no macro expansion is done.  Otherwise the  above  pair
     of  macros  would  cause  an  infinite loop.  To force macro
     expansion in the command field, enclose the macro call  with
     ^( ... ^) thusly:

     @s   |mysavescript
     @w   w^(@s^)

     You can use the %() conditional construct to construct  mac-
     ros that work differently under different circumstances.  In
     particular, the current mode (%m) of trn could  be  used  to
     make  a command that only works at a particular level.  This
     is particularly vital for the thread  selector,  which  uses
     most  of  the  lower-case  letters  to select the associated
     thread of discussion.  For example,

     a    %(%m=t?a:s art.hold\n)




Sun Release 4.1        Last change: LOCAL                      39






TRN(1)                   USER COMMANDS                     TRN(1)



     will return the original letter (a) in the thread  selector,
     and the command "s art.hold\n" everywhere else.

     %(%{TERM}=vt100?^[[O)    /^J

     will do the binding only if  the  terminal  type  is  vt100,
     though  if you have many of these it would be better to have
     separate files for each terminal.

     If you want to bind a macro to a function key  that  puts  a
     common  garbage  character  after  the sequence (such as the
     carriage  return  on  the  end  of  Televideo  920  function
     sequences),  DO  NOT  put  the  carriage return into all the
     sequences or you will waste a CONSIDERABLE amount of  inter-
     nal  storage.   Instead of "^AF^M", put "^AF+1", which indi-
     cates to trn that it should gobble up  one  character  after
     the F.

WHAT'S NEW?
     Here's a quick run-down of trn's new features  and  commands
     aimed at the knowledgeable rn user.

     One of the biggest  improvements  is  the  Thread  Selector,
     which is bound to the '+' key.  The selector displays a list
     of subject threads and (by default) authors to allow you  to
     select  the topics that interest you by typing their associ-
     ated letter.  The thread selector can also be used to browse
     articles that have already been read, to selectively re-read
     discussions (use the 'U' command).

     Another big improvement is  the  thread-ordered  display  of
     articles.  While reading each topic, trn displays each arti-
     cle and its replies in the order of their parent/child rela-
     tionship.   This  lets you follow the flow of the discussion
     better, instead of jumping around from idea to idea or  even
     reading a reply before the original article.

     Along this same line is the  addition  of  the  article-tree
     display  in  the upper-right corner of the header.  Glancing
     at the tree gives you a better feel for how the articles you
     are reading relate to each other.

     The header has  also  been  modified  to  hide  a  few  more
     header-lines  by  default (e.g. References), but, as always,
     you can override these with -h.   There  is  also  some  new
     "magic" in the header: the From header is trimmed to be just
     the comment portion (if available), and the Date  header  is
     displayed  in  local  time  (in  threaded groups).  Override
     these defaults with +H.

     Once you begin reading articles, use  the  regular  movement
     commands  (n,  N,  p, P, etc.) as you normally would.  Then,



Sun Release 4.1        Last change: LOCAL                      40






TRN(1)                   USER COMMANDS                     TRN(1)



     check out the [, ], {, and } commands to move around in  the
     article tree a bit more directly.  For example, the '[' com-
     mand takes you to  your  parent  article,  even  if  it  was
     already  read,  which  is  very useful for tracking down the
     cited portion of the article in its original context.

     There are additional kill commands for the entire thread (J)
     and  the  current article and all its replies (,).  The KILL
     files have been extended to allow  killing  by  thread  (T),
     which will kill a topic even if people fine-tune the subject
     along the way.

     There is also an easy way to skip around among  the  various
     threads with the < and > commands.

     Note:  your news administrator has  the  option  of  turning
     thread  processing off for individual groups, and thus it is
     possible for some  groups  to  not  have  any  pre-processed
     thread  information  available for use.  When trn encounters
     such a group, it generates the thread information on the fly
     while  entering  the  group.   For  really  large groups (or
     really slow systems), this can take an appreciable amount of
     time.   If  you can't talk your news administrator into pre-
     threading the group, you can turn off the thread database on
     a  group-by-group  basis  using the 't' command at the news-
     group selection level.  Groups turned off in  this  way  are
     read  in  the  traditional  rn fashion--articles arranged in
     arrival order with optional subject searching and no  thread
     selector.

     There is a new command,  "e  dir",  that  extracts  a  shell
     archive  or uuencoded file into the specified directory.  It
     is even possible  to  extract  other  data  formats  if  you
     specify the appropriate filter command (e.g. "e dir|cmd".

     Also, if you plan to use macro definitions, it  is  good  to
     keep  in  mind  that  the  thread  selector uses most of the
     lower-case letters for thread selection, and thus  it  is  a
     good  idea  to  explicitly  set the mode(s) in which a macro
     applies.  For example, if you want to  press  'f'  from  the
     article pager/selector to forward the current article to the
     user "smith", you could define:

          f    %(%m=[pa]?|mail smith\n:f)

     This checks the current mode (%m) and if it is 'p' or 'a' it
     expands  it  to  the  string  "|mail  smith\n", otherwise it
     returns the letter 'f'.  In some cases, you may simply  wish
     to  exclude the thread selector from a macro with the condi-
     tional "%m!=t".

     Finally, you'll probably want to use the new options, -x and



Sun Release 4.1        Last change: LOCAL                      41






TRN(1)                   USER COMMANDS                     TRN(1)



     -X  to ensure that all the newest features are available for
     use.  These options might be on by default, depending on how
     your administrator decided to install trn.

AUTHORS
     Rn was created by Larry Wall <lwall@jpl-devvax.jpl.nasa.gov>
     and  is   now   under   the   direction   of   Stan   Barber
     <sob@bcm.tmc.edu>.
     Threaded version by Wayne Davison <davison@borland.com>
     (Mail all bug reports for trn to Wayne.)
     Regular expression routines  are  borrowed  from  emacs,  by
     James Gosling.

FILES
     %./.newsrc  status of your news reading

     %./.oldnewsrc
                 backup copy of your .newsrc from start  of  ses-
                 sion

     %./.rnlock  lock file so you don't screw up your .newsrc

     %./.rnlast  info from last run of rn

     %./.rnsoft  soft pointers into /usr/lib/news/active to speed
                 startup, synchronous with .newsrc

     %./.rnhead  temporary header file to pass  to  a  mailer  or
                 news poster

     %./.rnmac   macro and keymap definitions

     %p          your news save directory, usually ~/News

     %x/active   the   list   of   active   newsgroups,   usually
                 /usr/lib/news/active  on  systems that don't use
                 NNTP

     %P          the  public  news   spool   directory,   usually
                 /usr/spool/news on systems that don't use NNTP

     %X/INIT     system-wide default switches

SEE ALSO
     newsrc(5), more(1), readnews(1), Pnews(1), Rnmail(1)

DIAGNOSTICS
     Generally self-documenting, as they say.

BUGS
     The -h switch can only hide  header  lines  that  trn  knows
     about.



Sun Release 4.1        Last change: LOCAL                      42






TRN(1)                   USER COMMANDS                     TRN(1)



     The '-' command doesn't cross newsgroup boundaries, and only
     undoes the last article selection.

     If you edit your .newsrc while trn is running, trn will hap-
     pily  wipe out your changes when it decides to write out the
     .newsrc file.

     Marking of duplicate articles as  read  in  cross-referenced
     newsgroups  will not work unless the Xref patch is installed
     in inews.

     If you get carried away with % or escape substitutions,  you
     can overflow buffers.

     There should be no fixed limit on the number of newsgroups.

     Some of  the  more  esoteric  features  may  be  missing  on
     machines with limited address space.





































Sun Release 4.1        Last change: LOCAL                      43



