/*

Birthday Reminder 1.0

(C) 1994 by Wolfram Koerner

FREEWARE but: Please do not spread it after you changed it. If you have bugs or
improvements tell them to me. So we can implement them together and no version-
confusion will raise:

          Internet : koerner@cip.informatik.uni-wuerzburg.de

          Fido     : Wolfram Koerner@2:2490/5100.8

          Snailmail: Wolfram Koerner
                     Friedenstrasse 5a
                     97072 Wuerzburg
                     GERMANY

*/


/* ********Load RexxUtil.DLL functions ********** */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* ******************Init variables************** */
DBFile="C:\BIRTHDAY.DAT"
DBFirstLine = "Birthday Database 1.0"
Sortindex = 3
modeCheckDB = 0
modeQuiet=0
RecCount = 0
global_again = 1

daysOfMonth.1  = 31
daysOfMonth.2  = 28
daysOfMonth.3  = 31
daysOfMonth.4  = 30
daysOfMonth.5  = 31
daysOfMonth.6  = 30
daysOfMonth.7  = 31
daysOfMonth.8  = 31
daysOfMonth.9  = 30
daysOfMonth.10 = 31
daysOfMonth.11 = 30
daysOfMonth.12 = 31

CurDate =Date("USA")
CurMM   = GetMM(CurDate)
CurDD   = GetDD(CurDate)
CurMMDD = GetMMDD(CurDate)   /* Month and Day mm/dd */
CurYY   = GetYY(CurDate)

/* ******************Init program**************** */
call InitColors    /* Init ANSI colors */
parse arg cmdline  /* Store all given Command parameters in CMDLINE */
if cmdline \= "" then
     call AnalyzeCmdLine


/*  -----------------------------MAIN-------------------------------- */
call LoadDB

if modeCheckDB = 0 then do
    do while global_again=1
       Men = MainMenu()
       if Men="L" then
	  call ListDB
       if Men="P" then
          call PrintDB
       if Men="R" then
          call ResetDB
       if Men="S" then do
          if Sortindex=1 then Sortindex=3
                         else Sortindex=1
          call SysCls
          call SortDB
       end
       if Men="A" then
	  call AddRecord
       if Men="E" then
          call EditRecord
       if Men="D" & RecCount>0 then
	  call DeleteRecord
       if Men="C" then
	  call CheckDB
       if Men="Q" then do
	  if RecCount>0 then
	     call SaveDB
	  global_again=0
       end
    end
end
else do
    call CheckDB
    if RecCount>0 then
       call SaveDB
end  /* else */
exit 0


/*  ----------------------Procedures and Subroutines------------------- */

/* ****************************************
   * PlaySong
   * Plays "Happy Birthday to you."
   **************************************** */
PlaySong:
  if ModeQuiet=1 then return
  call beep 262,100
  call beep 262,100
  call beep 294,200
  call beep 262,200
  call beep 349,200
  call beep 330,300
return


/* ********************************************
   * WarningSound
   ******************************************** */
WarningSound:
  if ModeQuiet=1 then return
  call beep 349,100
  call beep 294,100
return


/* **********************************************
   * MainMenu
   * returns Letter pressed
   ********************************************** */
MainMenu:
    call SysCls
    if Sortindex=1 then Sortname="NAME"
                   else Sortname="DATE"
    if Sortindex=1 then OtherSortname="DATE"
                   else OtherSortname="NAME"
    a = charout(,byellow||"Ŀ")
    a = charout(,"                            Birthday Reminder V1.0                            ")
    a = charout(,"                                                                              ")
    a = charout(,"                                Today:"||CurDate||"                                ")
    a = charout(,"                       Database:"||Format(RecCount,3)||" Recs - "||SortName||" sorted                        ")
    a = charout(,"Ĵ")
    a = charout(,"                                                                              ")
    a = charout(,"                                                                              ")
    a = charout(,"                                                                              ")
    a = charout(,""||bcyan||"                       L ..... List complete database                         "||byellow||"")
    a = charout(,""||bcyan||"                       P ..... Print database                                 "||byellow||"")
    a = charout(,""||bcyan||"                       R ..... Reactivate passive events                      "||byellow||"")
    a = charout(,""||bcyan||"                       S ..... Sort database by: "||OtherSortname||"                         "||byellow||"")
    a = charout(,""||bcyan||"                       C ..... Check for birthdays                            "||byellow||"")
    a = charout(,"                                                                              ")
    a = charout(,""||bcyan||"                       A ..... Add a record                                   "||byellow||"")
    a = charout(,""||bcyan||"                       E ..... Edit a record                                  "||byellow||"")
    a = charout(,""||bcyan||"                       D ..... Delete a record                                "||byellow||"")
    a = charout(,"                                                                              ")
    a = charout(,""||bcyan||"                       Q ..... Quit program (and save data)                   "||byellow||"")
    a = charout(,"                                                                              ")
    a = charout(,"                                                                              ")
    a = charout(,"                                                                              ")
    a = charout(,"(C)'94 WOK")
    call GotoXY 26,21
    a = charout(,byellow||"----> YOUR CHOICE")
    call GotoXY 24,21
    again=1
    do while again=1
       MM_key=Translate(SysGetKey('NOECHO'))
       if MM_key="L"|,
	  MM_key="A"|,
	  MM_key="D"|,
          MM_key="E"|,
          MM_key="R"|,
          MM_key="S"|,
	  MM_key="C"|,
          MM_key="P"|,
          MM_key="Q" then do
             again=0
             say MM_key
       end
    end
    say normal
return MM_key


/* **********************************************
   * AddRecord
   ********************************************** */
AddRecord:
   call SysCls
   say bcyan||"Add a record to database:"
   say "-------------------------"||normal
   say
   say "Enter Name (max 25 chars, <enter> to abort):"
   say "........................."
   call GotoXY 0,WhereY()-1
   parse pull aString
   if aString = "" then return
   dbdummy.1 = substr(aString,1,min(25,length(aString)))

   say "Enter Memo (max 20 chars):"
   say "...................."
   call GotoXY 0,WhereY()-1
   parse pull aString
   dbdummy.2 = substr(aString,1,min(20,length(aString)))

   again = 1
   do while again = 1
       say "Enter Birthday (mm/dd/yy):"
       parse pull aString
       say
       if substr(aString,3,1)='/',           /* Test Input */
	& substr(aString,6,1)='/',
	& length(aString)=8 then
	     again = 0
	else
	     say bred||"ERROR: Please enter Birthday again."||normal
       dbdummy.3 = aString
   end

   say "Enter prewarning-days (0 <= days <= 28):"
   loopready = 0
   do until loopready=1
       pull dbdummy.4
       if   dbdummy.4 = "" then dbdummy.4=0
       if datatype(dbdummy.4) = "NUM",
          & dbdummy.4>=0 ,
          & dbdummy.4<=28 then
	     loopready=1
	  else
             say bred||"ERROR: Enter a number from 0 to 28 !"||normal
   end
   dbdummy.5 = 0

   InsertPos = 1              /* search correct insert-position*/
   if RecCount > 0 then do    /* At least one record already in database ? */
      do while dbdummy.Sortindex > db.Sortindex.InsertPos
         InsertPos = InsertPos +1
      end
      do MoveFrom = RecCount to InsertPos by -1
         MoveTo = MoveFrom +1
         db.1.MoveTo = db.1.MoveFrom
         db.2.MoveTo = db.2.MoveFrom
         db.3.MoveTo = db.3.MoveFrom
         db.4.MoveTo = db.4.MoveFrom
         db.5.MoveTo = db.5.MoveFrom
         db.6.MoveTo = db.6.MoveFrom
      end
   end /* if */
   db.1.InsertPos = dbdummy.1
   db.2.InsertPos = dbdummy.2
   db.3.InsertPos = dbdummy.3
   db.4.InsertPos = dbdummy.4
   db.5.InsertPos = dbdummy.5

   RecCount = RecCount +1
   call UpdateRecord InsertPos
return


/* **********************************************
   * EditRecord
   ********************************************** */
EditRecord:
  if RecCount>0 then do
    call SysCls
    say bcyan||"Edit Record in database:"
    say "------------------------"||normal
    say
    say "Please enter number of record you wish to EDIT (from 1 to "||RecCount||")"
    say "Hit <enter> to abort."
    ER_i=0
    do while ER_i<1 | ER_i>RecCount
      pull ER_i
      if ER_i="" then return
    end
    ER_again=1
    do while ER_again=1
        call SysCls
        say bcyan"EDIT Record No."ER_i
        say
        say
        say "N ..... Name            : "db.1.ER_i
        say
        say "M ..... Memo            : "db.2.ER_i
        say
        say "B ..... Birthday        : "db.3.ER_i
        say
        say "P ..... Pre-Warningdays : "db.4.ER_i
        say
        say "E ..... EXIT TO MAINMENU"
        say
        say byellow||"  ----> Your choice"
        call GotoXY 0, WhereY()-1
        ER_key=Translate(SysGetKey('NOECHO'))
        ER_again2=1
        do while ER_again2=1
            if ER_key="N"|,
               ER_key="M"|,
               ER_key="B"|,
               ER_key="P"|,
               ER_key="E" then do
                  ER_again2=0
                  say MM_key
                  say
            end /* if */
        end /* do */

        if ER_key="E" then ER_again=0                               /* EXIT */

        if ER_key="N" then do                                       /* NAME */
            say "Enter Name (max 25 chars, <enter> to abort):"
            say "........................."
            call GotoXY 0,WhereY()-1
            parse pull aString
            if aString <> "" then
               db.1.ER_i = substr(aString,1,min(25,length(aString)))
        end /* if NAME-Edit */

        if ER_key = "M" then do                                      /* MEMO */
            say "Enter Memo (max 20 chars):"
            say "...................."
            call GotoXY 0,WhereY()-1
            parse pull aString
            if aString <> "" then
               db.2.ER_i = substr(aString,1,min(20,length(aString)))
        end /* if MEMO-Edit */

        if ER_key = "B" then do                                  /* BIRTHDAY */
            ER_again3 = 1
            do while ER_again3 = 1
                say "Enter Birthday (mm/dd/yy):"
                parse pull aString
                say
                if aString <> "" then do
                    if substr(aString,3,1)='/',
                     & substr(aString,6,1)='/',
                     & length(aString)=8 then
                          ER_again3 = 0
                     else
                          say bred||"ERROR: Please enter Birthday again."||normal
                    db.3.ER_i = aString
                end /* if */
            end /* do */
        end /* if Birthday-Edit */

        if ER_key = "P" then do                                /* PREWARNING */
                say "Enter prewarning-days (0 <= days <= 28):"
                ER_again3 = 0
                do until ER_again3=1
                    pull db.4.ER_i
                    if   db.4.ER_i = "" then db.4.ER_i=0
                    if datatype(db.4.ER_i) = "NUM",
                       & db.4.ER_i>=0 ,
                       & db.4.ER_i<=28 then
                          ER_again3=1
                       else
                          say bred||"ERROR: Enter a number from 0 to 28 !"||normal
                end /* do */
         end /* if PreWarning-Edit */
    end /* do while ER_again=1 */
    db.5.ER_i = 0
    call UpdateRecord ER_i
    call SortDB
  end /* if RecCount>0 */
return


/* **********************************************
   * DeleteRecord
   ********************************************** */
DeleteRecord:
  if RecCount>0 then do
    call SysCls
    say bcyan||"Delete record from database:"
    say "----------------------------"||normal
    say
    say "Please enter number of record you wish to DELETE (from 1 to "||RecCount||")"
    say "Hit <enter> to abort."
    DR_i=0
    do while DR_i<1 | DR_i>RecCount
      pull DR_i
      if DR_i="" then return
    end
    call ListRecord DR_i
    say bred||"WARNING: Do you really want to DELETE this Record (Y/N) ?"
    answer = ""
    do until answer = "Y" | answer = "N"
       pull answer
    end
    if answer = "Y" then do
	do ii=DR_i to RecCount-1
	   iii = ii+1
	   db.1.ii = db.1.iii
	   db.2.ii = db.2.iii
	   db.3.ii = db.3.iii
	   db.4.ii = db.4.iii
           db.5.ii = db.5.iii
           db.6.ii = db.6.iii
	end
	RecCount = RecCount -1
    end
  end /* if */
return



/* **********************************************
   * ListRecord(n)
   ********************************************** */
ListRecord:
    LR_i=arg(1)
    say LR_i
    call GotoXY 5,WhereY()-1
    say db.1.LR_i
    call GotoXY 35,WhereY()-1
    say db.2.LR_i
    call GotoXY 57,WhereY()-1
    say db.3.LR_i
    call GotoXY 65,WhereY()-1
    say" ("||db.4.LR_i||")"
    call GotoXY 71,WhereY()-1
    say ":"||db.5.LR_i||" #"||db.6.LR_i
return


/* **********************************************
   * PrintDB
   ********************************************** */
PrintDB:
    if RecCount > 0 then do
       call SysCls
       say bcyan||"Print database to file or device:"
       say "---------------------------------"||normal
       say
       say "Please enter a device/filename for database-output"
       say "e.g. PRN for printer"
       say "     c:\text.txt for a file"
       say "     con for screen"
       pull PDB_Device
       say bred||"WARNING: Do you really want to print the database (Y/N)?"||normal
       answer = ""
       do until answer = "Y" | answer = "N"
          pull answer
       end
       if answer = "Y" then do
          dummy=lineout(PDB_Device,"    Birthday Calendar")
          dummy=lineout(PDB_Device," ")
          if SortIndex = 3 then do
              dummy=lineout(PDB_Device,"    No.    mm/dd/yy (PW)  Name                        Memo               ")
              dummy=lineout(PDB_Device,"    ---------------------------------------------------------------------")
              do PDB_i = 1 to RecCount
                  DBP_str = "    "||Format(PDB_i,3)
                  DBP_str = DBP_str || "."
                  DBP_str = DBP_str || "   "
                  DBP_str = DBP_str || db.3.PDB_i
                  DBP_str = DBP_str || " (" ||Format(db.4.PDB_i,2)||")  "
                  DBP_str = DBP_str || Insert("",db.1.PDB_i,25)
                  DBP_str = DBP_str || "   "
                  DBP_str = DBP_str || Insert("",db.2.PDB_i,20)

                  dummy=lineout(PDB_Device,DBP_str)
              end
         end
         else do
              dummy=lineout(PDB_Device,"    No.    Name                        Memo                   mm/dd/yy (PW)")
              dummy=lineout(PDB_Device,"    -----------------------------------------------------------------------")
              do PDB_i = 1 to RecCount
                  DBP_str = "    "||Format(PDB_i,3)
                  DBP_str = DBP_str || "."
                  DBP_str = DBP_str || "   "
                  DBP_str = DBP_str || Insert("",db.1.PDB_i,25)
                  DBP_str = DBP_str || "   "
                  DBP_str = DBP_str || Insert("",db.2.PDB_i,20)
                  DBP_str = DBP_str || "   "
                  DBP_str = DBP_str || db.3.PDB_i
                  DBP_str = DBP_str || " (" ||Format(db.4.PDB_i,2)||")  "

                  dummy=lineout(PDB_Device,DBP_str)
              end

         end
         dummy=lineout(PDB_Device)   /* close Device */
       end
    end
return


/* **********************************************
   * ListDB
   ********************************************** */
ListDB:
    call SysCls
    say "No.  Name                          Memo                  mm/dd/yy (PW) :NE #D"
    say "-----------------------------------------------------------------------------"
    listedlines=0
    do i=1 to RecCount
       call ListRecord i
       listedlines=listedlines+1
       if listedlines=20 & RecCount>i then do              /* List page by page */
	  say
	  say "---HIT <ENTER> TO CONTINUE---"
	  pull dummy
          call SysCls
          say "No.  Name                          Memo                  mm/dd/yy (PW) :NE #D"
          say "-----------------------------------------------------------------------------"
          listedlines=0
       end
    end
    say
    say "Hit Enter..."
    pull dummy
return


/* ********************************************
   * ResetDB
   * Reacticate passive events
   ******************************************** */
ResetDB:
   if RecCount>0 then do
       call SysCls
       say bcyan||"Reactivate passive events:"
       say "--------------------------"||normal
       say
       say bred||"WARNING: Do you really want to reactivate passive events in database (Y/N)?"||normal
       answer = ""
       do until answer = "Y" | answer = "N"
          pull answer
       end
       if answer = "Y" then do
          do RDB_i = 1 to RecCount
             db.5.RDB_i = 0
             call UpdateRecord RDB_i
          end /* do */
       end /* if */
   end /* if */
return


/* **********************************************
   * SwapRecords (a,b)
   * Needed by Sortroutine
   ********************************************** */
SwapRecords:
   SR_a=arg(1)
   SR_b=arg(2)

   dbhelp.1 = db.1.SR_a
   dbhelp.2 = db.2.SR_a
   dbhelp.3 = db.3.SR_a
   dbhelp.4 = db.4.SR_a
   dbhelp.5 = db.5.SR_a
   dbhelp.6 = db.6.SR_a

   db.1.SR_a = db.1.SR_b
   db.2.SR_a = db.2.SR_b
   db.3.SR_a = db.3.SR_b
   db.4.SR_a = db.4.SR_b
   db.5.SR_a = db.5.SR_b
   db.6.SR_a = db.6.SR_b

   db.1.SR_b = dbhelp.1
   db.2.SR_b = dbhelp.2
   db.3.SR_b = dbhelp.3
   db.4.SR_b = dbhelp.4
   db.5.SR_b = dbhelp.5
   db.6.SR_b = dbhelp.6
return

/* **********************************************
   * SortDB by SortIndex
   ********************************************** */
SortDB:
  if RecCount > 1 then do
      say
      say "Sorting "RecCount" files."
      do SDB_i = 1 to RecCount-1
         say "Processing:"SDB_i"    "
         call GotoXY 0,WhereY()-1
         SDB_min = SDB_i
         do SDB_j = SDB_i+1 to RecCount
             if db.SortIndex.SDB_j < db.SortIndex.SDB_min then SDB_min = SDB_j
         end
         if SDB_min <> SDB_i then
             call SwapRecords SDB_min, SDB_i
      end
  end
return


/* **********************************************
   * SaveDB
   ********************************************** */
SaveDB:
    say
    say "Saving..."
    do until rc=0 | rc=2
       rc = SysFileDelete(DBFile)
       if rc\=0 & rc \=2 then do
	  say bred||"ERROR("||rc||"): Could not delete old Database: "||DBFile
	  say bred||"           Try to fix the error and hit <enter>"
	  say bred||"           Or hit CTRL-C and <enter> afterwards to terminate."
	  pull dummy
       end
    end
    ret=LineOut(DBFile,DBFirstLine)
    ret=LineOut(DBFile,"SortIndex="||SortIndex)
    ret=LineOut(DBFile,"")
    do i=1 to RecCount
       ret=LineOut(DBFile,db.1.i)
       ret=LineOut(DBFile,db.2.i)
       ret=LineOut(DBFile,db.3.i)
       ret=LineOut(DBFile,db.4.i)
       ret=LineOut(DBFile,db.5.i)
       ret=LineOut(DBFile,"")
    end
    ret=LineOut(DBFile) 		  /* close file */
    Say normal||"OK."
return


/* **********************************************
   * LoadDB
   ********************************************** */
LoadDB:
    call SysFileTree DBFile, dummy, "FO" ,"**-**" /* exists Database ?? */
    if dummy.0 > 0 then do
	 if modeCheckDB = 0 then
	    say "Loading..."
	 say normal
         dummy = LineIn(DBFile)
         if dummy <> DBFirstLine then do
             say bred||"ERROR: database ("||DBFile||") is not in correct format."
             say bred||"       First line must be:"||DBFirstLine
             say bred||"       Program terminated."
             say normal
             exit 1
         end
         dummy = LineIn(DBFile)
         dummy.1= left(dummy,10)
         dummy.2= right(dummy,1)
         if dummy.1<>"SortIndex=" | (dummy.2<>1 & dummy.2<>3) then do
             say bred||"ERROR: database ("||DBFile||") is not in correct format."
             say bred||"       Second line must be:SortIndex=1 or SortIndex=3"
             say bred||"       Program terminated."
             say normal
             exit 1
         end
         SortIndex = dummy.2
         dummy        =LineIn(DBFile)   /* Empty line behind header */
         if dummy <> "" then do
            say bred||"ERROR: database ("||DBFile||") is not in correct format."
            say bred||"       Third line must be empty."
            say bred||"       Program terminated."
            say normal
            exit 1
         end
         do while Lines(DBFile) \= 0
	    RecCount = RecCount +1
	    db.1.RecCount=LineIn(DBFile)
	    db.2.RecCount=LineIn(DBFile)
	    db.3.RecCount=LineIn(DBFile)
            db.4.RecCount=LineIn(DBFile)
            db.5.RecCount=LineIn(DBFile)
	    dummy	 =LineIn(DBFile)   /* Empty line behind every record */
            if dummy <> "" then do
               say
               say bred||"ERROR: database ("||DBFile||") is not in correct format."
               say bred||"       There must be an empty line behind a record (#"||RecCount||")."
               say bred||"       Program terminated."
               say normal
               exit 1
            end
	    if modeCheckDB = 0 then
                a = charout(,".")
	 end
	 ret = LineOut(DBFile)			 /* Close File */
    end
    Call UpdateDB
return


/* ******************************************************
   * CheckDB
   * The Checkroutine for warnings and birthdaymessages
   ****************************************************** */
CheckDB:
   if modeCheckDB=0 then call SysCls
   say bcyan"Checking for birthdays:"
   say "-----------------------"||normal
   FoundBirthdays=0
   Call UpdateDB                                /* Update the warningdates ! */
   do i=1 to RecCount
      Age= db.5.i - GetYY(db.3.i)
      if db.6.i = 0 then do
         say bred||"A HAPPY "||Age||". BIRTHDAY TO:"||normal
	 call ListRecord i
         call PlaySong
         FoundBirthdays=FoundBirthdays+1
      end
      if db.6.i > 0 then do
         say bred||"WARNING: "||Age||". Birthday in "||db.6.i||" day(s) !"||normal
	 call ListRecord i
         call WarningSound
         FoundBirthdays=FoundBirthdays+1
      end
      if db.6.i >= 0 then do
         say "Keep event active (Y/N) <enter>=YES ?"
         answer = ""
         do until answer = "Y" | answer = "N"
            pull answer
            if answer="" then do;answer="Y"; call GotoXY 1,WhereY()-1; say "y"; end
         end
         if answer="N" then do
             db.5.i = db.5.i+1   /* next warning: next year ! */
             call UpdateRecord i
         end
         say normal
      end
   end
   say bcyan"-----------------------"
   say FoundBirthdays "WARNINGS given."||normal
   if modeCheckDB = 0 then do
      say "Hit Enter..."
      pull dummy
   end
return



/* *********************************************
   * UpdateDB
   * Update whole database !
   ********************************************* */
UpdateDB:
   CurDate =Date("USA")
   CurMM   = GetMM(CurDate)
   CurDD   = GetDD(CurDate)
   CurMMDD = GetMMDD(CurDate)   /* Month and Day mm/dd */
   CurYY   = GetYY(CurDate)

   do UDB_i=1 to RecCount
      Call UpdateRecord UDB_i
   end
return


/* *************************************************
   * UpdateRecord(index)
   ************************************************* */
UpdateRecord:
    UR_i=arg(1)
    G_Date= db.3.UR_i
    G_Day = db.4.UR_i
    G_Intervall1 = GetMMDD(DecreaseDate(G_Date, G_Day))
    G_Intervall2 = GetMMDD(G_Date)

    if G_Intervall1 <= G_Intervall2 then do /* Normal:  |------1xxx2---------| */
      if db.5.UR_i <= CurYY then do
        db.5.UR_i = CurYY
        if   CurMMDD < G_Intervall1,
           | CurMMDD > G_Intervall2
        then db.6.UR_i = -1                      /* No warning */
        else do
           diffdays=0
           do while GetMMDD(DecreaseDate(G_Date,diffdays)) <> CurMMDD
              diffdays=diffdays+1
           end
           db.6.UR_i = diffdays                  /* Birthday warning */
           drop diffdays
        end /* else */
      end /* if */
      else db.6.UR_i = -1   /* No Warning this year anymore */
      if CurMMDD < G_Intervall1 then db.5.UR_i = CurYY    /* correct */
      if CurMMDD > G_Intervall2 then db.5.UR_i = CurYY+1  /* correct */
    end /* if NORMAL */

    if G_Intervall1 >  G_Intervall2 then do /* Wrapped: |xx2---------------1x| */
      if db.5.UR_i < CurYY then db.5.UR_i = CurYY
      if  (db.5.UR_i<=CurYY    & CurMM<=6),
         |(db.5.UR_i = CurYY+1 & CurMM> 6) then do
        if   CurMMDD < G_Intervall1,
           & CurMMDD > G_Intervall2
        then db.6.UR_i = -1                      /* No warning */
        else do
          diffdays=0
          do while GetMMDD(DecreaseDate(G_Date,diffdays)) <> CurMMDD
             diffdays=diffdays+1
          end
          db.6.UR_i = diffdays   /* Birthday Warning */
          drop diffdays
        end /* else */
      end /* if */
      else db.6.UR_i = -1   /* No Warning this year/next year anymore */
      if   CurMMDD>G_Intervall2,
         & CurMMDD<G_Intervall1 then db.5.UR_i = CurYY+1   /* correct */
    end  /* if WRAPPED */
return



/* **********************************************
   * date=DecreaseDate(date,days)
   * Returns DATE decreased by DAYS days
   ********************************************** */
DecreaseDate: procedure expose DaysOfMonth. bred normal
  aDate=arg(1)
  days=arg(2)
  if days > 28 then do
     say bred||"ERROR: More than 28 Warningdays in DB:" days normal
     pull dummy
     exit
  end
  aDateMM =substr(aDate,1,2)
  aDateDD =substr(aDate,4,2)
  aDateYY =substr(aDate,7,2)

  aDateDD = aDateDD-days

  if aDateDD < 1 then do              /* Switch of Month needed ? */
     aDateMM = aDateMM -1             /* Prev Month */
     if aDateMM = 0 then do           /* Switch of Year needed ? */
         aDateMM=12                   /* December of prev. year */
         aDateYY = aDateYY-1
         if aDateYY < 0 then          /* Switch of Year from 1900->1899 */
             aDateYY = 99
     end
     if isLeapYear(aDateYY) = 1 then
         DaysOfMonth.2=29
     aDateDD = (DaysOfMonth.aDateMM) + aDateDD
  end
                                                  /* Leading Zeroes ! */
  if length(aDateMM) = 1 then aDateMM = '0'||aDateMM
  if length(aDateDD) = 1 then aDateDD = '0'||aDateDD
  if length(aDateYY) = 1 then aDateYY = '0'||aDateYY

  aDate = aDateMM||'/'||aDateDD||'/'||aDateYY
  DaysOfMonth.2=28
return aDate



/* ***********************************************
   *boolean=isLeapYear(year)
   *********************************************** */
isLeapYear: procedure
    y=arg(1)
    if length(y) = 2 then y="19"||y
    if y //   4 = 0 then retcode=1
    if y // 100 = 0 then retcode=0
    if y // 400 = 0 then retcode=1
return retcode


/* *********************************************
   * DateFunctions
   ********************************************* */
GetMM:
return substr(arg(1),1,2)

GetDD:
return substr(arg(1),4,2)

GetYY:
return substr(arg(1),7,2)

GetMMDD:
return substr(arg(1),1,5)


/* **********************************************
   *  AnalyzeCmdLine
   *  This Procedure sets the demanded flags
   *  IN: -
   * OUT: -
   ********************************************** */
AnalyzeCmdLine:
    do while cmdline \= ""
	parse var cmdline aWord cmdline
        if pos(substr(aWord,1,1), '/-') \= 0 then do       /* oh! a switch */
          if pos(substr(aWord,2,1), '?Hh') \= 0 then      /* Help */
	    call HelpScreen
          else if pos(substr(aWord,2,1), 'Cc') \= 0 then  /* Just Check DB */
	    modeCheckDB=1
          else if pos(substr(aWord,2,1), 'Qq') \= 0 then  /* quiet !!! */
            modeQuiet=1
	  else do
	    say byellow"ERROR : Unknown switch - " aWord
	    say normal
	    call HelpScreen
	  end /* else */
	end /* if pos...*/
    end /* do */
return

/* ***********************************************
   * HelpScreen
   * Displays the Helpscreen and exists
   *********************************************** */
HelpScreen:
    say byellow||"Birthday Reminder V 1.0"
    say "-----------------------"
    say bcyan
    say "Birthday.cmd checks a database for coming birthdays."
    say
    say "To edit the database run birthday.cmd without any parameters:"
    say "BIRTHDAY.CMD<enter>"
    say
    say "Valid parameters:"
    say "/c   - Checkmode: just check the database and terminate program afterwards."
    say "       This is good for STARTUP.CMD. e.g.:"
    say "       CALL c:\cmd-files\birthday.cmd /c"
    say "/q   - Quietmode:  play NO tunes for birthday- and warning-messages."
    say
    say "(C) Feb.1994 by Wolfram Koerner"
    say "FREEWARE but: Please do not spread it after you changed it. If you have bugs or"
    say "improvements tell them to me. So we can implement them together and no version-"
    say "confusion will raise: koerner@cip.informatik.uni-wuerzburg.de"
    say "or: Wolfram Koerner, Friedenstrasse 5a, 97072 Wuerzburg, GERMANY"
    say normal
    exit 1
return


/* ***********************************************
   * Set Color Strings for AnsiColor
   *********************************************** */
InitColors:
  esc	 = '1B'x          /* define ESCape character */
  red	 = esc||"[31m"    /* ANSI.SYS-control for red foreground */
  yellow = esc||"[33m"    /* ANSI.SYS-control for yellow foreground */
  cyan	 = esc||"[36m"    /* ANSI.SYS-control for cyan foreground */
  normal = esc||"[0m"     /* ANSI.SYS-control for resetting attributes to normal */
  bright = esc||"[1m"     /* ANSI.SYS-control for bright foreground colors */
  bred	  = bright || red
  byellow = bright || yellow
  bcyan   = bright || cyan
RETURN

/* ************************************************
   * WhereX()
   ************************************************ */
WhereX: procedure
    parse value SysCurPos() with W_z W_s
return W_s

/* ************************************************
   * WhereY()
   ************************************************ */
WhereY: procedure
    parse value SysCurPos() with W_z W_s
return W_z

/* ************************************************
   * GotoXY(x,y)
   ************************************************ */
GotoXY: procedure
    G_s=arg(1)
    G_z=arg(2)
    G_dummy=SysCurPos(G_z, G_S)
return

/* -------------------------------- END ------------------------------- */

