#include "bobs.h"

#define APPLY_PALETTE

#include <stdlib.h>
#include <string.h>

// *************************************************************
// Raster Object Primitives, for OS/2 PM
// CopyRight (c) 1994 W. Roger Uzun
// Avatar Consulting
// *************************************************************


// **************************************************
// hab and hwndClient are opened and inited
// by the user before calling any of these calls
// CxClient and CyClient have to be set by outside and declared
// outside as well

// hwndClient is the handle to the target PM window
// hab is the HAB from the WinInitialize call
// CxClient is the Client Windows Width
// CyClient is the Client Windows Height
// **************************************************

// **************************************************
// Here are external data structures
// the main pgm must fill these in before he calls
// anything out of this C package
extern int cyClient,cxClient;
extern HAB hab;
extern HWND hwndClient;
extern int BOBHEIGHT;
extern int ROW8B;

#define SQUAREWIDTH 59
#define ROUNDEDSQUAREWIDTH 64
#define SQUAREHEIGHT BOBHEIGHT
#define COLA (16)
#define COLB (16+SQUAREWIDTH)
#define COLC (16+SQUAREWIDTH*2)
#define COLD (16+SQUAREWIDTH*3)
#define COLE (16+SQUAREWIDTH*4)
#define COLF (16+SQUAREWIDTH*5)
#define COLG (16+SQUAREWIDTH*6)
#define COLH (16+SQUAREWIDTH*7)
//#define ROW7 (ROW8-SQUAREHEIGHT)
#define ROW8 (ROW8B-SQUAREHEIGHT)
#define ROW7 (ROW8B-SQUAREHEIGHT*2)
#define ROW6 (ROW8B-SQUAREHEIGHT*3)
#define ROW5 (ROW8B-SQUAREHEIGHT*4)
#define ROW4 (ROW8B-SQUAREHEIGHT*5)
#define ROW3 (ROW8B-SQUAREHEIGHT*6)
#define ROW2 (ROW8B-SQUAREHEIGHT*7)
#define ROW1 (ROW8B-SQUAREHEIGHT*8)


void DrawAmigaBoard(void);

// **************************************************

// **************************************************
// here are internal data structures to this module
HMTX DrawSemaphore; // have WM_PAINT and DrawGels go 1 at a time
HDC hdcMemory,winhdc;
HPS hpsMemory;
HPS hwClientPS=0L; // we need to keep a PS around for the target
SIZEL bobsizl;
HBITMAP BackGndBitmap=NULL;
UCHAR *BackGndImage;
BOB *SystemBobList=NULL;
int SafeBlit=1; // if BM_SRCTRANSPARENT supported, try 0
int GelsInited=0;
// **************************************************

// ********************************************
// here are the function Prototypes
// You would first open your client window, and fill in
// the hab, hwndClient, CxClient, and CyClient data items
// You would then call InitGels() to init the system drawing structs
// You would then call CreateBob() for each Raster Object you want
// to create, You then call AddBob() to add each one you want
// to be drawn in the client window...
// you call DrawGList() to actually Draw things
// You can set SafeBlit to 1 for safe 2 part blits
// if the Video supports BM_SRCTRANSPARENT blits set
// SafeBlit to 0 for better blits
// When you want to erase a bob from a screen for a given
// frame, call EraseBob(), to remove a bob from the Drawing List
// call RemBob().  To shut it all down, call RemBob() for anyone
// in the list, then for every Bob created call FreeBob(),
// then call CloseGels() to shut it all down.
//
// As far as redrawing the window when WM_PAINT msgs are
// received, it is assumed that during WM_Paint >>YOU<< will
// have code to Blit the background into the Client Windows
// area...after that is done, You can call RepaintBobs();
// to repaint all of the raster objects...
// Probably a good idea to have your Client Window WM_PAINT
// routine do a DosRequestMutexSem(DrawSemaphore,xxx);
// and a DosReleaseMutexSem(DrawSemaphore); any time
// before it starts to upset the screen, so that only
// one routine at a time is drawing to the client window
// PS_Space
// ******************************************************

void DisplayError(char *);

BOB *CreateBob(LONG Width,LONG Height,LONG Depth,void *Image,UCHAR *Palette);
int FreeBob(BOB *);
void DrawGList(void);

ULONG Mono_Palette[2]={0x00000000L,
		       0x00ffffffL};

int InitGels(void);
void AddBob(BOB *);
void RemBob(BOB *);
void RemBobNR(BOB *);
void EraseBob(BOB *);
int CloseGels(void);
void TransBlit(BOB *,HPS,HPS,LONG,PPOINTL);
void TransBlit2(BOB *,HPS,HPS,LONG,PPOINTL);
void MakeShadowMask(void *,void *,ULONG,ULONG);
void RepaintBobs(HPS); // for WM_Paint situations



// THIS ROUTINE ONLY WORKS WHEN WID OF IMAGE IS A MULT OF 32!!!
void MakeShadowMask(s,d,wid,ht)
void *s;
void *d;
ULONG wid,ht;
{
 ULONG bytecnt=0;
 UBYTE  *src,*dest;
 UBYTE workbyte;
 ULONG rem,i,j;
 UBYTE srcbyte;

 src = (UBYTE *)s;
 dest = (UBYTE *)d;

 if (wid & 0x7)
  return;
 j = (wid & 0x1f);
 rem = j >> 3; // need to pad each scanline with rem bytes
 for(j=0;j<((wid*ht)/8);j++)
  {
   workbyte = 0;
   for(i=0;i<8;i++)
    {
     srcbyte = *src++;
     if ((srcbyte))
      { // this is a 1 bit
	 workbyte |= 1;
      }
     if (i != 7)
      workbyte <<= 1;
     if (rem)
      {
       bytecnt++;
       if (bytecnt == wid)
	{
	 for(bytecnt=0;bytecnt<rem;bytecnt++)
	  *dest++ = 0xff;
	 bytecnt = 0;
	}
      }
    }
   *dest++ = workbyte;
  }
}

void FreeFullBitmap()
{
  GpiSetBitmap(hpsMemory,NULL);
  GpiSetBitmap(hwClientPS,NULL);
  if (BackGndBitmap != (HBITMAP)NULL)
   GpiDeleteBitmap(BackGndBitmap);
  BackGndBitmap = NULL;
}

int LoadBMPImage(name,image,wid,ht)
char *name;
void *image;
ULONG wid,ht;
{
 char errstr[48];
 FILESTATUS fileinfo;
 ULONG action,len,bytesread,newptr;
 APIRET rc;
 HFILE file;

    rc = DosOpen(name, &file, &action,4L,FILE_NORMAL,FILE_OPEN,
	  OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE,NULL);
    if (rc)
     {
      sprintf(errstr,"Could open %s",name);
      DisplayError(errstr);
      return(0);
     }
    rc = DosQueryFileInfo(file,FIL_STANDARD,&fileinfo,sizeof(fileinfo));
    if (rc)
     {
      DosClose(file);
      return(0);
     }
    len = fileinfo.cbFile - (wid*ht);
    rc = DosSetFilePtr(file,len,FILE_BEGIN,&newptr);
    if (rc)
     {
      DisplayError("Could not set file ptr");
      DosClose(file);
      return(0);
     }
    rc = DosRead(file,image,wid*ht,&bytesread);
    if ((rc)||(bytesread != wid*ht))
     {
      DosClose(file);
      return(0);
     }
    DosClose(file);
    return(1);
}

int LoadFullBitmap(hps,name,first,Palette)
HPS hps;
char *name;
int first;
UCHAR *Palette;
{
#ifdef APPLY_PALETTE
 static int AppliedPal=0;
#endif
 static int FirstTimeRun=1;
 RECTL rect;
 POINTL apts,apts2[4];
 int i;
 ULONG ImageSize;
 BITMAPINFO2 *bmi2;
 APIRET rc;
 FILESTATUS fileinfo;
 HFILE file;
 ULONG bytesread;
 ULONG action;
 UCHAR type[4];
#ifdef APPLY_PALETTE
 LONG *tmpPalette;
#endif
 ULONG file_len,file_offset,newptr;

 if ((first == TRUE)&&(FirstTimeRun))
  {
    if (name == NULL)
     return(0);
    rc = DosOpen(name, &file, &action,4L,FILE_NORMAL,FILE_OPEN,
	  OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE,NULL);
    if (rc)
     {
      return(0);
     }
    rc = DosRead(file,type,2L,&bytesread);
    if ((rc)||(bytesread != 2))
     {
      DosClose(file);
      return(0);
     }
    type[2] = 0;
    if (stricmp(type,"BM"))
     {
      DosClose(file);
      return(0);
     }
    rc = DosRead(file,&file_len,4L,&bytesread);
    if ((rc)||(bytesread != 4))
     {
      DosClose(file);
      return(0);
     }
    rc = DosRead(file,&file_offset,4L,&bytesread);
    if ((rc)||(bytesread != 4))
     {
      DosClose(file);
      return(0);
     }
    rc = DosQueryFileInfo(file,FIL_STANDARD,&fileinfo,sizeof(fileinfo));
    if (rc)
     {
      DosClose(file);
      return(0);
     }
    ImageSize = fileinfo.cbFile - file_offset;
    rc = DosAllocMem((PPVOID)&BackGndImage,ImageSize,
	 (ULONG)(PAG_READ|PAG_WRITE|PAG_COMMIT));
    if (rc)
     {
      DosClose(file);
      return(0);
     }
    file_offset = fileinfo.cbFile - (640*480);
    rc = DosSetFilePtr(file,file_offset,FILE_BEGIN,&newptr);
    if (rc)
     {
      DosClose(file);
      return(0);
     }
    rc = DosRead(file,BackGndImage,640*480,&bytesread);
    if ((rc)||(bytesread != 640*480))
     {
      DosClose(file);
      return(0);
     }
    DosClose(file);
// now setup the bitmap info for it...
   bmi2 = calloc(sizeof(BITMAPINFOHEADER2)+(sizeof(RGB2)*256),1);
   if (bmi2 == NULL)
    {
     DosFreeMem(BackGndImage);
     return(0);
    }
   for(i=0;i<256;i++)
    {  // each rgb2 entry in the palette is 4 bytes long
      bmi2->argbColor[i].bRed = Palette[i*4];
      bmi2->argbColor[i].bGreen = Palette[i*4+1];
      bmi2->argbColor[i].bBlue = Palette[i*4+2];
    }
#ifdef APPLY_PALETTE
   if (!AppliedPal)
    {
     rc = DosAllocMem((PPVOID)&tmpPalette,256*4,
       (ULONG)(PAG_READ|PAG_WRITE|PAG_COMMIT));
     if (rc)
      {
        DosFreeMem(BackGndImage);
        return(0);
      }
     for(i=0;i<256;i++)
      {  // each rgb2 entry in the palette is 4 bytes long
        tmpPalette[i] = (Palette[i*4] << 16) +
         (Palette[i*4+1]<<8) + Palette[i*4+2];
      }
    }
#endif
   bmi2->cbFix = sizeof(BITMAPINFOHEADER2);
   bmi2->cx = 640;
   bmi2->cy = 480;
   bmi2->cPlanes = 1;
   bmi2->cBitCount = 8;
   bmi2->cbImage = (640*480);
   bmi2->cxResolution = cxClient;
   bmi2->cyResolution = cyClient;
   bmi2->cclrUsed = 256;
   bmi2->cclrImportant = 256;
   bmi2->ulColorEncoding = BCE_RGB;
   if (BackGndBitmap != (HBITMAP)NULL)
    {
     GpiSetBitmap(hpsMemory,NULL);
     GpiSetBitmap(hwClientPS,NULL);
     GpiDeleteBitmap(BackGndBitmap);
     //BackGndBitmap = NULL;
    }
   BackGndBitmap = GpiCreateBitmap(hwClientPS,(PBITMAPINFOHEADER2)bmi2,
		CBM_INIT,(PBYTE)BackGndImage,bmi2);
   if (BackGndBitmap == 0L)
    {
     DosFreeMem(BackGndImage);
     return(0);
    }
   DosFreeMem(BackGndImage);
   DosFreeMem(bmi2);
#ifdef APPLY_PALETTE
   if (!AppliedPal)
    {
     if (!GpiCreateLogColorTable(hwClientPS,LCOL_PURECOLOR,LCOLF_CONSECRGB,0L,256,(PLONG)tmpPalette))
      return(0);
     if (!GpiCreateLogColorTable(hpsMemory,LCOL_PURECOLOR,LCOLF_CONSECRGB,0L,256,(PLONG)tmpPalette))
      return(0);
     DosFreeMem(tmpPalette);
     AppliedPal = 1;
    }
#endif
  }
// now blit this thing into the windows space
  rect.xLeft = 0;
  rect.xRight = 639;
  rect.yTop = 479;
  rect.yBottom = 0;
  apts.x = 0;
  apts.y = 0;
  WinDrawBitmap(hps,BackGndBitmap,&rect,&apts,
		 0L,0L,DBM_NORMAL);
  if (!FirstTimeRun)
   {
    DrawAmigaBoard();
   }
  else //if (first == TRUE)
   { // fix the offscreen bitmap
     // A1 is black B1 is white
     // A2 is white B2 is black
     // A7 is black B7 is white
     // A8 is white B8 is black
     // A5 is black
     // B5 is white
   GpiSetBitmap(hpsMemory,BackGndBitmap);

// do ROW1 in offscreen bitmap
   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5); // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLA; // tgt left bottom
   apts2[0].y = (ROW1); // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5)  ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLC; // tgt left bottom
   apts2[0].y = (ROW1); // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5)  ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLE; // tgt left bottom
   apts2[0].y = (ROW1); // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5)  ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLG; // tgt left bottom
   apts2[0].y = (ROW1); // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5)  ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLB; // tgt left bottom
   apts2[0].y = (ROW1); // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5)  ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLD; // tgt left bottom
   apts2[0].y = (ROW1); // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5)  ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLF; // tgt left bottom
   apts2[0].y = (ROW1); // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5)  ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLH; // tgt left bottom
   apts2[0].y = (ROW1); // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

// now do row 7 in offscreen bitmap
   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLA; // tgt left bottom
   apts2[0].y = (ROW7) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLC; // tgt left bottom
   apts2[0].y = (ROW7) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLE; // tgt left bottom
   apts2[0].y = (ROW7) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLG; // tgt left bottom
   apts2[0].y = (ROW7) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLB; // tgt left bottom
   apts2[0].y = (ROW7) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLD; // tgt left bottom
   apts2[0].y = (ROW7) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLF; // tgt left bottom
   apts2[0].y = (ROW7) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLH; // tgt left bottom
   apts2[0].y = (ROW7) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

// now do row 2 in offscreen bitmap
   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLA; // tgt left bottom
   apts2[0].y = (ROW2) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLC; // tgt left bottom
   apts2[0].y = (ROW2) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLE; // tgt left bottom
   apts2[0].y = (ROW2) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLG; // tgt left bottom
   apts2[0].y = (ROW2) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLB; // tgt left bottom
   apts2[0].y = (ROW2) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLD; // tgt left bottom
   apts2[0].y = (ROW2) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLF; // tgt left bottom
   apts2[0].y = (ROW2) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLH; // tgt left bottom
   apts2[0].y = (ROW2) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

// now do row 8 in offscreen bitmap
   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLA; // tgt left bottom
   apts2[0].y = (ROW8); // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLC; // tgt left bottom
   apts2[0].y = (ROW8) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLE; // tgt left bottom
   apts2[0].y = (ROW8) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLB; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLG; // tgt left bottom
   apts2[0].y = (ROW8) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLB; // tgt left bottom
   apts2[0].y = (ROW8) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLD; // tgt left bottom
   apts2[0].y = (ROW8) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLF; // tgt left bottom
   apts2[0].y = (ROW8) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   apts2[2].x = COLA; // src left bottom
   apts2[2].y = (ROW5) ; // src left bottom
   apts2[3].x = apts2[2].x + SQUAREWIDTH - 1; // src rt top
   apts2[3].y = apts2[2].y + SQUAREHEIGHT - 1; // src rt top
   apts2[0].x = COLH; // tgt left bottom
   apts2[0].y = (ROW8) ; // tgt left bottom
   apts2[1].x = apts2[0].x + SQUAREWIDTH - 1; // tgt rt top
   apts2[1].y = apts2[0].y + SQUAREHEIGHT - 1; // tgt rt top
   GpiBitBlt(hpsMemory,hwClientPS,4,(PPOINTL)apts2,ROP_SRCCOPY,BBO_IGNORE);

   GpiSetBitmap(hpsMemory,NULL);
   }
 FirstTimeRun = 0;
 return(1);
}

void RepaintBobs(hps)
HPS hps; // this routine is for WM_PAINT time...
{// pass in the  HPS from WinBeginPaint,
 // A good idea to request the mutex sem DrawSemaphore
 // in your WM_PAINT routine, before you do any drawing
 // release it there too
 // YOU MUST HAVE RE-BLITTED THE BACKGND BITMAP 1st!!!
 // this just redraws the bob list at  oldx,oldy
 BOB *list;
 POINTL apts[4];

 if (!GelsInited) // in case we are called before gels setup
  return;
 //GpiSetDrawMode();
 list = SystemBobList;
 while (list != NULL)
  {
   if ((list->OldX != -1)&&(list->OldY != -1))
    {
     apts[2].x = 0; // src left bottom
     apts[2].y = 0; // src left bottom
     apts[3].x = list->Width - 1; // src rt top
     apts[3].y = list->Height - 1; // src rt top
     apts[0].x = list->OldX; // tgt left bottom
     apts[0].y = list->OldY; // tgt left bottom
     apts[1].x = apts[0].x + list->Width - 1; // tgt rt top
     apts[1].y = apts[0].y + list->Height - 1; // tgt rt top
     TransBlit(list,hps,hpsMemory,4L,(PPOINTL)apts);
    }
   list = list->Next;
  }
 //GpiSetDrawMode();
}


// BUGS HERE I THINK, The creation of the ShadowImage is not
// correct somehow... !!!!!

BOB *CreateBob(Width,Height,Depth,Image,Palette)
LONG Width,Height,Depth;
UCHAR *Palette; // this is a char array 3 bytes per entry for RGB
void *Image; // this is the image data for this Object, in OS/2 format
{
 LONG tmpw;
 APIRET rc;
 LONG i;
 BOB *bob;
 LONG NumColors=(1L<<Depth);

 bob = calloc(sizeof(BOB),1);
 if (!bob)
  return(NULL);
 bob->bmi2 = calloc((sizeof(BITMAPINFOHEADER2)+sizeof(RGB2)*NumColors),1);
 bob->sbmi2 = calloc(sizeof(BITMAPINFOHEADER2)+sizeof(RGB2)*2,1);
 if (bob->bmi2 == NULL)
  return(NULL);
 if (bob->sbmi2 == NULL)
  return(NULL);
 if (Width & 0x1f) // not mult of 32 bits in scanline
  {
   tmpw = Width & 0x1f;
   tmpw += 0x20; // now it is
  }
 else
  tmpw = Width;
 rc = DosAllocMem((PPVOID)&bob->ShadowImage,(tmpw*Height)/8,
	PAG_READ|PAG_WRITE|PAG_COMMIT);
 if (rc)
  return(NULL);
 MakeShadowMask(Image,bob->ShadowImage,Width,Height);
 for(i=0;i<NumColors;i++)
  {
    bob->bmi2->argbColor[i].bRed = Palette[i*4];
    bob->bmi2->argbColor[i].bGreen = Palette[i*4+1];
    bob->bmi2->argbColor[i].bBlue = Palette[i*4+2];
  }
 bob->sbmi2->argbColor[1].bRed = 0xff;
 bob->sbmi2->argbColor[1].bGreen = 0xff;
 bob->sbmi2->argbColor[1].bBlue = 0xff;
 bob->bmi2->cbFix = sizeof(BITMAPINFOHEADER2);
 bob->sbmi2->cbFix = sizeof(BITMAPINFOHEADER2);
 bob->bmi2->cx = bob->sbmi2->cx = Width;
 bob->bmi2->cy = bob->sbmi2->cy = Height;
 bob->bmi2->cPlanes = bob->sbmi2->cPlanes = 1;
 bob->bmi2->cBitCount = Depth;
 bob->sbmi2->cBitCount = 1;
 bob->bmi2->cbImage = ((Width*Height*Depth)/8);
 bob->sbmi2->cbImage = (Width*Height)/8;
 bob->bmi2->cxResolution = bob->sbmi2->cxResolution = cxClient;
 bob->bmi2->cyResolution = bob->sbmi2->cyResolution = cyClient;
 bob->bmi2->cclrUsed = NumColors;
 bob->sbmi2->cclrUsed = 2;
 bob->bmi2->cclrImportant = NumColors;
 bob->sbmi2->cclrImportant = 2;
 bob->bmi2->usUnits = bob->sbmi2->usUnits = 0;
 bob->bmi2->ulColorEncoding = bob->sbmi2->ulColorEncoding = BCE_RGB;
 bob->Width = Width;
 bob->Depth = Depth;
 bob->Height = Height;
 bob->XPos = bob->YPos = bob->OldY = bob->OldX = -1;
 bob->SaveBuffer = GpiCreateBitmap(hwClientPS,(PBITMAPINFOHEADER2)bob->bmi2,
		0L,NULL,bob->bmi2);
 if (bob->SaveBuffer == 0L)
  return(NULL);
 bob->Image = GpiCreateBitmap(hwClientPS,(PBITMAPINFOHEADER2)bob->bmi2,
		CBM_INIT,(PBYTE)Image,bob->bmi2);
 if (bob->Image == 0L)
  return(NULL);
 bob->ShadowMask = GpiCreateBitmap(hwClientPS,(PBITMAPINFOHEADER2)bob->sbmi2,
		CBM_INIT,(PBYTE)bob->ShadowImage,bob->sbmi2);
 if (bob->ShadowMask == 0L)
  return(NULL);
 DosFreeMem(bob->ShadowImage);
 bob->ShadowImage = NULL;
 return(bob);
}

int FreeBob(bob)
BOB *bob;
{
  GpiSetBitmap(hwClientPS,NULL);
  GpiDeleteBitmap(bob->ShadowMask);
  GpiDeleteBitmap(bob->Image);
  GpiDeleteBitmap(bob->SaveBuffer);
  free(bob->bmi2);
  free(bob->sbmi2);
  free(bob);
  return(1);
}

void TransBlit2(bob,hwClientPS,hpsMemory,numpts,rect_bounds)
BOB *bob;
HPS hwClientPS;
HPS hpsMemory;
LONG numpts;
PPOINTL rect_bounds;
{
 APIRET rc;

 rc = DosRequestMutexSem(DrawSemaphore,2000);
 if (rc)
  return;
 TransBlit(bob,hwClientPS,hpsMemory,numpts,rect_bounds);
 DosReleaseMutexSem(DrawSemaphore);
}

void TransBlit(bob,hwClientPS,hpsMemory,numpts,rect_bounds)
BOB *bob;
HPS hwClientPS;
HPS hpsMemory;
LONG numpts;
PPOINTL rect_bounds;
{
  if (!SafeBlit)
   {
	GpiSetBitmap(hpsMemory,bob->Image);
	GpiSetBackColor(hwClientPS,CLR_FALSE);
	GpiSetBackMix(hwClientPS,BM_SRCTRANSPARENT);
	GpiBitBlt(hwClientPS,hpsMemory,numpts,(PPOINTL)rect_bounds,ROP_SRCCOPY,BBO_IGNORE);
	GpiSetBackMix(hwClientPS,BM_DEFAULT);
   } // !safe
  else
   {
	GpiSetBitmap(hpsMemory,bob->ShadowMask);
	GpiBitBlt(hwClientPS,hpsMemory,numpts,(PPOINTL)rect_bounds,ROP_SRCAND,BBO_IGNORE);
	GpiSetBitmap(hpsMemory,bob->Image);
	GpiBitBlt(hwClientPS,hpsMemory,numpts,(PPOINTL)rect_bounds,ROP_SRCPAINT,BBO_IGNORE);
    } // safe
}

void DrawGList()
{
 RECTL rect;
 POINTL apts[4];
 BOB *list=SystemBobList;

 if (list != NULL)
  {
   if (DosRequestMutexSem(DrawSemaphore,10000L))
    {
     return;
    }
  }
 //GpiSetDrawMode();
 while (list != NULL)
  { // restore all the backgrounds that were destroyed
   if ((list->OldX != -1)&&(list->OldY != -1))
    {
      rect.xLeft = 0;
      rect.xRight = list->Width - 1;
      rect.yTop = list->Height - 1;
      rect.yBottom = 0;
      apts[0].x = list->OldX;
      apts[0].y = list->OldY;
     // restore the backgn to what it was
     WinDrawBitmap(hwClientPS,list->SaveBuffer,&rect,&apts[0],
		 0L,0L,DBM_NORMAL);
    }
   list = list->Next;
  }
 list = SystemBobList;
 while (list != NULL)
  {  // save all the backgnds that are about to be overwritten
   if ((list->XPos != -1)&&(list->YPos != -1))
    {
     apts[0].x = 0; // target left bottom
     apts[0].y = 0; // target left bottom
     apts[1].x = list->Width - 1; // target rt top
     apts[1].y = list->Height - 1; // tgt rt top
     apts[2].x = list->XPos; // src left bottom
     apts[2].y = list->YPos; // src left bottom
     apts[3].x = apts[2].x + list->Width - 1; // src rt top
     apts[3].y = apts[2].y + list->Height - 1; // src rt top
     // now save the backgn area to savebuffer area
     GpiSetBitmap(hpsMemory,list->SaveBuffer);
     GpiBitBlt(hpsMemory,hwClientPS,4L,(PPOINTL)apts,
		ROP_SRCCOPY,BBO_IGNORE);
    }
   list = list->Next;
  }
 list = SystemBobList;
 while (list != NULL)
  { // draw all the Bobs at their new locations
   if ((list->XPos != -1)&&(list->YPos != -1))
    {
     apts[2].x = 0; // src left bottom
     apts[2].y = 0; // src left bottom
     apts[3].x = list->Width - 1; // src rt top
     apts[3].y = list->Height - 1; // src rt top
     apts[0].x = list->XPos; // tgt left bottom
     apts[0].y = list->YPos; // tgt left bottom
     apts[1].x = apts[0].x + list->Width - 1; // tgt rt top
     apts[1].y = apts[0].y + list->Height - 1; // tgt rt top
     TransBlit(list,hwClientPS,hpsMemory,4L,(PPOINTL)apts);
     list->OldX = list->XPos;
     list->OldY = list->YPos;
    }
   list = list->Next;
  }
 //GpiSetDrawMode();
 DosReleaseMutexSem(DrawSemaphore);
}

int InitGels()
{
 bobsizl.cx = bobsizl.cy = 0;
 hwClientPS = GpiCreatePS(hab,winhdc,&bobsizl,
   PU_PELS|GPIF_DEFAULT|GPIT_MICRO|GPIA_ASSOC);
 bobsizl.cx = bobsizl.cy = 0;
 hdcMemory = DevOpenDC(hab,OD_MEMORY,"*",0L,NULL,NULLHANDLE);
 hpsMemory = GpiCreatePS(hab,hdcMemory,&bobsizl,
   PU_PELS|GPIF_DEFAULT|GPIT_MICRO|GPIA_ASSOC);
 SystemBobList = NULL; // no bobs on list
 if (DosCreateMutexSem("\\SEM32\\DrawSem",&DrawSemaphore,
     DC_SEM_SHARED,FALSE))
  {
   return(0);
  }
 GelsInited = 1;
 return(1);
}

int CloseGels()
{
 //WinCloseWindowDC(winhdc);
 DosCloseMutexSem(DrawSemaphore);
 GpiDestroyPS(hwClientPS);
 hwClientPS = 0L;
 GpiDestroyPS(hpsMemory);
 DevCloseDC(hdcMemory);
 GelsInited = 0;
 SystemBobList = NULL;
 return(1);
}

void AddBob(bob)
BOB *bob;
{
 BOB *list;
 
 if (bob == NULL)
  return;
 bob->Next = NULL;
 if (SystemBobList == NULL)
  { // first time
   SystemBobList = bob;
   return;
  }
 list = SystemBobList;
 while (list->Next != NULL)
  {
   list = list->Next;
  }
 list->Next = bob;
}

void EraseBob(bob)
BOB *bob;
{
 POINTL rcl;
 RECTL rect;

 if (bob == NULL)
  return;
 if (DosRequestMutexSem(DrawSemaphore,15000L))
  {
   return;
  }
 if ((bob->OldX != -1)&&(bob->OldY != -1))
  {
   rect.xLeft = 0;
   rect.xRight = bob->Width - 1;
   rect.yTop = bob->Height - 1;
   rect.yBottom = 0;
   rcl.x = bob->OldX;
   rcl.y = bob->OldY;
   // restore the backgn to what it was
   WinDrawBitmap(hwClientPS,bob->SaveBuffer,&rect,&rcl,
	       0L,0L,DBM_NORMAL);
  }
 bob->OldX = bob->OldY = -1;
 DosReleaseMutexSem(DrawSemaphore);
}

void RemBob(bob)
BOB *bob;
{ // we will use the HPS for the main client here..
 POINTL rcl;
 BOB *list;
 RECTL rect;

 if (bob == NULL)
  return;
 if (DosRequestMutexSem(DrawSemaphore,15000L))
  {
   return;
  }
 if ((bob->OldX != -1)&&(bob->OldY != -1))
  {
   rect.xLeft = 0;
   rect.xRight = bob->Width - 1;
   rect.yTop = bob->Height - 1;
   rect.yBottom = 0;
   rcl.x = bob->OldX;
   rcl.y = bob->OldY;
   // restore the backgn to what it was
   WinDrawBitmap(hwClientPS,bob->SaveBuffer,&rect,&rcl,
	       0L,0L,DBM_NORMAL);
  }
 bob->OldX = bob->OldY = -1;
 DosReleaseMutexSem(DrawSemaphore);
 if (bob == SystemBobList)
  {
   SystemBobList = bob->Next;
   return;
  }
 list = SystemBobList; 
 while (list != NULL)
  {
   if (list->Next == bob)
    {
     list->Next = bob->Next;
     return;
    }
   list = list->Next;
  }
}

void RemBobNR(bob)
BOB *bob;
{ // we will use the HPS for the main client here..
 BOB *list;

 if (bob == NULL)
  return;
 bob->OldX = bob->OldY = -1;
 if (bob == SystemBobList)
  {
   SystemBobList = bob->Next;
   return;
  }
 list = SystemBobList;
 while (list != NULL)
  {
   if (list->Next == bob)
    {
     list->Next = bob->Next;
     return;
    }
   list = list->Next;
  }
}

