:userdoc.
:docprof toc=1234.
:title.Spellbook Manager Docs

:h1 res=0.Introduction and Copyright
:i1.Introduction and Copyright
:p.
:lines align=center.
:font facename='Tms Rmn' size=36x24.
:hp4.
Spellbook Manager
:font facename=default size=0x0.
:ehp4.
:hp1.spl.exe:ehp1.

:hp2.Version 1.73:ehp2.

:hp2.7/26/94:ehp2.

:hp2.Copyright (C) 1993, 1994 John-Marc Chandonia:ehp2.

:elines.
:p.
For suggested enhancements and bug reports, please mail
:font facename=Courier size=13x8.
chandoni@husc8.harvard.edu
:font facename=default size=0x0.
or write:

:lines align=center.
John-Marc Chandonia
7 Divinity Avenue, #121
Cambridge, Ma. 02138
:elines.
:p.
This is spl, a program for handling spells and spellbooks
from various fantasy role-playing (FRP) games.  It can handle
both mage and priest spells for TSR's AD&amp.D (a trademark of TSR, Inc)
game, and can easily be expanded to handle other systems as well.
In addition to possibly being useful to FRP players and
GM's, the source may be useful to OS/2 2.x programmers learning
about containers, MLE's, and PM programming in general.
:p.
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
:p.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
:p.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
:p.
:h1 res=1.Release Notes
:i1.Release Notes
:hp2.Version 1.73&colon.:ehp2.
:sl.
:li.Several ways of sorting books are supported.
:li.You can choose which fields to show in details view.
:li.Spellbooks can be loaded from the command line.
:li.Multiple books can be loaded simultaneously.
:esl.
:p.
:hp2.Version 1.5&colon.:ehp2.
:sl.
:li.Spell searching, sorting, loading, and saving are now multithreaded,
allowing you to work on other books or adjust the window while the
program is working.
:li.Multiple views of the spellbook are supported.
:li.Large or small icons are supported.
:li.On-line help is available by pressing F1 or using the help menu/buttons.
:li.Spellbook position, view, icon size, and details bar position are
saved in EA's/INI files.
:li.Spell descriptions are loaded in as required, using less memory.
:li.Spells in the master list are saved in a "quick reference" file for
faster loading.
:esl.
:p.
:hp2.Version 1.0&colon.:ehp2.
:p.
This is the first initial release of the program.
:p.
Known bugs are listed in the file 
:font facename=Courier size=13x8.
bugs.txt.
:font facename=default size=0x0.
If you find any more, please either fix them yourself and send
me the patch (sure!) or report the bug to the address given
above.
:p.
I will put all future versions of this program on the OS/2
anonymous ftp site, currently
:font facename=Courier size=13x8.
ftp-os2.cdrom.com.
:font facename=default size=0x0.
If you distribute any enhanced versions of this program, please
do the same.  Also, please comment any changes in the source
code, and describe them in the file 
:font facename=Courier size=13x8.
changes.txt.
:font facename=default size=0x0.

:h1 res=2.Using the program
:i1 id=using.Using the program
This section describes how to install and use the program.
:p.
Topics include&colon.
:lines.
    :link reftype=hd res=3.Installation:elink.
    :link reftype=hd res=4.Master spell list:elink.
    :link reftype=hd res=5.Icon mapping:elink.
    :link reftype=hd res=6.Spellbook window:elink.
    :link reftype=hd res=38.Spell window:elink.
:elines.
:h2 res=3.Installation
:i2 refid=using.Installation
Unzip the zip file in some directory.  If you want, create a program
object for the file
:font facename=Courier size=13x8.
spl.exe,
:font facename=default size=0x0.
If you don't plan to look at the source code, you can delete the
src directory... this is not needed to run the program.
:p.
Check out the file
:font facename=Courier size=13x8.
splbook.all,
:font facename=default size=0x0.
which contains pointers to all spellbooks which will comprise the
:link reftype=hd res=4.master spell list:elink..
:p.
Also, look at the file
:font facename=Courier size=13x8.
splicon.res
:font facename=default size=0x0.
which contains a 
:link reftype=hd res=5.mapping:elink.
of spell spheres and schools to icons.
:p.
You already know how to view the docs; to run the program, just run 
:font facename=Courier size=13x8.
spl.exe.
:font facename=default size=0x0.

:h2 res=4.Master spell list
:i2 refid=using.Master spell list
:p.
The file
:font facename=Courier size=13x8.
splbook.all
:font facename=default size=0x0.
contains a list of spellbooks which make up the master spell list.
These spellbooks should contain full spell listings.   This is
important because other spellbooks are by default saved only
as lists of titles, which are then looked up in the master spell
list as the spells are loaded in.
:p.
The format of this file is just a list of other files.  To place a
comment in this list, start the line with a semicolon.
:p.

:h2 res=5.Icon mapping
:i2 refid=using.Icon mapping
:p.
The file
:font facename=Courier size=13x8.
splicon.def
:font facename=default size=0x0.
contains a mapping of spell schools and spheres to icons.
:p.
Spells in a book are shown with an icon which corresponds to their sphere
(if given) or school (if no sphere is available).  This file contains
a list of text strings to look for in the schools and spheres, and
a list of icons they correspond to.  If a spell matches two or more
text strings, the first one found is used.
:p.
The format of the file is a text string (containing no spaces), then
a space, then the path name of an icon file to use.  Comments are
allowed, as long as they begin with a semicolon.
:p.

:h2 res=6.Spellbook window
:i2 refid=using.Spellbook window
:p.
This is a window which represents a spellbook; it contains icons
representing spells in the book.  This window has can be viewed
several ways, representing spells as single icons, or more
or less detailed views.
:p.
Several menus can be activated from this window&colon.
:lines.
    :link reftype=hd res=7.File Menu:elink.
    :link reftype=hd res=15.Spell Menu:elink.
    :link reftype=hd res=18.Book Menu:elink.
    :link reftype=hd res=22.Views Menu:elink.
    :link reftype=hd res=29.Help Menu:elink.
:elines.
:p.
Also, pop-up context menus are available, either by clicking on the
background of the spellbook, or on individual spells.  The default
OS/2 method for bringing up these menus uses the right mouse button&colon.
:lines.
    :link reftype=hd res=35.Spell Context Menu:elink.
    :link reftype=hd res=36.Spellbook Context Menu:elink.
:elines.

:h3 res=7.File menu
:p.
Options on this menu include&colon.
:lines.
    :link reftype=hd res=8.New Spellbook:elink.
    :link reftype=hd res=9.Load Spellbook:elink.
    :link reftype=hd res=11.Save Spellbook:elink.
    :link reftype=hd res=12.Save Full Spellbook:elink.
    :link reftype=hd res=13.Close Spellbook:elink.
    :link reftype=hd res=14.Quit Program:elink.
:elines.

:h4 res=8.New Spellbook
:p.
This will create a new (empty) spellbook window that you can
:link reftype=hd res=37.drag and drop:elink.
spells into.

:h4 res=9.Load Spellbook
:p.
This will load in a spellbook from a file.  This file can contain
a full spellbook, including the text of the spells, or it can
be a list of spell names to be looked up in the master list.
Spells listed by name in a spellbook but not found in the master
list will be ignored (you will be warned if there are any).

:h4 res=11.Save Spellbook
:p.
This will save the names of spells in the current spellbook
to disk.

:h4 res=12.Save Full Spellbook
:p.
This will save the complete spellbook (names and descriptions)
to disk.  If the spells are in the master list, you might want
to just save the names instead.

:h4 res=13.Close Spellbook
:p.
This will close the current spellbook.  If it has been changed
but not saved, you will be asked if you want to save it first.
This option is equivalent to double-clicking on the box in the
upper left corner of the book, or selecting "Window -> Close"
:p.
Closing the last spellbook will end the program.  You can close
the master spell index if you want (once another window is open),
as the spells themselves are still in memory.

:h4 res=14.Quit Program
:p.
This will close all open spellbooks and exit the program.  If
any spellbooks have been changed but not saved, a window will
pop up asking if you really want to do this or not.

:h3 res=15.Spell menu
:p.
These options are only available if the book is writeable
(i.e. not the master spell list).
:p.
This menu includes&colon.
:lines.
    :link reftype=hd res=16.Add New Spell:elink.
    :link reftype=hd res=17.Delete Spell:elink.
:elines.

:h4 res=16.Add New Spell
:p.
This will add a new spell to the book; it isn't really useful
in this version.

:h4 res=17.Delete Spell
:p.
This will remove selected spells from the book.

:h3 res=18.Book menu
:p.
This menu includes&colon.
:lines.
    :link reftype=hd res=10.Master List:elink.
    :link reftype=hd res=19.Find Subset:elink.
    :link reftype=hd res=20.Sort Spellbook:elink.
    :link reftype=hd res=21.Rename Spellbook:elink.
:elines.

:h4 res=10.Master list
:p.
This will bring up a window with all spells in the
master list.  You can drag and drop these into spellbooks,
or look at them directly.

:h4 res=19.Find subset
:p.
This brings up a dialog which allows you to search through the
spells in the book (window) and bring up a new book (window)
which contains the results of the search.
:p.
Spells can be sorted on several fields, with the results
OR'ed or AND'ed together depending on the buttons in the
lower left corner of the dialog.  Case sensitivity is also
optional.  Most of the fields just want you to enter text.
:p.
The "level" field allows you to enter a number for the spell
level, such as "5" to select all 5th level spells.  It also
allows you to enter things like ">5" or "<5" to select all
spells higher or lower than a certain level.
:p.
The "description" field allows you to enter several lines of
text instead of only one.  All lines entered are searched
for in the spell descriptions, with the results OR'ed or 
AND'ed together according to the button pushed on the right.
:p.
Searches go faster with case sensitivity enabled.  Also,
searches go faster if the program doesn't have to search through
entire spell descriptions... limit using the other fields if possible.
:p.
Searching is multithreaded, so you can work on other books
while the search is in progress.

:h4 res=20.Sort spellbook
:p.
This sorts the spellbook by several criteria&colon.
:lines.
    Caster Type
    Name of Spell
    Spell level
    School/Sphere
    Components
    Save
:elines.
:p.
Sorting is multithreaded, although usually quick.

:h4 res=21.Rename spellbook
:p.
This renames the spellbook... it does not change the actual name of
the file the spellbook is saved in, only the name which appears
at the top of the window.

:h3 res=22.Views Menu
:p.
The Views menu includes&colon.
:lines.
    :link reftype=hd res=23.Icon View:elink.
    :link reftype=hd res=24.Name View:elink.
    :link reftype=hd res=25.Text View:elink.
    :link reftype=hd res=26.Details View:elink.
    :link reftype=hd res=51.Details Fields:elink.
    :link reftype=hd res=27.Small Icons:elink.
    :link reftype=hd res=28.Large Icons:elink.
:elines.
:p.
Spellbooks remember which view they are in, whether to use large
or small icons, and the bar position in details view.  This is
stored in extended attributes for saved spellbooks, or in the
INI file for the master spell window and new windows.

:h4 res=23.Icon View
:p.
This shows each spell as an icon with the name of the spell underneath.

:h4 res=24.Name View
:p.
This shows each spell on a single line with the icon to the left and
the name to the right.

:h4 res=25.Text View
:p.
This just shows the spell names, one per line.

:h4 res=26.Details View
:p.
This shows the spell and some other relevant details such as spell
level, and the school or sphere of the spell.
:p.
Which fields actually get shown are controlled by the
boxes checked off in the
:link reftype=hd res=51.Details Fields:elink.
dialog.

:h4 res=51.Details Fields
:p.
This dialog allows you to display which details of the spell
get shown.  Choices include&colon.
:lines.
    Spell Level
    Casting Time
    Range
    Duration
    Area of Effect
    Sphere or School
    Components
    Saving Throw
:elines.

:h4 res=27.Small Icons
:p.
This uses small icons in all views that show icons; the icons
lose detail, but allow more spells on the screen.

:h4 res=28.Large Icons
:p.
This tells the book to use large icons to represent spells; these
are as detailed as other icons in your system.

:h3 res=29.Help Menu
:p.
This includes&colon.
:lines.
    :link reftype=hd res=30.Help Index:elink.
    :link reftype=hd res=31.General Help:elink.
    :link reftype=hd res=33.Using Help:elink.
    :link reftype=hd res=34.About:elink.
:elines.

:h4 res=30.Help Index
:p.
This will display an index of help topics from within the program.

:h4 res=31.General Help
:p.
This will bring up general help on using this program, like pushing
F1.

:h4 res=33.Using Help
:p.
This will bring up help on how OS/2's help system works.

:h4 res=34.About
:p.
This will briefly describe the program.

:h3 res=35.Spell Context Menu
:p.
This menu will pop up if you right-click on a spell in the spellbook.
:p.
The menu includes&colon.
:lines.
    :link reftype=hd res=38.Show spell:elink.
    :link reftype=hd res=17.Delete spell:elink.
:elines.

:h3 res=36.Spellbook Context Menu
:p.
This menu will pop up if you right-click in the spellbook window 
somewhere in the blank (empty) part of the window.
:p.
The menu includes the options found in the 
:link reftype=hd res=22.Views:elink.
and
:link reftype=hd res=18.Book:elink.
menus.

:h3 res=37.Drag and Drop
:p.
To copy spells between windows (spellbooks), drag them with the right mouse
button.  You can select several spells with the left button.  Dragging
can also be used to reposition spells within a window, if the window
is not read-only.

:h2 res=38.Spell Window
:i2 refid=using.Spell Window
:p.
To bring up a spell in detail, double click on it, or
select "show spell" from the context menu.  This brings
up a window which is pretty self-explanatory.  Use ALT-N or ALT-P
as a shortcut to go to the next or previous spell in the book.
:p.
You can copy text from spells onto the clipboard using the
usual methods.  You can even edit and change spells, although
this doesn't work very well and will probably require you to
go in and fix the saved text file with an editor.
:p.
Any file you change and save is saved in the file
:font facename=Courier size=13x8.
splbook.chg.
:font facename=default size=0x0.

:h1 res=39.Source information
:i1 id=src.Source information
:p.
The source is written in C++ for the IBM C++ compiler; it will
probably work with other compilers, although I haven't tested
this.  You need a C++ compiler and a resource compiler to compile
the dialogs and menus.
:p.
The makefile is compatible with GNU's make.
:p.
You need an IPF compiler (IPFC) to compile the documentation.
:p.
Click one of the following for more information&colon.
:lines.
    :link reftype=hd res=41.general.cpp:elink.
    :link reftype=hd res=42.splbook.cpp:elink.
    :link reftype=hd res=43.spl.cpp:elink.
    :link reftype=hd res=44.bookwin.cpp:elink.
    :link reftype=hd res=45.splobj.cpp:elink.
    :link reftype=hd res=46.splwin.cpp:elink.
    :link reftype=hd res=47.spldlgs.cpp:elink.
    :link reftype=hd res=48.splhelp.cpp:elink.
    :link reftype=hd res=49.ea.cpp:elink.
:elines.

:h2 res=41.general.cpp
This file contains some generally useful functions which are
called from the rest of the code.  None are PM specific.
:p.
:hp2.fatal, error, warning:ehp2. - these are 3 error functions
indicating various levels of severity.  These are pretty useless
in a PM program.
:p.
:hp2.chkcalloc:ehp2. - this is a memory allocation function,
which is pretty useless
for a C++ program.  (Just use "new" instead)
:p.
:hp2.upstr, lowstr:ehp2. - these are 2 string functions to capitalize
and uncapitalize a
string... these are rarely found in C libraries, so they're
included here.  These actually get used in the code.
:p.
:hp2.fgets_no_cr:ehp2. - this works just like fgets(), but removes
the \n at the end of the string.

:h2 res=42.splbook.cpp
These files contain the C++ classes for handling spells and
spellbooks, and contain no OS/2-specific or PM-specific
information.  Routines for reading and writing spells out
of files are given.
:p.
Note that the classes are set up to allow later addition of
psionic disciplines as a subclass of the general spell.  This
is why the "magespell" class contains things like "school" and
so forth that you would normally associate with all spells.
:p.
If you want to change this program to change the format of
how spells are read in and out (for example to use this
program with another FRP system) this is the file to change.
It is also the most portable to other systems besides OS/2.
:p.

:h2 res=43.spl.cpp
:p.
This file contains some initialization and general use (PM) functions
which get called from classes.
:p.
Routines to load in the icon file, look up an icon for a given
spell, load in the INI file, enable/disable or check/uncheck
menu items, and printf() to a window's title bar are in here.

:h2 res=44.bookwin.cpp
:p.
:hp2.bookwindow:ehp2. is a class which refers to the spellbook windows which
appear on the screen.  The class definition appears in
bookwin.hpp.  
:p.
Bookwindow functions which are handled in the main thread
are included in bookwin.cpp.

:h2 res=45.splobj.cpp
:p.
The object thread for bookwindows is handled here.  Both
the object window function and the main() thread which
creates it are defined here.
:p.
Bookwindow functions that are handled in the object thread
are in this file.

:h2 res=46.splwin.cpp
:p.
:hp2.spellwindow:ehp2. is a class which refers to the spell windows
which show the detailed descriptions of spells.  The class
definition appears in splwin.hpp.
:p.
Spell windows are not multithreaded; all the code required to
handle them is in splwin.cpp.

:h2 res=47.spldlgs.cpp
:p.
These files contain all the code required for processing the
dialog boxes used in the program.

:h2 res=48.splhelp.cpp
:p.
These files contain code for on-line help.

:h2 res=49.ea.cpp
:p.
These files contain OS/2 specific file handling code.
:p.
:hp2.query_last_write:ehp2. is a function for finding out the
last time a file has been written to.
:p.
:hp2.getEA:ehp2. is a function for reading an given EA out of a file.
It may contain bugs; I have little coherent information on
OS/2's EAs.
:p.
:hp2.putEA:ehp2. is a function for writing data to a named
EA of a file.  It works, but could stand to be debugged also.

:h1 res=50.Planned enhancements
:i1.Planned enhancements
:p.
These are things I plan to add to the program in the future, both
in order to give it more functionality, and in order to learn more
about PM programming myself.  If you would like to help me out
with any of these, please let me know what you're working on.
:p.
Spellbooks within spellbooks... should make the master list
much easier to view.
:p.
Allow users to edit/save spells in a way that actually works.
:p.
Allow users to change default names of things; save in .ini file.
(Also find .ini file if not in same directory)
:p.
More drag and drop stuff... should allow you to drop a text file
into a spell window and read it in.  Also, should allow you to
drag a spell onto the printer and print it.  Drag and drop
icon assignment would also be cool.
:p.
:euserdoc.
