/* bookwin.hpp:  header for book windows

    Copyright (C) 1993, 1994 John-Marc Chandonia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

// some messages sent between book windows and their object windows
#define WM_USER_ACK WM_USER
#define WM_USER_LOAD WM_USER+1
#define WM_USER_SHOW_MASTER WM_USER+2
#define WM_USER_LOAD_MASTER WM_USER+3
#define WM_USER_SAVE WM_USER+4
#define WM_USER_CREATE_SUBSET WM_USER+6
#define WM_USER_DETAILS_FIELDS WM_USER+7
#define WM_USER_SORT WM_USER+8

// flags defining fields to show in details view
#define FL_LEVEL 1
#define FL_CAST 2
#define FL_RANGE 4
#define FL_DURATION 8
#define FL_AREA 16
#define FL_SPHERESCHOOL 32
#define FL_COMPONENTS 64
#define FL_SAVE 128

// a spellbook window class 
class bookwindow {
public:
    // handles for all relevant windows 
    HWND hwnd;  // main window
    HWND hwndframe;  // frame window
    HWND hwndcnr;  // container window
    HWND hwndobject; // object window.
    HWND hwndpopup; // popup menu
    HWND hwndsppopup; // popup menu when on a spell

    // object thread
    TID tidobject;
    boolean busy;

    // one spellbook per window.
    spellbook *sb;
    char *filename; // file it was read from, if applicable

    boolean readonly;  // is is changeable?
    boolean saved;  // has it been saved since last change?
    boolean master_list_win;  // is it the master list?

    // maintain double linked list 
    bookwindow *next;
    bookwindow *prev;

    // new book with a certain name
    bookwindow(char *bookname="New Spellbook");
    // new book, read from a file
    bookwindow(char *filename, boolean is_master);
    void init(char *bookname); // called by both constructors
    ~bookwindow();

    // show container in current mode
    ULONG view; // name, icon, text, or detailed
    ULONG miniicon; // container shows mini icons
    LONG splitbarpos; // position of split bar in details mode
    ULONG details_fields; // fields to show in details view.
    PFIELDINFO pfieldinfo; // pointer to actual allocated fields.
    void query_splitbar(); // record new splitbarpos
    void show();
    char *fontname;
    void load_attr(); // load the above from INI or EA
    void save_attr(); // save these to INI or EA

    void disable(); // make the window busy and inactive
    void enable(); // restore window

    boolean save_book(boolean just_titles);
    boolean set_spellbook(spellbook *);
    boolean sort_book(ULONG sortorder);

    boolean insert_fields();
    void show_fields();  // show fields specified in details_fields
    boolean add_spell(spell *s, spellrecord *where=NULL);
    boolean add_all_spells(spellbook *x, spellrecord *where=NULL);
    boolean add_new_spell();
    boolean delete_spell(spellrecord *s);
    boolean delete_selected_spells();
    boolean change_spell(spell *oldsp, spell *newsp);
    boolean refresh();  // redraw the window after adding or deleting spells.
};

// attributes saved with each window, in EA or INI
class book_attr {
  public:
    ULONG view, miniicon;
    LONG splitbarpos;
    SHORT x, cx, y, cy;
    ULONG foregroundcolor, backgroundcolor;
    char fontnamesize[128];
    ULONG details_fields;
};

#define spbclass "Bookwindow"
#define spbobjclass "Bookwindow Thread 2"

// routines to be called from outside
boolean load_book();
void change_all(spell *old_spell, spell *mod_spell);
void find_and_show_spell(bookwindow *mywin, spell *s);
boolean create_subset(bookwindow *mywin,HWND dlg);

// client & object window procedures
MRESULT EXPENTRY book_window_func(HWND hwnd, ULONG msg, 
				  MPARAM param1, MPARAM param2);
MRESULT EXPENTRY object_window_func(HWND hwnd, ULONG msg, 
				    MPARAM param1, MPARAM param2);

// object thread procedure
void _Optlink threadmain(void *);


