/*
    PMICS -- PM interface for playing chess on internet chess server
    Copyright (C) 1994  Kevin Nomura

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Author can be reached at email: chow@netcom.com
*/
#define  INCL_DOSNMPIPES
#include <os2.h>
#include "engcom.hh"
#include "pmics.hh"
#include "session.hh"

EngineComm *engineComm;
extern ASession  *aSession;
static void _System PipeListen(ULONG hFile);

EngineComm :: EngineComm() : hpipe(0), connected(false)
{
  APIRET    rc;
  HFILE     hFile;

  IFUNCTRACE_DEVELOP();
  rc = DosCreateNPipe (NPIPE_NAME, // create named pipe
		       &hFile,	   // pipe handle
		       NP_ACCESS_DUPLEX, // allow duplex access
		       NP_WAIT |	 // blocking mode
		       NP_TYPE_MESSAGE | // msg oriented pipe
		       NP_READMODE_MESSAGE | // msg oriented read
		       0x01,		    // single instance only
		       1024,	    // outbound buffer size
		       1024,	    // inbound buffer size
		       0);		    // default timeout value
  ITRACE_DEVELOP("EngineComm: DosCreateNPipe rc=" + IString(rc) +
		 " hFile=" + IString(hFile));

  if (rc != 0)
    throw "DosCreateNPipe";

  engineComm = this;		// export
  hpipe = IHandle(hFile);
  pthr = new IThread(PipeListen, (ULONG)hFile);
}


EngineComm :: ~EngineComm()
{
  delete pthr;
}


void EngineComm :: sendCommand (char *s)
{
  ULONG   rc, ulBytes;

  IFUNCTRACE_DEVELOP();
  ITRACE_DEVELOP(s);
  if (connected) {
    rc = DosWrite(hpipe, 
		  s,
		  strlen(s),
		  &ulBytes);
    ITRACE_DEVELOP("DosWrite rc " + IString(rc) +
		   "ulBytes " + IString(ulBytes));
  }
}


void _System PipeListen(ULONG hFile)
{
  char   request[256];
  ULONG  ulBytes;
  APIRET rc;

  IFUNCTRACE_DEVELOP();
  while (1) {
    rc = DosConnectNPipe(hFile);
    ITRACE_DEVELOP("DosConnectNPipe rc=" + IString(rc));
    engineComm->setConnected();

    while (1) {
      rc = DosRead(hFile,
		   request,
		   sizeof(request),
		   &ulBytes);
      ITRACE_DEVELOP("DosRead from pipe rc " + IString(rc) +
		     "ulBytes " + IString(ulBytes));
      if (rc) {
	ITRACE_DEVELOP("------ PipeListen: DosRead() rc = " + IString(rc));
	ITRACE_DEVELOP("Assuming broken pipe.  breaking from inner loop.");
	break;
      }
      else if (ulBytes == 0) {
	ITRACE_DEVELOP("----- PipeListen: ulBytes==0, assuming broken pipe");
	break;
      }

      request[ulBytes] = 0;
      aSession->write(request);	// send move to the comm port
    }

    rc = DosDisConnectNPipe(hFile);
    ITRACE_DEVELOP("DosDisconnectNPipe rc=" + IString(rc));
    engineComm->clearConnected();
  }
}
