#include <iframe.hpp>
#include <iapp.hpp>
#include <icombobx.hpp>
#include <imsgbox.hpp>
#include <icolor.hpp>
#include <ikeyhdr.hpp>
#include <iedithdr.hpp>
#include <string.h>
#include <stdio.h>
#define IC_TRACE_DEVELOP
#include <itrace.hpp>

class MyEditHandler : public IEditHandler
{
public:                               //Define the public Information
  virtual Boolean         edit(IControlEvent &evt);
};

class CommWindow : public IComboBox,
		   public IKeyboardHandler
{
public:                               //Define the public Information
  CommWindow(unsigned long windowId, //Constructor for this class
	     IWindow *parent);
  virtual Boolean         key(IKeyboardEvent &evt);
private:
  IEntryField  *ef;
  MyEditHandler  *eh;
};


main()
{
  IFrameWindow *fw = new IFrameWindow(0x1000);
  CommWindow *cbox = new CommWindow(0x1001,fw);
  int i;

  fw->setClient(cbox);
  fw->setFocus();
  fw->show();

  for (i = 'a'; i <= 'z'; i++) {
    cbox->addAsLast(IString((char)i) + " potatoe");
  }

  IApplication::current().run();
}

CommWindow::CommWindow(unsigned long windowId, //Constructor for this class
		       IWindow *parent) :
             IComboBox (windowId, parent, parent, IRectangle(500,100),
			IComboBox::classDefaultStyle &
			~(IComboBox::horizontalScroll))
{
  ef = (IEntryField*)IWindow::windowWithId(0x029B,this);
  if (ef) {
    ITRACE_DEVELOP("entry field found, using it");
  }
  else {
    ITRACE_DEVELOP("entry field not found, creating one");
    ef = new IEntryField(0x29b,this);
  }

  eh = new MyEditHandler;

  handleEventsFor(ef);
  eh->handleEventsFor(ef);
  eh->handleEventsFor(this);
  show();
}

Boolean MyEditHandler::edit (IControlEvent &evt)
{
  IFUNCTRACE_DEVELOP();
  return true;
}


Boolean CommWindow::key (IKeyboardEvent &evt)
{
  char c,s[2];

  IFUNCTRACE_DEVELOP();
  ITRACE_DEVELOP("ef contents: " + ef->text());

  if (evt.isVirtual()) {
    ITRACE_DEVELOP("vkey: " + IString((unsigned short)(evt.virtualKey())) +
		   " *" + IString(evt.repeatCount()));
    switch(evt.virtualKey()) {
    case IKeyboardEvent::backSpace:
      if (ef->text() != "") {
	ITRACE_DEVELOP("BS: deleting last character");
	ef->setText(ef->text().remove(ef->text().length()));
      }
      return true;
    }
    return false;
  }
  
  else if (evt.isCharacter()) {
    ITRACE_DEVELOP("key: " + IString((unsigned short)(evt.character())));
    if (evt.isRepeat() || evt.repeatCount() > 0)
      ITRACE_DEVELOP("repeatCount = "+IString(evt.repeatCount())+
		     "isRepeat = "+IString(evt.repeatCount()));
    c = evt.character();

    if (c == '\r'){
      ITRACE_DEVELOP("CRLF: clearing entry field");
      ef->setText("");
    }
    else if (c == 'w' && evt.isCtrlDown()) {
      ITRACE_DEVELOP("CTRL-W: trying to remove last word");
      ef->setText( ef->text().removeWords(ef->text().numWords()));
    }
    else {
      ef->setText(IString(ef->text()) + IString(c));
    }

    return true;   // inhibit listbox jump to line with first letter
  }

  return false;
}

