//
//  Copyright (C) 1986, 1987, 1988, 1989, 1990 Free Software Foundation, Inc.
//  Copyright (c) 1988, 1989, 1990  John Stanback
//
//  Project:    OS/2 PM Port of GNU CHESS 4.0 (PmChess)
//
//  Version:    1994-4-17
//
//   Porter:    Ported to Windows 3.0 by Darly Baker
//
//   Porter:    Ported to OS/2 1.2+ by Kent Cedola
//
//   Porter:    Revised and ported to OS/2 2.1 by Yibing Fan
//
//   System:    OS2 2.1 using emx0.8g 
//
//  Remarks:    This code modified to change menu logic
//
//

#define INCL_DOS
#define INCL_PM
#include <os2.h>
#include "PmChess.h"
#include "GnuChess.h"
#include "Resource.h"

extern int coords;
extern int UseBook;
extern int User_Move;
extern BOOL fHelpEnabled;     /* flag to determine if help is enabled, declared in help.c */

void EnableMenuItem(HWND hwndMenu, USHORT idItem, BOOL bEnable)
  {
  if (bEnable)
    WinSendMsg(hwndMenu, MM_SETITEMATTR, MPFROM2SHORT(idItem, TRUE),
               MPFROM2SHORT(MIA_DISABLED, 0));
  else
    WinSendMsg(hwndMenu, MM_SETITEMATTR, MPFROM2SHORT(idItem, TRUE),
               MPFROM2SHORT(MIA_DISABLED, MIA_DISABLED));
  }


void CheckMenuItem(HWND hwndMenu, USHORT idItem, BOOL bCheck)
  {
  if (bCheck)
    WinSendMsg(hwndMenu, MM_SETITEMATTR, MPFROM2SHORT(idItem, TRUE),
               MPFROM2SHORT(MIA_CHECKED, MIA_CHECKED));
  else
    WinSendMsg(hwndMenu, MM_SETITEMATTR, MPFROM2SHORT(idItem, TRUE),
               MPFROM2SHORT(MIA_CHECKED, 0));
  }


void Init_Menus(HWND hWnd, MPARAM mp1, MPARAM mp2)
  {
  HWND   hwndMenu;
  USHORT Status;


  hwndMenu = HWNDFROMMP(mp2);

  switch (SHORT1FROMMP(mp1))
    {
    case IDM_FILE:
      EnableMenuItem(hwndMenu, IDM_FILE_NEW,
                             (!flag.bothsides ? TRUE : FALSE) );
    case IDM_EDIT:
      EnableMenuItem(hwndMenu, IDM_EDIT_GAME,
                             (GameCnt>0 ? TRUE : FALSE) );
      EnableMenuItem(hwndMenu, IDM_EDIT_UNDO,
                             (flag.easy&flag.timeout&!flag.bothsides&GameCnt>0 ? TRUE : FALSE) );
      EnableMenuItem(hwndMenu, IDM_EDIT_REMOVE,
                             (flag.easy&flag.timeout&!flag.bothsides&GameCnt>1 ? TRUE : FALSE) );
      if ( flag.force == false)  Status = FALSE; else Status = TRUE;
      CheckMenuItem ( hwndMenu, IDM_EDIT_FORCE, Status);
      break;

    case IDM_OPTIONS:
      if ( flag.hash == false)  Status = FALSE; else Status = TRUE;
      CheckMenuItem ( hwndMenu, IDM_OPTIONS_HASH, Status);

      if ( coords == false)  Status = FALSE; else Status = TRUE;
      CheckMenuItem ( hwndMenu, IDM_OPTIONS_COOR, Status);
      EnableMenuItem(hwndMenu, IDM_OPTIONS_COOR,
                             (flag.bothsides|!User_Move|!flag.easy ? FALSE : TRUE) );

      if ( flag.beep == false)  Status = FALSE; else Status = TRUE;
      CheckMenuItem ( hwndMenu, IDM_OPTIONS_TONE, Status);

      if ( flag.bothsides == false)  Status = FALSE; else Status = TRUE;
      CheckMenuItem ( hwndMenu, IDM_OPTIONS_BOTH, Status);

      if ( !UseBook )  Status = FALSE; else Status = TRUE;
      CheckMenuItem ( hwndMenu, IDM_OPTIONS_BOOK, Status);

      if ( flag.post == false)  Status = FALSE; else Status = TRUE;
      CheckMenuItem ( hwndMenu, IDM_OPTIONS_STATS, Status);
      break;

    case IDM_SKILL:
      if ( dither == 0)
        Status = FALSE; else Status = TRUE;
      CheckMenuItem ( hwndMenu, IDM_SKILL_RANDOM, Status);
  
      if ( flag.easy == false)
        Status = TRUE; else Status = FALSE;
      CheckMenuItem ( hwndMenu, IDM_SKILL_EASY, Status);

      EnableMenuItem(hwndMenu, IDM_SKILL_EASY,
                             (flag.bothsides ? FALSE : TRUE) );

      break;

    case IDM_SIDE:
      if ( flag.reverse == false)
        Status = FALSE; else Status = TRUE;
       CheckMenuItem ( hwndMenu, IDM_SIDE_REVERSE, Status);

      EnableMenuItem(hwndMenu, IDM_SIDE_REVERSE,
                             (flag.bothsides|!User_Move|!flag.easy  ? FALSE : TRUE) );

      if (computer == black)
        {
        CheckMenuItem(hwndMenu, IDM_SIDE_BLACK, TRUE);
        CheckMenuItem(hwndMenu, IDM_SIDE_WHITE, FALSE);
        }
      else
        {
        CheckMenuItem(hwndMenu, IDM_SIDE_WHITE, TRUE);
        CheckMenuItem(hwndMenu, IDM_SIDE_BLACK, FALSE);
        }

      EnableMenuItem(hwndMenu, IDM_SIDE_SWITCH,
                             (flag.bothsides|!User_Move|!flag.easy ? FALSE : TRUE) );

      EnableMenuItem(hwndMenu, IDM_SIDE_WHITE,
                             (flag.bothsides|!User_Move|!flag.easy ? FALSE : TRUE) );

      EnableMenuItem(hwndMenu, IDM_SIDE_BLACK,
                             (flag.bothsides|!User_Move|!flag.easy  ? FALSE : TRUE) );

      break;

     case IDM_HELP:
            /*
             * Enable or disable the Help menu depending upon whether the
             * help manager has been enabled
             */
        EnableMenuItem(hwndMenu, IDM_HELP_DISPLAY, fHelpEnabled);
        EnableMenuItem(hwndMenu, IDM_HELP_EXT, fHelpEnabled);
        EnableMenuItem(hwndMenu, IDM_HELP_KEYS, fHelpEnabled);
        EnableMenuItem(hwndMenu, IDM_HELP_INDEX, fHelpEnabled);

         /*  REMEMBER: add a case for IDM_HELPTUTORIAL if you include
          *  the Tutorial menu item.
          */

       break;

    }
  }
